/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.List;
import java.util.function.IntPredicate;
import org.graphper.def.Curves;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.layout.dot.BoxGuideLineRouter;
import org.graphper.layout.dot.RouterBox;

abstract class CurveFitBoxRouter
extends BoxGuideLineRouter {
    protected static final int MAX_ITERATORS = 24;

    CurveFitBoxRouter() {
    }

    protected void straightenSpline(Curves.ThirdOrderBezierCurve curve) {
        curve.adjust(0.6, 0.6);
    }

    protected void refineSpline(SplineFitInfo splineFitInfo) {
        splineFitInfo.curve.adjust(0.9, 0.9);
    }

    protected SplineFitInfo splineIsFit(Curves.MultiBezierCurve curves, List<RouterBox> lineRouterBoxes, int boxStart, int boxEnd, boolean needOffset) {
        return this.splineCheck(curves, lineRouterBoxes, needOffset, true, boxStart, boxEnd);
    }

    protected SplitInfo splineSplit(Curves.MultiBezierCurve curves, List<RouterBox> lineRouterBoxes, List<BoxGuideLineRouter.ThroughPoint> throughPoints, int pointStart, int pointEnd, int boxStart, int boxEnd) {
        if (pointEnd - pointStart < 2) {
            return null;
        }
        SplineFitInfo splineFitInfo = this.splineCheck(curves, lineRouterBoxes, true, false, boxStart, boxEnd);
        for (int i = pointStart; i <= pointEnd; ++i) {
            BoxGuideLineRouter.ThroughPoint point = throughPoints.get(i);
            if (point.getBoxIndex() <= splineFitInfo.boxIndex) continue;
            if (i == pointStart) {
                return null;
            }
            SplitInfo splitInfo = new SplitInfo();
            if (i == pointStart + 1) {
                splitInfo.pointsSplitIndex = i;
                splitInfo.boxSplitIndex = point.getBoxIndex();
            } else if (i == pointEnd) {
                splitInfo.pointsSplitIndex = i - 1;
                splitInfo.boxSplitIndex = throughPoints.get(splitInfo.pointsSplitIndex).getBoxIndex();
            } else {
                int pointSplitIndex = i - 1;
                BoxGuideLineRouter.ThroughPoint pre = throughPoints.get(pointSplitIndex);
                if (splineFitInfo.boxIndex - pre.getBoxIndex() < point.getBoxIndex() - splineFitInfo.boxIndex) {
                    point = pre;
                } else {
                    pointSplitIndex = i;
                }
                splitInfo.pointsSplitIndex = pointSplitIndex;
                splitInfo.boxSplitIndex = point.getBoxIndex();
            }
            splitInfo.splitVector = this.splitCurveTangent(throughPoints.get(splitInfo.pointsSplitIndex - 1), throughPoints.get(splitInfo.pointsSplitIndex), throughPoints.get(splitInfo.pointsSplitIndex + 1));
            return splitInfo;
        }
        return null;
    }

    private SplineFitInfo splineCheck(Curves.MultiBezierCurve curves, List<RouterBox> lineRouterBoxes, boolean needOffset, boolean firstOrFurthest, int boxStart, int boxEnd) {
        SplineFitInfo tmp = null;
        SplineFitInfo splineFitInfo = new SplineFitInfo();
        splineFitInfo.needOffset = needOffset;
        RouterBox first = lineRouterBoxes.get(0);
        RouterBox last = lineRouterBoxes.get(lineRouterBoxes.size() - 1);
        double boxMinY = (first.getUpBorder() + first.getDownBorder()) / 2.0;
        double boxMaxY = (last.getUpBorder() + last.getDownBorder()) / 2.0;
        block0: for (int j = 0; j < curves.size(); ++j) {
            Curves.ThirdOrderBezierCurve curve = (Curves.ThirdOrderBezierCurve)curves.get(j);
            int segmentNum = 2;
            for (int i = boxStart; i <= boxEnd; ++i) {
                if (i < 0 || i >= lineRouterBoxes.size()) continue;
                RouterBox lineRouterBox = lineRouterBoxes.get(i);
                double minY = Math.min(curve.getV1().getY(), curve.getV4().getY());
                minY = Math.min(curve.getV2().getY(), minY);
                minY = Math.min(curve.getV3().getY(), minY);
                double maxY = Math.max(curve.getV1().getY(), curve.getV4().getY());
                maxY = Math.max(curve.getV2().getY(), maxY);
                maxY = Math.max(curve.getV3().getY(), maxY);
                if (minY != maxY && minY <= lineRouterBox.getUpBorder() && maxY >= lineRouterBox.getUpBorder() || minY <= lineRouterBox.getDownBorder() && maxY >= lineRouterBox.getDownBorder()) {
                    double ratio = Math.abs(minY != maxY ? (Math.abs(lineRouterBox.getUpBorder() + lineRouterBox.getDownBorder()) / 2.0 - minY) / (maxY - minY) : 0.5);
                    double d = ratio = ratio > 1.0 ? 1.0 : ratio;
                    if (!firstOrFurthest) {
                        tmp = new SplineFitInfo(splineFitInfo);
                    }
                    if (!this.isInBox(curve, lineRouterBox, (int)(ratio * (double)segmentNum), segmentNum, boxMinY, boxMaxY, splineFitInfo)) {
                        splineFitInfo.routerBox = lineRouterBox;
                        splineFitInfo.boxIndex = i;
                        splineFitInfo.curve = curve;
                        if (firstOrFurthest) {
                            return splineFitInfo;
                        }
                        if (tmp.curve != null && tmp.offset > splineFitInfo.offset) {
                            splineFitInfo = tmp;
                        }
                    }
                }
                if (lineRouterBox.getUpBorder() > curve.getV4().getY()) continue block0;
            }
        }
        return splineFitInfo;
    }

    private boolean isInBox(Curves.ThirdOrderBezierCurve curve, RouterBox routerBox, int currentSegment, int segmentNum, double minY, double maxY, SplineFitInfo splineFitInfo) {
        double unit = 1.0 / (double)segmentNum;
        FlatPoint p1 = Curves.besselEquationCalc(unit * (double)currentSegment, curve.getV1(), curve.getV2(), curve.getV3(), curve.getV4());
        if (!this.inBox(curve, p1, routerBox, unit, currentSegment, -1, minY, maxY, c -> 0 < c, splineFitInfo) && !splineFitInfo.needOffset) {
            return false;
        }
        return this.inBox(curve, p1, routerBox, unit, currentSegment, 1, minY, maxY, c -> c < segmentNum, splineFitInfo);
    }

    private boolean inBox(Curves.ThirdOrderBezierCurve curve, FlatPoint p1, RouterBox routerBox, double unit, int currentSegment, int addNum, double minY, double maxY, IntPredicate breakCondition, SplineFitInfo splineFitInfo) {
        boolean result = true;
        Integer count = null;
        while (breakCondition.test(currentSegment)) {
            FlatPoint p2 = Curves.besselEquationCalc(unit * (double)(currentSegment += addNum), curve.getV1(), curve.getV2(), curve.getV3(), curve.getV4());
            if (!RouterBox.inRange(minY, maxY, p1.getY()) || !RouterBox.inRange(minY, maxY, p2.getY())) {
                result = false;
                break;
            }
            if (routerBox.getUpBorder() > p1.getY() && routerBox.getUpBorder() > p2.getY()) continue;
            if (!this.approximatelyInBoxY(routerBox, p1.getY()) && !this.approximatelyInBoxY(routerBox, p2.getY())) break;
            if (this.approximatelyInBoxY(routerBox, p1.getY()) && !this.approximatelyInBox(routerBox, p1) || this.approximatelyInBoxY(routerBox, p2.getY()) && !this.approximatelyInBox(routerBox, p2)) {
                result = false;
                if (!splineFitInfo.needOffset) break;
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                splineFitInfo.offset += this.offset(p1, routerBox);
                splineFitInfo.offset += this.offset(p2, routerBox);
            }
            p1 = p2;
        }
        if (splineFitInfo.needOffset && count != null) {
            splineFitInfo.offset /= (double)count.intValue();
        }
        return result;
    }

    private double offset(FlatPoint p, RouterBox routerBox) {
        if (this.approximatelyInBoxX(routerBox, p.getX())) {
            return 0.0;
        }
        return Math.abs(routerBox.closerVerWall(p.getX()) - p.getX());
    }

    private boolean approximatelyInBoxX(RouterBox routerBox, double p) {
        return this.approximatelyInRange(routerBox.getLeftBorder(), routerBox.getRightBorder(), p);
    }

    private boolean approximatelyInBoxY(RouterBox routerBox, double p) {
        return this.approximatelyInRange(routerBox.getUpBorder(), routerBox.getDownBorder(), p);
    }

    private boolean approximatelyInRange(double left, double right, double v) {
        return RouterBox.inRange(left, right, v) || RouterBox.inRange(left, right, v - 1.0) || RouterBox.inRange(left, right, v + 1.0);
    }

    private boolean approximatelyInBox(RouterBox routerBox, FlatPoint p) {
        return this.approximatelyInRange(routerBox.getLeftBorder(), routerBox.getRightBorder(), p.getX()) && this.approximatelyInRange(routerBox.getUpBorder(), routerBox.getDownBorder(), p.getY());
    }

    private double slopToDegree(FlatPoint p) {
        return Math.toDegrees(Math.atan(p.getX() != 0.0 ? p.getY() / p.getX() : Double.MAX_VALUE));
    }

    private FlatPoint splitCurveTangent(FlatPoint up, FlatPoint p, FlatPoint down) {
        FlatPoint referVector = Vectors.add(Vectors.sub(up, p), Vectors.sub(down, p));
        if (referVector.getY() == 0.0) {
            return Vectors.sub(up, p);
        }
        double x = Math.sqrt(4.0 / (1.0 + Math.pow(referVector.getX(), 2.0) / Math.pow(referVector.getY(), 2.0)));
        double y = -x * referVector.getX() / referVector.getY();
        if (y > 0.0) {
            y = -y;
            x = -x;
        }
        return new FlatPoint(x, y);
    }

    protected static class SplitInfo {
        protected int pointsSplitIndex;
        protected int boxSplitIndex;
        protected FlatPoint splitVector;

        protected SplitInfo() {
        }
    }

    protected static class SplineFitInfo {
        protected Curves.ThirdOrderBezierCurve curve;
        protected RouterBox routerBox;
        protected int boxIndex;
        protected double offset;
        protected boolean needOffset;

        protected SplineFitInfo() {
        }

        private SplineFitInfo(SplineFitInfo splineFitInfo) {
            this.curve = splineFitInfo.curve;
            this.routerBox = splineFitInfo.routerBox;
            this.boxIndex = splineFitInfo.boxIndex;
            this.offset = splineFitInfo.offset;
            this.needOffset = splineFitInfo.needOffset;
        }

        protected boolean isFit() {
            return this.curve == null;
        }
    }
}

