/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import org.graphper.api.ext.ShapePosition;
import org.graphper.def.Curves;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.dot.AbstractDotLineRouter;
import org.graphper.layout.dot.PathClip;
import org.graphper.util.CollectionUtils;

public class CurvePathClip
extends PathClip<LineDrawProp> {
    public static final CurvePathClip INSTANCE = new CurvePathClip();

    @Override
    protected FlatPoint pathFrom(LineDrawProp path) {
        return AbstractDotLineRouter.getFirst(path);
    }

    @Override
    protected FlatPoint pathTo(LineDrawProp path) {
        return AbstractDotLineRouter.getLast(path);
    }

    @Override
    protected LineDrawProp fromArrowClip(double arrowSize, LineDrawProp path) {
        ShapePosition arrowShapePosition = AbstractDotLineRouter.newArrowShapePosition(AbstractDotLineRouter.getFirst(path), arrowSize);
        AbstractDotLineRouter.InOutPointPair inOutPair = AbstractDotLineRouter.findInOutPair(3, path, true, arrowShapePosition);
        if (inOutPair != null) {
            Curves.ThirdOrderBezierCurve curve = this.getCurve(path, inOutPair);
            this.subPath(path, inOutPair, AbstractDotLineRouter.besselCurveClipShape(arrowShapePosition, curve));
        } else {
            path.clear();
        }
        return path;
    }

    @Override
    protected LineDrawProp toArrowClip(double arrowSize, LineDrawProp path) {
        ShapePosition arrowShapePosition = AbstractDotLineRouter.newArrowShapePosition(AbstractDotLineRouter.getLast(path), arrowSize);
        AbstractDotLineRouter.InOutPointPair inOutPair = AbstractDotLineRouter.findInOutPair(3, path, false, arrowShapePosition);
        if (inOutPair != null) {
            Curves.ThirdOrderBezierCurve curve = this.getCurve(path, inOutPair);
            this.subPath(path, inOutPair, AbstractDotLineRouter.besselCurveClipShape(arrowShapePosition, curve));
        } else {
            path.clear();
        }
        return path;
    }

    @Override
    protected LineDrawProp clusterClip(ClusterDrawProp clusterDrawProp, LineDrawProp path) {
        AbstractDotLineRouter.InOutPointPair inOutPair = AbstractDotLineRouter.findInOutPair(3, path, true, clusterDrawProp);
        if (inOutPair != null) {
            Curves.ThirdOrderBezierCurve curve = this.getCurve(path, inOutPair);
            this.subPath(path, inOutPair, AbstractDotLineRouter.besselCurveClipShape(clusterDrawProp, curve));
        } else {
            path.clear();
        }
        return path;
    }

    @Override
    protected LineDrawProp nodeClip(ShapePosition node, LineDrawProp path, boolean firstStart) {
        AbstractDotLineRouter.InOutPointPair inOutPair = AbstractDotLineRouter.findInOutPair(3, path, firstStart, node);
        if (inOutPair != null) {
            Curves.ThirdOrderBezierCurve curve = this.getCurve(path, inOutPair);
            this.subPath(path, inOutPair, AbstractDotLineRouter.besselCurveClipShape(node, curve));
        }
        return path;
    }

    @Override
    protected boolean isNull(LineDrawProp path) {
        return CollectionUtils.isEmpty(path);
    }

    private void subPath(LineDrawProp path, AbstractDotLineRouter.InOutPointPair inOutPair, Curves.ThirdOrderBezierCurve curve) {
        if (inOutPair.isDeleteBefore()) {
            if (inOutPair.getIdx() > -4) {
                path.subList(0, inOutPair.getIdx() + 4).clear();
            }
            path.add(0, curve.getV4());
            path.add(0, curve.getV3());
            path.add(0, curve.getV2());
            path.add(0, curve.getV1());
        } else {
            int time = path.size() - inOutPair.getIdx() + 3;
            for (int i = 0; i < time; ++i) {
                path.remove(path.size() - 1);
            }
            path.add(curve.getV1());
            path.add(curve.getV2());
            path.add(curve.getV3());
            path.add(curve.getV4());
        }
    }

    private Curves.ThirdOrderBezierCurve getCurve(LineDrawProp path, AbstractDotLineRouter.InOutPointPair inOutPair) {
        Curves.ThirdOrderBezierCurve curve = inOutPair.isDeleteBefore() ? new Curves.ThirdOrderBezierCurve(inOutPair.getIn(), (FlatPoint)path.get(inOutPair.getIdx() + 1), (FlatPoint)path.get(inOutPair.getIdx() + 2), inOutPair.getOut()) : new Curves.ThirdOrderBezierCurve(inOutPair.getOut(), (FlatPoint)path.get(inOutPair.getIdx() - 2), (FlatPoint)path.get(inOutPair.getIdx() - 1), inOutPair.getIn());
        return curve;
    }
}

