/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.attributes.LineStyle;
import org.graphper.def.AbstractDirectedEdge;
import org.graphper.def.FlatPoint;
import org.graphper.layout.dot.DNode;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

class DLine
extends AbstractDirectedEdge<DNode, DLine> {
    private static final long serialVersionUID = -4923098199188113451L;
    private final Line line;
    private double cutVal;
    private List<DLine> parallelLineRecord;
    private int limit;
    private final boolean realTimeLimit;
    private final FlatPoint labelSize;
    private final LineAttrs lineAttrs;

    DLine(DNode left, DNode right, Line line, LineAttrs lineAttrs, double weight, int limit) {
        this(left, right, line, lineAttrs, weight, limit, null);
    }

    DLine(DNode left, DNode right, double weight, int limit, boolean realTimeLimit) {
        this(left, right, null, null, weight, limit, null, realTimeLimit);
    }

    DLine(DNode left, DNode right, Line line, LineAttrs lineAttrs, double weight, int limit, FlatPoint labelSize) {
        this(left, right, line, lineAttrs, weight, limit, labelSize, false);
    }

    DLine(DNode left, DNode right, Line line, LineAttrs lineAttrs, double weight, int limit, FlatPoint labelSize, boolean realTimeLimit) {
        super(left, right, weight);
        this.line = line;
        this.limit = limit;
        this.labelSize = labelSize;
        if (line != null) {
            Asserts.nullArgument(lineAttrs, "lineAttrs");
        }
        this.lineAttrs = lineAttrs;
        this.realTimeLimit = realTimeLimit;
    }

    Line getLine() {
        return this.line;
    }

    LineAttrs lineAttrs() {
        return this.lineAttrs;
    }

    DNode getLowRankNode() {
        return ((DNode)this.from()).getRankIgnoreModel() < ((DNode)this.to()).getRankIgnoreModel() ? (DNode)this.from() : (DNode)this.to();
    }

    DNode getLargeRankNode() {
        return ((DNode)this.from()).getRankIgnoreModel() >= ((DNode)this.to()).getRankIgnoreModel() ? (DNode)this.from() : (DNode)this.to();
    }

    double getCutVal() {
        return this.cutVal;
    }

    void setCutVal(double cutVal) {
        this.cutVal = cutVal;
    }

    void setLimit(int limit) {
        this.limit = limit;
    }

    int limit() {
        if (this.realTimeLimit) {
            return (int)((DNode)this.from()).rightWidth() + this.limit + (int)((DNode)this.to()).leftWidth();
        }
        return this.limit;
    }

    int slack() {
        return ((DNode)this.to()).getRank() - ((DNode)this.from()).getRank();
    }

    int reduceLen() {
        int slack = Math.abs(this.slack());
        return slack - this.limit();
    }

    boolean isParallelMerge() {
        return CollectionUtils.isNotEmpty(this.parallelLineRecord);
    }

    boolean isSameRank() {
        return ((DNode)this.from()).getRankIgnoreModel() == ((DNode)this.to()).getRankIgnoreModel();
    }

    boolean isSameRankAdj() {
        return this.isSameRank() && Math.abs(((DNode)this.from()).getRankIndex() - ((DNode)this.to()).getRankIndex()) == 1;
    }

    int getParallelNums() {
        return CollectionUtils.isEmpty(this.parallelLineRecord) ? 1 : this.parallelLineRecord.size();
    }

    DLine parallelLine(int no) {
        return CollectionUtils.isEmpty(this.parallelLineRecord) ? this : this.parallelLineRecord.get(no);
    }

    void addParallelEdge(DLine edge) {
        if (this.parallelLineRecord == null) {
            this.parallelLineRecord = new ArrayList<DLine>(2);
            this.parallelLineRecord.add(this);
        }
        this.parallelLineRecord.add(edge);
    }

    boolean isVirtual() {
        return this.line == null;
    }

    FlatPoint getLabelSize() {
        return this.labelSize;
    }

    boolean haveLabel() {
        if (this.isParallelMerge()) {
            for (int i = 0; i < this.getParallelNums(); ++i) {
                DLine l = this.parallelLine(i);
                if (!(l == this ? this.labelSize != null : l.getLabelSize() != null)) continue;
                return true;
            }
            return false;
        }
        return this.labelSize != null;
    }

    boolean isReversal() {
        if (this.isVirtual()) {
            return false;
        }
        return this.line.tail() == ((DNode)this.to()).getNode();
    }

    boolean isHide() {
        if (this.isVirtual()) {
            return false;
        }
        return this.lineAttrs().getStyle() == LineStyle.INVIS;
    }

    @Override
    public double weight() {
        if (!this.isParallelMerge()) {
            return this.line != null ? this.line.weight() : this.weight;
        }
        double w = 0.0;
        for (int i = 0; i < this.parallelLineRecord.size(); ++i) {
            DLine l = this.parallelLineRecord.get(i);
            if (l.isVirtual()) continue;
            w += l.lineAttrs().getWeight() == null ? 1.0 : l.lineAttrs().getWeight();
        }
        return w;
    }

    @Override
    public DLine reverse() {
        return new DLine((DNode)this.right, (DNode)this.left, this.line, this.lineAttrs, this.weight, this.limit, this.labelSize, this.realTimeLimit);
    }

    @Override
    public DLine copy() {
        DLine repl = new DLine((DNode)this.left, (DNode)this.right, this.line, this.lineAttrs, this.weight, this.limit, this.labelSize, this.realTimeLimit);
        repl.cutVal = this.cutVal;
        return repl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DLine line1 = (DLine)o;
        return Double.compare(line1.cutVal, this.cutVal) == 0 && this.limit == line1.limit && Objects.equals(this.line, line1.line);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.line, this.cutVal, this.limit);
    }

    @Override
    public String toString() {
        return "{from:" + this.left + ",to:" + this.right + ",weight:" + this.weight + ",limit:" + this.limit + ",cutval:" + this.cutVal + "}";
    }
}

