/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.graphper.api.GraphContainer;
import org.graphper.api.Line;
import org.graphper.api.Node;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.Splines;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePosition;
import org.graphper.def.FlatPoint;
import org.graphper.def.VertexIndex;
import org.graphper.draw.DrawGraph;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.NodeSizeExpander;
import org.graphper.layout.dot.OrthoNodeSizeExpander;
import org.graphper.layout.dot.PortNodeSizeExpander;
import org.graphper.layout.dot.PortNodeSizeExpanderV2;
import org.graphper.util.CollectionUtils;

class DNode
extends VertexIndex
implements Box,
ShapePosition {
    private static final long serialVersionUID = -7182604069185202045L;
    public static final int FLAT_LABEL_GAP = 5;
    private static final int RANK_MODEL_BIT = 31;
    private static final int AUX_MODE = 1;
    private static final int NOT_ADJUST_MID = 1024;
    private final Node node;
    private int rank;
    private int rankIndex;
    private int auxRank;
    private int low;
    private int lim;
    private double median;
    private double x;
    private double y;
    private double width;
    private double height;
    private double nodeSep;
    private int status;
    private List<DLine> selfLines;
    private GraphContainer container;
    private NodeAttrs nodeAttrs;
    private Line labelLine;
    private final DLine flatLabelLine;
    private NodeSizeExpander nodeSizeExpander;

    DNode(Node node, double width, double height, double nodeSep) {
        this(node, width, height, nodeSep, null, null);
    }

    DNode(Node node, double width, double height, double nodeSep, Line labelLine) {
        this(node, width, height, nodeSep, labelLine, null);
    }

    DNode(Node node, double width, double height, double nodeSep, DLine labelLine) {
        this(node, width, height, nodeSep, null, labelLine);
    }

    private DNode(Node node, double width, double height, double nodeSep, Line labelLine, DLine flatLabelLine) {
        this.node = node;
        this.width = width;
        this.height = height;
        this.nodeSep = nodeSep;
        this.labelLine = labelLine;
        this.flatLabelLine = flatLabelLine;
        this.setFlatLabelSize(flatLabelLine);
    }

    private void setFlatLabelSize(DLine flatLabelLine) {
        if (flatLabelLine == null) {
            return;
        }
        this.height = 0.0;
        this.width = 0.0;
        for (int i = 0; i < flatLabelLine.getParallelNums(); ++i) {
            DLine line = flatLabelLine.parallelLine(i);
            FlatPoint labelSize = line.getLabelSize();
            if (labelSize == null) {
                this.height += 5.0;
                continue;
            }
            this.height += labelSize.getHeight();
            this.width = Math.max(labelSize.getWidth(), this.width);
        }
    }

    static DNode newVirtualNode(double nodeSep, GraphContainer container) {
        DNode node = new DNode(null, 20.0, 1.0, nodeSep);
        node.setContainer(container);
        return node;
    }

    Node getNode() {
        return this.node;
    }

    void setNodeAttrs(NodeAttrs nodeAttrs) {
        this.nodeAttrs = nodeAttrs;
    }

    boolean isVirtual() {
        return this.node == null;
    }

    boolean isLabelNode() {
        return this.labelLine != null;
    }

    void setLabelLine(Line labelLine) {
        this.labelLine = labelLine;
    }

    boolean isFlatLabelNode() {
        return this.flatLabelLine != null;
    }

    int getRankIgnoreModel() {
        int s = this.status;
        this.switchNormalModel();
        int rank = this.getRank();
        this.status = s;
        return rank;
    }

    int getRank() {
        if (this.isNormalModel()) {
            return this.rank;
        }
        if (this.isAuxModel()) {
            return this.auxRank;
        }
        throw new IllegalStateException("Node unknown status");
    }

    void setRank(int rank) {
        if (this.isNormalModel()) {
            this.rank = rank;
        } else if (this.isAuxModel()) {
            this.auxRank = rank;
        } else {
            throw new IllegalStateException("Node unknown status");
        }
    }

    void setAuxRank(int auxRank) {
        this.auxRank = auxRank;
    }

    int getLow() {
        return this.low;
    }

    void setLow(int low) {
        this.low = low;
    }

    int getLim() {
        return this.lim;
    }

    void setLim(int lim) {
        this.lim = lim;
    }

    double getMedian() {
        return this.median;
    }

    void setMedian(double median) {
        this.median = median;
    }

    @Override
    public double getX() {
        return this.x;
    }

    void setX(double x) {
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    void setY(double y) {
        this.y = y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    void setWidth(int width) {
        this.width = width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    void setHeight(int height) {
        this.height = height;
    }

    boolean isNormalModel() {
        return this.status << 31 >>> 31 == 0;
    }

    boolean isAuxModel() {
        return this.status << 31 >>> 31 == 1;
    }

    boolean notAdjust() {
        return (this.status & 0x400) == 1024;
    }

    void switchAuxModel() {
        this.status |= 1;
    }

    void switchNormalModel() {
        this.status >>= 1;
        this.status <<= 1;
    }

    void markNotAdjustMid() {
        this.status |= 0x400;
    }

    int getSelfLoopCount() {
        return this.selfLines == null ? 0 : this.selfLines.size();
    }

    void addSelfLine(DLine line) {
        if (line == null) {
            return;
        }
        if (this.selfLines == null) {
            this.selfLines = new ArrayList<DLine>(2);
        }
        this.selfLines.add(line);
    }

    void sortSelfLine(Comparator<DLine> lineComparator) {
        if (lineComparator == null || CollectionUtils.isEmpty(this.selfLines)) {
            return;
        }
        this.selfLines.sort(lineComparator);
    }

    DLine selfLine(int index) {
        return CollectionUtils.isEmpty(this.selfLines) ? null : this.selfLines.get(index);
    }

    boolean haveSelfLine() {
        return CollectionUtils.isNotEmpty(this.selfLines);
    }

    List<DLine> getSelfLines() {
        return this.selfLines == null ? Collections.emptyList() : this.selfLines;
    }

    void initNodeSizeExpander(DrawGraph drawGraph) {
        if (this.isVirtual() || !this.haveSelfLine() || this.nodeSizeExpander != null) {
            return;
        }
        Splines splines = drawGraph.getGraphviz().graphAttrs().getSplines();
        this.nodeSizeExpander = splines == Splines.ORTHO ? new OrthoNodeSizeExpander(this) : (drawGraph.usePortAxisExpander() ? new PortNodeSizeExpander(drawGraph, this) : new PortNodeSizeExpanderV2(drawGraph, this));
    }

    NodeSizeExpander getNodeSizeExpander() {
        return this.nodeSizeExpander;
    }

    DLine getFlatLabelLine() {
        return this.flatLabelLine;
    }

    double leftWidth() {
        if (this.isLabelNode()) {
            return 0.0;
        }
        double lw = this.nodeShape().leftWidth(this.width);
        if (this.nodeSizeExpander != null) {
            lw += this.nodeSizeExpander.getLeftWidthOffset();
        }
        return lw;
    }

    double rightWidth() {
        if (this.isLabelNode()) {
            return this.width;
        }
        double rw = this.nodeShape().rightWidth(this.width);
        if (this.nodeSizeExpander != null) {
            rw += this.nodeSizeExpander.getRightWidthOffset();
        }
        return rw;
    }

    double topHeight() {
        double th = this.nodeShape().topHeight(this.height);
        if (this.nodeSizeExpander != null) {
            th += this.nodeSizeExpander.getTopHeightOffset();
        }
        return th;
    }

    double bottomHeight() {
        double bh = this.nodeShape().bottomHeight(this.height);
        if (this.nodeSizeExpander != null) {
            bh += this.nodeSizeExpander.getBottomHeightOffset();
        }
        return bh;
    }

    double realLeftWidth() {
        return this.nodeShape().leftWidth(this.width);
    }

    double realRightWidth() {
        if (this.isLabelNode()) {
            return this.width;
        }
        return this.nodeShape().rightWidth(this.width);
    }

    double realTopHeight() {
        return this.nodeShape().topHeight(this.height);
    }

    double realBottomHeight() {
        return this.nodeShape().bottomHeight(this.height);
    }

    @Override
    public double getLeftBorder() {
        if (this.isLabelNode()) {
            return this.getX() - this.leftWidth();
        }
        return this.getX() - this.realLeftWidth();
    }

    @Override
    public double getRightBorder() {
        if (this.isLabelNode()) {
            return this.getX() + this.rightWidth();
        }
        return this.getX() + this.realRightWidth();
    }

    @Override
    public double getUpBorder() {
        return this.getY() - this.realTopHeight();
    }

    @Override
    public double getDownBorder() {
        return this.getY() + this.realBottomHeight();
    }

    double getNodeSep() {
        return this.nodeSep;
    }

    void nodeSepHalving() {
        this.nodeSep /= 2.0;
    }

    String name() {
        if (this.isVirtual() || this.nodeAttrs == null) {
            if (this.isLabelNode()) {
                return this.labelLine.lineAttrs().getLabel();
            }
            return String.valueOf(this.hashCode());
        }
        return this.nodeAttrs.getLabel() != null ? this.nodeAttrs.getLabel() : "none";
    }

    int getAuxRank() {
        return this.auxRank;
    }

    int getRankIndex() {
        return this.rankIndex;
    }

    void setRankIndex(int rankIndex) {
        if (this.status == 1) {
            return;
        }
        this.rankIndex = rankIndex;
    }

    Line getLabelLine() {
        return this.labelLine;
    }

    @Override
    public NodeShape nodeShape() {
        if (this.isVirtual() || this.nodeAttrs == null) {
            return NodeShapeEnum.CIRCLE;
        }
        return this.nodeAttrs.getNodeShape();
    }

    GraphContainer getContainer() {
        return this.container;
    }

    void setContainer(GraphContainer container) {
        this.container = container;
    }

    boolean isTail(DLine line) {
        if (line == null || line.isVirtual() || this.isVirtual()) {
            return false;
        }
        return this.node == line.getLine().tail();
    }

    public String toString() {
        return "{name=" + this.name() + ",rank=" + this.getRank() + ",width=" + this.width + "}";
    }
}

