/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graphper.api.Cluster;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.api.Subgraph;
import org.graphper.api.attributes.Port;
import org.graphper.def.BiConcatIterable;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.Rectangle;
import org.graphper.layout.Cell;
import org.graphper.layout.LayoutAttach;
import org.graphper.layout.dot.CurvePathClip;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.LineClip;
import org.graphper.layout.dot.LineDrawPropPathClip;
import org.graphper.layout.dot.PathClip;
import org.graphper.layout.dot.SameRankAdjacentRecord;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.graphper.util.ValueUtils;

class DotAttachment
extends LayoutAttach {
    private final DotDigraph dotDigraph;
    private final Map<Node, DNode> nodeRecord;
    private final DrawGraph drawGraph;
    private boolean haveClusters;
    private boolean haveSubgraphs;
    private List<DLine> labelLines;
    private GeneratePort generatePort;
    private DotLineClip lineClip;
    private SameRankAdjacentRecord sameRankAdjacentRecord;

    public DotAttachment(DotDigraph dotDigraph, DrawGraph drawGraph, Map<Node, DNode> nodeRecord) {
        Asserts.nullArgument(drawGraph, "drawGraph");
        this.dotDigraph = dotDigraph;
        this.drawGraph = drawGraph;
        this.nodeRecord = nodeRecord;
    }

    void initLineClip() {
        this.lineClip = new DotLineClip(this.drawGraph, this.dotDigraph);
    }

    void clipAllLines() {
        if (this.lineClip != null) {
            this.lineClip.clipAllLines();
        }
    }

    Iterable<DNode> nodes(GraphContainer graphContainer) {
        return this.dotDigraph.nodes(graphContainer);
    }

    Iterable<Line> lines(GraphContainer graphContainer) {
        return this.dotDigraph.lines(graphContainer);
    }

    DotDigraph getDotDigraph() {
        return this.dotDigraph;
    }

    DrawGraph getDrawGraph() {
        return this.drawGraph;
    }

    Graphviz getGraphviz() {
        return this.drawGraph.getGraphviz();
    }

    DNode get(Node node) {
        return this.nodeRecord.get(node);
    }

    public SameRankAdjacentRecord getSameRankAdjacentRecord() {
        return this.sameRankAdjacentRecord;
    }

    public void releaseSameRankAdj() {
        this.sameRankAdjacentRecord = null;
    }

    public void setSameRankAdjacentRecord(SameRankAdjacentRecord sameRankAdjacentRecord) {
        this.sameRankAdjacentRecord = sameRankAdjacentRecord;
    }

    DNode mappingToDNode(Node node) {
        return new DNode(node, this.drawGraph.width(node), this.drawGraph.height(node), this.drawGraph.getGraphviz().graphAttrs().getNodeSep());
    }

    List<DLine> getLabelLines() {
        return CollectionUtils.isEmpty(this.labelLines) ? Collections.emptyList() : this.labelLines;
    }

    void releaseLabelLines() {
        this.labelLines = null;
    }

    void addNode(DNode node) {
        this.dotDigraph.add(node);
    }

    void addEdge(DLine line) {
        this.dotDigraph.addEdge(line);
        if (line.haveLabel()) {
            if (this.labelLines == null) {
                this.labelLines = new ArrayList<DLine>(2);
            }
            this.labelLines.add(line);
        }
    }

    void put(Node node, DNode dNode) {
        this.nodeRecord.put(node, dNode);
    }

    void markHaveCluster() {
        this.haveClusters = true;
    }

    void markHaveSubgraph() {
        this.haveSubgraphs = true;
    }

    boolean haveClusters() {
        return this.haveClusters;
    }

    boolean haveSubgraphs() {
        return this.haveSubgraphs;
    }

    GeneratePort getGeneratePort() {
        return this.generatePort;
    }

    boolean notContain(GraphContainer father, GraphContainer container) {
        return DotAttachment.notContain(this.drawGraph.getGraphviz(), father, container);
    }

    GraphContainer commonParent(DNode v, DNode w) {
        return DotAttachment.commonParent(this.getGraphviz(), v, w);
    }

    GraphContainer clusterDirectContainer(GraphContainer parent, DNode node) {
        GraphContainer father;
        if (node.getContainer() == parent) {
            return null;
        }
        Graphviz graphviz = this.getGraphviz();
        GraphContainer current = node.getContainer();
        while ((father = graphviz.effectiveFather(current)) != parent && father != null) {
            current = father;
        }
        return father == parent ? current : null;
    }

    void addGeneratePort(DLine line) {
        if (line == null || line.isVirtual()) {
            return;
        }
        Line edge = line.getLine();
        Node tail = edge.tail();
        Node head = edge.head();
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(edge);
        Asserts.nullArgument(lineDrawProp, "Can not found line prop when generate line port");
        LineAttrs lineAttrs = lineDrawProp.lineAttrs();
        GeneratePortLine generatePortLine = null;
        Node node = this.getNode((DNode)line.from(), tail, head);
        if (this.lineNodeNeedGeneratePort(node, tail, head, lineAttrs)) {
            generatePortLine = new GeneratePortLine(lineDrawProp);
            this.setCell(node, tail, head, lineAttrs, generatePortLine, true);
        }
        if (this.lineNodeNeedGeneratePort(node = this.getNode((DNode)line.to(), tail, head), tail, head, lineAttrs)) {
            if (generatePortLine == null) {
                generatePortLine = new GeneratePortLine(lineDrawProp);
            }
            generatePortLine.to = (DNode)line.to();
            this.setCell(node, tail, head, lineAttrs, generatePortLine, false);
        }
        if (generatePortLine != null) {
            generatePortLine.from = (DNode)line.from();
            generatePortLine.to = (DNode)line.to();
            this.generatePort().addLine(generatePortLine);
        }
    }

    private void setCell(Node node, Node tail, Node head, LineAttrs lineAttrs, GeneratePortLine generatePortLine, boolean isFrom) {
        NodeDrawProp nodeDrawProp;
        Cell cell = null;
        if (tail == node) {
            nodeDrawProp = this.drawGraph.getNodeDrawProp(tail);
            Cell.RootCell root = nodeDrawProp.getCell();
            if (root != null) {
                cell = root.getCellById(lineAttrs.getTailCell());
            }
        } else {
            nodeDrawProp = this.drawGraph.getNodeDrawProp(head);
            Cell.RootCell root = nodeDrawProp.getCell();
            if (root != null) {
                cell = root.getCellById(lineAttrs.getHeadCell());
            }
        }
        if (cell == null) {
            return;
        }
        this.generatePort().addCellOpenPorts(nodeDrawProp, cell);
        if (isFrom) {
            generatePortLine.fromCell = cell;
        } else {
            generatePortLine.toCell = cell;
        }
    }

    static Iterable<Cluster> clusters(GraphContainer container) {
        ArrayList<Iterable<Cluster>> iterables = null;
        for (Subgraph subgraph : container.subgraphs()) {
            Iterable<Cluster> clusters;
            if (!subgraph.isTransparent() || (clusters = DotAttachment.clusters(subgraph)) == null) continue;
            if (iterables == null) {
                iterables = new ArrayList<Iterable<Cluster>>(2);
            }
            iterables.add(clusters);
        }
        if (iterables == null) {
            return container.clusters();
        }
        iterables.add(container.clusters());
        return new BiConcatIterable<Cluster>((Collection<Iterable<Cluster>>)iterables);
    }

    static boolean notContain(Graphviz graphviz, GraphContainer father, GraphContainer container) {
        if (father == null || container == null) {
            return true;
        }
        GraphContainer p = container;
        while (p != father && p != null) {
            p = graphviz.father(p);
        }
        return p == null;
    }

    static GraphContainer commonParent(Graphviz graphviz, DNode n, DNode w) {
        GraphContainer c1 = n.getContainer();
        GraphContainer c2 = w.getContainer();
        return DotAttachment.commonParent(graphviz, c1, c2);
    }

    static GraphContainer commonParent(Graphviz graphviz, GraphContainer c1, GraphContainer c2) {
        if (c1 == c2) {
            return c1;
        }
        if (graphviz.effectiveFather(c1) == c2) {
            return c2;
        }
        if (graphviz.effectiveFather(c2) == c1) {
            return c1;
        }
        GraphContainer tn = c1;
        GraphContainer tw = c2;
        HashMap<GraphContainer, GraphContainer> path = new HashMap<GraphContainer, GraphContainer>(4);
        while (c1 != null || c2 != null) {
            GraphContainer t;
            if (c1 != null) {
                t = (GraphContainer)path.get(c1);
                if (t != null && t == tw) {
                    return c1;
                }
                path.put(c1, tn);
                c1 = graphviz.effectiveFather(c1);
            }
            if (c2 == null) continue;
            t = (GraphContainer)path.get(c2);
            if (t != null && t == tn) {
                return c2;
            }
            path.put(c2, tw);
            c2 = graphviz.effectiveFather(c2);
        }
        return c1;
    }

    private GeneratePort generatePort() {
        if (this.generatePort == null) {
            this.generatePort = new GeneratePort();
        }
        return this.generatePort;
    }

    private Node getNode(DNode node, Node tail, Node head) {
        if (node.getNode() == tail) {
            return tail;
        }
        if (node.getNode() == head) {
            return head;
        }
        return null;
    }

    private boolean lineNodeNeedGeneratePort(Node node, Node tail, Node head, LineAttrs lineAttrs) {
        if (node == null) {
            return false;
        }
        return !this.lineHaveNodePort(node, tail, head, lineAttrs) && this.lineHaveNodeCell(node, tail, head, lineAttrs);
    }

    private boolean lineHaveNodePort(Node node, Node tail, Node head, LineAttrs lineAttrs) {
        if (node == tail) {
            return lineAttrs.getTailPort() != null;
        }
        if (node == head) {
            return lineAttrs.getHeadPort() != null;
        }
        return false;
    }

    private boolean lineHaveNodeCell(Node node, Node tail, Node head, LineAttrs lineAttrs) {
        if (node == tail) {
            return lineAttrs.getTailCell() != null;
        }
        if (node == head) {
            return lineAttrs.getHeadCell() != null;
        }
        return false;
    }

    static class GeneratePortLine {
        private LineDrawProp line;
        private DNode from;
        private DNode to;
        private Cell fromCell;
        private Cell toCell;

        public GeneratePortLine(LineDrawProp line) {
            Asserts.nullArgument(line, "Line prop");
            this.line = line;
        }

        public LineAttrs getLineAttrs() {
            return this.line.lineAttrs();
        }

        public LineDrawProp getLine() {
            return this.line;
        }

        public DNode getFrom() {
            return this.from;
        }

        public DNode getTo() {
            return this.to;
        }

        public Cell getFromCell() {
            return this.fromCell;
        }

        public Cell getToCell() {
            return this.toCell;
        }
    }

    static class GeneratePort {
        private List<GeneratePortLine> lines;
        private Map<Cell, List<Port>> cellOpenPort;

        GeneratePort() {
        }

        List<GeneratePortLine> getLines() {
            if (this.lines == null) {
                return Collections.emptyList();
            }
            return this.lines;
        }

        List<Port> getCellOpenBox(Cell cell) {
            if (this.cellOpenPort == null) {
                return null;
            }
            return this.cellOpenPort.getOrDefault(cell, Collections.emptyList());
        }

        private void addLine(GeneratePortLine line) {
            if (this.lines == null) {
                this.lines = new ArrayList<GeneratePortLine>();
            }
            this.lines.add(line);
        }

        private void addCellOpenPorts(NodeDrawProp node, Cell cell) {
            List<Port> ports;
            if (this.cellOpenPort == null) {
                this.cellOpenPort = new HashMap<Cell, List<Port>>();
            }
            if ((ports = this.cellOpenPort.get(cell)) != null) {
                return;
            }
            Rectangle cellBox = cell.getCellBox(node);
            if (ValueUtils.approximate(cellBox.getLeftBorder(), node.getLeftBorder(), 0.01)) {
                ports = new ArrayList<Port>(2);
                ports.add(Port.WEST);
            }
            if (ValueUtils.approximate(cellBox.getRightBorder(), node.getRightBorder(), 0.01)) {
                if (ports == null) {
                    ports = new ArrayList<Port>(2);
                }
                ports.add(Port.EAST);
            }
            if (ValueUtils.approximate(cellBox.getUpBorder(), node.getUpBorder(), 0.01)) {
                if (ports == null) {
                    ports = new ArrayList<Port>(2);
                }
                ports.add(Port.NORTH);
            }
            if (ValueUtils.approximate(cellBox.getDownBorder(), node.getDownBorder(), 0.01)) {
                if (ports == null) {
                    ports = new ArrayList<Port>(2);
                }
                ports.add(Port.SOUTH);
            }
            if (ports == null) {
                return;
            }
            this.cellOpenPort.put(cell, ports);
        }
    }

    static class DotLineClip
    extends LineClip {
        DotLineClip(DrawGraph drawGraph, DotDigraph dotDigraph) {
            this.drawGraph = drawGraph;
            this.dotDigraph = dotDigraph;
        }

        private void clipAllLines() {
            this.drawGraph.syncGraphvizBorder();
            for (LineDrawProp line : this.drawGraph.lines()) {
                PathClip pathClip = line.isBesselCurve() ? CurvePathClip.INSTANCE : LineDrawPropPathClip.INSTANCE;
                if (line.isSelfLoop() && CollectionUtils.isNotEmpty(line)) {
                    FlatPoint noPathDirection = (FlatPoint)line.get(line.size() / 2);
                    this.clipProcess(line, pathClip, noPathDirection, line);
                } else {
                    this.clipProcess(line, pathClip, null, line);
                }
                if (CollectionUtils.isEmpty(line)) continue;
                line.setStart((FlatPoint)line.get(0));
                line.setEnd((FlatPoint)line.get(line.size() - 1));
                this.setFloatLabel(line);
            }
            this.drawGraph.syncToGraphvizBorder();
        }
    }
}

