/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graphper.api.Cluster;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.api.Node;
import org.graphper.def.BiConcatIterable;
import org.graphper.def.ConcatIterable;
import org.graphper.def.DirectedEdgeGraph;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.util.CollectionUtils;

class DotDigraph
extends DirectedEdgeGraph<DNode, DLine> {
    private static final long serialVersionUID = -4312972825511898843L;
    private final Graphviz graphviz;
    private final Map<Node, DNode> nodeMap;
    private Map<GraphContainer, GraphGroup> containerMap;

    DotDigraph(int capacity) {
        this(capacity, null, null);
    }

    DotDigraph(int capacity, Graphviz graphviz, Map<Node, DNode> nodeMap) {
        super(capacity);
        this.graphviz = graphviz;
        this.nodeMap = nodeMap;
    }

    DNode getDNode(Node node) {
        return this.nodeMap != null ? this.nodeMap.get(node) : null;
    }

    @Override
    public boolean add(DNode node) {
        super.add(node);
        if (this.notAddChildContainer(node)) {
            return true;
        }
        GraphContainer container = node.getContainer();
        this.addContainerGroup(container);
        return true;
    }

    @Override
    public void addEdge(DLine edge) {
        super.addEdge(edge);
        if (this.notAddChildContainer((DNode)edge.from()) || this.notAddChildContainer((DNode)edge.to())) {
            return;
        }
        DNode from = (DNode)edge.from();
        DNode to = (DNode)edge.to();
        GraphContainer container = !DotAttachment.notContain(this.graphviz, from.getContainer(), to.getContainer()) ? from.getContainer() : (!DotAttachment.notContain(this.graphviz, to.getContainer(), from.getContainer()) ? to.getContainer() : DotAttachment.commonParent(this.graphviz, (DNode)edge.from(), (DNode)edge.to()));
        GraphGroup graphGroup = this.containerMap().computeIfAbsent(container, x$0 -> new GraphGroup((GraphContainer)x$0));
        if (!graphGroup.contains(edge)) {
            graphGroup.addPatchLine(edge);
        }
    }

    Iterable<DNode> nodes(GraphContainer graphContainer) {
        if (this.graphviz == null) {
            return Collections.emptyList();
        }
        if (this.graphviz == graphContainer) {
            return this;
        }
        GraphGroup graphGroup = this.containerMap().get(graphContainer);
        return graphGroup == null ? Collections.emptySet() : graphGroup.nodes();
    }

    Iterable<Line> lines(GraphContainer graphContainer) {
        if (this.graphviz == null) {
            return Collections.emptyList();
        }
        if (this.graphviz == graphContainer) {
            return this.graphviz.lines();
        }
        GraphGroup graphGroup = this.containerMap().get(graphContainer);
        return graphGroup == null ? Collections.emptySet() : graphGroup.lines();
    }

    private void addContainerGroup(GraphContainer container) {
        do {
            this.containerMap().computeIfAbsent(container, x$0 -> new GraphGroup((GraphContainer)x$0));
        } while (!(container = this.graphviz.effectiveFather(container)).isGraphviz());
    }

    private Map<GraphContainer, GraphGroup> containerMap() {
        if (this.containerMap == null) {
            this.containerMap = new HashMap<GraphContainer, GraphGroup>(this.graphviz != null ? this.graphviz.clusters().size() : 1);
        }
        return this.containerMap;
    }

    private boolean notAddChildContainer(DNode node) {
        return this.graphviz == null || node.getContainer() == this.graphviz || node.isVirtual();
    }

    private class GraphGroup {
        private final GraphContainer container;
        private List<Line> patchLines;

        private GraphGroup(GraphContainer container) {
            this.container = container;
        }

        private boolean contains(DLine line) {
            return this.container.containsLine(line.getLine());
        }

        private void addPatchLine(DLine line) {
            if (this.patchLines == null) {
                this.patchLines = new ArrayList<Line>(2);
            }
            this.patchLines.add(line.getLine());
        }

        private ConcatIterable<Node, DNode> nodes() {
            return new ConcatIterable<Node, DNode>(this::nodeFilter, DotDigraph.this.nodeMap::get, this.container.nodes());
        }

        private BiConcatIterable<Line> lines() {
            ArrayList<BiConcatIterable<Line>> iterables = null;
            for (Cluster cluster : this.container.clusters()) {
                GraphGroup graphGroup = (GraphGroup)DotDigraph.this.containerMap().get(cluster);
                if (graphGroup == null) continue;
                if (iterables == null) {
                    iterables = new ArrayList<BiConcatIterable<Line>>(2);
                }
                iterables.add(graphGroup.lines());
            }
            if (CollectionUtils.isEmpty(iterables)) {
                return new BiConcatIterable<Line>(this::lineFilter, this.container.lines(), this.patchLines);
            }
            iterables.add(new BiConcatIterable<Line>(this::lineFilter, this.container.lines(), this.patchLines));
            return new BiConcatIterable<Line>(this::lineFilter, (Collection<Iterable<Line>>)iterables);
        }

        private boolean nodeFilter(DNode node) {
            GraphContainer c = node.getContainer();
            return !DotAttachment.notContain(DotDigraph.this.graphviz, this.container, c);
        }

        private boolean lineFilter(Line line) {
            DNode from = (DNode)DotDigraph.this.nodeMap.get(line.tail());
            DNode to = (DNode)DotDigraph.this.nodeMap.get(line.head());
            GraphContainer c = DotAttachment.commonParent(DotDigraph.this.graphviz, from, to);
            return !DotAttachment.notContain(DotDigraph.this.graphviz, this.container, c);
        }
    }
}

