/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graphper.def.UndirectedEdgeGraph;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.ULine;

class DotGraph
extends UndirectedEdgeGraph<DNode, ULine> {
    private static final long serialVersionUID = -288796423920317541L;
    private final Set<ULine> lineRecord;
    private final Set<DNode> nodeRecord;

    public DotGraph() {
        this.lineRecord = new HashSet<ULine>();
        this.nodeRecord = new HashSet<DNode>();
    }

    public DotGraph(int vertexNum) {
        super(vertexNum);
        this.lineRecord = new HashSet<ULine>();
        this.nodeRecord = new HashSet<DNode>(vertexNum);
    }

    public DotGraph(int vertexNum, int edgeNum) {
        super(vertexNum);
        this.nodeRecord = new HashSet<DNode>(vertexNum);
        this.lineRecord = new HashSet<ULine>(edgeNum);
    }

    @Override
    public boolean add(DNode node) {
        if (super.add(node)) {
            return this.nodeRecord.add(node);
        }
        return false;
    }

    @Override
    public void addEdge(ULine uLine) {
        Objects.requireNonNull(uLine);
        DLine dLine = uLine.getdLine();
        Objects.requireNonNull(dLine);
        super.addEdge(uLine);
        this.lineRecord.add(uLine);
        this.nodeRecord.add((DNode)dLine.from());
        this.nodeRecord.add((DNode)dLine.to());
    }

    @Override
    public boolean removeEdge(ULine uLine) {
        return this.removeLine(uLine);
    }

    @Override
    public boolean remove(Object vertex) {
        if (vertex instanceof DNode) {
            return this.removeNode((DNode)vertex);
        }
        return false;
    }

    public boolean removeNode(DNode vertex) {
        if (super.remove(vertex)) {
            return this.nodeRecord.remove(vertex);
        }
        return false;
    }

    public boolean removeLine(ULine uLine) {
        if (super.removeEdge(uLine)) {
            return this.lineRecord.remove(uLine);
        }
        return false;
    }

    public boolean containEdge(ULine uLine) {
        return this.lineRecord.contains(uLine);
    }

    public boolean containNode(DNode node) {
        return this.nodeRecord.contains(node);
    }
}

