/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.Assemble;
import org.graphper.api.GraphAttrs;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.api.attributes.Port;
import org.graphper.api.attributes.Rankdir;
import org.graphper.api.attributes.Splines;
import org.graphper.api.ext.Box;
import org.graphper.def.EdgeDedigraph;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.layout.AbstractLayoutEngine;
import org.graphper.layout.Cell;
import org.graphper.layout.FlipShifterStrategy;
import org.graphper.layout.LayoutAttach;
import org.graphper.layout.ShifterStrategy;
import org.graphper.layout.dot.ContainerCollapse;
import org.graphper.layout.dot.Coordinate;
import org.graphper.layout.dot.CoordinateV2;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.DotLineRouter;
import org.graphper.layout.dot.LabelSupplement;
import org.graphper.layout.dot.LineHandler;
import org.graphper.layout.dot.MinCross;
import org.graphper.layout.dot.OrthogonalRouter;
import org.graphper.layout.dot.PolyLineRouter;
import org.graphper.layout.dot.RankContent;
import org.graphper.layout.dot.RoundedRouter;
import org.graphper.layout.dot.SplineRouter;
import org.graphper.util.Asserts;
import org.graphper.util.ClassUtils;
import org.graphper.util.CollectionUtils;

public class DotLayoutEngine
extends AbstractLayoutEngine
implements Serializable {
    private static final long serialVersionUID = 1932138711284862609L;
    private static final List<DotLineRouter.DotLineRouterFactory<?>> SPLINES_HANDLERS = Arrays.asList(new RoundedRouter.RoundedRouterFactory(), new SplineRouter.SplineRouterFactory(), new PolyLineRouter.PolyLineRouterFactory(), new LineHandler.LineRouterBuilder(), new OrthogonalRouter.OrthogonalRouterFactory());

    @Override
    public List<ShifterStrategy> shifterStrategies(DrawGraph drawGraph) {
        if (drawGraph.getGraphviz().graphAttrs().getRankdir() == Rankdir.TB) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new FlipShifterStrategy(drawGraph));
    }

    @Override
    protected LayoutAttach attachment(DrawGraph drawGraph) {
        HashMap<Node, DNode> nodeRecord = new HashMap<Node, DNode>(drawGraph.getGraphviz().nodeNum());
        DotDigraph dotDigraph = new DotDigraph(drawGraph.getGraphviz().nodeNum(), drawGraph.getGraphviz(), nodeRecord);
        return new DotAttachment(dotDigraph, drawGraph, nodeRecord);
    }

    @Override
    protected void consumerNode(Node node, LayoutAttach attachment, DrawGraph drawGraph, GraphContainer parentContainer) {
        boolean dnIsNull;
        DotAttachment dotAttachment = (DotAttachment)attachment;
        DNode dn = dotAttachment.get(node);
        boolean bl = dnIsNull = dn == null;
        if (dnIsNull) {
            NodeDrawProp nodeDrawProp = drawGraph.getNodeDrawProp(node);
            nodeDrawProp.flip(drawGraph.rankdir());
            dn = dotAttachment.mappingToDNode(node);
        }
        if (dn.getContainer() == null || dn.getContainer().isGraphviz()) {
            if (parentContainer.isSubgraph()) {
                if (!parentContainer.isTransparent()) {
                    dotAttachment.markHaveSubgraph();
                }
                parentContainer = drawGraph.getGraphviz().effectiveFather(parentContainer);
            }
            dn.setContainer(parentContainer);
        }
        dn.setNodeAttrs(drawGraph.getNodeDrawProp(node).nodeAttrs());
        dotAttachment.put(node, dn);
        dotAttachment.addNode(dn);
        if (parentContainer.isCluster()) {
            dotAttachment.markHaveCluster();
        }
    }

    @Override
    protected void consumerLine(Line line, LayoutAttach attachment, DrawGraph drawGraph) {
        DotAttachment dotAttachment = (DotAttachment)attachment;
        DNode source = dotAttachment.get(line.tail());
        DNode target = dotAttachment.get(line.head());
        FlatPoint labelSize = null;
        LineDrawProp lineDrawProp = drawGraph.getLineDrawProp(line);
        LineAttrs lineAttrs = lineDrawProp.lineAttrs();
        Assemble assemble = lineDrawProp.getAssemble();
        if (assemble != null) {
            labelSize = assemble.size();
        } else if (this.needLabelNode(drawGraph, line)) {
            labelSize = this.lineLabelSizeInit(lineAttrs);
        }
        if (labelSize != null && drawGraph.needFlip()) {
            labelSize.flip();
        }
        DLine dLine = new DLine(source, target, line, lineAttrs, lineAttrs.getWeight() == null ? line.weight() : lineAttrs.getWeight().doubleValue(), lineAttrs.getMinlen() != null ? lineAttrs.getMinlen() : 1, labelSize);
        dotAttachment.addEdge(dLine);
    }

    @Override
    protected void afterLayoutShifter(LayoutAttach attach) {
        DotAttachment dotAttachment = (DotAttachment)attach;
        DrawGraph drawGraph = dotAttachment.getDrawGraph();
        for (NodeDrawProp nodeDrawProp : drawGraph.nodes(true)) {
            DotLayoutEngine.nodeLabelSet(nodeDrawProp, drawGraph, true);
        }
        for (LineDrawProp line : drawGraph.lines()) {
            Assemble assemble = line.getAssemble();
            DotLayoutEngine.setCellNodeOffset(drawGraph, line.getLabelCenter(), assemble, true);
        }
        drawGraph.syncToGraphvizBorder();
    }

    @Override
    protected void afterRenderShifter(LayoutAttach attach) {
        DotAttachment dotAttachment = (DotAttachment)attach;
        DrawGraph drawGraph = dotAttachment.getDrawGraph();
        if (drawGraph.needFlip()) {
            this.containerLabelPos(drawGraph);
        }
        for (ClusterDrawProp cluster : drawGraph.clusters()) {
            Assemble assemble = cluster.getAssemble();
            DotLayoutEngine.setCellNodeOffset(drawGraph, cluster.getLabelCenter(), assemble, true);
        }
        GraphvizDrawProp graphvizDrawProp = drawGraph.getGraphvizDrawProp();
        Assemble assemble = graphvizDrawProp.getAssemble();
        if (assemble != null) {
            DotLayoutEngine.setCellNodeOffset(drawGraph, graphvizDrawProp.getLabelCenter(), assemble, true);
        }
        dotAttachment.clipAllLines();
    }

    @Override
    protected void layout(DrawGraph drawGraph, LayoutAttach attach) {
        Asserts.nullArgument(drawGraph, "DrawGraph");
        DotAttachment dotAttachment = (DotAttachment)attach;
        DotDigraph dotDigraph = dotAttachment.getDotDigraph();
        Graphviz graphviz = drawGraph.getGraphviz();
        GraphAttrs graphAttrs = graphviz.graphAttrs();
        dotAttachment.initLineClip();
        ContainerCollapse containerCollapse = new ContainerCollapse(dotAttachment, graphviz);
        RankContent rankContent = containerCollapse.getRankContent();
        if (dotAttachment.haveClusters() || dotAttachment.haveSubgraphs()) {
            this.handleLegalLine(dotDigraph);
            rankContent = new RankContent(dotDigraph, graphAttrs.getRankSep(), true, null);
        }
        MinCross minCross = new MinCross(rankContent, dotAttachment);
        EdgeDedigraph<DNode, DLine> digraphProxy = minCross.getDigraphProxy();
        new LabelSupplement(rankContent, dotAttachment, digraphProxy);
        if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("dot.coordinate.v1"))) {
            new Coordinate(graphAttrs.getNslimit(), rankContent, dotAttachment, digraphProxy);
        } else {
            new CoordinateV2(graphAttrs.getNslimit(), rankContent, dotAttachment, digraphProxy);
        }
        this.autoGeneratePort(dotAttachment);
        if (!drawGraph.needFlip()) {
            this.containerLabelPos(drawGraph);
        }
        this.splines(drawGraph, dotDigraph, rankContent, digraphProxy);
    }

    private void handleLegalLine(DotDigraph dotDigraph) {
        ArrayList<DLine> reverseLines = null;
        ArrayList<DLine> selfLoopLines = null;
        for (DNode node : dotDigraph) {
            for (DLine line : dotDigraph.adjacent(node)) {
                if (((DNode)line.from()).getRank() <= ((DNode)line.to()).getRank()) {
                    if (line.from() != line.to()) continue;
                    if (selfLoopLines == null) {
                        selfLoopLines = new ArrayList<DLine>(2);
                    }
                    selfLoopLines.add(line);
                    continue;
                }
                if (reverseLines == null) {
                    reverseLines = new ArrayList<DLine>();
                }
                reverseLines.add(line);
            }
        }
        if (CollectionUtils.isNotEmpty(reverseLines)) {
            for (DLine reverseLine : reverseLines) {
                dotDigraph.reverseEdge(reverseLine);
            }
        }
        if (CollectionUtils.isNotEmpty(selfLoopLines)) {
            for (DLine selfLoopLine : selfLoopLines) {
                if (!dotDigraph.removeEdge(selfLoopLine)) continue;
                ((DNode)selfLoopLine.from()).addSelfLine(selfLoopLine);
            }
        }
    }

    private void autoGeneratePort(DotAttachment attach) {
        DotAttachment.GeneratePort generatePort = attach.getGeneratePort();
        if (generatePort == null) {
            return;
        }
        HashMap<Cell, Box> cellBoxMap = new HashMap<Cell, Box>();
        Rankdir rankdir = attach.getDrawGraph().rankdir();
        for (DotAttachment.GeneratePortLine line : generatePort.getLines()) {
            List<Port> ports;
            Port port;
            Cell fromCell = line.getFromCell();
            Cell toCell = line.getToCell();
            Box fromCellBox = null;
            Box toCellBox = null;
            if (fromCell != null) {
                fromCellBox = cellBoxMap.computeIfAbsent(fromCell, c -> c.getCellBox(line.getFrom()));
            }
            if (toCell != null) {
                toCellBox = cellBoxMap.computeIfAbsent(toCell, c -> c.getCellBox(line.getTo()));
            }
            if (fromCellBox != null && (port = this.closestPort(ports = generatePort.getCellOpenBox(fromCell), fromCellBox, line.getTo())) != null) {
                this.setLinePort(line.getLine(), line.getFrom(), FlipShifterStrategy.backPort(port, rankdir));
            }
            if (toCellBox == null || (port = this.closestPort(ports = generatePort.getCellOpenBox(toCell), toCellBox, line.getFrom())) == null) continue;
            this.setLinePort(line.getLine(), line.getTo(), FlipShifterStrategy.backPort(port, rankdir));
        }
    }

    private void setLinePort(LineDrawProp line, DNode node, Port port) {
        LineAttrs lineAttrs = line.lineAttrs();
        try {
            if (node.getNode() == line.getLine().tail()) {
                if (lineAttrs.getTailPort() != null) {
                    return;
                }
                ClassUtils.modifyField(lineAttrs, "tailPort", port);
            }
            if (node.getNode() == line.getLine().head()) {
                if (lineAttrs.getHeadPort() != null) {
                    return;
                }
                ClassUtils.modifyField(lineAttrs, "headPort", port);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private Port closestPort(List<Port> ports, Box source, Box target) {
        if (CollectionUtils.isEmpty(ports)) {
            return null;
        }
        Port closestPort = null;
        for (Port port : ports) {
            if (closestPort == null) {
                closestPort = port;
                continue;
            }
            closestPort = this.closerPort(closestPort, port, source, target);
        }
        return closestPort;
    }

    private Port closerPort(Port left, Port right, Box source, Box target) {
        double lsy = source.getY() + left.verOffset(source);
        double rsy = source.getY() + right.verOffset(source);
        int r = Double.compare(this.yDist(lsy, target), this.yDist(rsy, target));
        if (r != 0) {
            return r < 0 ? left : right;
        }
        double lsx = source.getX() + left.horOffset(source);
        double rsx = source.getX() + right.horOffset(source);
        r = Double.compare(this.xDist(lsx, target), this.xDist(rsx, target));
        return r < 0 ? left : right;
    }

    private double xDist(double x, Box target) {
        return Math.abs(x - target.getX());
    }

    private double yDist(double y, Box target) {
        return Math.abs(y - target.getY());
    }

    private void splines(DrawGraph drawGraph, DotDigraph dotDigraph, RankContent rankContent, EdgeDedigraph<DNode, DLine> digraphProxy) {
        Splines splines = drawGraph.getGraphviz().graphAttrs().getSplines();
        Map<Line, LineDrawProp> lineDrawPropMap = drawGraph.getLineDrawPropMap();
        if (splines == null || splines == Splines.NONE || lineDrawPropMap == null || digraphProxy.vertexNum() == 0) {
            return;
        }
        for (DotLineRouter.DotLineRouterFactory<?> linesHandlerFactory : SPLINES_HANDLERS) {
            Object dotLineRouter = linesHandlerFactory.newInstance(drawGraph, dotDigraph, rankContent, digraphProxy);
            if (!dotLineRouter.needDeal(splines)) continue;
            dotLineRouter.route();
            break;
        }
    }

    private boolean needLabelNode(DrawGraph drawGraph, Line line) {
        Map<Line, LineDrawProp> lineDrawPropMap = drawGraph.getLineDrawPropMap();
        if (lineDrawPropMap == null) {
            return false;
        }
        return StringUtils.isNotEmpty(drawGraph.lineAttrs(line).getLabel());
    }

    private FlatPoint lineLabelSizeInit(LineAttrs lineAttrs) {
        String label = lineAttrs.getLabel();
        if (StringUtils.isEmpty(label)) {
            return null;
        }
        double fontSize = lineAttrs.getFontSize() != null ? lineAttrs.getFontSize() : 0.0;
        return this.labelContainer(label, lineAttrs.getFontName(), fontSize);
    }
}

