/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graphper.api.Line;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.DefaultBox;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DrawGraph;
import org.graphper.layout.Grid;
import org.graphper.layout.OrthoVisGraph;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.Maze;
import org.graphper.layout.dot.RankContent;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

class DotMaze
extends Maze {
    private final RankContent rankContent;
    private Map<Line, List<GuideInfo>> labelGuideBoxes;

    protected DotMaze(RankContent rankContent, DrawGraph drawGraph) {
        super(drawGraph);
        Asserts.nullArgument(rankContent, "rankContent");
        this.rankContent = rankContent;
        this.init();
    }

    List<GuideInfo> getGuideInfos(Line line) {
        if (line == null || this.labelGuideBoxes == null) {
            return null;
        }
        List<GuideInfo> guideInfos = this.labelGuideBoxes.get(line);
        if (CollectionUtils.isEmpty(guideInfos)) {
            return guideInfos;
        }
        for (GuideInfo guideInfo : guideInfos) {
            if (guideInfo.guideVertex == null) {
                guideInfo.guideVertex = this.getGuideVertex(guideInfo.guideBox);
            }
            Asserts.illegalArgument(guideInfo.signPos == null, "Can not found guide sign of label line");
            Asserts.illegalArgument(guideInfo.guideBox == null, "Can not found guide box of label line");
            Asserts.illegalArgument(guideInfo.guideVertex == null, "Can not found guide vertex of label line");
        }
        return guideInfos;
    }

    @Override
    protected void initGrid(Grid.GridBuilder gridBuilder) {
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (DNode node : rankNode) {
                if (!node.isVirtual()) {
                    this.addCell(node, new Maze.NodeCell(node), gridBuilder);
                    continue;
                }
                this.addLabelNode(gridBuilder, node);
                this.addFlatLabelNode(gridBuilder, node);
            }
        }
    }

    private void addLabelNode(Grid.GridBuilder gridBuilder, DNode node) {
        Box guideBox;
        if (!node.isLabelNode()) {
            return;
        }
        Box label = this.splitLabelNode(node, false);
        if (label != null) {
            this.addCell(node, new Maze.VirtualCell(label), gridBuilder);
        }
        if ((guideBox = this.splitLabelNode(node, true)) != null) {
            this.addGuideBox(guideBox, gridBuilder);
        }
        this.recordGuideBox(node.getLabelLine(), label, guideBox);
    }

    private Box splitLabelNode(DNode node, boolean isGuideBox) {
        if (!node.isLabelNode()) {
            return null;
        }
        double guideWidth = Math.min(10.0, node.getWidth() / 3.0);
        double splitLine = node.getLeftBorder() + guideWidth;
        if (isGuideBox) {
            if (10.0 >= node.getWidth()) {
                return node;
            }
            return new DefaultBox(node.getLeftBorder(), splitLine, node.getUpBorder(), node.getDownBorder());
        }
        return new DefaultBox(splitLine, node.getRightBorder(), node.getUpBorder(), node.getDownBorder());
    }

    private void addFlatLabelNode(Grid.GridBuilder gridBuilder, DNode node) {
        if (!node.isFlatLabelNode()) {
            return;
        }
        double start = node.getUpBorder();
        DLine flatLabelLine = node.getFlatLabelLine();
        for (int i = 0; i < flatLabelLine.getParallelNums(); ++i) {
            DefaultBox guideBox;
            DLine line = flatLabelLine.parallelLine(i);
            DefaultBox label = null;
            FlatPoint labelSize = line.getLabelSize();
            if (labelSize != null) {
                label = new DefaultBox(node.getLeftBorder(), node.getRightBorder(), start, start += labelSize.getHeight() - 5.0);
                guideBox = new DefaultBox(node.getLeftBorder(), node.getRightBorder(), start, start += 5.0);
            } else {
                guideBox = new DefaultBox(node.getLeftBorder(), node.getRightBorder(), start, start += 5.0);
            }
            this.addGuideBox(guideBox, gridBuilder);
            if (label == null) {
                label = guideBox;
            } else {
                this.addCell(node, new Maze.VirtualCell(label), gridBuilder);
            }
            this.recordGuideBox(line.getLine(), label, guideBox);
        }
    }

    private void recordGuideBox(Line line, Box sign, Box guideBox) {
        if (this.labelGuideBoxes == null) {
            this.labelGuideBoxes = new LinkedHashMap<Line, List<GuideInfo>>();
        }
        List guideInfos = this.labelGuideBoxes.computeIfAbsent(line, k -> new ArrayList());
        GuideInfo guideInfo = new GuideInfo();
        guideInfo.signPos = sign;
        guideInfo.guideBox = guideBox;
        guideInfo.isLabelSign = true;
        guideInfos.add(guideInfo);
    }

    static class GuideInfo {
        private Box signPos;
        private Box guideBox;
        private OrthoVisGraph.GridVertex guideVertex;
        private boolean isLabelSign;

        GuideInfo() {
        }

        public Box getSignPos() {
            return this.signPos;
        }

        public OrthoVisGraph.GridVertex getGuideVertex() {
            return this.guideVertex;
        }

        public boolean isLabelSign() {
            return this.isLabelSign;
        }
    }
}

