/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graphper.layout.Mark;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.DotGraph;
import org.graphper.layout.dot.ULine;
import org.graphper.util.CollectionUtils;

class FeasibleTree {
    private final DotDigraph dotDigraph;
    private Queue<ULine> negativeLine;
    private final DotGraph graph;
    private final DotGraph tree;
    private final boolean haveUnconnectedGraph;
    private final Map<DNode, Integer> nodeConnectRecord;

    FeasibleTree(DotDigraph digraph) {
        if (digraph == null || digraph.vertexNum() == 0) {
            throw new IllegalArgumentException("Graph can not be empty");
        }
        this.dotDigraph = digraph;
        RankInit rankInit = new RankInit(digraph);
        this.graph = rankInit.graph;
        Collection sources = rankInit.sources;
        this.tree = rankInit.tree;
        this.haveUnconnectedGraph = sources.size() > 1;
        this.nodeConnectRecord = rankInit.nodeConnectRecord;
        if (digraph.edgeNum() != 0) {
            PropInit propInit = new PropInit(digraph, this.graph, this.tree, sources);
            this.negativeLine = propInit.negativeLine;
        }
    }

    public boolean isHaveUnconnectedGraph() {
        return this.haveUnconnectedGraph;
    }

    int getConnectNo(DNode node) {
        if (this.nodeConnectRecord == null) {
            return 1;
        }
        Integer connectNo = this.nodeConnectRecord.get(node);
        return connectNo != null ? connectNo : 1;
    }

    DotDigraph getDotDigraph() {
        return this.dotDigraph;
    }

    Queue<ULine> negativeLine() {
        return this.negativeLine;
    }

    DotGraph graph() {
        return this.graph;
    }

    DotGraph tree() {
        return this.tree;
    }

    static boolean inTail(DNode node, DLine treeLine) {
        DNode from = (DNode)treeLine.from();
        DNode to = (DNode)treeLine.to();
        boolean directed = from.getLim() < to.getLim();
        DNode tail = directed ? from : to;
        return directed == (tail.getLow() <= node.getLim() && tail.getLim() >= node.getLim());
    }

    static boolean isCross(DLine treeLine, DLine line) {
        DNode from = (DNode)line.from();
        DNode to = (DNode)line.to();
        return FeasibleTree.inTail(from, treeLine) ^ FeasibleTree.inTail(to, treeLine);
    }

    static double lineCrossVal(DLine treeLine, DLine line) {
        DNode from = (DNode)line.from();
        DNode to = (DNode)line.to();
        boolean fromInTail = FeasibleTree.inTail(from, treeLine);
        boolean isCross = fromInTail ^ FeasibleTree.inTail(to, treeLine);
        if (!isCross) {
            return 0.0;
        }
        if (fromInTail) {
            return line.weight();
        }
        return -line.weight();
    }

    static double halfDfsCalcCutVal(DotGraph graph, ULine treeLine) {
        double[] cutVal = new double[]{0.0};
        Consumer<ULine> consumer = uLine -> {
            cutVal[0] = cutVal[0] + FeasibleTree.lineCrossVal(treeLine.getdLine(), uLine.getdLine());
        };
        FeasibleTree.halfDfs(graph, treeLine, consumer);
        return cutVal[0];
    }

    static Set<DNode> halfDfs(DotGraph graph, ULine treeLine, Consumer<ULine> dLineConsumer) {
        Objects.requireNonNull(graph);
        Objects.requireNonNull(treeLine);
        if (dLineConsumer == null) {
            return Collections.emptySet();
        }
        DLine treeDLine = treeLine.getdLine();
        DNode from = (DNode)treeDLine.from();
        DNode to = (DNode)treeDLine.to();
        DNode tailNode = FeasibleTree.inTail(to, treeDLine) ? to : from;
        DNode headNode = to == tailNode ? from : to;
        HashSet<DNode> queenRecord = new HashSet<DNode>();
        LinkedList<DNode> halfNodeQueen = new LinkedList<DNode>();
        DNode startNode = headNode.getLim() - headNode.getLow() < tailNode.getLim() - tailNode.getLow() ? headNode : tailNode;
        halfNodeQueen.offer(startNode);
        queenRecord.add(startNode);
        while (!halfNodeQueen.isEmpty()) {
            DNode node = (DNode)halfNodeQueen.poll();
            for (ULine uLine : graph.adjacent(node)) {
                if (FeasibleTree.isCross(treeDLine, uLine.getdLine())) {
                    dLineConsumer.accept(uLine);
                    continue;
                }
                DNode other = uLine.other(node);
                if (queenRecord.contains(other)) continue;
                halfNodeQueen.offer(other);
                queenRecord.add(other);
            }
        }
        return queenRecord;
    }

    static double calcCutValByAdjTreeLine(DotGraph graph, DNode node, ULine treeLine, Predicate<ULine> isTree) {
        if (graph == null || node == null || treeLine == null || isTree == null) {
            throw new NullPointerException();
        }
        double cutVal = 0.0;
        for (ULine uLine : graph.adjacent(node)) {
            if (uLine.getdLine() == treeLine.getdLine()) {
                cutVal += treeLine.getdLine().weight();
                continue;
            }
            if (FeasibleTree.isSameInOut(treeLine.getdLine(), uLine.getdLine())) {
                if (isTree.test(uLine)) {
                    cutVal = cutVal - uLine.getdLine().getCutVal() + uLine.getdLine().weight();
                    continue;
                }
                cutVal += uLine.getdLine().weight();
                continue;
            }
            if (isTree.test(uLine)) {
                cutVal = cutVal + uLine.getdLine().getCutVal() - uLine.getdLine().weight();
                continue;
            }
            cutVal -= uLine.getdLine().weight();
        }
        return cutVal;
    }

    private static boolean isSameInOut(DLine treeLine, DLine targetLine) {
        return treeLine.from() == targetLine.from() || treeLine.to() == targetLine.to();
    }

    private static class CutValRecord {
        private int calcNum;
        private boolean isInCutQueen;

        private CutValRecord() {
        }
    }

    private static class PropInit
    extends Mark<DNode> {
        private int reserveCount = 0;
        private int low = Integer.MAX_VALUE;
        private Queue<DNode> cutQueen;
        private Set<DLine> lineCache;
        private Queue<ULine> negativeLine;
        private final DotDigraph dotDigraph;
        private final Set<DNode> isBorder;
        private final DotGraph tree;
        private Map<DNode, CutValRecord> nodeCountValRecord;

        private PropInit(DotDigraph dotDigraph, DotGraph graph, DotGraph tree, Collection<DNode> sourceNodes) {
            super(dotDigraph.vertexNum());
            this.dotDigraph = dotDigraph;
            this.tree = tree;
            this.isBorder = new HashSet<DNode>();
            for (DNode source : sourceNodes) {
                if (this.isMark(source)) continue;
                this.dfs(source);
            }
            this.computeCutVal(graph);
        }

        private void dfs(DNode v) {
            this.mark(v);
            int tmpLow = Integer.MAX_VALUE;
            for (ULine e : this.tree.adjacent(v)) {
                DNode w = e.other(v);
                if (this.isMark(w)) continue;
                this.dfs(w);
                tmpLow = Math.min(tmpLow, this.low);
                this.low = Integer.MAX_VALUE;
            }
            if (this.tree.degree(v) == 1) {
                this.isBorder.add(v);
                this.offerCutQueen(v);
            }
            int lim = ++this.reserveCount;
            this.low = Math.min(tmpLow, lim);
            v.setLow(this.low);
            v.setLim(lim);
        }

        private void computeCutVal(DotGraph graph) {
            while (CollectionUtils.isNotEmpty(this.cutQueen)) {
                DNode node = this.cutQueen.poll();
                if (this.isBorder.contains(node)) {
                    this.calcBorderCutVal(graph, node);
                    continue;
                }
                this.calcNormalCutVal(graph, node);
            }
        }

        private void calcNormalCutVal(DotGraph graph, DNode node) {
            int degreeThreshold = this.tree.degree(node) - 1;
            for (ULine uLine : this.tree.adjacent(node)) {
                if (this.lineCacheContain(uLine.getdLine())) continue;
                DNode other = uLine.other(node);
                DNode nextNode = node;
                if (this.getNodeHavedCalcLineNum(nextNode) == degreeThreshold || this.getNodeHavedCalcLineNum(nextNode = other) == this.tree.degree(other) - 1) {
                    this.calcCutValByAdjNode(graph, nextNode, uLine);
                } else {
                    this.npCalcCutVal(graph, uLine);
                }
                this.offerCutQueen(other);
            }
        }

        private void calcBorderCutVal(DotGraph graph, DNode border) {
            ULine uTreeLine = null;
            Iterator iterator = this.tree.adjacent(border).iterator();
            if (iterator.hasNext()) {
                ULine uLine;
                uTreeLine = uLine = (ULine)iterator.next();
            }
            if (uTreeLine == null) {
                throw new RuntimeException("Find the wrong border node!");
            }
            DLine treeLine = uTreeLine.getdLine();
            if (this.lineCacheContain(treeLine)) {
                return;
            }
            double cutVal = 0.0;
            boolean borderIsFrom = treeLine.from() == border;
            for (ULine edge : graph.adjacent(border)) {
                if (borderIsFrom == (edge.getdLine().from() == border)) {
                    cutVal += edge.getdLine().weight();
                    continue;
                }
                cutVal -= edge.getdLine().weight();
            }
            this.setCutValAndMarkTreeLine(cutVal, uTreeLine);
            this.offerCutQueen(treeLine.other(border));
        }

        private void calcCutValByAdjNode(DotGraph graph, DNode node, ULine treeLine) {
            this.setCutValAndMarkTreeLine(FeasibleTree.calcCutValByAdjTreeLine(graph, node, treeLine, this.tree::containEdge), treeLine);
        }

        private void npCalcCutVal(DotGraph graph, ULine treeLine) {
            this.setCutValAndMarkTreeLine(FeasibleTree.halfDfsCalcCutVal(graph, treeLine), treeLine);
        }

        private int getNodeHavedCalcLineNum(DNode node) {
            CutValRecord cutValRecord = this.getCutValRecord(node);
            return cutValRecord.calcNum;
        }

        private void increaseNodeHavedCalcLineNum(DNode node) {
            CutValRecord cutValRecord = this.getCutValRecord(node);
            cutValRecord.calcNum++;
        }

        private CutValRecord getCutValRecord(DNode node) {
            CutValRecord cutValRecord;
            if (this.nodeCountValRecord == null) {
                this.nodeCountValRecord = new HashMap<DNode, CutValRecord>(this.dotDigraph.vertexNum());
            }
            if ((cutValRecord = this.nodeCountValRecord.get(node)) == null) {
                cutValRecord = new CutValRecord();
                this.nodeCountValRecord.put(node, cutValRecord);
            }
            return cutValRecord;
        }

        private void setCutValAndMarkTreeLine(double cutVal, ULine treeLine) {
            treeLine.getdLine().setCutVal(cutVal);
            if (this.lineCache == null) {
                this.lineCache = new HashSet<DLine>();
            }
            this.lineCache.add(treeLine.getdLine());
            this.increaseNodeHavedCalcLineNum((DNode)treeLine.getdLine().from());
            this.increaseNodeHavedCalcLineNum((DNode)treeLine.getdLine().to());
            if (cutVal < 0.0) {
                if (this.negativeLine == null) {
                    this.negativeLine = new LinkedBlockingQueue<ULine>();
                }
                this.negativeLine.offer(treeLine);
            }
        }

        private boolean lineCacheContain(DLine treeLine) {
            if (this.lineCache == null) {
                return false;
            }
            return this.lineCache.contains(treeLine);
        }

        private void offerCutQueen(DNode node) {
            CutValRecord cutValRecord;
            if (this.cutQueen == null) {
                this.cutQueen = new LinkedBlockingQueue<DNode>();
            }
            if (!(cutValRecord = this.getCutValRecord(node)).isInCutQueen) {
                this.cutQueen.offer(node);
                cutValRecord.isInCutQueen = true;
            }
        }
    }

    private static class RankInit
    extends Mark<DNode> {
        private final DotGraph graph;
        private final DotGraph tree;
        private Collection<DNode> sources;
        private Map<DNode, Integer> nodeConnectRecord;

        public RankInit(DotDigraph dotDigraph) {
            int edgeNum = dotDigraph.edgeNum();
            this.graph = new DotGraph(dotDigraph.vertexNum(), edgeNum);
            this.tree = edgeNum == 0 ? this.graph : new DotGraph(dotDigraph.vertexNum());
            PriorityQueue<ULine> minLines = new PriorityQueue<ULine>(Comparator.comparing(ULine::reduceLen));
            this.initRank(dotDigraph, minLines);
            this.generateTree(minLines);
            this.clear();
        }

        private void initRank(DotDigraph dotDigraph, Queue<ULine> minLines) {
            for (DNode node : dotDigraph) {
                if (this.isMark(node)) continue;
                this.dfs(dotDigraph, minLines, node);
            }
            this.connectSource();
        }

        private void connectSource() {
            this.clear();
            HashMap<Integer, DNode> sourceMap = new HashMap<Integer, DNode>(1);
            int connectNo = 1;
            for (DNode node : this.graph) {
                if (this.isMark(node)) continue;
                this.dfs(node, connectNo++, sourceMap);
            }
            this.sources = sourceMap.values();
        }

        private void dfs(DotDigraph dotDigraph, Queue<ULine> minLines, DNode from) {
            this.mark(from);
            this.graph.add(from);
            int minRank = 0;
            ULine minLine = null;
            for (DLine dLine : dotDigraph.adjacent(from)) {
                DNode to = dLine.other(from);
                ULine uLine = new ULine((DNode)dLine.from(), to, dLine, dLine.weight());
                this.graph.addEdge(uLine);
                if (!this.isMark(to)) {
                    this.dfs(dotDigraph, minLines, to);
                }
                minRank = Math.min(minRank, to.getRank() - dLine.limit());
                from.setRank(minRank);
                if (minLine != null && minLine.reduceLen() <= uLine.reduceLen()) continue;
                minLine = uLine;
            }
            if (minLine != null) {
                minLines.add(minLine);
            }
        }

        private void dfs(DNode node, int connectNo, Map<Integer, DNode> sourceMap) {
            DNode sn;
            this.mark(node);
            if (connectNo > 1) {
                if (this.nodeConnectRecord == null) {
                    this.nodeConnectRecord = new HashMap<DNode, Integer>();
                }
                this.nodeConnectRecord.put(node, connectNo);
            }
            if ((sn = sourceMap.get(connectNo)) == null || node.getRank() < sn.getRank()) {
                sourceMap.put(connectNo, node);
            }
            for (ULine uLine : this.graph.adjacent(node)) {
                DNode other = uLine.other(node);
                if (this.isMark(other)) continue;
                this.dfs(other, connectNo, sourceMap);
            }
        }

        private void generateTree(Queue<ULine> minLines) {
            Queue<ULine> treeAdjacentEdges = new PriorityQueue<ULine>(Comparator.comparing(ULine::reduceLen));
            while (this.tree.vertexNum() < this.graph.vertexNum() && CollectionUtils.isNotEmpty(minLines)) {
                treeAdjacentEdges.clear();
                treeAdjacentEdges.add(minLines.poll());
                while (CollectionUtils.isNotEmpty(treeAdjacentEdges)) {
                    DLine dLine;
                    DNode next;
                    ULine uLine = (ULine)treeAdjacentEdges.poll();
                    if (uLine == null || this.tree.containEdge(uLine) || this.tree.containNode(next = this.tree.containNode((DNode)(dLine = uLine.getdLine()).from()) ? (DNode)dLine.to() : (DNode)dLine.from())) continue;
                    int reduceLen = dLine.reduceLen();
                    if (reduceLen != 0) {
                        int delta = next == dLine.from() ? -reduceLen : reduceLen;
                        for (DNode dNode : this.tree) {
                            dNode.setRank(dNode.getRank() + delta);
                        }
                        treeAdjacentEdges = this.newMinQueue(treeAdjacentEdges);
                    }
                    this.addAdjEdgesQueen(treeAdjacentEdges, uLine);
                    this.tree.addEdge(uLine);
                }
            }
        }

        private void addAdjEdgesQueen(Queue<ULine> treeAdjacentEdges, ULine uLine) {
            DNode from = (DNode)uLine.getdLine().from();
            DNode to = (DNode)uLine.getdLine().to();
            if (!this.tree.containNode(from)) {
                this.addAdjEdgesQueen(treeAdjacentEdges, uLine, from);
            }
            if (!this.tree.containNode(to)) {
                this.addAdjEdgesQueen(treeAdjacentEdges, uLine, to);
            }
        }

        private void addAdjEdgesQueen(Queue<ULine> treeAdjacentEdges, ULine uLine, DNode node) {
            for (ULine line : this.graph.adjacent(node)) {
                if (line == uLine || this.tree.containNode((DNode)line.getdLine().from()) && this.tree.containNode((DNode)line.getdLine().to())) continue;
                treeAdjacentEdges.offer(line);
            }
        }

        private Queue<ULine> newMinQueue(Queue<ULine> treeAdjacentEdges) {
            if (CollectionUtils.isEmpty(treeAdjacentEdges)) {
                return treeAdjacentEdges;
            }
            PriorityQueue<ULine> uLines = new PriorityQueue<ULine>(treeAdjacentEdges.size(), Comparator.comparing(ULine::reduceLen));
            uLines.addAll(treeAdjacentEdges);
            return uLines;
        }
    }
}

