/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import org.graphper.def.AbstractDirectedEdge;
import org.graphper.def.EdgeDedigraph;
import org.graphper.def.FlatPoint;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.layout.dot.PortHelper;
import org.graphper.layout.dot.RankContent;
import org.graphper.layout.dot.SameRankAdjacentRecord;
import org.graphper.util.CollectionUtils;

class LabelSupplement {
    private final RankContent rankContent;
    private final DotAttachment dotAttachment;
    private final EdgeDedigraph<DNode, DLine> digraphProxy;

    public LabelSupplement(RankContent rankContent, DotAttachment dotAttachment, EdgeDedigraph<DNode, DLine> digraphProxy) {
        this.rankContent = rankContent;
        this.dotAttachment = dotAttachment;
        this.digraphProxy = digraphProxy;
        this.insertLabelNodeRank();
        this.flatParallelEdge();
    }

    private void insertLabelNodeRank() {
        if (CollectionUtils.isEmpty(this.dotAttachment.getLabelLines())) {
            return;
        }
        HashSet<Integer> needInsertLabelRankIdxs = null;
        for (DLine labelLine : this.dotAttachment.getLabelLines()) {
            Iterator from = (DNode)labelLine.from();
            if (!labelLine.haveLabel() || Math.abs(labelLine.slack()) != 1) continue;
            Object minRankNode = (DNode)labelLine.to();
            Object object = minRankNode = ((DNode)minRankNode).getRank() > ((DNode)((Object)from)).getRank() ? from : minRankNode;
            if (needInsertLabelRankIdxs == null) {
                needInsertLabelRankIdxs = new HashSet<Integer>();
            }
            needInsertLabelRankIdxs.add(((DNode)minRankNode).getRank());
        }
        this.dotAttachment.releaseLabelLines();
        if (CollectionUtils.isEmpty(needInsertLabelRankIdxs)) {
            return;
        }
        ArrayList addLines = null;
        ArrayList<DLine> removeLines = null;
        for (Integer rankIdx : needInsertLabelRankIdxs) {
            RankContent.RankNode rankNode = this.rankContent.get(rankIdx);
            RankContent.RankNode labelRankNode = new RankContent.RankNode(rankNode, rankNode.next(), 0, true);
            if (rankNode.next != null) {
                rankNode.next.pre = labelRankNode;
            }
            rankNode.next = labelRankNode;
            rankNode.rankSep /= 2.0;
            labelRankNode.rankSep = rankNode.rankSep;
            for (DNode node : rankNode) {
                for (DLine line : this.digraphProxy.outAdjacent(node)) {
                    if (removeLines == null) {
                        removeLines = new ArrayList<DLine>();
                        addLines = new ArrayList();
                    }
                    this.recordNewRemoveLines(line, labelRankNode, addLines, removeLines);
                }
            }
        }
        if (CollectionUtils.isEmpty(removeLines)) {
            return;
        }
        for (DLine removeLine : removeLines) {
            this.digraphProxy.removeEdge(removeLine);
        }
        for (DLine addLine : addLines) {
            this.digraphProxy.addEdge(addLine);
        }
        this.rankContent.rankIndexSync();
        for (RankContent.RankNode current = this.rankContent.get(this.rankContent.minRank()); current != null; current = current.next()) {
            if (current.isLabelRank()) {
                current.sort(this::labelNodeComparator);
            }
            for (int j = 0; j < current.size(); ++j) {
                DNode node = current.get(j);
                node.setRank(current.rankIndex());
                node.setRankIndex(j);
            }
        }
    }

    private void recordNewRemoveLines(DLine line, RankContent.RankNode rankNode, List<DLine> addLines, List<DLine> removeLines) {
        if (line.isSameRank()) {
            return;
        }
        removeLines.add(line);
        for (int i = 0; i < line.getParallelNums(); ++i) {
            DNode virtual;
            DLine edge = line.parallelLine(i);
            FlatPoint labelSize = edge.getLabelSize();
            if (labelSize == null) {
                virtual = DNode.newVirtualNode(20.0, this.dotAttachment.commonParent((DNode)edge.from(), (DNode)edge.to()));
            } else {
                virtual = new DNode(null, labelSize.getWidth(), labelSize.getHeight(), ((DNode)edge.from()).getNodeSep(), edge.getLine());
                virtual.setContainer(this.dotAttachment.commonParent((DNode)edge.from(), (DNode)edge.to()));
            }
            addLines.add(new DLine((DNode)edge.from(), virtual, edge.getLine(), edge.lineAttrs(), edge.weight(), edge.limit()));
            addLines.add(new DLine(virtual, (DNode)edge.to(), edge.getLine(), edge.lineAttrs(), edge.weight(), edge.limit()));
            rankNode.add(virtual);
        }
    }

    private int labelNodeComparator(DNode left, DNode right) {
        double rightNextPoint;
        double rightPrePoint;
        double leftNextPoint;
        double leftPrePoint;
        DNode leftPreNode = null;
        DNode leftNextNode = null;
        DNode rightPreNode = null;
        DNode rightNextNode = null;
        DLine leftLine = null;
        DLine rightLine = null;
        for (DLine line : this.digraphProxy.inAdjacent(left)) {
            leftPreNode = (DNode)line.from();
        }
        for (DLine line : this.digraphProxy.outAdjacent(left)) {
            leftNextNode = (DNode)line.to();
            leftLine = line;
        }
        for (DLine line : this.digraphProxy.inAdjacent(right)) {
            rightPreNode = (DNode)line.from();
        }
        for (DLine line : this.digraphProxy.outAdjacent(right)) {
            rightNextNode = (DNode)line.to();
            rightLine = line;
        }
        if (leftPreNode == null || leftNextNode == null || rightPreNode == null || rightNextNode == null) {
            return 0;
        }
        int r = Double.compare(leftPreNode.getRankIndex() + leftNextNode.getRankIndex(), rightPreNode.getRankIndex() + rightNextNode.getRankIndex());
        if (r != 0) {
            return r;
        }
        if (leftPreNode == rightPreNode && leftNextNode == rightNextNode && (r = Double.compare((leftPrePoint = this.getPortPoint(leftLine, leftPreNode)) + (leftNextPoint = this.getPortPoint(leftLine, leftNextNode)), (rightPrePoint = this.getPortPoint(rightLine, rightPreNode)) + (rightNextPoint = this.getPortPoint(rightLine, rightNextNode)))) != 0) {
            return r;
        }
        if (left.name() == null && right.name() == null) {
            return 0;
        }
        if (left.name() == null && right.name() != null) {
            return -1;
        }
        if (left.name() != null && right.name() == null) {
            return 1;
        }
        return left.name().compareTo(right.name());
    }

    private void flatParallelEdge() {
        if (this.dotAttachment.getSameRankAdjacentRecord() == null || !this.dotAttachment.getSameRankAdjacentRecord().haveSameRank()) {
            return;
        }
        SameRankAdjacentRecord sameRankAdjacentRecord = this.dotAttachment.getSameRankAdjacentRecord();
        this.dotAttachment.releaseSameRankAdj();
        HashMap<DNode, HashMap<DNode, DLine>> parallelEdgeRecord = null;
        HashMap<DLine, DNode> flatLabelNodeRecord = null;
        for (Map.Entry<DNode, SameRankAdjacentRecord.SameRankAdjacentInfo> rankAdjacentInfoEntry : sameRankAdjacentRecord.getOutSameRankAdjacent().entrySet()) {
            DNode node = rankAdjacentInfoEntry.getKey();
            SameRankAdjacentRecord.SameRankAdjacentInfo sameRankAdjacentInfo = rankAdjacentInfoEntry.getValue();
            if (CollectionUtils.isEmpty(sameRankAdjacentInfo.lines)) continue;
            for (DLine line : sameRankAdjacentInfo.lines) {
                DNode other = line.other(node);
                if (node == other) continue;
                if (parallelEdgeRecord == null) {
                    parallelEdgeRecord = new HashMap<DNode, HashMap<DNode, DLine>>();
                }
                AbstractDirectedEdge mergeLine = null;
                HashMap<DNode, DLine> linePair = (HashMap<DNode, DLine>)parallelEdgeRecord.get(node);
                if (linePair != null) {
                    mergeLine = (DLine)linePair.get(line.other(node));
                }
                if (mergeLine == null) {
                    if (linePair == null) {
                        linePair = new HashMap<DNode, DLine>(1);
                    }
                    linePair.put(line.other(node), line);
                    parallelEdgeRecord.put(node, linePair);
                    continue;
                }
                if (line.from() != mergeLine.from()) {
                    line = line.reverse();
                }
                ((DLine)mergeLine).addParallelEdge(line);
            }
        }
        if (parallelEdgeRecord == null) {
            return;
        }
        for (Map value : parallelEdgeRecord.values()) {
            for (DLine line : value.values()) {
                if (!line.haveLabel()) continue;
                if (flatLabelNodeRecord == null) {
                    flatLabelNodeRecord = new HashMap<DLine, DNode>();
                }
                DNode flatLabelNode = flatLabelNodeRecord.computeIfAbsent(line, ml -> new DNode(null, 0.0, 0.0, ml.isSameRankAdj() ? ((DNode)ml.from()).getNodeSep() / 2.0 : ((DNode)ml.from()).getNodeSep(), (DLine)ml));
                flatLabelNode.setContainer(this.dotAttachment.commonParent((DNode)line.from(), (DNode)line.to()));
                if (!line.isSameRankAdj()) continue;
                ((DNode)line.from()).nodeSepHalving();
            }
        }
        this.insertFlatLabelNode(flatLabelNodeRecord);
    }

    private void insertFlatLabelNode(Map<DLine, DNode> flatLabelNodeRecord) {
        if (flatLabelNodeRecord == null) {
            return;
        }
        ArrayList<RankContent.RankNode> needInsertVirtualRank = null;
        HashMap<RankContent.RankNode, Double> newRankNodeIndex = null;
        HashMap<RankContent.RankNode, Queue> rankLabelNodeQueue = null;
        double minRankIndex = Double.MAX_VALUE;
        RankContent.RankNode minRankNode = null;
        for (DNode flatLabelNode : flatLabelNodeRecord.values()) {
            Double ri;
            DLine labelLine = flatLabelNode.getFlatLabelLine();
            if (labelLine == null) continue;
            flatLabelNode.setMedian((double)(((DNode)labelLine.from()).getRankIndex() + ((DNode)labelLine.to()).getRankIndex()) / 2.0);
            RankContent.RankNode rankNode = this.rankContent.get(((DNode)labelLine.from()).getRank());
            if (!labelLine.isSameRankAdj()) {
                if (rankNode.pre() == null || !rankNode.pre().noNormalNode()) {
                    if (rankNode.pre() != null) {
                        if (needInsertVirtualRank == null) {
                            needInsertVirtualRank = new ArrayList<RankContent.RankNode>(1);
                        }
                        needInsertVirtualRank.add(rankNode.pre());
                    }
                    double ri2 = rankNode.pre() != null ? (double)(rankNode.pre().rankIndex() + rankNode.rankIndex()) / 2.0 : (double)(rankNode.rankIndex() - 1);
                    rankNode = this.rankContent.insertLabelRankNode(rankNode.rankIndex());
                    if (newRankNodeIndex == null) {
                        newRankNodeIndex = new HashMap<RankContent.RankNode, Double>(1);
                    }
                    newRankNodeIndex.put(rankNode, ri2);
                } else {
                    rankNode = rankNode.pre();
                }
            }
            if (rankNode == null) continue;
            if (minRankNode == null || newRankNodeIndex != null && (ri = (Double)newRankNodeIndex.get(rankNode)) != null && ri < minRankIndex || (double)rankNode.rankIndex() < minRankIndex) {
                minRankNode = rankNode;
                minRankIndex = newRankNodeIndex != null ? ((ri = (Double)newRankNodeIndex.get(rankNode)) != null ? ri : (double)rankNode.rankIndex()) : (double)rankNode.rankIndex();
            }
            if (rankLabelNodeQueue == null) {
                rankLabelNodeQueue = new HashMap<RankContent.RankNode, Queue>(4);
            }
            rankLabelNodeQueue.computeIfAbsent(rankNode, k -> new PriorityQueue<DNode>(Comparator.comparing(DNode::getMedian))).offer(flatLabelNode);
        }
        this.rankContent.rankIndexSync();
        this.newRankAddVirtualNode(needInsertVirtualRank);
        this.syncNodeProp(minRankNode, rankLabelNodeQueue);
    }

    private void newRankAddVirtualNode(List<RankContent.RankNode> needInsertVirtualRank) {
        if (CollectionUtils.isEmpty(needInsertVirtualRank)) {
            return;
        }
        ArrayList<DLine> removeLines = new ArrayList<DLine>();
        for (RankContent.RankNode rankNode : needInsertVirtualRank) {
            for (int i = 0; i < rankNode.size(); ++i) {
                DNode node = rankNode.get(i);
                for (DLine line : this.digraphProxy.outAdjacent(node)) {
                    if (line.isSameRank()) continue;
                    removeLines.add(line);
                }
            }
            RankContent.RankNode next = rankNode.next();
            for (DLine removeLine : removeLines) {
                if (removeLine.isParallelMerge()) {
                    for (int i = 0; i < removeLine.getParallelNums(); ++i) {
                        this.cutLine(next, removeLine.parallelLine(i));
                    }
                    continue;
                }
                this.cutLine(next, removeLine);
            }
            removeLines.clear();
        }
    }

    private void syncNodeProp(RankContent.RankNode rankNode, Map<RankContent.RankNode, Queue<DNode>> rankLabelNodeQueue) {
        if (rankNode == null || rankLabelNodeQueue == null) {
            return;
        }
        while (rankNode != null) {
            int i;
            Queue<DNode> labelNodes = rankLabelNodeQueue.get(rankNode);
            for (i = 0; i < rankNode.size(); ++i) {
                DNode peek;
                DNode node = rankNode.get(i);
                double median = this.outMedian(node, rankNode.noNormalNode());
                while (labelNodes != null && !labelNodes.isEmpty() && !((peek = labelNodes.peek()).getMedian() > median)) {
                    labelNodes.poll();
                    peek.setRank(rankNode.rankIndex());
                    peek.setRankIndex(i);
                    rankNode.add(i++, peek);
                    this.digraphProxy.add(peek);
                    this.addArchBridgeFlatLine(peek, rankNode);
                }
                node.setRank(rankNode.rankIndex());
                node.setRankIndex(i);
            }
            while (labelNodes != null && !labelNodes.isEmpty()) {
                DNode poll = labelNodes.poll();
                poll.setRank(rankNode.rankIndex());
                poll.setRankIndex(i++);
                rankNode.add(poll);
                this.digraphProxy.add(poll);
                this.addArchBridgeFlatLine(poll, rankNode);
            }
            rankNode = rankNode.next();
        }
    }

    private void cutLine(RankContent.RankNode next, DLine removeLine) {
        DNode virtual = DNode.newVirtualNode(20.0, this.dotAttachment.commonParent((DNode)removeLine.from(), (DNode)removeLine.to()));
        this.digraphProxy.removeEdge(removeLine);
        this.digraphProxy.addEdge(new DLine((DNode)removeLine.from(), virtual, removeLine.getLine(), removeLine.lineAttrs(), removeLine.weight(), removeLine.limit()));
        this.digraphProxy.addEdge(new DLine(virtual, (DNode)removeLine.to(), removeLine.getLine(), removeLine.lineAttrs(), removeLine.weight(), removeLine.limit()));
        next.add(virtual);
    }

    private void addArchBridgeFlatLine(DNode flatLabelNode, RankContent.RankNode rankNode) {
        if (flatLabelNode.getFlatLabelLine() == null) {
            return;
        }
        DLine flatLabelLine = flatLabelNode.getFlatLabelLine();
        DNode next = rankNode.get(flatLabelNode.getRankIndex() + 1);
        if (next != null && (flatLabelLine.from() == next || flatLabelLine.to() == next)) {
            return;
        }
        this.digraphProxy.addEdge(new DLine(flatLabelNode, (DNode)flatLabelLine.from(), flatLabelLine.getLine(), flatLabelLine.lineAttrs(), flatLabelLine.weight(), flatLabelLine.limit()));
        this.digraphProxy.addEdge(new DLine(flatLabelNode, (DNode)flatLabelLine.to(), flatLabelLine.getLine(), flatLabelLine.lineAttrs(), flatLabelLine.weight(), flatLabelLine.limit()));
    }

    private double outMedian(DNode node, boolean isLabelRank) {
        double median = 0.0;
        if (isLabelRank) {
            for (DLine line : this.digraphProxy.outAdjacent(node)) {
                median = line.other(node).getRankIndex();
            }
        } else {
            median = node.getRankIndex();
        }
        return median;
    }

    private double getPortPoint(DLine line, DNode node) {
        return PortHelper.portCompareNo(line.getLine(), node, this.dotAttachment.getDrawGraph());
    }
}

