/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.Assemble;
import org.graphper.api.Cluster;
import org.graphper.api.FloatLabel;
import org.graphper.api.GraphAttrs;
import org.graphper.api.GraphContainer;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.api.attributes.ArrowShape;
import org.graphper.api.attributes.Dir;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.Tend;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePosition;
import org.graphper.def.Curves;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.draw.ArrowDrawProp;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.DefaultShapePosition;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.Rectangle;
import org.graphper.layout.AbstractLayoutEngine;
import org.graphper.layout.Cell;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.PathClip;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.graphper.util.FontUtils;
import org.graphper.util.ValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LineClip {
    private static final Logger log = LoggerFactory.getLogger(LineClip.class);
    private static final FlatPoint FLOAT_LABEL_LEFT_OFFSET = new FlatPoint.UnmodifyFlatPoint(-0.5, -0.5);
    private static final FlatPoint FLOAT_LABEL_RIGHT_OFFSET;
    private static final FlatPoint FLOAT_LABEL_UP_OFFSET;
    private static final FlatPoint FLOAT_LABEL_DOWN_OFFSET;
    protected DrawGraph drawGraph;
    protected DotDigraph dotDigraph;

    protected void lineArrowSite(FlatPoint headAxisEnd, FlatPoint headAxisDir, FlatPoint tailAxisEnd, FlatPoint tailAxisDir, double arrowSize, LineDrawProp lineDrawProp) {
        Asserts.nullArgument(lineDrawProp, "lineDrawProp");
        if (headAxisEnd != null && headAxisDir != null) {
            lineDrawProp.setArrowHead(new ArrowDrawProp(true, this.calcArrowLinkPoint(headAxisEnd, arrowSize, headAxisDir), headAxisEnd));
        }
        if (tailAxisEnd != null && tailAxisDir != null) {
            lineDrawProp.setArrowTail(new ArrowDrawProp(false, this.calcArrowLinkPoint(tailAxisEnd, arrowSize, tailAxisDir), tailAxisEnd));
        }
    }

    protected <P> void clipProcess(P path, PathClip<P> pathClip, FlatPoint noPathDirection, LineDrawProp lineDrawProp) {
        DNode dNode;
        ClusterDrawProp clusterDrawProp;
        Asserts.nullArgument(pathClip, "pathClip");
        Asserts.nullArgument(lineDrawProp, "lineDrawProp");
        Line line = lineDrawProp.getLine();
        LineAttrs lineAttrs = lineDrawProp.lineAttrs();
        boolean isSelfLine = line.head() == line.tail();
        boolean reversal = !isSelfLine && lineDrawProp.isHeadStart();
        Node from = lineDrawProp.isHeadStart() ? line.head() : line.tail();
        Node to = lineDrawProp.isHeadStart() ? line.tail() : line.head();
        NodeDrawProp fromProp = this.drawGraph.getNodeDrawProp(from);
        NodeDrawProp toProp = this.drawGraph.getNodeDrawProp(to);
        FlatPoint f = pathClip.pathFrom(path);
        FlatPoint t = pathClip.pathTo(path);
        if (!isSelfLine && this.needClip(line, lineAttrs, from) || isSelfLine && this.needClip(line, lineAttrs, from, false)) {
            clusterDrawProp = null;
            if (!isSelfLine) {
                dNode = this.dotDigraph.getDNode(from);
                Asserts.illegalArgument(dNode == null, "Can not found from node of line prop");
                clusterDrawProp = this.findLineEndPointCluster(dNode.getContainer(), this.getCompoundId(lineAttrs, !reversal));
            }
            path = clusterDrawProp != null ? pathClip.clusterClip(clusterDrawProp, path) : pathClip.nodeClip(this.getClipShapePosition(lineDrawProp, fromProp, true), path, true);
        }
        if (pathClip.isNotNull(path) && (!isSelfLine && this.needClip(line, lineAttrs, to) || isSelfLine && this.needClip(line, lineAttrs, to, true))) {
            clusterDrawProp = null;
            if (!isSelfLine) {
                dNode = this.dotDigraph.getDNode(to);
                Asserts.illegalArgument(dNode == null, "Can not found to node of line prop");
                clusterDrawProp = this.findLineEndPointCluster(dNode.getContainer(), this.getCompoundId(lineAttrs, reversal));
            }
            path = clusterDrawProp != null ? pathClip.clusterClip(clusterDrawProp, path) : pathClip.nodeClip(this.getClipShapePosition(lineDrawProp, toProp, false), path, false);
        }
        double arrowSize = this.getArrowSize(lineAttrs);
        if (pathClip.isNull(path)) {
            this.noPathArrowSet(line, reversal, f, t, noPathDirection, lineDrawProp);
        } else {
            boolean toArrowNeed;
            f = pathClip.pathFrom(path);
            t = pathClip.pathTo(path);
            boolean fromArrowNeed = this.haveTailArrow(line) && !reversal || this.haveHeadArrow(line) && reversal;
            boolean bl = toArrowNeed = this.haveHeadArrow(line) && !reversal || this.haveTailArrow(line) && reversal;
            if (fromArrowNeed) {
                path = pathClip.fromArrowClip(this.getClipSize(arrowSize, lineAttrs, lineDrawProp.isHeadStart()), path);
            }
            if (pathClip.isNull(path)) {
                this.noPathArrowSet(line, reversal, f, t, noPathDirection, lineDrawProp);
            } else if (toArrowNeed) {
                path = pathClip.toArrowClip(this.getClipSize(arrowSize, lineAttrs, !lineDrawProp.isHeadStart()), path);
            }
            if (pathClip.isNull(path)) {
                this.noPathArrowSet(line, reversal, f, t, noPathDirection, lineDrawProp);
            } else {
                FlatPoint nf = pathClip.pathFrom(path);
                FlatPoint nt = pathClip.pathTo(path);
                if (fromArrowNeed) {
                    this.arrowSet(f, nf, !reversal, lineDrawProp);
                }
                if (toArrowNeed) {
                    this.arrowSet(t, nt, reversal, lineDrawProp);
                }
            }
        }
    }

    protected void setFloatLabel(LineDrawProp lineDrawProp) {
        double[] dArray;
        if (lineDrawProp == null) {
            return;
        }
        if (CollectionUtils.isEmpty(lineDrawProp)) {
            return;
        }
        LineAttrs lineAttrs = lineDrawProp.lineAttrs();
        FloatLabel[] floatLabels = lineAttrs.getFloatLabels();
        if (floatLabels == null || floatLabels.length == 0) {
            return;
        }
        if (floatLabels.length > 1) {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = -1.0;
        } else {
            dArray = null;
        }
        double[] labelLength = dArray;
        for (FloatLabel floatLabel : floatLabels) {
            FlatPoint labelSize;
            FlatPoint startPoint;
            FlatPoint offset = floatLabel.getOffset();
            if (floatLabel.getTend() == null) {
                startPoint = lineDrawProp.isBesselCurve() ? this.curveGetFloatLabelStart(labelLength, floatLabel.getLengthRatio(), lineDrawProp) : this.straightGetFloatLabelStart(labelLength, floatLabel.getLengthRatio(), lineDrawProp);
            } else {
                NodeDrawProp node;
                Tend tend = floatLabel.getTend();
                if (tend == Tend.TAIL) {
                    startPoint = (FlatPoint)lineDrawProp.get(0);
                    node = this.drawGraph.getNodeDrawProp(lineDrawProp.getLine().tail());
                } else {
                    startPoint = (FlatPoint)lineDrawProp.get(lineDrawProp.size() - 1);
                    node = this.drawGraph.getNodeDrawProp(lineDrawProp.getLine().head());
                }
                offset = this.getFloatLabelLeftOffset(node, lineDrawProp, startPoint, offset, tend == Tend.TAIL);
            }
            Assemble assemble = lineDrawProp.getFloatAssemble(floatLabel);
            if (assemble == null) {
                String label = floatLabel.getLabel();
                if (label == null || Objects.equals(labelSize = FontUtils.measure(label, lineAttrs.getFontName(), floatLabel.getFontSize(), 0.0), Vectors.ZERO)) {
                    continue;
                }
            } else {
                labelSize = assemble.size();
                AbstractLayoutEngine.setCellNodeOffset(this.drawGraph, startPoint, assemble, true);
            }
            if (startPoint == null) continue;
            FlatPoint center = this.floatPointCenter(startPoint, labelSize, offset);
            if (assemble == null) {
                lineDrawProp.addFloatLabelCenter(floatLabel, center);
            } else {
                AbstractLayoutEngine.setCellNodeOffset(this.drawGraph, center, assemble, true);
            }
            this.drawGraph.updateXAxisRange(center.getX() - labelSize.getWidth() / 2.0);
            this.drawGraph.updateXAxisRange(center.getX() + labelSize.getWidth() / 2.0);
            this.drawGraph.updateYAxisRange(center.getY() - labelSize.getHeight() / 2.0);
            this.drawGraph.updateYAxisRange(center.getY() + labelSize.getHeight() / 2.0);
        }
    }

    private FlatPoint getFloatLabelLeftOffset(NodeDrawProp node, LineDrawProp lineDrawProp, FlatPoint start, FlatPoint offset, boolean isTail) {
        Cell cell;
        Rectangle nodeBox = node;
        LineAttrs lineAttrs = lineDrawProp.lineAttrs();
        if (node.getCell() != null && (cell = node.getCell().getCellById(isTail ? lineAttrs.getTailCell() : lineAttrs.getHeadCell())) != null) {
            nodeBox = cell.getCellBox(node);
        }
        FlatPoint pointOffset = this.calcFloatLabelOffset(start, nodeBox);
        if (offset == null) {
            return pointOffset;
        }
        return new FlatPoint(offset.getHeight() + pointOffset.getHeight(), offset.getWidth() + pointOffset.getWidth());
    }

    protected boolean needClip(Line line, LineAttrs lineAttrs, Node node) {
        return this.needClip(line, lineAttrs, node, null);
    }

    protected boolean needClip(Line line, LineAttrs lineAttrs, Node node, Boolean isHead) {
        if (isHead == null) {
            if (line.head() == node && !this.needClip(true, lineAttrs)) {
                return false;
            }
            return line.tail() != node || this.needClip(false, lineAttrs);
        }
        return this.needClip(isHead, lineAttrs);
    }

    protected boolean needClip(boolean isHead, LineAttrs lineAttrs) {
        if (lineAttrs == null) {
            return false;
        }
        if (isHead) {
            return Objects.equals(lineAttrs.getHeadclip(), Boolean.TRUE) && Objects.isNull(lineAttrs.getHeadPort());
        }
        return Objects.equals(lineAttrs.getTailclip(), Boolean.TRUE) && Objects.isNull(lineAttrs.getTailPort());
    }

    protected ClusterDrawProp findLineEndPointCluster(GraphContainer graphContainer, String clusterId) {
        if (StringUtils.isEmpty(clusterId)) {
            return null;
        }
        if (graphContainer == null || graphContainer.isGraphviz()) {
            return null;
        }
        while (graphContainer.isCluster()) {
            ClusterDrawProp clusterDrawProp = this.drawGraph.getClusterDrawProp((Cluster)graphContainer);
            if (clusterDrawProp != null && Objects.equals(clusterDrawProp.id(), clusterId)) {
                return clusterDrawProp;
            }
            graphContainer = this.drawGraph.getGraphviz().effectiveFather(graphContainer);
        }
        return null;
    }

    protected boolean haveTailArrow(Line line) {
        Asserts.nullArgument(line, "line");
        if (!this.drawGraph.getGraphviz().isDirected()) {
            return false;
        }
        LineAttrs lineAttrs = this.getLineAttrs(line);
        if (lineAttrs.getDir() == null || lineAttrs.getDir() == Dir.NONE || lineAttrs.getDir() == Dir.FORWARD) {
            return false;
        }
        return lineAttrs.getArrowTail() != null && lineAttrs.getArrowTail() != ArrowShape.NONE;
    }

    protected boolean haveHeadArrow(Line line) {
        Asserts.nullArgument(line, "line");
        if (!this.drawGraph.getGraphviz().isDirected()) {
            return false;
        }
        LineAttrs lineAttrs = this.getLineAttrs(line);
        if (lineAttrs.getDir() == null || lineAttrs.getDir() == Dir.NONE || lineAttrs.getDir() == Dir.BACK) {
            return false;
        }
        return lineAttrs.getArrowHead() != null && lineAttrs.getArrowHead() != ArrowShape.NONE;
    }

    protected LineAttrs getLineAttrs(Line line) {
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(line);
        if (lineDrawProp == null) {
            return line.lineAttrs();
        }
        return lineDrawProp.lineAttrs();
    }

    protected String getCompoundId(LineAttrs lineAttrs, boolean isTail) {
        GraphAttrs graphAttrs = this.drawGraph.getGraphviz().graphAttrs();
        if (!graphAttrs.isCompound()) {
            return null;
        }
        return isTail ? lineAttrs.getLtail() : lineAttrs.getLhead();
    }

    protected double getArrowSize(LineAttrs lineAttrs) {
        Double arrowSize = lineAttrs.getArrowSize();
        return arrowSize != null ? arrowSize : 0.125;
    }

    protected double getClipSize(double arrowSize, LineAttrs lineAttrs, boolean isHead) {
        ArrowShape arrowShape = isHead ? lineAttrs.getArrowHead() : lineAttrs.getArrowTail();
        return arrowSize * arrowShape.getClipRatio();
    }

    private FlatPoint calcFloatLabelOffset(FlatPoint endPoint, Box box) {
        double leftBorder = box.getLeftBorder();
        double rightBorder = box.getRightBorder();
        double upBorder = box.getUpBorder();
        double downBorder = box.getDownBorder();
        if (Vectors.inAngle(box.getX(), box.getY(), leftBorder, upBorder, leftBorder, downBorder, endPoint.getX(), endPoint.getY())) {
            return FLOAT_LABEL_LEFT_OFFSET;
        }
        if (Vectors.inAngle(box.getX(), box.getY(), leftBorder, downBorder, rightBorder, downBorder, endPoint.getX(), endPoint.getY())) {
            return FLOAT_LABEL_DOWN_OFFSET;
        }
        return FLOAT_LABEL_RIGHT_OFFSET;
    }

    private FlatPoint calcArrowLinkPoint(FlatPoint clip, double arrowSize, FlatPoint point) {
        FlatPoint dirVector = Vectors.sub(clip, point);
        double dist = dirVector.dist();
        if (ValueUtils.approximate(dist, 0.0, 0.001)) {
            return point;
        }
        return Vectors.add(point, Vectors.multiple(dirVector, (dist - arrowSize) / dist));
    }

    private void arrowSet(FlatPoint f, FlatPoint t, boolean isTail, LineDrawProp lineDrawProp) {
        if (Objects.equals(f, t)) {
            log.debug("Found that the arrow end point and arrow direction point of the arrow are equal, and the arrow setting has been skipped, arrow end {}, arrow direction {}", (Object)f, (Object)t);
            return;
        }
        double arrowSize = this.getClipSize(this.getArrowSize(lineDrawProp.lineAttrs()), lineDrawProp.lineAttrs(), !isTail);
        if (isTail) {
            this.lineArrowSite(null, null, f, t, arrowSize, lineDrawProp);
        } else {
            this.lineArrowSite(f, t, null, null, arrowSize, lineDrawProp);
        }
    }

    private void noPathArrowSet(Line line, boolean reversal, FlatPoint f, FlatPoint t, FlatPoint noPathDirection, LineDrawProp lineDrawProp) {
        if (this.haveTailArrow(line) && !reversal || this.haveHeadArrow(line) && reversal) {
            this.arrowSet(f, noPathDirection == null ? t : noPathDirection, !reversal, lineDrawProp);
        }
        if (this.haveHeadArrow(line) && !reversal || this.haveTailArrow(line) && reversal) {
            this.arrowSet(t, noPathDirection == null ? f : noPathDirection, reversal, lineDrawProp);
        }
    }

    private FlatPoint curveGetFloatLabelStart(double[] labelLength, double lengthRatio, LineDrawProp lineDrawProp) {
        double len;
        if (lineDrawProp.size() < 4) {
            return null;
        }
        double d = len = labelLength != null ? labelLength[0] : -1.0;
        if (len < 0.0) {
            len = 0.0;
            for (int i = 3; i < lineDrawProp.size(); i += 3) {
                FlatPoint v1 = (FlatPoint)lineDrawProp.get(i - 3);
                FlatPoint v2 = (FlatPoint)lineDrawProp.get(i - 2);
                FlatPoint v3 = (FlatPoint)lineDrawProp.get(i - 1);
                FlatPoint v4 = (FlatPoint)lineDrawProp.get(i);
                len += FlatPoint.twoFlatPointDistance(v1, v2);
                len += FlatPoint.twoFlatPointDistance(v2, v3);
                len += FlatPoint.twoFlatPointDistance(v3, v4);
            }
            if (labelLength != null) {
                labelLength[0] = len;
            }
        }
        double beforeLen = 0.0;
        double floatLabelInCurveLen = 0.0;
        FlatPoint v1 = null;
        FlatPoint v2 = null;
        FlatPoint v3 = null;
        FlatPoint v4 = null;
        double start = len * lengthRatio - 1.0;
        double end = len * lengthRatio + 1.0;
        for (int i = 3; i < lineDrawProp.size(); i += 3) {
            v1 = (FlatPoint)lineDrawProp.get(i - 3);
            v2 = (FlatPoint)lineDrawProp.get(i - 2);
            v3 = (FlatPoint)lineDrawProp.get(i - 1);
            v4 = (FlatPoint)lineDrawProp.get(i);
            floatLabelInCurveLen = 0.0;
            floatLabelInCurveLen += FlatPoint.twoFlatPointDistance(v1, v2);
            floatLabelInCurveLen += FlatPoint.twoFlatPointDistance(v2, v3);
            if (beforeLen + (floatLabelInCurveLen += FlatPoint.twoFlatPointDistance(v3, v4)) > end) break;
            beforeLen += floatLabelInCurveLen;
        }
        if (floatLabelInCurveLen == 0.0) {
            return null;
        }
        if (beforeLen < start && beforeLen + floatLabelInCurveLen > end) {
            double t = BigDecimal.valueOf(len).multiply(BigDecimal.valueOf(lengthRatio)).subtract(BigDecimal.valueOf(beforeLen)).divide(BigDecimal.valueOf(floatLabelInCurveLen), 4, RoundingMode.HALF_UP).doubleValue();
            return Curves.besselEquationCalc(t, v1, v2, v3, v4);
        }
        return lengthRatio == 0.0 ? v1 : v4;
    }

    private FlatPoint straightGetFloatLabelStart(double[] labelLength, double lengthRatio, LineDrawProp lineDrawProp) {
        double len;
        double d = len = labelLength != null ? labelLength[0] : -1.0;
        if (len < 0.0) {
            len = 0.0;
            for (int i = 1; i < lineDrawProp.size(); ++i) {
                FlatPoint v1 = (FlatPoint)lineDrawProp.get(i - 1);
                FlatPoint v2 = (FlatPoint)lineDrawProp.get(i);
                len += FlatPoint.twoFlatPointDistance(v1, v2);
            }
            if (labelLength != null) {
                labelLength[0] = len;
            }
        }
        double beforeLen = 0.0;
        double floatLabelInCurveLen = 0.0;
        FlatPoint v1 = null;
        FlatPoint v2 = null;
        double start = len * lengthRatio - 1.0;
        double end = len * lengthRatio + 1.0;
        for (int i = 1; i < lineDrawProp.size(); ++i) {
            v1 = (FlatPoint)lineDrawProp.get(i - 1);
            v2 = (FlatPoint)lineDrawProp.get(i);
            floatLabelInCurveLen = 0.0;
            if (beforeLen + (floatLabelInCurveLen += FlatPoint.twoFlatPointDistance(v1, v2)) > end) break;
            beforeLen += floatLabelInCurveLen;
        }
        if (floatLabelInCurveLen == 0.0) {
            return null;
        }
        if (beforeLen < start && beforeLen + floatLabelInCurveLen > end) {
            double t = BigDecimal.valueOf(len).multiply(BigDecimal.valueOf(lengthRatio)).subtract(BigDecimal.valueOf(beforeLen)).divide(BigDecimal.valueOf(floatLabelInCurveLen), 4, RoundingMode.HALF_UP).doubleValue();
            return Vectors.add(Vectors.multiple(Vectors.sub(v2, v1), t), v1);
        }
        return lengthRatio == 0.0 ? v1 : v2;
    }

    private FlatPoint floatPointCenter(FlatPoint startPoint, FlatPoint labelSize, FlatPoint offset) {
        if (labelSize == null || offset == null) {
            return new FlatPoint(startPoint.getX(), startPoint.getY());
        }
        return new FlatPoint(startPoint.getX() + labelSize.getWidth() * offset.getWidth(), startPoint.getY() + labelSize.getHeight() * offset.getHeight());
    }

    private ShapePosition getClipShapePosition(LineDrawProp line, NodeDrawProp node, boolean isTail) {
        if (node.getCell() == null) {
            return node;
        }
        String cellId = isTail ? line.lineAttrs().getTailCell() : line.lineAttrs().getHeadCell();
        if (cellId == null) {
            return node;
        }
        Cell.RootCell Cell2 = node.getCell();
        Cell cell = Cell2.getCellById(cellId);
        if (cell == null) {
            return node;
        }
        FlatPoint cellCenter = cell.getCenter(node);
        return new DefaultShapePosition(cellCenter.getX(), cellCenter.getY(), cell.getHeight(), cell.getWidth(), NodeShapeEnum.RECT);
    }

    static {
        FLOAT_LABEL_UP_OFFSET = FLOAT_LABEL_RIGHT_OFFSET = new FlatPoint.UnmodifyFlatPoint(-0.5, 0.5);
        FLOAT_LABEL_DOWN_OFFSET = new FlatPoint.UnmodifyFlatPoint(0.5, 0.5);
    }
}

