/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graphper.api.ext.ShapePosition;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.dot.AbstractDotLineRouter;
import org.graphper.layout.dot.PathClip;

class LineDrawPropPathClip
extends PathClip<LineDrawProp> {
    public static final LineDrawPropPathClip INSTANCE = new LineDrawPropPathClip();

    LineDrawPropPathClip() {
    }

    @Override
    protected FlatPoint pathFrom(LineDrawProp path) {
        return AbstractDotLineRouter.getFirst(path);
    }

    @Override
    protected FlatPoint pathTo(LineDrawProp path) {
        return AbstractDotLineRouter.getLast(path);
    }

    @Override
    protected LineDrawProp fromArrowClip(double arrowSize, LineDrawProp path) {
        FlatPoint first = AbstractDotLineRouter.getFirst(path);
        return this.arrowClip(arrowSize, path, first, true);
    }

    @Override
    protected LineDrawProp toArrowClip(double arrowSize, LineDrawProp path) {
        FlatPoint last = AbstractDotLineRouter.getLast(path);
        return this.arrowClip(arrowSize, path, last, false);
    }

    @Override
    protected LineDrawProp clusterClip(ClusterDrawProp clusterDrawProp, LineDrawProp path) {
        AbstractDotLineRouter.InOutPointPair inOutPair = AbstractDotLineRouter.findInOutPair(1, path, true, clusterDrawProp);
        if (inOutPair != null) {
            FlatPoint p = AbstractDotLineRouter.straightLineClipShape(clusterDrawProp, inOutPair.getIn(), inOutPair.getOut());
            return this.subPath(path, inOutPair, p);
        }
        return null;
    }

    @Override
    protected LineDrawProp nodeClip(ShapePosition node, LineDrawProp path, boolean firstStart) {
        AbstractDotLineRouter.InOutPointPair inOutPair = AbstractDotLineRouter.findInOutPair(1, path, firstStart, node);
        if (inOutPair != null) {
            FlatPoint p = AbstractDotLineRouter.straightLineClipShape(node, inOutPair.getIn(), inOutPair.getOut());
            return this.subPath(path, inOutPair, p);
        }
        return path;
    }

    private LineDrawProp subPath(LineDrawProp path, AbstractDotLineRouter.InOutPointPair inOutPair, FlatPoint p) {
        if (inOutPair.isDeleteBefore()) {
            List<FlatPoint> temp = this.subList(inOutPair.getIdx(), path.size(), path);
            path.clear();
            path.addAll((Collection<? extends FlatPoint>)temp);
            path.set(0, p);
        } else {
            List<FlatPoint> temp = this.subList(0, inOutPair.getIdx() + 1, path);
            path.clear();
            path.addAll((Collection<? extends FlatPoint>)temp);
            path.set(path.size() - 1, p);
        }
        return path;
    }

    private LineDrawProp arrowClip(double arrowSize, LineDrawProp path, FlatPoint first, boolean firstStart) {
        if (first == null) {
            return path;
        }
        ShapePosition shapePosition = AbstractDotLineRouter.newArrowShapePosition(first, arrowSize);
        AbstractDotLineRouter.InOutPointPair inOutPair = AbstractDotLineRouter.findInOutPair(1, path, firstStart, shapePosition);
        if (inOutPair != null) {
            FlatPoint p = AbstractDotLineRouter.straightLineClipShape(shapePosition, inOutPair.getIn(), inOutPair.getOut());
            return this.subPath(path, inOutPair, p);
        }
        return null;
    }

    private List<FlatPoint> subList(int start, int end, LineDrawProp lineDrawProp) {
        ArrayList<FlatPoint> temp = new ArrayList<FlatPoint>(end - start);
        for (int i = start; i < end; ++i) {
            temp.add((FlatPoint)lineDrawProp.get(i));
        }
        return temp;
    }
}

