/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.attributes.Splines;
import org.graphper.def.FlatPoint;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.dot.AbstractDotLineRouter;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotLineRouter;
import org.graphper.layout.dot.PortHelper;
import org.graphper.layout.dot.RankContent;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

class LineHandler
extends AbstractDotLineRouter
implements DotLineRouter {
    LineHandler() {
    }

    @Override
    public boolean needDeal(Splines splines) {
        return splines == Splines.LINE && super.needDeal(splines);
    }

    @Override
    public void route() {
        DNode[] to = new DNode[]{null};
        ParallelLineRecord parallelLineRecord = new ParallelLineRecord(this.drawGraph.getNodeNum());
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode dNodes = this.rankContent.get(i);
            for (DNode node : dNodes) {
                if (node.isVirtual()) {
                    if (!node.isFlatLabelNode()) continue;
                    this.flatLineLabelSet(node);
                    continue;
                }
                for (DLine line : this.digraphProxy.outAdjacent(node)) {
                    to[0] = null;
                    if (line.isVirtual() || line.isHide()) continue;
                    if (line.isParallelMerge() && (!line.isSameRank() || line.isSameRank() && this.isAdj((DNode)line.from(), (DNode)line.to()))) {
                        this.parallelLineHandle(line);
                        continue;
                    }
                    LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(line.getLine());
                    if (CollectionUtils.isNotEmpty(lineDrawProp)) continue;
                    lineDrawProp.add(PortHelper.getPortPoint(line.getLine(), (DNode)line.from(), this.drawGraph));
                    this.lineSegmentConsumer(line, l -> {
                        if (!((DNode)l.to()).isVirtual()) {
                            lineDrawProp.add(PortHelper.getPortPoint(line.getLine(), (DNode)l.to(), this.drawGraph));
                            to[0] = (DNode)l.to();
                        }
                        if (((DNode)l.to()).isLabelNode()) {
                            lineDrawProp.add(new FlatPoint(((DNode)l.to()).getX(), ((DNode)l.to()).getY()));
                            lineDrawProp.setLabelCenter(new FlatPoint(((DNode)l.to()).getX() + ((DNode)l.to()).getWidth() / 2.0, ((DNode)l.to()).getY()));
                        }
                    });
                    lineDrawProp.setIsHeadStart(((DNode)line.from()).getNode());
                    parallelLineRecord.addLine(node, to[0], line.getLine());
                }
                this.selfLoopHandle(node);
            }
        }
        this.drawParallelLine(parallelLineRecord);
    }

    private void flatLineLabelSet(DNode node) {
        DLine flatLabelLine = node.getFlatLabelLine();
        Map<Line, LineDrawProp> lineDrawPropMap = this.drawGraph.getLineDrawPropMap();
        if (lineDrawPropMap == null) {
            return;
        }
        for (int i = 0; i < flatLabelLine.getParallelNums(); ++i) {
            DLine line = flatLabelLine.parallelLine(i);
            if (line.getLabelSize() == null) continue;
            LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(line.getLine());
            lineDrawProp.setLabelCenter(new FlatPoint(node.getX(), node.getY()));
            if (((DNode)line.from()).getRank() == node.getRank()) continue;
            DNode tail = ((DNode)line.from()).getNode() == line.getLine().tail() ? (DNode)line.from() : (DNode)line.to();
            lineDrawProp.add(PortHelper.getPortPoint(line.getLine(), tail, this.drawGraph));
            lineDrawProp.add(new FlatPoint(node.getX(), node.getY()));
            lineDrawProp.add(PortHelper.getPortPoint(line.getLine(), line.other(tail), this.drawGraph));
        }
    }

    private void drawParallelLine(ParallelLineRecord parallelLineRecord) {
        if (CollectionUtils.isEmpty(parallelLineRecord.parallelLineGroup)) {
            return;
        }
        for (DLine line : parallelLineRecord.parallelLineGroup) {
            this.parallelLineHandle(line);
        }
    }

    static class LineRouterBuilder
    extends AbstractDotLineRouter.AbstractDotLineRouterFactory<LineHandler> {
        LineRouterBuilder() {
        }

        @Override
        protected LineHandler newInstance() {
            return new LineHandler();
        }
    }

    class ParallelLineRecord {
        private final Map<DNode, Map<DNode, DLine>> lineRecord;
        private List<DLine> parallelLineGroup;

        public ParallelLineRecord(int cap) {
            Asserts.illegalArgument(cap <= 0, "ParallelLineRecord cap <= 0");
            this.lineRecord = new LinkedHashMap<DNode, Map<DNode, DLine>>(cap);
        }

        void addLine(DNode n1, DNode n2, Line line) {
            if (n1 == n2) {
                return;
            }
            LineDrawProp lineDrawProp = LineHandler.this.drawGraph.getLineDrawProp(line);
            LineAttrs lineAttrs = lineDrawProp.lineAttrs();
            if (lineAttrs.getLabel() != null) {
                return;
            }
            DNode t = n1;
            n1 = n1.getRank() == n2.getRank() ? (n1.getRankIndex() < n2.getRankIndex() ? n1 : n2) : (n1.getRank() < n2.getRank() ? n1 : n2);
            n2 = t == n1 ? n2 : t;
            Map adjLine = this.lineRecord.computeIfAbsent(n1, n -> new LinkedHashMap());
            DLine dLine = (DLine)adjLine.get(n2);
            if (dLine == null) {
                dLine = new DLine(n1, n2, line, lineAttrs, 0.0, 0);
                adjLine.put(n2, dLine);
            } else {
                dLine.addParallelEdge(new DLine(n1, n2, line, lineAttrs, 0.0, 0));
            }
            if (dLine.getParallelNums() == 2) {
                if (this.parallelLineGroup == null) {
                    this.parallelLineGroup = new ArrayList<DLine>(2);
                }
                this.parallelLineGroup.add(dLine);
            }
        }
    }
}

