/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graphper.api.ext.Box;
import org.graphper.def.BiConcatIterable;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.layout.Grid;
import org.graphper.layout.OrthoVisGraph;
import org.graphper.layout.dot.DNode;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public abstract class Maze {
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int UP = 4;
    private static final int DOWN = 8;
    private static final int RIGHT_ACCESSED = 16;
    private static final int DOWN_ACCESSED = 32;
    private static final int LEFT_UP_CORNET = 64;
    private static final double INTERNAL_OFFSET = 0.01;
    private double minBorderExtendSize = 20.0;
    private OrthoVisGraph ovg;
    private final DrawGraph drawGraph;
    private final Map<Box, Cell> cellMap;
    private Map<Box, OrthoVisGraph.GridVertex> guideVertex;

    protected Maze(DrawGraph drawGraph) {
        Asserts.nullArgument(drawGraph, "drawGraph");
        this.drawGraph = drawGraph;
        this.cellMap = new LinkedHashMap<Box, Cell>();
        this.minBorderExtendSize = Math.max(this.minBorderExtendSize, drawGraph.getGraphviz().graphAttrs().getNodeSep());
    }

    protected void init() {
        Grid.GridBuilder gridBuilder = Grid.builder();
        this.initGrid(gridBuilder);
        this.extendGrid(gridBuilder);
        this.createOrthoVisGraph(gridBuilder);
    }

    Cell getCell(Box cellKey) {
        return this.cellMap.get(cellKey);
    }

    OrthoVisGraph.GridVertex getGuideVertex(Box sign) {
        if (sign == null || this.guideVertex == null) {
            return null;
        }
        return this.guideVertex.get(sign);
    }

    protected void addCell(Box cellKey, Cell cell, Grid.GridBuilder gridBuilder) {
        if (cellKey == null || cell == null || gridBuilder == null) {
            return;
        }
        cell.getWidth();
        cell.check();
        this.cellMap.put(cellKey, cell);
        this.addToGrid(gridBuilder, cell);
    }

    protected void addGuideBox(Box guideVertexKey, Grid.GridBuilder gridBuilder) {
        if (guideVertexKey == null || gridBuilder == null) {
            return;
        }
        guideVertexKey.check();
        this.addGuideBox(guideVertexKey);
        this.addToGrid(gridBuilder, guideVertexKey);
    }

    protected abstract void initGrid(Grid.GridBuilder var1);

    private Iterable<? extends Box> boxes() {
        if (this.guideVertex == null) {
            return this.cellMap.values();
        }
        return new BiConcatIterable(this.cellMap.values(), this.guideVertex.keySet());
    }

    private void addGuideBox(Box box) {
        if (this.guideVertex == null) {
            this.guideVertex = new LinkedHashMap<Box, OrthoVisGraph.GridVertex>();
        }
        this.guideVertex.put(box, null);
    }

    private void addToGrid(Grid.GridBuilder gridBuilder, Box box) {
        gridBuilder.addVerAxis(box.getLeftBorder()).addVerAxis(box.getRightBorder()).addHorAxis(box.getUpBorder()).addHorAxis(box.getDownBorder());
    }

    private void extendGrid(Grid.GridBuilder gridBuilder) {
        Double minHor = gridBuilder.minHorAxis();
        Double maxHor = gridBuilder.maxHorAxis();
        Double minVer = gridBuilder.minVerAxis();
        Double maxVer = gridBuilder.maxVerAxis();
        if (minHor != null) {
            gridBuilder.addHorAxis(minHor - this.minBorderExtendSize);
        }
        if (maxHor != null) {
            gridBuilder.addHorAxis(maxHor + this.minBorderExtendSize);
        }
        if (minVer != null) {
            gridBuilder.addVerAxis(minVer - this.minBorderExtendSize);
        }
        if (maxVer != null) {
            gridBuilder.addVerAxis(maxVer + this.minBorderExtendSize);
        }
    }

    private void createOrthoVisGraph(Grid.GridBuilder builder) {
        int i;
        Grid grid = builder.build();
        this.ovg = new OrthoVisGraph();
        int[][] track = new int[grid.rowNum()][grid.colNum()];
        for (Cell cell : this.cellMap.values()) {
            this.initAxisLaunchItems(grid, track, cell, true);
        }
        if (this.guideVertex != null) {
            for (Box box : this.guideVertex.keySet()) {
                this.initAxisLaunchItems(grid, track, box, false);
            }
        }
        for (Box box : this.boxes()) {
            Grid.GridAxis leftAxis = grid.getVerAxis(box.getLeftBorder());
            Grid.GridAxis rightAxis = grid.getVerAxis(box.getRightBorder());
            Grid.GridAxis topAxis = grid.getHorAxis(box.getUpBorder());
            Grid.GridAxis bottomAxis = grid.getHorAxis(box.getDownBorder());
            this.directAccess(true, true, 1, track, topAxis, bottomAxis, leftAxis);
            this.directAccess(false, true, 2, track, topAxis, bottomAxis, rightAxis);
            this.directAccess(true, false, 4, track, leftAxis, rightAxis, topAxis);
            this.directAccess(false, false, 8, track, leftAxis, rightAxis, bottomAxis);
        }
        for (i = 0; i < grid.colNum(); ++i) {
            if (i != 0) {
                this.markLeft(track, 0, i);
                this.markLeft(track, grid.rowNum() - 1, i);
            }
            if (i == grid.colNum() - 1) continue;
            this.markRight(track, 0, i);
            this.markRight(track, grid.rowNum() - 1, i);
        }
        for (i = 0; i < grid.rowNum(); ++i) {
            if (i != 0) {
                this.markUp(track, i, 0);
                this.markUp(track, i, grid.colNum() - 1);
            }
            if (i == grid.rowNum() - 1) continue;
            this.markDown(track, i, 0);
            this.markDown(track, i, grid.colNum() - 1);
        }
        this.initOvg(grid, track);
        this.generateGrid(grid, track);
    }

    private void initAxisLaunchItems(Grid grid, int[][] track, Box box, boolean isCell) {
        Grid.GridAxis current;
        Grid.GridAxis leftAxis = grid.getVerAxis(box.getLeftBorder());
        Grid.GridAxis rightAxis = grid.getVerAxis(box.getRightBorder());
        Grid.GridAxis topAxis = grid.getHorAxis(box.getUpBorder());
        Grid.GridAxis bottomAxis = grid.getHorAxis(box.getDownBorder());
        if (isCell) {
            this.markNodeLeftUpCorner(track, topAxis.getIdx(), leftAxis.getIdx());
        }
        for (current = leftAxis.next(); current != null && current.getVal() < rightAxis.getVal(); current = current.next()) {
            if (isCell) {
                topAxis.addBlockAxis(current.getVal());
                bottomAxis.addBlockAxis(current.getVal());
            }
            this.markLeft(track, topAxis.getIdx(), current.getIdx());
            this.markRight(track, topAxis.getIdx(), current.getIdx());
            this.markLeft(track, bottomAxis.getIdx(), current.getIdx());
            this.markRight(track, bottomAxis.getIdx(), current.getIdx());
        }
        for (current = topAxis.next(); current != null && current.getVal() < bottomAxis.getVal(); current = current.next()) {
            if (isCell) {
                leftAxis.addBlockAxis(current.getVal());
                rightAxis.addBlockAxis(current.getVal());
            }
            this.markUp(track, current.getIdx(), leftAxis.getIdx());
            this.markDown(track, current.getIdx(), leftAxis.getIdx());
            this.markUp(track, current.getIdx(), rightAxis.getIdx());
            this.markDown(track, current.getIdx(), rightAxis.getIdx());
        }
        this.nodeTrack(track, leftAxis, rightAxis, topAxis, bottomAxis);
    }

    private void directAccess(boolean isPre, boolean isHor, int dir, int[][] track, Grid.GridAxis firstAxis, Grid.GridAxis secondAxis, Grid.GridAxis startAxis) {
        boolean fc = true;
        boolean sc = true;
        Grid.GridAxis pre = null;
        Grid.GridAxis current = startAxis;
        do {
            boolean isFirst;
            boolean bl = isFirst = current == startAxis;
            if (fc) {
                fc = this.directAccess(isHor, isFirst, dir, track, firstAxis, startAxis, pre, current);
            }
            if (sc) {
                sc = this.directAccess(isHor, isFirst, dir, track, secondAxis, startAxis, pre, current);
            }
            pre = current;
            Grid.GridAxis gridAxis = current = isPre ? current.pre() : current.next();
        } while (current != null && (fc || sc));
    }

    private boolean directAccess(boolean isHor, boolean isFirst, int dir, int[][] track, Grid.GridAxis axis, Grid.GridAxis startAxis, Grid.GridAxis pre, Grid.GridAxis current) {
        int v;
        int n = v = isHor ? track[axis.getIdx()][current.getIdx()] : track[current.getIdx()][axis.getIdx()];
        if (!isFirst) {
            this.markDir(track, this.reverseDir(dir), isHor, axis, current);
        }
        if (pre != null) {
            this.markDir(track, dir, isHor, axis, pre);
        }
        return !(current != startAxis && !this.notHaveVertex(v) || !current.isNotBlock(axis.getVal()) && !isFirst);
    }

    private void initOvg(Grid grid, int[][] track) {
        Grid.GridAxis firstHorAxis = grid.getFirstHorAxis();
        Grid.GridAxis firstVerAxis = grid.getFirstVerAxis();
        HashMap<Integer, OrthoVisGraph.GridVertex> vertexMap = new HashMap<Integer, OrthoVisGraph.GridVertex>();
        this.generateOutCellVertexEdge(grid, track, firstVerAxis, firstHorAxis, vertexMap);
        this.generateInCellVertexEdge(grid, track, vertexMap);
        this.generateGuideBoxVertex(grid, vertexMap);
        this.checkOvg();
    }

    private void generateOutCellVertexEdge(Grid grid, int[][] track, Grid.GridAxis firstVerAxis, Grid.GridAxis firstHorAxis, Map<Integer, OrthoVisGraph.GridVertex> vertexMap) {
        Grid.GridAxis verAxis;
        Grid.GridAxis horAxis;
        OrthoVisGraph.GridVertex pre = null;
        for (horAxis = firstHorAxis; horAxis != null; horAxis = horAxis.next()) {
            verAxis = firstVerAxis;
            while (verAxis != null) {
                int val = track[horAxis.getIdx()][verAxis.getIdx()];
                if (!this.haveRight(val) || !this.haveDown(val) || this.isNodeLeftUpCorner(val)) {
                    verAxis = verAxis.next();
                    if (this.haveRight(val) && !this.isNodeLeftUpCorner(val)) continue;
                    pre = null;
                    continue;
                }
                FlatPoint leftUp = new FlatPoint(verAxis.getVal(), horAxis.getVal());
                FlatPoint rightDown = this.findRightDown(track, horAxis, verAxis);
                OrthoVisGraph.GridVertex vertex = new OrthoVisGraph.GridVertex(leftUp, rightDown);
                this.ovg.add(vertex);
                vertexMap.put(grid.coordToIdx(horAxis.getIdx(), verAxis.getIdx()), vertex);
                if (pre != null) {
                    this.ovg.addLeft(vertex, pre);
                }
                pre = vertex;
                verAxis = verAxis.next();
            }
        }
        pre = null;
        for (verAxis = firstVerAxis; verAxis != null; verAxis = verAxis.next()) {
            horAxis = firstHorAxis;
            while (horAxis != null) {
                OrthoVisGraph.GridVertex vertex = vertexMap.get(grid.coordToIdx(horAxis.getIdx(), verAxis.getIdx()));
                if (vertex == null) {
                    horAxis = horAxis.next();
                    continue;
                }
                if (pre != null && this.isVerContinuous(pre, vertex)) {
                    this.ovg.addTop(vertex, pre);
                }
                pre = vertex;
                horAxis = horAxis.next();
            }
        }
    }

    private void generateInCellVertexEdge(Grid grid, int[][] track, Map<Integer, OrthoVisGraph.GridVertex> vertexMap) {
        for (Cell cell : this.cellMap.values()) {
            OrthoVisGraph.GridVertex vertex;
            OrthoVisGraph.GridVertex adjVertex;
            Integer idx;
            int val;
            Grid.GridAxis current;
            if (!cell.needInternalVertex()) continue;
            Grid.GridAxis leftAxis = grid.getVerAxis(cell.getLeftBorder());
            Grid.GridAxis rightAxis = grid.getVerAxis(cell.getRightBorder());
            Grid.GridAxis topAxis = grid.getHorAxis(cell.getUpBorder());
            Grid.GridAxis bottomAxis = grid.getHorAxis(cell.getDownBorder());
            for (current = leftAxis; current != null && current.getVal() <= rightAxis.getVal(); current = current.next()) {
                val = track[topAxis.getIdx()][current.getIdx()];
                if (current.getVal() > leftAxis.getVal() && this.haveUp(val) && this.haveLeft(val) && (idx = this.findCellVertexByRightDown(track, grid, topAxis, current)) != null) {
                    adjVertex = vertexMap.get(idx);
                    Asserts.illegalArgument(adjVertex == null, "Can not found ovg node");
                    this.connectNodeInternal(adjVertex, cell, 4);
                }
                val = track[bottomAxis.getIdx()][current.getIdx()];
                if (!(current.getVal() < rightAxis.getVal()) || !this.haveDown(val) || !this.haveRight(val) || !this.isNotNodeLeftUpCorner(val)) continue;
                vertex = vertexMap.get(grid.coordToIdx(bottomAxis.getIdx(), current.getIdx()));
                Asserts.illegalArgument(vertex == null, "Can not found ovg node");
                this.connectNodeInternal(vertex, cell, 8);
            }
            for (current = topAxis; current != null && current.getVal() <= bottomAxis.getVal(); current = current.next()) {
                val = track[current.getIdx()][leftAxis.getIdx()];
                if (current.getVal() > topAxis.getVal() && this.haveLeft(val) && this.haveUp(val) && (idx = this.findCellVertexByRightDown(track, grid, current, leftAxis)) != null) {
                    adjVertex = vertexMap.get(idx);
                    Asserts.illegalArgument(adjVertex == null, "Can not found ovg node");
                    this.connectNodeInternal(adjVertex, cell, 1);
                }
                val = track[current.getIdx()][rightAxis.getIdx()];
                if (!(current.getVal() < bottomAxis.getVal()) || !this.haveRight(val) || !this.haveDown(val) || !this.isNotNodeLeftUpCorner(val)) continue;
                vertex = vertexMap.get(grid.coordToIdx(current.getIdx(), rightAxis.getIdx()));
                Asserts.illegalArgument(vertex == null, "Can not found ovg node");
                this.connectNodeInternal(vertex, cell, 2);
            }
        }
    }

    private void connectNodeInternal(OrthoVisGraph.GridVertex adjVertex, Cell cell, int dir) {
        OrthoVisGraph.GridVertex vertex = null;
        switch (dir) {
            case 1: {
                FlatPoint leftUp = new FlatPoint(adjVertex.getRightDown().getX(), adjVertex.getLeftUp().getY());
                FlatPoint rightDown = new FlatPoint(cell.getRightBorder() - 0.01, adjVertex.getRightDown().getY());
                vertex = new OrthoVisGraph.GridVertex(leftUp, rightDown);
                this.ovg.addLeft(vertex, adjVertex);
                break;
            }
            case 2: {
                FlatPoint leftUp = new FlatPoint(cell.getLeftBorder() + 0.01, adjVertex.getLeftUp().getY());
                FlatPoint rightDown = new FlatPoint(adjVertex.getLeftUp().getX(), adjVertex.getRightDown().getY());
                vertex = new OrthoVisGraph.GridVertex(leftUp, rightDown);
                this.ovg.addRight(vertex, adjVertex);
                break;
            }
            case 4: {
                FlatPoint leftUp = new FlatPoint(adjVertex.getLeftUp().getX(), adjVertex.getRightDown().getY());
                FlatPoint rightDown = new FlatPoint(adjVertex.getRightDown().getX(), cell.getDownBorder() - 0.01);
                vertex = new OrthoVisGraph.GridVertex(leftUp, rightDown);
                this.ovg.addTop(vertex, adjVertex);
                break;
            }
            case 8: {
                FlatPoint leftUp = new FlatPoint(adjVertex.getLeftUp().getX(), cell.getUpBorder() + 0.01);
                FlatPoint rightDown = new FlatPoint(adjVertex.getRightDown().getX(), adjVertex.getLeftUp().getY());
                vertex = new OrthoVisGraph.GridVertex(leftUp, rightDown);
                this.ovg.addBottom(vertex, adjVertex);
                break;
            }
        }
        if (vertex != null) {
            cell.addAxisVertex(vertex);
            vertex.markInternalNode();
        }
    }

    private FlatPoint findRightDown(int[][] track, Grid.GridAxis hor, Grid.GridAxis ver) {
        int val;
        Grid.GridAxis horAxis;
        int val2;
        Grid.GridAxis verAxis;
        for (verAxis = ver.next(); !(verAxis == null || this.haveLeft(val2 = track[hor.getIdx()][verAxis.getIdx()]) && this.haveDown(val2)); verAxis = verAxis.next()) {
        }
        Asserts.illegalArgument(verAxis == null, "Can not found right down vertex");
        for (horAxis = hor.next(); !(horAxis == null || this.haveLeft(val = track[horAxis.getIdx()][verAxis.getIdx()]) && this.haveUp(val)); horAxis = horAxis.next()) {
        }
        Asserts.illegalArgument(horAxis == null, "Can not found right down vertex");
        return new FlatPoint(verAxis.getVal(), horAxis.getVal());
    }

    private Integer findCellVertexByRightDown(int[][] track, Grid grid, Grid.GridAxis hor, Grid.GridAxis ver) {
        int val;
        Grid.GridAxis horAxis;
        int val2;
        Grid.GridAxis verAxis;
        for (verAxis = ver.pre(); !(verAxis == null || this.haveRight(val2 = track[hor.getIdx()][verAxis.getIdx()]) && this.haveUp(val2)); verAxis = verAxis.pre()) {
        }
        Asserts.illegalArgument(verAxis == null, "Can not found left up vertex");
        for (horAxis = hor.pre(); !(horAxis == null || this.haveRight(val = track[horAxis.getIdx()][verAxis.getIdx()]) && this.haveDown(val)); horAxis = horAxis.pre()) {
        }
        Asserts.illegalArgument(horAxis == null, "Can not found left up vertex");
        if (this.isNotNodeLeftUpCorner(track[horAxis.getIdx()][verAxis.getIdx()])) {
            return grid.coordToIdx(horAxis.getIdx(), verAxis.getIdx());
        }
        return null;
    }

    private void generateGuideBoxVertex(Grid grid, Map<Integer, OrthoVisGraph.GridVertex> vertexMap) {
        if (this.guideVertex == null) {
            return;
        }
        for (Box box : this.guideVertex.keySet()) {
            OrthoVisGraph.GridVertex vertex = this.getBoxCenterVertex(box, grid, vertexMap);
            if (vertex == null) continue;
            this.guideVertex.put(box, vertex);
        }
    }

    private OrthoVisGraph.GridVertex getBoxCenterVertex(Box box, Grid grid, Map<Integer, OrthoVisGraph.GridVertex> vertexMap) {
        Grid.GridAxis leftAxis = grid.getVerAxis(box.getLeftBorder());
        Grid.GridAxis rightAxis = grid.getVerAxis(box.getRightBorder());
        Grid.GridAxis topAxis = grid.getHorAxis(box.getUpBorder());
        Grid.GridAxis bottomAxis = grid.getHorAxis(box.getDownBorder());
        for (Grid.GridAxis currentVer = leftAxis; currentVer != null && currentVer.getVal() < rightAxis.getVal(); currentVer = currentVer.next()) {
            for (Grid.GridAxis currentHor = topAxis; currentHor != null && currentHor.getVal() < bottomAxis.getVal(); currentHor = currentHor.next()) {
                OrthoVisGraph.GridVertex vertex = vertexMap.get(grid.coordToIdx(currentHor.getIdx(), currentVer.getIdx()));
                if (!this.vertexOverlapBoxCenter(vertex, box)) continue;
                return vertex;
            }
        }
        return null;
    }

    private boolean vertexOverlapBoxCenter(OrthoVisGraph.GridVertex vertex, Box box) {
        if (vertex == null || box == null) {
            return false;
        }
        FlatPoint leftUp = vertex.getLeftUp();
        FlatPoint rightDown = vertex.getRightDown();
        return leftUp.getX() <= box.getX() && leftUp.getY() <= box.getY() && rightDown.getX() >= box.getX() && rightDown.getY() >= box.getY();
    }

    private void checkOvg() {
        if (!Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("ovg.check"))) {
            return;
        }
        for (OrthoVisGraph.GridVertex node : this.ovg.nodes()) {
            OrthoVisGraph.GridVertex left = node.getLeft();
            OrthoVisGraph.GridVertex right = node.getRight();
            OrthoVisGraph.GridVertex top = node.getTop();
            OrthoVisGraph.GridVertex bottom = node.getBottom();
            Asserts.illegalArgument(left != null && !this.isHorContinuous(left, node), "Left vertex is not continuous");
            Asserts.illegalArgument(right != null && !this.isHorContinuous(node, right), "Right vertex is not continuous");
            Asserts.illegalArgument(top != null && !this.isVerContinuous(top, node), "Top vertex is not continuous");
            Asserts.illegalArgument(bottom != null && !this.isVerContinuous(node, bottom), "Bottom vertex is not continuous");
        }
    }

    private boolean isHorContinuous(OrthoVisGraph.GridVertex pre, OrthoVisGraph.GridVertex vertex) {
        return pre.getRightDown().getX() == vertex.getLeftUp().getX() && pre.getLeftUp().getY() == vertex.getLeftUp().getY() && pre.getRightDown().getY() == vertex.getRightDown().getY();
    }

    private boolean isVerContinuous(OrthoVisGraph.GridVertex pre, OrthoVisGraph.GridVertex vertex) {
        return pre.getRightDown().getY() == vertex.getLeftUp().getY() && pre.getLeftUp().getX() == vertex.getLeftUp().getX() && pre.getRightDown().getX() == vertex.getRightDown().getX();
    }

    private void generateGrid(Grid grid, int[][] track) {
        GraphvizDrawProp graphvizDrawProp = this.drawGraph.getGraphvizDrawProp();
        if (!graphvizDrawProp.getGraphviz().graphAttrs().isShowGrid()) {
            return;
        }
        Grid.GridAxis firstHorAxis = grid.getFirstHorAxis();
        Grid.GridAxis firstVerAxis = grid.getFirstVerAxis();
        for (Grid.GridAxis horAxis = firstHorAxis; horAxis != null; horAxis = horAxis.next()) {
            Grid.GridAxis verAxis = firstVerAxis;
            while (verAxis != null) {
                OrthoVisGraph.Segment segment;
                if (this.notHaveVertex(track[horAxis.getIdx()][verAxis.getIdx()])) {
                    verAxis = verAxis.next();
                    continue;
                }
                if (this.rightNotAccessed(track, horAxis.getIdx(), verAxis.getIdx())) {
                    segment = new OrthoVisGraph.Segment();
                    double x = this.rightAccess(verAxis, horAxis.getIdx(), verAxis.getIdx(), track);
                    segment.setStart(new FlatPoint(verAxis.getVal(), horAxis.getVal()));
                    segment.setEnd(new FlatPoint(x, horAxis.getVal()));
                    this.addSegment(segment);
                }
                if (this.bottomNotAccessed(track, horAxis.getIdx(), verAxis.getIdx())) {
                    segment = new OrthoVisGraph.Segment();
                    double y = this.bottomAccess(horAxis, horAxis.getIdx(), verAxis.getIdx(), track);
                    segment.setStart(new FlatPoint(verAxis.getVal(), horAxis.getVal()));
                    segment.setEnd(new FlatPoint(verAxis.getVal(), y));
                    this.addSegment(segment);
                }
                verAxis = verAxis.next();
            }
        }
    }

    private double rightAccess(Grid.GridAxis axis, int row, int col, int[][] track) {
        this.markAccessed(track, row, col, 16);
        if (!this.haveRight(track[row][col])) {
            return axis.getVal();
        }
        return this.rightAccess(axis.next(), row, col + 1, track);
    }

    private double bottomAccess(Grid.GridAxis axis, int row, int col, int[][] track) {
        this.markAccessed(track, row, col, 32);
        if (!this.haveDown(track[row][col])) {
            return axis.getVal();
        }
        return this.bottomAccess(axis.next(), row + 1, col, track);
    }

    private void addSegment(OrthoVisGraph.Segment segment) {
        FlatPoint start = segment.getStart();
        FlatPoint end = segment.getEnd();
        this.drawGraph.updateXAxisRange(start.getX());
        this.drawGraph.updateXAxisRange(end.getX());
        this.drawGraph.updateYAxisRange(start.getY());
        this.drawGraph.updateYAxisRange(end.getY());
        GraphvizDrawProp graphvizDrawProp = this.drawGraph.getGraphvizDrawProp();
        graphvizDrawProp.addSegment(segment);
    }

    private void nodeTrack(int[][] track, Grid.GridAxis leftAxis, Grid.GridAxis rightAxis, Grid.GridAxis topAxis, Grid.GridAxis bottomAxis) {
        this.markRight(track, topAxis.getIdx(), leftAxis.getIdx());
        this.markDown(track, topAxis.getIdx(), leftAxis.getIdx());
        this.markLeft(track, topAxis.getIdx(), rightAxis.getIdx());
        this.markDown(track, topAxis.getIdx(), rightAxis.getIdx());
        this.markRight(track, bottomAxis.getIdx(), leftAxis.getIdx());
        this.markUp(track, bottomAxis.getIdx(), leftAxis.getIdx());
        this.markLeft(track, bottomAxis.getIdx(), rightAxis.getIdx());
        this.markUp(track, bottomAxis.getIdx(), rightAxis.getIdx());
    }

    private int markDir(int[][] track, int dir, boolean isHor, Grid.GridAxis a1, Grid.GridAxis a2) {
        int val;
        if (isHor) {
            int[] nArray = track[a1.getIdx()];
            int n = a2.getIdx();
            int n2 = nArray[n] | dir;
            nArray[n] = n2;
            val = n2;
        } else {
            int[] nArray = track[a2.getIdx()];
            int n = a1.getIdx();
            int n3 = nArray[n] | dir;
            nArray[n] = n3;
            val = n3;
        }
        return val;
    }

    private void markNodeLeftUpCorner(int[][] track, int row, int col) {
        int[] nArray = track[row];
        int n = col;
        nArray[n] = nArray[n] | 0x40;
    }

    private boolean isNotNodeLeftUpCorner(int val) {
        return !this.isNodeLeftUpCorner(val);
    }

    private boolean isNodeLeftUpCorner(int val) {
        return (val & 0x40) == 64;
    }

    private boolean notHaveVertex(int val) {
        return !this.haveVertex(val);
    }

    private boolean haveVertex(int val) {
        return this.haveHor(val) && this.haveVer(val);
    }

    private boolean haveHor(int val) {
        return this.haveLeft(val) || this.haveRight(val);
    }

    private boolean haveVer(int val) {
        return this.haveUp(val) || this.haveDown(val);
    }

    private void markLeft(int[][] track, int row, int col) {
        int[] nArray = track[row];
        int n = col;
        nArray[n] = nArray[n] | 1;
    }

    private void markRight(int[][] track, int row, int col) {
        int[] nArray = track[row];
        int n = col;
        nArray[n] = nArray[n] | 2;
    }

    private void markUp(int[][] track, int row, int col) {
        int[] nArray = track[row];
        int n = col;
        nArray[n] = nArray[n] | 4;
    }

    private void markDown(int[][] track, int row, int col) {
        int[] nArray = track[row];
        int n = col;
        nArray[n] = nArray[n] | 8;
    }

    private boolean haveLeft(int val) {
        return (val & 1) == 1;
    }

    private boolean haveRight(int val) {
        return (val & 2) == 2;
    }

    private boolean haveUp(int val) {
        return (val & 4) == 4;
    }

    private boolean haveDown(int val) {
        return (val & 8) == 8;
    }

    private boolean rightNotAccessed(int[][] track, int row, int col) {
        return !this.rightAccessed(track, row, col);
    }

    private boolean bottomNotAccessed(int[][] track, int row, int col) {
        return !this.bottomAccessed(track, row, col);
    }

    private boolean rightAccessed(int[][] track, int row, int col) {
        return this.rightAccessed(track[row][col]);
    }

    private boolean bottomAccessed(int[][] track, int row, int col) {
        return this.downAccessed(track[row][col]);
    }

    private boolean rightAccessed(int val) {
        return (val & 0x10) == 16;
    }

    private boolean downAccessed(int val) {
        return (val & 0x20) == 32;
    }

    private void markAccessed(int[][] track, int row, int col, int accessMark) {
        int[] nArray = track[row];
        int n = col;
        nArray[n] = nArray[n] | accessMark;
    }

    private int reverseDir(int dir) {
        switch (dir) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 8;
            }
            case 8: {
                return 4;
            }
        }
        return 0;
    }

    public static class VirtualCell
    extends Cell {
        private final Box box;

        public VirtualCell(Box box) {
            Asserts.nullArgument(box, "box");
            this.box = box;
        }

        @Override
        public double getX() {
            return this.box.getX();
        }

        @Override
        public double getY() {
            return this.box.getY();
        }

        @Override
        public double getLeftBorder() {
            return this.box.getLeftBorder();
        }

        @Override
        public double getRightBorder() {
            return this.box.getRightBorder();
        }

        @Override
        public double getUpBorder() {
            return this.box.getUpBorder();
        }

        @Override
        public double getDownBorder() {
            return this.box.getDownBorder();
        }

        @Override
        boolean needInternalVertex() {
            return false;
        }
    }

    public static class NodeCell
    extends Cell {
        private final DNode node;

        public NodeCell(DNode node) {
            Asserts.nullArgument(node, "node");
            this.node = node;
        }

        @Override
        public double getLeftBorder() {
            return this.node.getLeftBorder() - 0.5;
        }

        @Override
        public double getRightBorder() {
            return this.node.getRightBorder() + 0.5;
        }

        @Override
        public double getUpBorder() {
            return this.node.getUpBorder() - 0.5;
        }

        @Override
        public double getDownBorder() {
            return this.node.getDownBorder() + 0.5;
        }

        @Override
        public double getX() {
            return this.node.getX();
        }

        @Override
        public double getY() {
            return this.node.getY();
        }

        public String toString() {
            return "NodeCell{node=" + this.node + '}';
        }
    }

    public static abstract class Cell
    implements Box {
        private List<OrthoVisGraph.GridVertex> axisVertexes;

        private void addAxisVertex(OrthoVisGraph.GridVertex vertex) {
            if (this.axisVertexes == null) {
                this.axisVertexes = new ArrayList<OrthoVisGraph.GridVertex>();
            }
            this.axisVertexes.add(vertex);
        }

        @Override
        public boolean in(double x, double y) {
            return !(!this.inHor(x - 0.1) && !this.inHor(x) && !this.inHor(x + 0.1) || !this.inVer(y - 0.1) && !this.inVer(y) && !this.inVer(y + 0.1));
        }

        boolean inHor(double val) {
            return val > this.getLeftBorder() && val < this.getRightBorder();
        }

        boolean inVer(double val) {
            return val > this.getUpBorder() && val < this.getDownBorder();
        }

        boolean needInternalVertex() {
            return true;
        }

        List<OrthoVisGraph.GridVertex> getAxisVertexes() {
            return CollectionUtils.isNotEmpty(this.axisVertexes) ? this.axisVertexes : Collections.emptyList();
        }
    }
}

