/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.graphper.api.Cluster;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.def.DedirectedEdgeGraph;
import org.graphper.def.Digraph;
import org.graphper.def.DirectedGraph;
import org.graphper.def.EdgeDedigraph;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DrawGraph;
import org.graphper.layout.Mark;
import org.graphper.layout.dot.BasicCrossRank;
import org.graphper.layout.dot.CrossRank;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.PortHelper;
import org.graphper.layout.dot.RankContent;
import org.graphper.layout.dot.RootCrossRank;
import org.graphper.layout.dot.SameRankAdjacentRecord;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinCross {
    private static final Logger log = LoggerFactory.getLogger(MinCross.class);
    private static final double CONVERGENCE = 0.995;
    private RootCrossRank rootCrossRank;
    private ClusterExpand clusterExpand;
    private final RankContent rankContent;
    private final DotAttachment dotAttachment;
    private MinCrossDedigraph digraphProxy;

    MinCross(RankContent rankContent, DotAttachment dotAttachment) {
        this.rankContent = rankContent;
        this.dotAttachment = dotAttachment;
        this.reduceLongEdges();
        this.initRootCrossRank();
        this.dotMincross();
        this.syncRankOrder();
        this.rootCrossRank = null;
    }

    public EdgeDedigraph<DNode, DLine> getDigraphProxy() {
        return this.digraphProxy;
    }

    private void reduceLongEdges() {
        RankContent.RankNode rankNode;
        DotDigraph digraph = this.dotAttachment.getDotDigraph();
        this.digraphProxy = new MinCrossDedigraph(digraph.vertexNum());
        HashMap<DNode, Map> parallelEdgesRecord = new HashMap<DNode, Map>(1);
        int d = 0;
        RankContent.RankNode pre = null;
        RankContent.RankNode current = this.rankContent.get(this.rankContent.minRank());
        HashMap<Integer, RankContent.RankNode> rm = new HashMap<Integer, RankContent.RankNode>(this.rankContent.size());
        while (current != null) {
            if (current.isEmpty()) {
                ++d;
                if (pre != null) {
                    pre.setRankSep(pre.getRankSep() + current.getRankSep());
                }
                current = current.next;
                continue;
            }
            if (d > 0) {
                if (pre != null) {
                    pre.next = current;
                }
                current.pre = pre;
                current.setRankIndex(current.rankIndex() - d);
            }
            for (int j = 0; j < current.size(); ++j) {
                DNode from = current.get(j);
                int fromRank = this.getOldRank(from);
                this.digraphProxy.add(from);
                Map lineMap = parallelEdgesRecord.computeIfAbsent(from, k -> new HashMap(this.dotAttachment.getDotDigraph().degree(from)));
                for (DLine e : digraph.adjacent(from)) {
                    DNode to = (DNode)e.to();
                    DLine edge = (DLine)lineMap.get(to);
                    if (edge != null) {
                        edge.addParallelEdge(e);
                        continue;
                    }
                    if (this.getOldRank(to) - fromRank <= 1 && from != to) {
                        this.digraphProxy.addEdge(e, this.dotAttachment.getDrawGraph());
                        if (this.getOldRank(to) - fromRank != 1) continue;
                        lineMap.put(to, e);
                        continue;
                    }
                    this.cutLongEdge(e, lineMap, current);
                }
                parallelEdgesRecord.remove(from);
                from.setRank(current.rankIndex());
            }
            rm.put(current.rankIndex(), current);
            pre = current;
            current = current.next;
        }
        this.rankContent.rankNodeMap = rm;
        this.rankContent.maxRank -= d;
        for (int rank = this.rankContent.maxRank; rank > this.rankContent.maxRank && (rankNode = this.rankContent.get(rank)) != null; --rank) {
            this.rankContent.remove(rank);
        }
    }

    private int getOldRank(DNode node) {
        if (node.isLabelNode() || node.getRank() > this.rankContent.size()) {
            return node.getRank();
        }
        return this.rankContent.get(node.getRank()).rankIndex();
    }

    private void cutLongEdge(DLine edge, Map<DNode, DLine> lineMap, RankContent.RankNode rankNode) {
        DNode from = (DNode)edge.from();
        int end = this.getOldRank((DNode)edge.to());
        Graphviz graphviz = this.dotAttachment.getGraphviz();
        GraphContainer container = DotAttachment.commonParent(graphviz, from, (DNode)edge.to());
        ArrayList<DNode> virtualNodes = null;
        if (edge.haveLabel() && edge.getLabelSize() != null) {
            virtualNodes = new ArrayList<DNode>(Math.abs(end - from.getRank()));
        }
        rankNode = rankNode.next;
        while (rankNode != null && rankNode.rankIndex() <= end) {
            DNode to;
            if (rankNode.rankIndex() == end) {
                to = (DNode)edge.to();
            } else {
                if (rankNode.isEmpty()) {
                    rankNode = rankNode.next;
                    continue;
                }
                to = DNode.newVirtualNode(20.0, container);
                to.setRank(rankNode.rankIndex());
                rankNode.add(to);
                if (virtualNodes != null) {
                    virtualNodes.add(to);
                }
            }
            if (from == edge.from() && to == edge.to()) {
                this.digraphProxy.addEdge(edge, this.dotAttachment.getDrawGraph());
                lineMap.put(to, edge);
            } else {
                this.digraphProxy.addEdge(new DLine(from, to, edge.getLine(), edge.lineAttrs(), edge.weight(), edge.limit()), this.dotAttachment.getDrawGraph());
            }
            from = to;
            rankNode = rankNode.next;
        }
        if (CollectionUtils.isNotEmpty(virtualNodes)) {
            FlatPoint labelSize = edge.getLabelSize();
            DNode labelNode = (DNode)virtualNodes.get(virtualNodes.size() / 2);
            labelNode.setLabelLine(edge.getLine());
            labelNode.setWidth((int)labelSize.getWidth());
            labelNode.setHeight((int)labelSize.getHeight());
        }
    }

    private void dotMincross() {
        if (this.clusterExpand != null) {
            this.clusterExpand.cluster = this.dotAttachment.getGraphviz();
        }
        this.mincross(0, 2);
        for (Cluster cluster : DotAttachment.clusters(this.dotAttachment.getGraphviz())) {
            this.mincrossCluster(cluster);
        }
    }

    private void mincrossCluster(Cluster cluster) {
        SameRankAdjacentRecord sameRankAdjacentRecord = this.rootCrossRank.getSameRankAdjacentRecord();
        if (sameRankAdjacentRecord != null) {
            sameRankAdjacentRecord.clearMarkIn();
        }
        BasicCrossRank crossRank = this.clusterExpand.init(cluster);
        this.rootCrossRank.expand(this.clusterExpand);
        this.expandLine(crossRank);
        this.clusterExpand.clusterMerge.clearCluster(cluster);
        this.mincross(1, 2);
        for (Cluster c : DotAttachment.clusters(cluster)) {
            this.mincrossCluster(c);
        }
        this.rootCrossRank.syncChildOrder();
        this.rootCrossRank.setSameRankAdjacentRecord(null);
    }

    private void syncRankOrder() {
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (int j = 0; j < rankNode.size(); ++j) {
                DNode from = this.rootCrossRank.getNode(i, j);
                rankNode.set(j, from);
                from.setRankIndex(j);
                for (DLine dLine : this.digraphProxy.outAdjacent(from)) {
                    DNode to = dLine.other(from);
                    if (to.getRank() != from.getRank()) continue;
                    if (this.dotAttachment.getSameRankAdjacentRecord() == null) {
                        this.dotAttachment.setSameRankAdjacentRecord(new SameRankAdjacentRecord());
                    }
                    this.dotAttachment.getSameRankAdjacentRecord().addOutAdjacent(from, dLine);
                }
            }
        }
    }

    private void initRootCrossRank() {
        if (!this.dotAttachment.haveClusters()) {
            this.rootCrossRank = new RootCrossRank(this.dotAttachment.getDrawGraph(), this.digraphProxy);
            return;
        }
        this.rootCrossRank = new RootCrossRank(this.dotAttachment.getDrawGraph());
        Graphviz graphviz = this.dotAttachment.getGraphviz();
        this.clusterExpand = new ClusterExpand(new ClusterMerge());
        HashMap<DNode, Set<DNode>> nodeHaveLine = new HashMap<DNode, Set<DNode>>();
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (int j = 0; j < rankNode.size(); ++j) {
                DNode from = rankNode.get(j);
                DNode fromClusterNode = this.clusterProxyNode(from, graphviz);
                for (DLine line : this.digraphProxy.outAdjacent(from)) {
                    DNode to = (DNode)line.to();
                    DNode toCLusterNode = this.clusterProxyNode((DNode)line.to(), graphviz);
                    this.addLine(from, fromClusterNode, nodeHaveLine, line, to, toCLusterNode);
                }
                if (from != fromClusterNode) continue;
                this.rootCrossRank.addNode(fromClusterNode);
            }
        }
    }

    private void expandLine(BasicCrossRank clusterCrossRank) {
        int j;
        int s;
        int i;
        HashMap<DNode, Set<DNode>> nodeHaveLine = new HashMap<DNode, Set<DNode>>();
        HashSet<DLine> linesRecord = new HashSet<DLine>();
        GraphContainer container = clusterCrossRank.container();
        for (i = clusterCrossRank.minRank(); i <= clusterCrossRank.maxRank(); ++i) {
            s = clusterCrossRank.rankSize(i);
            for (j = 0; j < s; ++j) {
                DNode from = clusterCrossRank.getNode(i, j);
                DNode fromClusterNode = this.clusterProxyNode(from, container);
                for (DLine line : this.digraphProxy.outAdjacent(from)) {
                    linesRecord.add(line);
                    DNode to = (DNode)line.to();
                    DNode toCLusterNode = this.clusterProxyNode((DNode)line.to(), container);
                    this.addLine(from, fromClusterNode, nodeHaveLine, line, to, toCLusterNode);
                }
            }
        }
        for (i = clusterCrossRank.maxRank(); i >= clusterCrossRank.minRank(); --i) {
            s = clusterCrossRank.rankSize(i);
            for (j = 0; j < s; ++j) {
                DNode to = clusterCrossRank.getNode(i, j);
                DNode toClusterNode = this.clusterProxyNode(to, clusterCrossRank.container);
                for (DLine line : this.digraphProxy.inAdjacent(to)) {
                    if (linesRecord.contains(line)) continue;
                    DNode from = (DNode)line.from();
                    DNode fromClusterNode = this.clusterProxyNode(from, clusterCrossRank.container);
                    this.addLine(from, fromClusterNode, nodeHaveLine, line, to, toClusterNode);
                }
            }
        }
    }

    private void addLine(DNode from, DNode fromClusterNode, Map<DNode, Set<DNode>> nodeHaveLine, DLine line, DNode to, DNode toCLusterNode) {
        Set nodes = nodeHaveLine.computeIfAbsent(fromClusterNode, f -> new HashSet(2));
        if (from != fromClusterNode || to != toCLusterNode) {
            if (!nodes.contains(toCLusterNode) && fromClusterNode != toCLusterNode) {
                nodes.add(toCLusterNode);
                line = new DLine(fromClusterNode, toCLusterNode, null, null, line.weight(), line.limit());
                this.rootCrossRank.addEdge(line);
            }
        } else {
            nodes.add(toCLusterNode);
            this.rootCrossRank.addEdge(line);
        }
    }

    private DNode clusterProxyNode(DNode node, GraphContainer graphContainer) {
        GraphContainer father;
        Graphviz graphviz = this.dotAttachment.getGraphviz();
        if (node.getContainer() == graphContainer) {
            return node;
        }
        GraphContainer current = node.getContainer();
        while ((father = graphviz.effectiveFather(current)) != graphContainer && father != null) {
            current = father;
        }
        if (father == null) {
            DNode n = this.clusterExpand.clusterMerge.getMergeNode(node);
            return n != null ? n : node;
        }
        return this.clusterExpand.clusterMerge.getMergeNodeOrPut((Cluster)current, node);
    }

    private void mincross(int startPass, int endPass) {
        int minCrossNum;
        int currentNum = minCrossNum = this.rootCrossRank.currentCrossNum();
        BasicCrossRank optimal = this.rootCrossRank.getBasicCrossRank();
        int minQuit = this.dotAttachment.getDrawGraph().getGraphviz().graphAttrs().getMclimit();
        int maxIter = 24;
        BasicCrossRank c = optimal.clone();
        new InitSort(c, c.container(), this.dotAttachment.getDrawGraph(), true);
        int cn = this.getCrossNum(c);
        if (cn <= minCrossNum) {
            optimal = c;
            minCrossNum = currentNum = cn;
            this.rootCrossRank.setBasicCrossRank(optimal);
        }
        BasicCrossRank p = optimal.clone();
        new InitSort(p, p.container(), this.dotAttachment.getDrawGraph(), false);
        cn = this.getCrossNum(p);
        if (cn < minCrossNum) {
            optimal = p;
            minCrossNum = currentNum = cn;
            this.rootCrossRank.setBasicCrossRank(optimal);
        }
        for (int pass = startPass; pass <= endPass; ++pass) {
            int maxThisPass;
            if (pass <= 1) {
                maxThisPass = Math.min(4, maxIter);
                if (pass == 1 && (this.rootCrossRank.getSameRankAdjacentRecord() != null || optimal.container().haveChildCluster())) {
                    BasicCrossRank repl = optimal.clone();
                    new InitSort(repl, repl.container(), this.dotAttachment.getDrawGraph(), false, false);
                    BasicCrossRank tmp = this.rootCrossRank.getBasicCrossRank();
                    this.rootCrossRank.setBasicCrossRank(repl);
                    currentNum = this.rootCrossRank.currentCrossNum();
                    if (minCrossNum >= currentNum) {
                        optimal = repl;
                    } else {
                        this.rootCrossRank.setBasicCrossRank(tmp);
                    }
                }
                this.flatOrder(optimal);
                this.rootCrossRank.setBasicCrossRank(optimal);
                minCrossNum = this.rootCrossRank.currentCrossNum();
            } else {
                maxThisPass = maxIter;
            }
            optimal = optimal.clone();
            int trying = 0;
            for (int i = 0; i < maxThisPass; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("pass {} iter {} trying {} cur_cross {} best_cross {}", new Object[]{pass, i, trying, currentNum, minCrossNum});
                }
                if (trying++ >= minQuit || minCrossNum == 0) break;
                this.mincrossStep(i);
                currentNum = this.rootCrossRank.currentCrossNum();
                if (minCrossNum <= currentNum) continue;
                optimal = this.rootCrossRank.getBasicCrossRank().clone();
                if ((double)currentNum < 0.995 * (double)minCrossNum) {
                    trying = 0;
                }
                minCrossNum = currentNum;
            }
            if (minCrossNum == 0) break;
        }
        this.rootCrossRank.setBasicCrossRank(optimal);
        this.rootCrossRank.transpose(false);
        this.rootCrossRank.syncChildOrder();
    }

    private void mincrossStep(int iterNum) {
        this.rootCrossRank.vmedian(iterNum);
        this.rootCrossRank.transpose(iterNum % 4 >= 2);
    }

    private int getCrossNum(BasicCrossRank basicCrossRank) {
        BasicCrossRank tmp = this.rootCrossRank.getBasicCrossRank();
        this.rootCrossRank.setBasicCrossRank(basicCrossRank);
        int n = this.rootCrossRank.currentCrossNum();
        this.rootCrossRank.setBasicCrossRank(tmp);
        return n;
    }

    private void flatOrder(CrossRank crossRank) {
        SameRankAdjacentRecord sameRankAdjacentRecord = this.rootCrossRank.getSameRankAdjacentRecord();
        int[] no = new int[]{0};
        int connectNo = 0;
        HashSet<DNode> mark = new HashSet<DNode>();
        HashMap<DNode, Map.Entry<Integer, Integer>> postOrderRecord = new HashMap<DNode, Map.Entry<Integer, Integer>>();
        ClusterOrder clusterOrder = this.clusterExpand != null ? new ClusterOrder(this.clusterExpand.clusterMerge) : null;
        for (int i = crossRank.minRank(); i <= crossRank.maxRank(); ++i) {
            for (int j = 0; j < crossRank.rankSize(i); ++j) {
                DNode node = crossRank.getNode(i, j);
                if (mark.contains(node) || sameRankAdjacentRecord != null && sameRankAdjacentRecord.haveIn(node)) continue;
                GraphContainer fromCluster = this.addClusterNode(node, clusterOrder);
                if (fromCluster != null) {
                    clusterOrder.put(node, fromCluster);
                    clusterOrder.addReorderNode(node);
                }
                this.postOrder(connectNo++, no, node, mark, clusterOrder, fromCluster, postOrderRecord);
            }
        }
        this.clusterPostOrder(clusterOrder);
        this.rootCrossRank.clusterOrder = clusterOrder;
        crossRank.sort((left, right) -> {
            Integer rightConnect;
            Integer leftConnect = (Integer)((Map.Entry)postOrderRecord.get(left)).getKey();
            if (!Objects.equals(leftConnect, rightConnect = (Integer)((Map.Entry)postOrderRecord.get(right)).getKey())) {
                return leftConnect.compareTo(rightConnect);
            }
            Integer leftPost = (Integer)((Map.Entry)postOrderRecord.get(left)).getValue();
            Integer rightPost = (Integer)((Map.Entry)postOrderRecord.get(right)).getValue();
            return rightPost.compareTo(leftPost);
        });
        if (clusterOrder != null) {
            clusterOrder.reorderNode(crossRank);
        }
    }

    private int postOrder(int connectNo, int[] no, DNode node, Set<DNode> mark, ClusterOrder clusterOrder, GraphContainer fromCluster, Map<DNode, Map.Entry<Integer, Integer>> orderRecord) {
        mark.add(node);
        if (this.rootCrossRank.getSameRankAdjacentRecord() == null) {
            int n = no[0];
            no[0] = n + 1;
            orderRecord.put(node, new AbstractMap.SimpleEntry<Integer, Integer>(connectNo, n));
            return connectNo;
        }
        Set<DNode> adjacent = this.rootCrossRank.getSameRankAdjacentRecord().outAdjacent(node);
        if (CollectionUtils.isNotEmpty(adjacent)) {
            for (DNode dNode : adjacent) {
                if (mark.contains(dNode)) {
                    Map.Entry<Integer, Integer> accessOrder = orderRecord.get(dNode);
                    if (accessOrder == null) continue;
                    connectNo = accessOrder.getKey() != null ? accessOrder.getKey() : connectNo;
                    continue;
                }
                GraphContainer toCluster = this.addClusterNode(dNode, clusterOrder);
                if (fromCluster != null && toCluster != null) {
                    clusterOrder.addEdge(fromCluster, toCluster);
                }
                if (toCluster != null) {
                    clusterOrder.put(dNode, toCluster);
                    clusterOrder.addReorderNode(dNode);
                }
                connectNo = this.postOrder(connectNo, no, dNode, mark, clusterOrder, toCluster, orderRecord);
            }
        }
        int n = no[0];
        no[0] = n + 1;
        orderRecord.put(node, new AbstractMap.SimpleEntry<Integer, Integer>(connectNo, n));
        return connectNo;
    }

    private GraphContainer addClusterNode(DNode node, ClusterOrder clusterOrder) {
        if (clusterOrder == null) {
            return null;
        }
        DNode mergeNode = clusterOrder.getMergeNode(node);
        if (mergeNode != null) {
            GraphContainer cluster = this.dotAttachment.clusterDirectContainer(this.clusterExpand.container(), mergeNode);
            if (cluster == null) {
                return null;
            }
            clusterOrder.add(cluster);
            return cluster;
        }
        return null;
    }

    private void clusterPostOrder(ClusterOrder clusterOrder) {
        if (clusterOrder == null) {
            return;
        }
        HashSet<GraphContainer> mark = new HashSet<GraphContainer>();
        LinkedList<GraphContainer> stack = new LinkedList<GraphContainer>();
        for (GraphContainer container : clusterOrder.containers()) {
            if (mark.contains(container)) continue;
            this.clusterDfs(container, clusterOrder, mark, stack);
        }
        while (!stack.isEmpty()) {
            int size = stack.size();
            clusterOrder.addClusterOrder((GraphContainer)stack.pollFirst(), size);
        }
    }

    private void clusterDfs(GraphContainer container, ClusterOrder clusterOrder, Set<GraphContainer> mark, Deque<GraphContainer> stack) {
        mark.add(container);
        for (GraphContainer c : clusterOrder.adj(container)) {
            if (mark.contains(c)) continue;
            this.clusterDfs(c, clusterOrder, mark, stack);
        }
        stack.offerFirst(container);
    }

    static class ClusterOrder {
        private final ClusterMerge clusterMerge;
        private Digraph.VertexDigraph<GraphContainer> clusterGraph;
        private Map<DNode, GraphContainer> nodeGraphContainerMap;
        private Map<GraphContainer, Integer> orderRecord;
        private Map<Integer, List<DNode>> reorderClusterNodes;

        public ClusterOrder(ClusterMerge clusterMerge) {
            Asserts.nullArgument(clusterMerge, "clusterMerge");
            this.clusterMerge = clusterMerge;
        }

        Iterable<GraphContainer> containers() {
            if (this.clusterGraph == null) {
                return Collections.emptyList();
            }
            return this.clusterGraph;
        }

        Iterable<GraphContainer> adj(GraphContainer container) {
            if (this.clusterGraph == null) {
                return Collections.emptyList();
            }
            return this.clusterGraph.adjacent(container);
        }

        void put(DNode node, GraphContainer container) {
            if (this.nodeGraphContainerMap == null) {
                this.nodeGraphContainerMap = new HashMap<DNode, GraphContainer>();
            }
            this.nodeGraphContainerMap.put(node, container);
        }

        void add(GraphContainer container) {
            this.clusterGraph().add(container);
        }

        void addEdge(GraphContainer n, GraphContainer w) {
            this.clusterGraph().addEdge(n, w);
        }

        DNode getMergeNode(DNode node) {
            return this.clusterMerge.getMergeNode(node);
        }

        void addClusterOrder(GraphContainer container, int order) {
            if (this.orderRecord == null) {
                this.orderRecord = new HashMap<GraphContainer, Integer>();
            }
            this.orderRecord.put(container, order);
        }

        Integer getClusterOrder(GraphContainer container) {
            if (this.orderRecord == null) {
                return null;
            }
            return this.orderRecord.get(container);
        }

        Integer getNodeOrder(DNode node) {
            if (this.nodeGraphContainerMap == null) {
                return null;
            }
            GraphContainer container = this.nodeGraphContainerMap.get(node);
            if (container == null) {
                return null;
            }
            return this.getClusterOrder(container);
        }

        void addReorderNode(DNode node) {
            if (this.reorderClusterNodes == null) {
                this.reorderClusterNodes = new HashMap<Integer, List<DNode>>();
            }
            this.reorderClusterNodes.computeIfAbsent(node.getRank(), n -> new ArrayList(2)).add(node);
        }

        void reorderNode(CrossRank crossRank) {
            if (this.reorderClusterNodes == null || this.reorderClusterNodes.size() == 0) {
                return;
            }
            for (Map.Entry<Integer, List<DNode>> entry : this.reorderClusterNodes.entrySet()) {
                List<DNode> nodes = entry.getValue();
                for (int i = 0; i < nodes.size(); ++i) {
                    DNode n = nodes.get(i);
                    int ni = crossRank.getRankIndex(n);
                    Integer nci = this.getNodeOrder(n);
                    if (nci == null) continue;
                    for (int j = i + 1; j < nodes.size(); ++j) {
                        DNode w = nodes.get(j);
                        int wi = crossRank.getRankIndex(w);
                        Integer wci = this.getNodeOrder(w);
                        if (wci == null || ni - wi > 0 == nci - wci > 0) continue;
                        crossRank.exchange(n, w);
                    }
                }
            }
            this.reorderClusterNodes.clear();
        }

        private Digraph.VertexDigraph<GraphContainer> clusterGraph() {
            if (this.clusterGraph == null) {
                this.clusterGraph = new DirectedGraph<GraphContainer>();
            }
            return this.clusterGraph;
        }
    }

    private static class ClusterMerge {
        private final Map<Cluster, Map<Integer, DNode>> clusterRankProxyNode = new LinkedHashMap<Cluster, Map<Integer, DNode>>();
        private final Map<DNode, DNode> mergeNodeMap = new LinkedHashMap<DNode, DNode>();

        void clearCluster(Cluster cluster) {
            this.clusterRankProxyNode.remove(cluster);
        }

        Iterable<DNode> clusterMergeNode(GraphContainer container) {
            Map<Integer, DNode> rankMap = this.clusterRankProxyNode.get(container);
            if (rankMap == null) {
                return Collections.emptyList();
            }
            return rankMap.values();
        }

        DNode getMergeNode(DNode node) {
            return this.mergeNodeMap.get(node);
        }

        DNode getMergeNodeOrPut(Cluster cluster, DNode node) {
            DNode n = this.clusterRankProxyNode.computeIfAbsent(cluster, c -> new HashMap()).computeIfAbsent(node.getRank(), k -> node);
            this.mergeNodeMap.put(node, n);
            return n;
        }
    }

    private static class InOrOutHavePort {
        private boolean inHavePort;
        private boolean outHavePort;

        private InOrOutHavePort() {
        }
    }

    private static class MinCrossDedigraph
    extends DedirectedEdgeGraph<DNode, DLine> {
        private static final long serialVersionUID = -2242254412888614002L;
        private Map<DNode, InOrOutHavePort> nodeInOrOutHavePortMap;

        MinCrossDedigraph(int capacity) {
            super(capacity);
        }

        void addEdge(DLine dLine, DrawGraph drawGraph) {
            this.addEdge(dLine);
            this.markNodeHavePort(dLine.getLine(), (DNode)dLine.from(), drawGraph, false);
            this.markNodeHavePort(dLine.getLine(), (DNode)dLine.to(), drawGraph, true);
        }

        boolean inHavePort(DNode node) {
            if (node == null || this.nodeInOrOutHavePortMap == null) {
                return false;
            }
            InOrOutHavePort inOrOutHavePort = this.nodeInOrOutHavePortMap.get(node);
            return inOrOutHavePort != null && inOrOutHavePort.inHavePort;
        }

        boolean outHavePort(DNode node) {
            if (node == null || this.nodeInOrOutHavePortMap == null) {
                return false;
            }
            InOrOutHavePort inOrOutHavePort = this.nodeInOrOutHavePortMap.get(node);
            return inOrOutHavePort != null && inOrOutHavePort.outHavePort;
        }

        private void markNodeHavePort(Line line, DNode node, DrawGraph drawGraph, boolean isIn) {
            double compareNo = PortHelper.portCompareNo(line, node, drawGraph);
            if (compareNo == 0.0) {
                return;
            }
            if (this.nodeInOrOutHavePortMap == null) {
                this.nodeInOrOutHavePortMap = new HashMap<DNode, InOrOutHavePort>();
            }
            InOrOutHavePort havePort = this.nodeInOrOutHavePortMap.computeIfAbsent(node, n -> new InOrOutHavePort());
            if (isIn) {
                havePort.inHavePort = true;
            } else {
                havePort.outHavePort = true;
            }
        }
    }

    private class InitSort
    extends Mark<DNode> {
        private SameRankAdjacentRecord sameRankAdjacentRecord;
        private final Map<Integer, Integer> rankAccessIndex;
        private final boolean isOutDirection;
        private final CrossRank crossRank;
        private final GraphContainer graphContainer;

        InitSort(CrossRank crossRank, GraphContainer graphContainer, DrawGraph drawGraph, boolean isOutDirection) {
            this(crossRank, graphContainer, drawGraph, true, isOutDirection);
        }

        InitSort(CrossRank crossRank, GraphContainer graphContainer, DrawGraph drawGraph, boolean isNormal, boolean isOutDirection) {
            this.isOutDirection = isOutDirection;
            this.rankAccessIndex = new HashMap<Integer, Integer>();
            this.graphContainer = graphContainer;
            this.crossRank = crossRank;
            if (isNormal) {
                this.normalInit(crossRank, drawGraph, isOutDirection);
            } else {
                this.flatInit();
            }
        }

        private void normalInit(CrossRank crossRank, DrawGraph drawGraph, boolean isOutDirection) {
            int limit;
            int addNum;
            int first;
            if (isOutDirection) {
                first = crossRank.minRank();
                addNum = 1;
                limit = crossRank.maxRank() + 1;
            } else {
                first = crossRank.maxRank();
                addNum = -1;
                limit = crossRank.minRank() - 1;
            }
            EdgeDedigraph<DNode, DLine> digraph = MinCross.this.rootCrossRank.getDigraphProxy();
            Function<DNode, Iterable<DLine>> adjacentFunc = n -> {
                if (digraph instanceof MinCrossDedigraph) {
                    MinCrossDedigraph dedigraph = (MinCrossDedigraph)digraph;
                    if (isOutDirection) {
                        if (dedigraph.outHavePort((DNode)n)) {
                            return this.sortLines((DNode)n, drawGraph, dedigraph.outAdjacent(n));
                        }
                        return dedigraph.outAdjacent(n);
                    }
                    if (dedigraph.inHavePort((DNode)n)) {
                        return this.sortLines((DNode)n, drawGraph, dedigraph.inAdjacent(n));
                    }
                    return dedigraph.inAdjacent(n);
                }
                return isOutDirection ? digraph.outAdjacent(n) : digraph.inAdjacent(n);
            };
            for (int i = first; i != limit; i += addNum) {
                for (int j = 0; j < crossRank.rankSize(i); ++j) {
                    DNode node = crossRank.getNode(i, j);
                    if (this.isMark(node)) continue;
                    this.dfs(node, adjacentFunc);
                }
            }
            if (this.sameRankAdjacentRecord != null) {
                MinCross.this.rootCrossRank.setSameRankAdjacentRecord(this.sameRankAdjacentRecord);
            }
        }

        private void flatInit() {
            TreeSet<DNode> adjNodes = new TreeSet<DNode>(Comparator.comparingInt(this.crossRank::getRankIndex));
            HashMap<DNode, Integer> rankIndexRecord = new HashMap<DNode, Integer>();
            for (int i = this.crossRank.minRank(); i <= this.crossRank.maxRank(); ++i) {
                int s = this.crossRank.rankSize(i);
                int rankIdx = 0;
                rankIndexRecord.clear();
                for (int j = 0; j < s; ++j) {
                    adjNodes.clear();
                    DNode node = this.crossRank.getNode(i, j);
                    this.mark(node);
                    for (DLine line : MinCross.this.rootCrossRank.getDigraphProxy().outAdjacent(node)) {
                        DNode other;
                        if (MinCross.this.dotAttachment.notContain(this.graphContainer, ((DNode)line.to()).getContainer()) || (other = line.other(node)).getRank() == node.getRank() || this.isMark(other)) continue;
                        this.mark(other);
                        adjNodes.add(other);
                    }
                    for (DNode n2 : adjNodes) {
                        rankIndexRecord.put(n2, rankIdx++);
                    }
                }
                int ri = rankIdx;
                this.crossRank.sort(i + 1, Comparator.comparingInt(n -> {
                    Integer idx = (Integer)rankIndexRecord.get(n);
                    return idx != null ? idx : ri + this.crossRank.getRankIndex((DNode)n);
                }));
            }
        }

        private void dfs(DNode from, Function<DNode, Iterable<DLine>> adjacentFunc) {
            this.mark(from);
            int idx = this.rankAccessIndex.getOrDefault(from.getRank(), 0);
            this.crossRank.exchange(from, this.crossRank.getNode(from.getRank(), idx));
            this.rankAccessIndex.put(from.getRank(), idx + 1);
            Iterable<DLine> adjacent = adjacentFunc.apply(from);
            for (DLine dLine : adjacent) {
                DNode to = dLine.other(from);
                if (MinCross.this.dotAttachment.notContain(this.graphContainer, to.getContainer())) continue;
                if (this.isOutDirection && to.getRank() == from.getRank()) {
                    if (this.sameRankAdjacentRecord == null) {
                        this.sameRankAdjacentRecord = new SameRankAdjacentRecord();
                    }
                    this.sameRankAdjacentRecord.addOutAdjacent(from, dLine);
                    continue;
                }
                if (this.isMark(to)) continue;
                this.dfs(to, adjacentFunc);
            }
        }

        private Iterable<DLine> sortLines(DNode node, DrawGraph drawGraph, Iterable<DLine> lines) {
            TreeSet<DLine> sortLines = new TreeSet<DLine>((l, r) -> this.lineComp((DLine)l, (DLine)r, node, drawGraph));
            lines.forEach(sortLines::add);
            return sortLines;
        }

        private int lineComp(DLine left, DLine right, DNode node, DrawGraph drawGraph) {
            double leftComNo = PortHelper.portCompareNo(left.getLine(), node, drawGraph);
            double rightComNo = PortHelper.portCompareNo(right.getLine(), node, drawGraph);
            return Double.compare(leftComNo, rightComNo);
        }
    }

    private class ClusterExpand
    implements RootCrossRank.ExpandInfoProvider {
        private GraphContainer cluster;
        private final ClusterMerge clusterMerge;
        private Map<DNode, Set<DNode>> mergeNodes;

        public ClusterExpand(ClusterMerge clusterMerge) {
            this.clusterMerge = clusterMerge;
        }

        BasicCrossRank init(Cluster cluster) {
            this.cluster = cluster;
            if (this.mergeNodes == null) {
                this.mergeNodes = new HashMap<DNode, Set<DNode>>();
            } else {
                this.mergeNodes.clear();
            }
            BasicCrossRank crossRank = new BasicCrossRank(cluster);
            Iterator iterator = this.clusterMerge.mergeNodeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                DNode node = (DNode)entry.getKey();
                DNode mergeNode = (DNode)entry.getValue();
                GraphContainer commonParent = MinCross.this.dotAttachment.commonParent(node, mergeNode);
                if (MinCross.this.dotAttachment.notContain(cluster, commonParent)) continue;
                crossRank.addNode(node);
                if (node == mergeNode) {
                    this.mergeNodes.computeIfAbsent(mergeNode, n -> new LinkedHashSet()).add(node);
                    if (node.getContainer() != cluster) continue;
                    iterator.remove();
                    continue;
                }
                if (node.getContainer() == cluster) {
                    this.mergeNodes.computeIfAbsent(mergeNode, n -> new LinkedHashSet()).add(node);
                    iterator.remove();
                    continue;
                }
                if (mergeNode.getContainer() == cluster) {
                    this.mergeNodes.computeIfAbsent(mergeNode, n -> new LinkedHashSet()).add(MinCross.this.clusterProxyNode(node, cluster));
                    continue;
                }
                if (commonParent == cluster) {
                    this.mergeNodes.computeIfAbsent(mergeNode, n -> new LinkedHashSet()).add(MinCross.this.clusterProxyNode(node, cluster));
                    continue;
                }
                this.clusterMerge.getMergeNodeOrPut((Cluster)commonParent, mergeNode);
            }
            return crossRank;
        }

        @Override
        public Iterable<DNode> expandNodes() {
            return this.clusterMerge.clusterMergeNode(this.cluster);
        }

        @Override
        public Iterable<DNode> replaceNodes(DNode node) {
            return this.mergeNodes.get(node);
        }

        @Override
        public GraphContainer container() {
            return this.cluster;
        }
    }
}

