/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import org.graphper.layout.Mark;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.DotGraph;
import org.graphper.layout.dot.FeasibleTree;
import org.graphper.layout.dot.RankContent;
import org.graphper.layout.dot.ULine;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetworkSimplex {
    private static final Logger log = LoggerFactory.getLogger(NetworkSimplex.class);
    private RankContent rankContent;
    private final DotDigraph dotDigraph;
    private FeasibleTree feasibleTree;
    private Queue<ULine> negativeLine;
    private ArrayList<ULine> updateCutvalLines;
    private DNode calcCutvalHead;
    private final boolean positiveRank;
    private final double rankSep;

    public NetworkSimplex(FeasibleTree feasibleTree, int nsLimit, double rankSep, Consumer<DNode[]> sortNodesConsumer) {
        this(feasibleTree, nsLimit, true, true, rankSep, sortNodesConsumer);
    }

    public NetworkSimplex(FeasibleTree feasibleTree, int nsLimit, boolean positiveRank, boolean needRankContent, double rankSep, Consumer<DNode[]> sortNodesConsumer) {
        Asserts.nullArgument(feasibleTree, "feasibleTree");
        Asserts.illegalArgument(feasibleTree.getDotDigraph() == null, "feasibleTree.getDotDigraph() can not be null");
        Asserts.illegalArgument(rankSep < 0.0, "rankSpace (" + rankSep + ") must be > 0");
        this.feasibleTree = feasibleTree;
        this.dotDigraph = feasibleTree.getDotDigraph();
        this.negativeLine = feasibleTree.negativeLine();
        this.positiveRank = positiveRank;
        this.rankSep = rankSep;
        this.networkSimplex(nsLimit);
        this.alignUnconnectGraph(this.balance(needRankContent, sortNodesConsumer));
        this.clear();
    }

    public RankContent getRankContent() {
        return this.rankContent;
    }

    private void networkSimplex(int nsLimit) {
        ULine out;
        String prefix = null;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            prefix = "network simplex: ";
            log.debug("{} nodes={} edges={} maxiter={}", new Object[]{prefix, this.dotDigraph.vertexNum(), this.dotDigraph.edgeNum(), nsLimit});
        }
        int count = 0;
        ArrayList<Set<DNode>> halfNodeRecord = null;
        while ((out = this.negativeTreeLine()) != null && count++ < nsLimit) {
            if (halfNodeRecord == null) {
                halfNodeRecord = new ArrayList<Set<DNode>>(1);
            }
            halfNodeRecord.clear();
            ULine enter = this.findEnterLine(out, halfNodeRecord);
            if (enter == null) continue;
            this.enterLine(enter, out, (Set)halfNodeRecord.get(0));
            if (!log.isDebugEnabled() || count % 100 != 0) continue;
            log.debug("{} {}", (Object)prefix, (Object)count);
        }
        if (log.isDebugEnabled()) {
            log.debug("Network is done,total number of iterations is {},time is {}s", (Object)count, (Object)((System.currentTimeMillis() - start) / 1000L));
        }
    }

    private ULine findEnterLine(ULine outLine, List<Set<DNode>> halfNodeRecord) {
        ULine[] minSlackLine = new ULine[]{null};
        int[] minSlack = new int[]{Integer.MAX_VALUE};
        Consumer<ULine> consumer = uLine -> {
            if (!FeasibleTree.isCross(outLine.getdLine(), uLine.getdLine()) || FeasibleTree.inTail((DNode)uLine.getdLine().from(), outLine.getdLine())) {
                return;
            }
            int slack = uLine.reduceLen();
            if (minSlackLine[0] == null || slack < minSlack[0]) {
                minSlackLine[0] = uLine;
                minSlack[0] = slack;
            }
        };
        halfNodeRecord.add(FeasibleTree.halfDfs(this.feasibleTree.graph(), outLine, consumer));
        return minSlackLine[0];
    }

    private void enterLine(ULine enterLine, ULine outLine, Set<DNode> halfNodes) {
        DNode largeLimNode;
        DotGraph tree = this.feasibleTree.tree();
        enterLine.getdLine().setCutVal(-outLine.getdLine().getCutVal());
        DNode root = this.findNeedUpdateCutvalLines(tree, enterLine);
        DNode dNode = largeLimNode = ((DNode)outLine.getdLine().from()).getLim() > ((DNode)outLine.getdLine().to()).getLim() ? (DNode)outLine.getdLine().from() : (DNode)outLine.getdLine().to();
        if (this.notInLimLowRange(root, largeLimNode)) {
            root = this.publicRoot(tree, root, largeLimNode, null);
        }
        tree.removeLine(outLine);
        tree.addEdge(enterLine);
        if (enterLine.reduceLen() != 0) {
            DNode t;
            int r = enterLine.reduceLen();
            DNode dNode2 = t = FeasibleTree.inTail((DNode)outLine.either(), outLine.getdLine()) ? (DNode)outLine.either() : (DNode)outLine.other(outLine.either());
            if (halfNodes.contains(t)) {
                r = -r;
            }
            for (DNode halfNode : halfNodes) {
                halfNode.setRank(halfNode.getRank() + r);
            }
        }
        new LowLimCalc(tree, root);
        this.updateCutval();
        this.updateCutvalLines.clear();
    }

    private Map<Integer, DNode> balance(boolean needRankContent, Consumer<DNode[]> sortNodesConsumer) {
        if (this.positiveRank) {
            return this.tbBalance(sortNodesConsumer);
        }
        this.lrBalance();
        if (needRankContent) {
            this.rankContent = new RankContent(this.feasibleTree.graph(), this.rankSep, this.positiveRank, sortNodesConsumer);
        }
        return null;
    }

    private Map<Integer, DNode> tbBalance(Consumer<DNode[]> sortNodesConsumer) {
        DotGraph dotGraph = this.feasibleTree.graph();
        HashMap<Integer, DNode> connectLowRank = this.feasibleTree.isHaveUnconnectedGraph() ? new HashMap<Integer, DNode>() : null;
        this.rankContent = new RankContent(dotGraph, this.rankSep, this.positiveRank, sortNodesConsumer);
        for (DNode node : dotGraph) {
            Integer nextRank;
            int connectNo = this.feasibleTree.getConnectNo(node);
            if (connectLowRank != null) {
                connectLowRank.compute(connectNo, (c, n) -> {
                    if (n == null) {
                        return node;
                    }
                    return n.getRank() < node.getRank() ? n : node;
                });
            }
            int currentRank = node.getRank();
            RankContent.RankNode current = this.rankContent.get(currentRank);
            Integer preRank = current.pre != null ? Integer.valueOf(current.pre.rankIndex()) : null;
            Integer n2 = nextRank = current.next != null ? Integer.valueOf(current.next.rankIndex()) : null;
            if (preRank == null || nextRank == null) continue;
            double inAndOutWeight = 0.0;
            int preMax = Integer.MIN_VALUE;
            int nextMin = Integer.MAX_VALUE;
            boolean canNotMove = false;
            for (ULine uLine : dotGraph.adjacent(node)) {
                DNode other = uLine.other(node);
                int otherRank = other.getRank();
                if (this.positiveRank) {
                    otherRank = otherRank < node.getRank() ? otherRank + uLine.limit() - 1 : otherRank - uLine.limit() + 1;
                }
                if (otherRank < currentRank && otherRank > preMax) {
                    preMax = otherRank;
                }
                if (otherRank > currentRank && otherRank < nextMin) {
                    nextMin = otherRank;
                }
                if (canNotMove = Objects.equals(preMax, preRank) && Objects.equals(nextMin, nextRank)) break;
                if (this.isInEdge(node, uLine)) {
                    inAndOutWeight += uLine.getdLine().weight();
                    continue;
                }
                inAndOutWeight -= uLine.getdLine().weight();
            }
            if (canNotMove || inAndOutWeight != 0.0 || preMax == Integer.MIN_VALUE || nextMin == Integer.MAX_VALUE) continue;
            RankContent.RankNode sparsestRank = current;
            RankContent.RankNode preMaxNode = this.rankContent.get(preMax);
            RankContent.RankNode nextMinNode = this.rankContent.get(nextMin);
            RankContent.RankNode curNode = preMaxNode.next;
            while (curNode != null && curNode != nextMinNode) {
                if (curNode.size() >= sparsestRank.size() - 1) {
                    curNode = curNode.next;
                    continue;
                }
                sparsestRank = curNode;
                curNode = curNode.next;
            }
            if (sparsestRank == current) continue;
            this.updateRank(node, current, sparsestRank);
        }
        return connectLowRank;
    }

    private void updateRank(DNode node, RankContent.RankNode sourceNode, RankContent.RankNode targetRank) {
        if (sourceNode == targetRank || node.getRank() != sourceNode.rankIndex()) {
            return;
        }
        sourceNode.remove(node);
        node.setRank(targetRank.rankIndex());
        targetRank.add(node);
    }

    private void lrBalance() {
        ArrayList<Set<DNode>> halfNodeRecord = null;
        HashSet<ULine> lineMarks = new HashSet<ULine>(this.feasibleTree.tree().edgeNum());
        for (DNode n : this.feasibleTree.tree()) {
            for (ULine e : this.feasibleTree.tree().adjacent(n)) {
                int delta;
                ULine enter;
                if (e.cutVal() != 0.0 || lineMarks.contains(e)) continue;
                lineMarks.add(e);
                if (halfNodeRecord == null) {
                    halfNodeRecord = new ArrayList<Set<DNode>>();
                } else {
                    halfNodeRecord.clear();
                }
                if ((enter = this.findEnterLine(e, halfNodeRecord)) == null || (delta = enter.reduceLen()) <= 1) continue;
                DNode from = (DNode)enter.getdLine().from();
                Set halfNodes = (Set)halfNodeRecord.get(0);
                delta = halfNodes.contains(from) ? (delta /= -2) : (delta /= 2);
                for (DNode halfNode : halfNodes) {
                    halfNode.setRank(halfNode.getRank() - delta);
                }
            }
        }
    }

    private DNode findNeedUpdateCutvalLines(DotGraph tree, ULine enterLine) {
        DNode from = (DNode)enterLine.getdLine().from();
        DNode to = (DNode)enterLine.getdLine().to();
        DNode current = this.calcCutvalHead = from;
        DNode root = current = this.publicRoot(tree, to, current, this::addUpdateCutvalLines);
        block0: while (current != to) {
            for (ULine uLine : tree.adjacent(current)) {
                DNode other = uLine.other(current);
                if (other.getLim() > current.getLim() || this.notInLimLowRange(other, to)) continue;
                current = other;
                this.addUpdateCutvalLines(uLine);
                continue block0;
            }
        }
        return root;
    }

    private DNode publicRoot(DotGraph tree, DNode to, DNode current, Consumer<ULine> lineConsumer) {
        block0: while (this.notInLimLowRange(current, to)) {
            for (ULine uLine : tree.adjacent(current)) {
                DNode other = uLine.other(current);
                if (other.getLim() < current.getLim()) continue;
                current = other;
                if (lineConsumer == null) continue block0;
                lineConsumer.accept(uLine);
                continue block0;
            }
        }
        return current;
    }

    private void updateCutval() {
        if (CollectionUtils.isEmpty(this.updateCutvalLines)) {
            return;
        }
        DotGraph tree = this.feasibleTree.tree();
        DNode current = this.calcCutvalHead;
        for (ULine updateCutvalLine : this.updateCutvalLines) {
            double cutval = FeasibleTree.calcCutValByAdjTreeLine(this.feasibleTree.graph(), current, updateCutvalLine, tree::containEdge);
            updateCutvalLine.getdLine().setCutVal(cutval);
            current = updateCutvalLine.other(current);
            if (!(cutval < 0.0)) continue;
            this.negativeLine.offer(updateCutvalLine);
        }
    }

    private boolean notInLimLowRange(DNode source, DNode target) {
        return source.getLow() > target.getLim() || source.getLim() < target.getLim();
    }

    private void addUpdateCutvalLines(ULine uLine) {
        if (this.updateCutvalLines == null) {
            this.updateCutvalLines = new ArrayList();
        }
        this.updateCutvalLines.add(uLine);
    }

    private ULine negativeTreeLine() {
        ULine negative;
        if (CollectionUtils.isEmpty(this.negativeLine)) {
            return null;
        }
        do {
            if (!CollectionUtils.isEmpty(this.negativeLine)) continue;
            return null;
        } while ((negative = this.negativeLine.poll()) != null && negative.getdLine().getCutVal() >= 0.0);
        return negative;
    }

    private boolean isInEdge(DNode node, ULine uLine) {
        return uLine.getdLine().to() == node;
    }

    private void alignUnconnectGraph(Map<Integer, DNode> connectLowRank) {
        if (connectLowRank == null) {
            return;
        }
        DNode basic = null;
        for (DNode source : connectLowRank.values()) {
            if (source.getRank() != this.rankContent.minRank()) continue;
            basic = source;
        }
        HashSet<DNode> mark = new HashSet<DNode>();
        for (DNode source : connectLowRank.values()) {
            if (basic == null || basic.getRank() == source.getRank()) {
                basic = source;
                continue;
            }
            int rankOffset = source.getRank() - basic.getRank();
            this.dfs(mark, source, rankOffset);
        }
    }

    private void dfs(Set<DNode> mark, DNode node, int rankOffset) {
        mark.add(node);
        RankContent.RankNode sourceRankNode = this.rankContent.get(node.getRank());
        RankContent.RankNode targetRankNode = this.rankContent.get(node.getRank() - rankOffset);
        if (sourceRankNode == targetRankNode) {
            return;
        }
        this.updateRank(node, sourceRankNode, targetRankNode);
        for (ULine uLine : this.feasibleTree.tree().adjacent(node)) {
            DNode other = uLine.other(node);
            if (mark.contains(other)) continue;
            this.dfs(mark, other, rankOffset);
        }
    }

    private void clear() {
        this.updateCutvalLines = null;
        this.negativeLine = null;
        this.feasibleTree = null;
    }

    private static class LowLimCalc
    extends Mark<DNode> {
        private int reserveCount;
        private int low = Integer.MAX_VALUE;
        private final DNode root;

        private LowLimCalc(DotGraph tree, DNode node) {
            super(tree.vertexNum());
            this.root = node;
            this.reserveCount = node.getLow() - 1;
            this.dfs(tree, node);
        }

        private void dfs(DotGraph tree, DNode v) {
            this.mark(v);
            int tmpLow = Integer.MAX_VALUE;
            for (ULine e : tree.adjacent(v)) {
                DNode w = e.other(v);
                if (this.isMark(w) || !this.isRightNode(w)) continue;
                this.dfs(tree, w);
                tmpLow = Math.min(tmpLow, this.low);
                this.low = Integer.MAX_VALUE;
            }
            int lim = ++this.reserveCount;
            this.low = Math.min(tmpLow, lim);
            v.setLow(this.low);
            v.setLim(lim);
        }

        private boolean isRightNode(DNode node) {
            return node != this.root && node.getLim() >= this.root.getLow() && node.getLim() < this.root.getLim();
        }
    }
}

