/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graphper.api.LineAttrs;
import org.graphper.api.attributes.Port;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.layout.Cell;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.PortHelper;
import org.graphper.util.Asserts;
import org.graphper.util.ValueUtils;

public class NodeSizeExpander {
    protected DNode node;
    protected double leftWidthOffset;
    protected double rightWidthOffset;
    protected double topHeightOffset;
    protected double bottomHeightOffset;

    public double getLeftWidthOffset() {
        return this.leftWidthOffset;
    }

    public double getRightWidthOffset() {
        return this.rightWidthOffset;
    }

    public double getTopHeightOffset() {
        return this.topHeightOffset;
    }

    public double getBottomHeightOffset() {
        return this.bottomHeightOffset;
    }

    public static double minSelfInterval(DNode node) {
        if (node == null) {
            return 0.0;
        }
        return NodeSizeExpander.minSelfInterval(node.getSelfLoopCount(), node.getNodeSep());
    }

    public static double minSelfInterval(int lineNum, double nodeSep) {
        if (lineNum <= 1) {
            return nodeSep;
        }
        return (nodeSep + nodeSep / (double)lineNum) / (double)lineNum;
    }

    protected void addPoint(LineDrawProp lineDrawProp, FlatPoint point) {
        lineDrawProp.addAndNotRefreshDrawGraph(point);
        this.refreshVolume(point);
    }

    protected void refreshVolume(FlatPoint point) {
        this.refreshVolume(point.getX(), point.getY());
    }

    protected void refreshVolume(double x, double y) {
        if (x < this.node.getLeftBorder()) {
            this.leftWidthOffset = Math.max(this.leftWidthOffset, this.node.getLeftBorder() - x);
        }
        if (x > this.node.getRightBorder()) {
            this.rightWidthOffset = Math.max(this.rightWidthOffset, x - this.node.getRightBorder());
        }
        if (y < this.node.getUpBorder()) {
            this.topHeightOffset = Math.max(this.topHeightOffset, this.node.getUpBorder() - y);
        }
        if (y > this.node.getDownBorder()) {
            this.bottomHeightOffset = Math.max(this.bottomHeightOffset, y - this.node.getDownBorder());
        }
    }

    protected Map<GroupKey, List<GroupEntry>> groupSelfLine(DrawGraph drawGraph, DNode node) {
        NodeDrawProp nodeDrawProp = drawGraph.getNodeDrawProp(node.getNode());
        Asserts.illegalArgument(nodeDrawProp == null, "Not found the node draw properties!");
        LinkedHashMap<GroupKey, List<GroupEntry>> selfLineGroup = new LinkedHashMap<GroupKey, List<GroupEntry>>(1);
        for (int i = 0; i < node.getSelfLoopCount(); ++i) {
            DLine selfLine = node.selfLine(i);
            LineDrawProp line = drawGraph.getLineDrawProp(selfLine.getLine());
            if (line == null) continue;
            LineAttrs lineAttrs = line.lineAttrs();
            GroupKey key = this.newGroupKey(lineAttrs.getTailPort(), lineAttrs.getHeadPort(), nodeDrawProp, drawGraph, lineAttrs.getTailCell(), lineAttrs.getHeadCell());
            NodeSizeExpander.addLineToGroup(selfLineGroup, selfLine, key);
        }
        return selfLineGroup;
    }

    private GroupKey newGroupKey(Port tailPort, Port headPort, NodeDrawProp nodeDrawProp, DrawGraph drawGraph, String tailCell, String headCell) {
        if (tailPort == null && headPort == null && tailCell == null && headCell == null) {
            GroupKey groupKey = new GroupKey();
            groupKey.tailPoint = new FlatPoint(this.node.getX(), this.node.getY());
            groupKey.headPoint = groupKey.tailPoint.clone();
            return groupKey;
        }
        GroupKey groupKey = new GroupKey();
        groupKey.tailPort = tailPort;
        groupKey.headPort = headPort;
        groupKey.tailCell = this.getCell(nodeDrawProp, tailCell);
        groupKey.headCell = this.getCell(nodeDrawProp, headCell);
        groupKey.tailPoint = PortHelper.getPortPoint(this.node, tailCell, tailPort, drawGraph);
        groupKey.headPoint = groupKey.samePoint() ? groupKey.tailPoint : PortHelper.getPortPoint(this.node, headCell, headPort, drawGraph);
        return groupKey;
    }

    private static void addLineToGroup(Map<GroupKey, List<GroupEntry>> selfLineGroup, DLine selfLine, GroupKey groupKey) {
        selfLineGroup.compute(groupKey, (g, v) -> {
            if (v == null) {
                v = new ArrayList<GroupEntry>(1);
            }
            v.add(new GroupEntry(groupKey, selfLine));
            return v;
        });
    }

    private Cell getCell(NodeDrawProp nodeDrawProp, String cellId) {
        Cell.RootCell rootCell = nodeDrawProp.getCell();
        if (rootCell == null) {
            return null;
        }
        return rootCell.getCellById(cellId);
    }

    protected static class GroupKey {
        protected Port tailPort;
        protected Port headPort;
        protected Cell tailCell;
        protected Cell headCell;
        protected FlatPoint tailPoint;
        protected FlatPoint headPoint;

        protected GroupKey() {
        }

        public Port getTailPort() {
            return this.tailPort;
        }

        public Port getHeadPort() {
            return this.headPort;
        }

        public Cell getTailCell() {
            return this.tailCell;
        }

        public Cell getHeadCell() {
            return this.headCell;
        }

        public boolean samePoint() {
            return this.tailCell == this.headCell && this.tailPort == this.headPort;
        }

        public FlatPoint getTailPoint() {
            Asserts.illegalArgument(this.tailPoint == null, "GroupKey Not Ready");
            return this.tailPoint.clone();
        }

        public FlatPoint getHeadPoint() {
            Asserts.illegalArgument(this.headPoint == null, "GroupKey Not Ready");
            return this.headPoint.clone();
        }

        public boolean isOnlySameHor() {
            if (this.samePoint() || this.tailCell != this.headCell) {
                return false;
            }
            if (Objects.equals(this.tailPoint, this.headPoint) || this.tailPoint == null || this.headPoint == null) {
                return false;
            }
            return ValueUtils.approximate(this.tailPoint.getY(), this.headPoint.getY(), 0.1) && !ValueUtils.approximate(this.tailPoint.getX(), this.headPoint.getX(), 0.1);
        }

        public boolean isOnlySameVer() {
            if (this.samePoint() || this.tailCell != this.headCell) {
                return false;
            }
            if (Objects.equals(this.tailPoint, this.headPoint) || this.tailPoint == null || this.headPoint == null) {
                return false;
            }
            return ValueUtils.approximate(this.tailPoint.getX(), this.headPoint.getX(), 0.1) && !ValueUtils.approximate(this.tailPoint.getY(), this.headPoint.getY(), 0.1);
        }

        public boolean sameCell() {
            return this.tailCell == this.headCell;
        }

        public boolean notSameCell() {
            return !this.sameCell();
        }

        public boolean havePortOrCell() {
            return this.tailPort != null || this.headPort != null || this.tailCell != null || this.headCell != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupKey groupKey = (GroupKey)o;
            return this.tailPort == groupKey.tailPort && this.headPort == groupKey.headPort && Objects.equals(this.tailCell, groupKey.tailCell) && Objects.equals(this.headCell, groupKey.headCell) || this.tailPort == groupKey.headPort && this.headPort == groupKey.tailPort && Objects.equals(this.tailCell, groupKey.headCell) && Objects.equals(this.headCell, groupKey.tailCell);
        }

        public int hashCode() {
            return Objects.hash(this.tailPort, this.headPort, this.tailCell, this.headCell) + Objects.hash(this.headPort, this.tailPort, this.headCell, this.tailCell);
        }
    }

    protected static class GroupEntry {
        protected final GroupKey groupKey;
        protected final DLine line;

        public GroupEntry(GroupKey groupKey, DLine line) {
            Asserts.nullArgument(groupKey, "groupKey");
            Asserts.nullArgument(line, "line");
            this.groupKey = groupKey;
            this.line = line;
        }

        public DLine getLine() {
            return this.line;
        }
    }
}

