/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.List;
import java.util.Map;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.NodeSizeExpander;
import org.graphper.util.Asserts;

public class OrthoNodeSizeExpander
extends NodeSizeExpander {
    public OrthoNodeSizeExpander(DNode node) {
        Asserts.nullArgument(node, "Self line node");
        Asserts.illegalArgument(!node.haveSelfLine(), "Node not have any self line");
        this.node = node;
        this.init(node);
    }

    private void init(DNode node) {
        node.sortSelfLine(this::lineComparator);
        OffsetConsumer consumer = (lineNo, line, topOffset, bottomOffset, rightOffset) -> {
            this.topHeightOffset = topOffset;
            this.bottomHeightOffset = bottomOffset;
            this.rightWidthOffset = rightOffset;
        };
        OrthoNodeSizeExpander.linePos(node, consumer);
    }

    public static void linePos(DNode node, OffsetConsumer consumer) {
        Asserts.nullArgument(node, "node");
        Asserts.nullArgument(consumer, "consumer");
        Asserts.illegalArgument(node.getSelfLoopCount() < 1, "node do not have any self line");
        double interval = OrthoNodeSizeExpander.minSelfInterval(node) / 2.0;
        double topHeight = node.realTopHeight();
        double bottomHeight = node.realBottomHeight();
        double topHeightOffset = 0.0;
        double bottomHeightOffset = 0.0;
        double rightWidthOffset = 0.0;
        for (int i = 0; i < node.getSelfLoopCount(); ++i) {
            DLine line = node.selfLine(i);
            FlatPoint labelSize = line.getLabelSize();
            double height = 0.0;
            double width = 0.0;
            if (labelSize != null) {
                height = labelSize.getHeight();
                width = labelSize.getWidth();
            }
            topHeightOffset = Math.max(topHeight + topHeightOffset + interval, height / 2.0) - topHeight;
            bottomHeightOffset = Math.max(bottomHeight + bottomHeightOffset + interval, height / 2.0) - bottomHeight;
            consumer.consumeSelfLine(i, line, topHeightOffset, bottomHeightOffset, rightWidthOffset += Math.max(width, interval));
        }
    }

    public void drawSelfLine(DrawGraph drawGraph) {
        Map<NodeSizeExpander.GroupKey, List<NodeSizeExpander.GroupEntry>> groupKeyListMap = this.groupSelfLine(drawGraph, this.node);
        double interval = OrthoNodeSizeExpander.minSelfInterval(this.node) / 2.0;
        double topHeight = this.node.realTopHeight();
        double bottomHeight = this.node.realBottomHeight();
        double topHeightOffset = 0.0;
        double bottomHeightOffset = 0.0;
        double rightWidthOffset = 0.0;
        for (Map.Entry<NodeSizeExpander.GroupKey, List<NodeSizeExpander.GroupEntry>> entry : groupKeyListMap.entrySet()) {
            NodeSizeExpander.GroupKey key = entry.getKey();
            FlatPoint tailPoint = key.getTailPoint();
            FlatPoint headPoint = key.getHeadPoint();
            List<NodeSizeExpander.GroupEntry> groupLines = entry.getValue();
            double nodeInternalInterval = this.node.getWidth() / (double)(groupLines.size() + 1);
            for (int lineNo = 0; lineNo < groupLines.size(); ++lineNo) {
                NodeSizeExpander.GroupEntry groupEntry = groupLines.get(lineNo);
                DLine line = groupEntry.getLine();
                LineDrawProp lineDrawProp = drawGraph.getLineDrawProp(line.getLine());
                if (lineDrawProp == null || lineDrawProp.isInit()) continue;
                lineDrawProp.clear();
                FlatPoint labelSize = line.getLabelSize();
                double height = 0.0;
                double width = 0.0;
                if (labelSize != null) {
                    height = labelSize.getHeight();
                    width = labelSize.getWidth();
                }
                topHeightOffset = Math.max(topHeight + topHeightOffset + interval, height / 2.0) - topHeight;
                bottomHeightOffset = Math.max(bottomHeight + bottomHeightOffset + interval, height / 2.0) - bottomHeight;
                double right = this.node.getRightBorder() + (rightWidthOffset += Math.max(width, interval));
                double top = this.node.getUpBorder() - topHeightOffset;
                double bottom = this.node.getDownBorder() + bottomHeightOffset;
                if (key.havePortOrCell()) {
                    lineDrawProp.add(new FlatPoint(tailPoint.getX(), tailPoint.getY()));
                    lineDrawProp.add(new FlatPoint(tailPoint.getX(), top));
                    lineDrawProp.add(new FlatPoint(right, top));
                    lineDrawProp.add(new FlatPoint(right, bottom));
                    lineDrawProp.add(new FlatPoint(headPoint.getX(), bottom));
                    lineDrawProp.add(new FlatPoint(headPoint.getX(), headPoint.getY()));
                } else {
                    double left = this.node.getRightBorder() - nodeInternalInterval * (double)(lineNo + 1);
                    FlatPoint center = new FlatPoint(left, this.node.getY());
                    lineDrawProp.add(center);
                    lineDrawProp.add(new FlatPoint(left, top));
                    lineDrawProp.add(new FlatPoint(right, top));
                    lineDrawProp.add(new FlatPoint(right, bottom));
                    lineDrawProp.add(new FlatPoint(left, bottom));
                    lineDrawProp.add(center);
                }
                if (labelSize == null) continue;
                lineDrawProp.setLabelCenter(new FlatPoint(right - labelSize.getWidth() / 2.0, this.node.getY()));
            }
        }
    }

    private int lineComparator(DLine left, DLine right) {
        FlatPoint ls = left.getLabelSize();
        FlatPoint rs = right.getLabelSize();
        if (ls == null && rs == null) {
            return 0;
        }
        if (ls == null) {
            return -1;
        }
        if (rs == null) {
            return 1;
        }
        return Double.compare(ls.getHeight(), rs.getHeight());
    }

    public static interface OffsetConsumer {
        public void consumeSelfLine(int var1, DLine var2, double var3, double var5, double var7);
    }
}

