/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.graphper.api.Line;
import org.graphper.api.attributes.Port;
import org.graphper.api.attributes.Splines;
import org.graphper.api.ext.Box;
import org.graphper.def.DedirectedGraph;
import org.graphper.def.FlatPoint;
import org.graphper.def.VertexIndex;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.FlipShifterStrategy;
import org.graphper.layout.Mark;
import org.graphper.layout.OrthoVisGraph;
import org.graphper.layout.dot.AbstractDotLineRouter;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotMaze;
import org.graphper.layout.dot.Maze;
import org.graphper.layout.dot.NodeSizeExpander;
import org.graphper.layout.dot.OrthoNodeSizeExpander;
import org.graphper.layout.dot.PortHelper;
import org.graphper.layout.dot.RankContent;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.graphper.util.ValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OrthogonalRouter
extends AbstractDotLineRouter {
    private static final Logger log = LoggerFactory.getLogger(OrthogonalRouter.class);
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;
    private static final int[][] BEND_NUM_TABLE = new int[][]{{2, 1, 2, 1}, {1, 1, 2, 0}, {1, 2, 2, 1}, {2, 0, 1, 1}, {0, 0, 0, 0}, {0, 2, 1, 1}, {2, 1, 1, 2}, {1, 1, 0, 2}, {1, 2, 1, 2}};
    private static final int[][] TARGET_SIDE_TABLE = new int[][]{{0, 2, 2, 0}, {2, 2, 2, 2}, {2, 1, 2, 1}, {0, 0, 0, 0}, {0, 1, 2, 3}, {1, 1, 1, 1}, {0, 3, 0, 3}, {3, 3, 3, 3}, {3, 1, 1, 3}};
    private DotMaze maze;
    private PathContent pathContent;

    OrthogonalRouter() {
    }

    @Override
    public boolean needDeal(Splines splines) {
        return splines == Splines.ORTHO && super.needDeal(splines);
    }

    @Override
    public void route() {
        this.pathContent = new PathContent();
        this.maze = new DotMaze(this.rankContent, this.drawGraph);
        this.generateEdge();
    }

    @Override
    protected void selfLoopHandle(DNode node) {
        if (node == null || node.getSelfLoopCount() < 1) {
            return;
        }
        NodeSizeExpander nodeSizeExpander = node.getNodeSizeExpander();
        Asserts.illegalArgument(!(nodeSizeExpander instanceof OrthoNodeSizeExpander), "error type");
        OrthoNodeSizeExpander sizeExpander = (OrthoNodeSizeExpander)nodeSizeExpander;
        sizeExpander.drawSelfLine(this.drawGraph);
    }

    private void generateEdge() {
        EdgeSegRecord edgeSegRecord = new EdgeSegRecord();
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (DNode node : rankNode) {
                if (node.isVirtual()) continue;
                for (DLine line : this.digraphProxy.outAdjacent(node)) {
                    if (line.isVirtual()) continue;
                    for (int j = 0; j < line.getParallelNums(); ++j) {
                        this.ovgRouter(edgeSegRecord, line.parallelLine(j));
                    }
                }
                this.selfLoopHandle(node);
            }
        }
        this.splitOverlapSegment(edgeSegRecord);
        this.edgeSegToLine(edgeSegRecord);
    }

    private void ovgRouter(EdgeSegRecord edgeSegRecord, DLine line) {
        if (line.isHide()) {
            return;
        }
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(line.getLine());
        if (lineDrawProp == null || lineDrawProp.isInit()) {
            return;
        }
        List<DotMaze.GuideInfo> guideInfos = this.maze.getGuideInfos(line.getLine());
        if (CollectionUtils.isEmpty(guideInfos)) {
            this.ovgRouter(edgeSegRecord, lineDrawProp, x$0 -> new Target(x$0));
            return;
        }
        this.ovgRouter(edgeSegRecord, lineDrawProp, end -> new Target(end, guideInfos));
        for (int i = 0; i < guideInfos.size(); ++i) {
            DotMaze.GuideInfo guideInfo = guideInfos.get(i);
            if (!guideInfo.isLabelSign()) continue;
            Box signPos = guideInfo.getSignPos();
            lineDrawProp.setLabelCenter(new FlatPoint(signPos.getX(), signPos.getY()));
        }
    }

    private void ovgRouter(EdgeSegRecord edgeSegRecord, LineDrawProp lineDrawProp, TargetConstructor targetConstructor) {
        DNode tail = this.dotDigraph.getDNode(lineDrawProp.getLine().tail());
        DNode head = this.dotDigraph.getDNode(lineDrawProp.getLine().head());
        if (tail == null || head == null) {
            return;
        }
        DNode from = tail.getRank() < head.getRank() ? tail : head;
        DNode to = from == tail ? head : tail;
        Maze.Cell fromCell = this.maze.getCell(from);
        Maze.Cell toCell = this.maze.getCell(to);
        if (fromCell == null || toCell == null) {
            if (log.isWarnEnabled()) {
                log.warn("From Cell = {} or To Cell = {} is null", (Object)fromCell, (Object)toCell);
            }
            return;
        }
        Target target = targetConstructor.newTarget(toCell);
        Asserts.nullArgument(target, "target");
        PortHelper.PortPoint fromPoint = PortHelper.getPortPoint(lineDrawProp.getLine(), from, this.drawGraph);
        PortHelper.PortPoint toPoint = PortHelper.getPortPoint(lineDrawProp.getLine(), to, this.drawGraph);
        EdgeDraw edgeDraw = this.ovgRouter(fromCell, target, fromPoint, toPoint, edgeSegRecord);
        this.pathContent.clear();
        if (edgeDraw == null) {
            return;
        }
        lineDrawProp.fakeInit();
        edgeDraw.from = from;
        edgeDraw.to = to;
        edgeSegRecord.addLineEdgeSeg(lineDrawProp.getLine(), edgeDraw);
    }

    private void splitOverlapSegment(EdgeSegRecord edgeSegRecord) {
        ChannelSegRank channelSegRank = new ChannelSegRank();
        DedirectedGraph<EdgeSeg> digraph = new DedirectedGraph<EdgeSeg>();
        for (Channel channel : edgeSegRecord.channels()) {
            if (channel.segmentSize() <= 1) continue;
            this.initDigraph(channel, digraph);
            this.splitEdgeSegs(digraph, channelSegRank, channel);
            digraph.clear();
        }
    }

    private void splitEdgeSegs(DedirectedGraph<EdgeSeg> digraph, ChannelSegRank channelSegRank, Channel channel) {
        Iterable groups = channelSegRank.group(digraph);
        for (Map group : groups) {
            int idx = 0;
            double moveUnit = channel.range() / (double)(group.size() + 1);
            for (Map.Entry rank : group.entrySet()) {
                if (CollectionUtils.isEmpty((Collection)rank.getValue())) {
                    ++idx;
                    continue;
                }
                ++idx;
                for (EdgeSeg edgeSeg : (List)rank.getValue()) {
                    if (edgeSeg.canNotMove) continue;
                    double offset = moveUnit * (double)idx - edgeSeg.axis + channel.min;
                    edgeSeg.moveAxis(offset);
                }
            }
        }
    }

    private void initDigraph(Channel channel, DedirectedGraph<EdgeSeg> digraph) {
        channel.sortEdgeSegs();
        for (int i = 0; i < channel.segmentSize(); ++i) {
            EdgeSeg overlapSeg;
            EdgeSeg edgeSeg = channel.get(i);
            for (int j = i + 1; j < channel.segmentSize() && (overlapSeg = channel.get(j)).isHor == edgeSeg.isHor && edgeSeg.overlap(overlapSeg); ++j) {
                if (this.overlapCmp(edgeSeg, overlapSeg) < 0) {
                    digraph.addEdge(edgeSeg, overlapSeg);
                    continue;
                }
                digraph.addEdge(overlapSeg, edgeSeg);
            }
        }
    }

    private int overlapCmp(EdgeSeg source, EdgeSeg target) {
        if (source.isHor != target.isHor || !source.overlap(target)) {
            return 0;
        }
        return this.crossNum(source, target, true) < this.crossNum(source, target, false) ? -1 : 1;
    }

    private int crossNum(EdgeSeg source, EdgeSeg target, boolean origin) {
        EdgeSeg sourceStartPre = source.startPre();
        EdgeSeg sourceEndNext = source.endNext();
        EdgeSeg targetStartPre = target.startPre();
        EdgeSeg targetEndNext = target.endNext();
        int crossNum = 0;
        if (this.isCross(sourceStartPre, target, !origin)) {
            ++crossNum;
        }
        if (this.isCross(sourceEndNext, target, !origin)) {
            ++crossNum;
        }
        if (this.isCross(targetStartPre, source, origin)) {
            ++crossNum;
        }
        if (this.isCross(targetEndNext, source, origin)) {
            ++crossNum;
        }
        return crossNum;
    }

    private boolean isCross(EdgeSeg seg1, EdgeSeg seg2, boolean isAdd) {
        if (seg1 == null || seg2 == null) {
            return false;
        }
        double start = seg1.getStart();
        double end = seg1.getEnd();
        if (isAdd) {
            start += 1.0;
            end += 1.0;
        } else {
            start -= 1.0;
            end -= 1.0;
        }
        return seg2.axis >= start && seg2.axis <= end && seg2.inRange(seg1.axis);
    }

    private void edgeSegToLine(EdgeSegRecord edgeSegRecord) {
        for (Map.Entry entry : edgeSegRecord.lineEdgeSegs.entrySet()) {
            LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp((Line)entry.getKey());
            EdgeSeg edgeSeg = ((EdgeDraw)entry.getValue()).edgeSeg;
            lineDrawProp.setIsHeadStart(((EdgeDraw)entry.getValue()).from.getNode());
            while (edgeSeg != null) {
                this.addPoint(lineDrawProp, edgeSeg);
                edgeSeg = edgeSeg.next;
            }
        }
    }

    private void addPoint(LineDrawProp lineDrawProp, EdgeSeg edgeSeg) {
        if (edgeSeg.isHor) {
            if (edgeSeg.pos) {
                lineDrawProp.add(new FlatPoint(edgeSeg.getStart(), edgeSeg.axis));
                lineDrawProp.add(new FlatPoint(edgeSeg.getEnd(), edgeSeg.axis));
            } else {
                lineDrawProp.add(new FlatPoint(edgeSeg.getEnd(), edgeSeg.axis));
                lineDrawProp.add(new FlatPoint(edgeSeg.getStart(), edgeSeg.axis));
            }
        } else if (edgeSeg.pos) {
            lineDrawProp.add(new FlatPoint(edgeSeg.axis, edgeSeg.getStart()));
            lineDrawProp.add(new FlatPoint(edgeSeg.axis, edgeSeg.getEnd()));
        } else {
            lineDrawProp.add(new FlatPoint(edgeSeg.axis, edgeSeg.getEnd()));
            lineDrawProp.add(new FlatPoint(edgeSeg.axis, edgeSeg.getStart()));
        }
    }

    private EdgeDraw ovgRouter(Maze.Cell from, Target target, PortHelper.PortPoint fromCenter, PortHelper.PortPoint toCenter, EdgeSegRecord edgeSegRecord) {
        this.addStartVertexesToQueue(from, target, fromCenter);
        while (this.pathContent.isNotEmpty()) {
            VertexDir vertexDir = this.pathContent.poll();
            if (vertexDir == null) continue;
            if (this.arriveAtDestination(target, vertexDir, toCenter)) {
                return this.terminateRouter(edgeSegRecord, from, target.end, fromCenter, toCenter, vertexDir);
            }
            OrthoVisGraph.GridVertex right = vertexDir.vertex.getRight();
            OrthoVisGraph.GridVertex top = vertexDir.vertex.getTop();
            OrthoVisGraph.GridVertex left = vertexDir.vertex.getLeft();
            OrthoVisGraph.GridVertex bottom = vertexDir.vertex.getBottom();
            this.successor(0, left, vertexDir);
            this.successor(1, right, vertexDir);
            this.successor(2, top, vertexDir);
            this.successor(3, bottom, vertexDir);
        }
        if (log.isWarnEnabled()) {
            log.warn("Fail route Cell = {} to Cell = {}", (Object)from, (Object)target.end);
        }
        return null;
    }

    private void addStartVertexesToQueue(Maze.Cell from, Target target, PortHelper.PortPoint fromPoint) {
        Integer horDir = this.horDir(fromPoint, from);
        Integer verDir = this.verDir(fromPoint, from);
        for (OrthoVisGraph.GridVertex vertex : from.getAxisVertexes()) {
            if (!vertex.in(fromPoint.getX(), fromPoint.getY())) continue;
            this.addStartVertexesToQueue(horDir, verDir, from, target, vertex);
        }
    }

    private boolean notNodeCenter(Integer horDir, Integer verDir) {
        return horDir != null || verDir != null;
    }

    private void addStartVertexesToQueue(Integer horDir, Integer verDir, Maze.Cell from, Target target, OrthoVisGraph.GridVertex vertex) {
        int dir = this.getCellInternalNodeDir(vertex);
        if (this.notNodeCenter(horDir, verDir) && this.isNotExpectDir(horDir, dir) && this.isNotExpectDir(verDir, dir)) {
            return;
        }
        VertexDir v = new VertexDir(dir, null, vertex, target);
        v.centering = FlatPoint.twoPointDistance(vertex.getX(), vertex.getY(), from.getX(), from.getY());
        this.pathContent.offer(v);
    }

    private boolean arriveAtDestination(Target target, VertexDir vertexDir, PortHelper.PortPoint endPoint) {
        Integer verDir;
        Integer horDir = this.horDir(endPoint, target.end);
        if (this.notNodeCenter(horDir, verDir = this.verDir(endPoint, target.end)) && this.isNotContrary(horDir, vertexDir.dir) && this.isNotContrary(verDir, vertexDir.dir)) {
            return false;
        }
        OrthoVisGraph.GridVertex vertex = vertexDir.vertex;
        return target.end.in(vertex.getX(), vertex.getY()) && vertex.isNodeInternal() && vertex.in(endPoint.getX(), endPoint.getY());
    }

    private EdgeDraw terminateRouter(EdgeSegRecord edgeSegRecord, Maze.Cell from, Maze.Cell to, PortHelper.PortPoint fromCenter, PortHelper.PortPoint toCenter, VertexDir end) {
        VertexDir current = end;
        EdgeSeg edgeSeg = null;
        EdgeSeg lastSeg = null;
        OrthoVisGraph.GridVertex breakOffVertex = null;
        do {
            if (edgeSeg != null) {
                edgeSeg.addVertex(current);
            }
            if (!current.vertex.isNodeInternal()) {
                if (breakOffVertex == null) {
                    breakOffVertex = current.vertex;
                } else if (current.isHor()) {
                    if (breakOffVertex.getWidth() < current.vertex.getWidth()) {
                        breakOffVertex = current.vertex;
                    }
                } else if (breakOffVertex.getHeight() < current.vertex.getHeight()) {
                    breakOffVertex = current.vertex;
                }
            }
            if (edgeSeg != null && !current.isOrthogonal(edgeSeg.isHor)) {
                current = current.parent;
                continue;
            }
            EdgeSeg newEdgeSeg = new EdgeSeg(current.isHor() ? current.vertex.getY() : current.vertex.getX(), edgeSeg != null ? !edgeSeg.isHor : current.isHor(), current.dir == 1 || current.dir == 3);
            if (lastSeg == null) {
                lastSeg = newEdgeSeg;
            }
            if (edgeSeg != null) {
                edgeSeg.pre = newEdgeSeg;
            }
            newEdgeSeg.next = edgeSeg;
            edgeSeg = newEdgeSeg;
            edgeSeg.addVertex(current);
            this.setEdgeRecord(edgeSegRecord, current.vertex, edgeSeg);
            current = current.parent;
        } while (current != null);
        OrthogonalRouter.adjustPortSeg(fromCenter, edgeSeg, from);
        if (edgeSeg == lastSeg && toCenter.getPort() != null && breakOffVertex != null) {
            EdgeDraw edgeDraw = this.splitWhenTailHeadAxisDiff(edgeSegRecord, to, toCenter, end, edgeSeg, breakOffVertex);
            if (edgeDraw != null) {
                return edgeDraw;
            }
        } else {
            OrthogonalRouter.adjustPortSeg(toCenter, lastSeg, to);
        }
        return new EdgeDraw(edgeSeg);
    }

    private EdgeDraw splitWhenTailHeadAxisDiff(EdgeSegRecord edgeSegRecord, Maze.Cell to, PortHelper.PortPoint toCenter, VertexDir end, EdgeSeg edgeSeg, OrthoVisGraph.GridVertex breakOffVertex) {
        double breakAxis = edgeSeg.isHor ? breakOffVertex.getX() : breakOffVertex.getY();
        EdgeSeg lastSeg = new EdgeSeg(edgeSeg.axis, edgeSeg.isHor, edgeSeg.pos);
        if (breakAxis > edgeSeg.start == edgeSeg.pos) {
            lastSeg.addPoint(breakAxis);
            lastSeg.addPoint(edgeSeg.end);
        } else {
            lastSeg.addPoint(edgeSeg.start);
            lastSeg.addPoint(breakAxis);
        }
        OrthogonalRouter.adjustPortSeg(toCenter, lastSeg, to);
        if (ValueUtils.approximate(edgeSeg.axis, lastSeg.axis, 5.0)) {
            OrthogonalRouter.adjustPortSeg(toCenter, edgeSeg, to);
            return new EdgeDraw(edgeSeg);
        }
        if (breakAxis > edgeSeg.start && edgeSeg.pos) {
            edgeSeg.moveEndpoint(edgeSeg.end, breakAxis);
        } else {
            edgeSeg.moveEndpoint(edgeSeg.start, breakAxis);
        }
        EdgeSeg second = new EdgeSeg(breakAxis, !edgeSeg.isHor, lastSeg.axis > edgeSeg.axis);
        second.addPoint(edgeSeg.axis);
        second.addPoint(lastSeg.axis);
        second.pre = edgeSeg;
        edgeSeg.next = second;
        lastSeg.pre = second;
        second.next = lastSeg;
        this.setEdgeRecord(edgeSegRecord, breakOffVertex, second);
        this.setEdgeRecord(edgeSegRecord, end.vertex, lastSeg);
        return null;
    }

    private static void adjustPortSeg(PortHelper.PortPoint portPoint, EdgeSeg edgeSeg, Maze.Cell targetCell) {
        boolean moveStart;
        double move;
        edgeSeg.canNotMove = portPoint.getPort() != null;
        if (!portPoint.notNodeCenter()) {
            return;
        }
        if (edgeSeg.isHor) {
            move = portPoint.getX();
            edgeSeg.moveAxis(portPoint.getY() - edgeSeg.axis);
        } else {
            move = portPoint.getY();
            edgeSeg.moveAxis(portPoint.getX() - edgeSeg.axis);
        }
        if (edgeSeg.isHor) {
            moveStart = Math.abs(edgeSeg.start - targetCell.getX()) < Math.abs(edgeSeg.end - targetCell.getX());
        } else {
            boolean bl = moveStart = Math.abs(edgeSeg.start - targetCell.getY()) < Math.abs(edgeSeg.end - targetCell.getY());
        }
        if (moveStart) {
            edgeSeg.start = move;
        } else {
            edgeSeg.end = move;
        }
    }

    private void setEdgeRecord(EdgeSegRecord edgeSegRecord, OrthoVisGraph.GridVertex vertex, EdgeSeg edgeSeg) {
        double max;
        double min;
        if (edgeSeg == null) {
            return;
        }
        if (edgeSeg.isHor) {
            min = vertex.getLeftUp().getY();
            max = vertex.getRightDown().getY();
        } else {
            min = vertex.getLeftUp().getX();
            max = vertex.getRightDown().getX();
        }
        edgeSegRecord.addSeg(min, max, edgeSeg);
    }

    private void successor(int dir, OrthoVisGraph.GridVertex vertex, VertexDir parentDir) {
        if (vertex == null || OrthogonalRouter.isContrary(dir, parentDir.dir)) {
            return;
        }
        AdjPair adjPair = this.pathContent.getOrNullCreateAdjPair(vertex);
        VertexDir vertexDir = adjPair.get(dir);
        if (vertexDir == null) {
            vertexDir = new VertexDir(dir, parentDir, vertex, parentDir.target);
            this.pathContent.offer(vertexDir);
            return;
        }
        if (vertexDir.compareCost(parentDir) <= 0) {
            return;
        }
        vertexDir.setParent(parentDir);
        this.pathContent.offer(vertexDir);
    }

    private boolean isNotContrary(Integer srcDir, int dir) {
        if (srcDir == null) {
            return true;
        }
        return !OrthogonalRouter.isContrary(srcDir, dir);
    }

    private boolean isNotExpectDir(Integer expectDir1, int dir) {
        return Objects.isNull(expectDir1) || !Objects.equals(dir, expectDir1);
    }

    private Integer horDir(PortHelper.PortPoint portPoint, Maze.Cell nodeCell) {
        if (portPoint.getPort() == null) {
            double xv = portPoint.getX() - nodeCell.getX();
            if (xv < -0.01) {
                return 0;
            }
            if (xv > 0.01) {
                return 1;
            }
            return null;
        }
        Port port = FlipShifterStrategy.movePort(this.drawGraph, portPoint.getPort());
        if (port.horOffsetRatio() < 0.0) {
            return 0;
        }
        if (port.horOffsetRatio() > 0.0) {
            return 1;
        }
        return null;
    }

    private Integer verDir(PortHelper.PortPoint portPoint, Maze.Cell nodeCell) {
        if (portPoint.getPort() == null) {
            double yv = portPoint.getY() - nodeCell.getY();
            if (yv < -0.01) {
                return 2;
            }
            if (yv > 0.01) {
                return 3;
            }
            return null;
        }
        Port port = FlipShifterStrategy.movePort(this.drawGraph, portPoint.getPort());
        if (port.verOffsetRatio() < 0.0) {
            return 2;
        }
        if (port.verOffsetRatio() > 0.0) {
            return 3;
        }
        return null;
    }

    private int getCellInternalNodeDir(OrthoVisGraph.GridVertex vertex) {
        if (vertex.getLeft() != null) {
            return 0;
        }
        if (vertex.getRight() != null) {
            return 1;
        }
        if (vertex.getTop() != null) {
            return 2;
        }
        if (vertex.getBottom() != null) {
            return 3;
        }
        throw new IllegalArgumentException("Vertex is not correct internal cell node");
    }

    private static boolean isContrary(int src, int tar) {
        switch (src) {
            case 0: {
                return tar == 1;
            }
            case 1: {
                return tar == 0;
            }
            case 2: {
                return tar == 3;
            }
            case 3: {
                return tar == 2;
            }
        }
        return false;
    }

    public static class OrthogonalRouterFactory
    extends AbstractDotLineRouter.AbstractDotLineRouterFactory<OrthogonalRouter> {
        @Override
        protected OrthogonalRouter newInstance() {
            return new OrthogonalRouter();
        }
    }

    private static class ChannelSegRank
    extends Mark<EdgeSeg> {
        private Iterable<TreeMap<Integer, List<EdgeSeg>>> edgeSegGroups;

        private ChannelSegRank() {
        }

        private Iterable<TreeMap<Integer, List<EdgeSeg>>> group(DedirectedGraph<EdgeSeg> digraph) {
            this.clear();
            this.setRank(digraph);
            this.setGroup(digraph);
            this.groupEdgeSegs(digraph);
            return this.getEdgeSegGroups();
        }

        private Iterable<TreeMap<Integer, List<EdgeSeg>>> getEdgeSegGroups() {
            return this.edgeSegGroups != null ? this.edgeSegGroups : Collections.emptyList();
        }

        private void setRank(DedirectedGraph<EdgeSeg> digraph) {
            for (EdgeSeg node : digraph) {
                if (this.isMark(node)) continue;
                this.dfs(node, digraph);
            }
        }

        private void dfs(EdgeSeg from, DedirectedGraph<EdgeSeg> digraph) {
            this.mark(from);
            for (EdgeSeg to : digraph.outAdjacent(from)) {
                if (!this.isMark(to)) {
                    this.dfs(to, digraph);
                }
                from.rank = Math.min(from.rank, to.rank - 1);
            }
        }

        private void setGroup(DedirectedGraph<EdgeSeg> digraph) {
            this.clear();
            int group = 0;
            for (EdgeSeg node : digraph) {
                if (this.isMark(node)) continue;
                this.dfs(group++, node, digraph);
            }
        }

        private void dfs(int group, EdgeSeg from, DedirectedGraph<EdgeSeg> digraph) {
            this.mark(from);
            from.group = group;
            for (EdgeSeg to : digraph.adjacent(from)) {
                if (this.isMark(to)) continue;
                this.dfs(group, to, digraph);
            }
        }

        private void groupEdgeSegs(DedirectedGraph<EdgeSeg> digraph) {
            this.edgeSegGroups = digraph.stream().collect(Collectors.groupingBy(e -> ((EdgeSeg)e).group, Collectors.groupingBy(e -> ((EdgeSeg)e).rank, TreeMap::new, Collectors.toList()))).values();
        }
    }

    private static class Channel {
        private final double min;
        private final double max;
        private List<EdgeSeg> edgeSegs;

        public Channel(double min, double max) {
            this.min = min;
            this.max = max;
        }

        private void addEdgeSeg(EdgeSeg edgeSeg) {
            if (this.edgeSegs == null) {
                this.edgeSegs = new ArrayList<EdgeSeg>();
            }
            this.edgeSegs.add(edgeSeg);
        }

        private double range() {
            return Math.abs(this.max - this.min);
        }

        private int segmentSize() {
            return CollectionUtils.isNotEmpty(this.edgeSegs) ? this.edgeSegs.size() : 0;
        }

        private EdgeSeg get(int idx) {
            Asserts.illegalArgument(CollectionUtils.isEmpty(this.edgeSegs), "Null Edge Segments");
            return this.edgeSegs.get(idx);
        }

        private void sortEdgeSegs() {
            if (CollectionUtils.isEmpty(this.edgeSegs)) {
                return;
            }
            this.edgeSegs.sort(EdgeSeg::compareTo);
        }
    }

    private static class EdgeDraw {
        private DNode from;
        private DNode to;
        private final EdgeSeg edgeSeg;

        public EdgeDraw(EdgeSeg edgeSeg) {
            this.edgeSeg = edgeSeg;
        }

        public DNode getFrom() {
            Asserts.illegalArgument(this.from == null, "EdgeDraw do not have from node");
            return this.from;
        }

        public DNode getTo() {
            Asserts.illegalArgument(this.to == null, "EdgeDraw do not have to node");
            return this.to;
        }
    }

    private static class EdgeSegRecord {
        private final Map<Line, EdgeDraw> lineEdgeSegs = new LinkedHashMap<Line, EdgeDraw>();
        private Map<Double, Map<Double, Channel>> channels;

        private EdgeSegRecord() {
        }

        private void addSeg(double min, double max, EdgeSeg edgeSeg) {
            Asserts.nullArgument(edgeSeg, "edgeSeg");
            Channel channel = this.getNullOrCreateChannel(min, max);
            channel.addEdgeSeg(edgeSeg);
        }

        private void addLineEdgeSeg(Line line, EdgeDraw edgeDraw) {
            this.lineEdgeSegs.put(line, edgeDraw);
        }

        private Channel getNullOrCreateChannel(double axis1, double axis2) {
            if (this.channels == null) {
                this.channels = new HashMap<Double, Map<Double, Channel>>();
            }
            double min = Math.min(axis1, axis2);
            double max = Math.max(axis1, axis2);
            Map channelRecord = this.channels.computeIfAbsent(min, a -> new HashMap(1));
            return channelRecord.computeIfAbsent(max, a -> new Channel(min, max));
        }

        private Iterable<Channel> channels() {
            if (this.channels == null) {
                return Collections.emptyList();
            }
            return this.channels.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toList());
        }
    }

    private static class EdgeSeg
    extends VertexIndex
    implements Comparable<EdgeSeg> {
        private static final long serialVersionUID = -941291526419206546L;
        private int rank;
        private int group;
        private double axis;
        private Double start;
        private Double end;
        private EdgeSeg pre;
        private EdgeSeg next;
        private boolean canNotMove;
        private final boolean isHor;
        private final boolean pos;

        public EdgeSeg(double axis, boolean isHor, boolean pos) {
            this.axis = axis;
            this.isHor = isHor;
            this.pos = pos;
        }

        private void moveAxis(double dist) {
            double oldAxis = this.axis;
            this.axis += dist;
            if (this.pre != null) {
                this.pre.moveEndpoint(oldAxis, this.axis);
            }
            if (this.next != null) {
                this.next.moveEndpoint(oldAxis, this.axis);
            }
        }

        private void moveEndpoint(double oldEndPoint, double newEndpoint) {
            if (this.start == null || this.end == null) {
                return;
            }
            double other = Objects.equals(oldEndPoint, this.start) ? this.end : this.start;
            this.start = Math.min(newEndpoint, other);
            this.end = Math.max(newEndpoint, other);
        }

        private void addVertex(VertexDir vertexDir) {
            if (this.isHor) {
                this.addPoint(vertexDir.vertex.getX());
            } else {
                this.addPoint(vertexDir.vertex.getY());
            }
        }

        private boolean preAtStart() {
            if (this.pre == null) {
                return false;
            }
            return Objects.equals(this.pre.axis, this.start);
        }

        private boolean nextAtStart() {
            if (this.next == null) {
                return false;
            }
            return Objects.equals(this.next.axis, this.start);
        }

        private void addPoint(double point) {
            if (this.start == null) {
                this.start = point;
                return;
            }
            if (Objects.equals(this.start, point) || Objects.equals(point, this.end)) {
                return;
            }
            Double tmp = this.start;
            this.start = Math.min(this.start, point);
            this.end = this.end == null ? Double.valueOf(Math.max(tmp, point)) : Double.valueOf(Math.max(this.end, point));
        }

        private double getStart() {
            Asserts.illegalArgument(this.start == null, "start not ready");
            return this.start;
        }

        private double getEnd() {
            Asserts.illegalArgument(this.end == null, "end not ready");
            return this.end;
        }

        private boolean overlap(EdgeSeg edgeSeg) {
            if (Objects.isNull(edgeSeg)) {
                return false;
            }
            return this.inRange(edgeSeg.getStart()) || this.inRange(edgeSeg.getEnd());
        }

        private boolean inRange(double val) {
            if (this.start == null || this.end == null) {
                return false;
            }
            return this.start <= val && this.end >= val;
        }

        private EdgeSeg startPre() {
            if (this.start == null) {
                return null;
            }
            if (this.pre != null && Objects.equals(this.start, this.pre.axis)) {
                return this.pre;
            }
            if (this.next != null && Objects.equals(this.start, this.next.axis)) {
                return this.next;
            }
            return null;
        }

        private EdgeSeg endNext() {
            if (this.end == null) {
                return null;
            }
            if (this.pre != null && Objects.equals(this.end, this.pre.axis)) {
                return this.pre;
            }
            if (this.next != null && Objects.equals(this.end, this.next.axis)) {
                return this.next;
            }
            return null;
        }

        @Override
        public int compareTo(EdgeSeg o) {
            if (o == null) {
                return 1;
            }
            if (this.isHor != o.isHor) {
                return this.isHor ? 1 : -1;
            }
            if (this.axis != o.axis) {
                return Double.compare(this.axis, o.axis);
            }
            if (this.start == null || this.end == null || o.start == null || o.end == null) {
                return 0;
            }
            int r = Double.compare(this.start, o.start);
            if (r != 0) {
                return r;
            }
            return Double.compare(this.end, o.end);
        }
    }

    private static class AdjPair {
        private VertexDir left;
        private VertexDir right;
        private VertexDir top;
        private VertexDir bottom;

        private AdjPair() {
        }

        private VertexDir get(int dir) {
            if (dir == 0) {
                return this.left;
            }
            if (dir == 1) {
                return this.right;
            }
            if (dir == 2) {
                return this.top;
            }
            if (dir == 3) {
                return this.bottom;
            }
            return null;
        }

        private void set(VertexDir vertexDir) {
            if (vertexDir == null) {
                return;
            }
            if (vertexDir.dir == 0) {
                this.left = vertexDir;
            }
            if (vertexDir.dir == 1) {
                this.right = vertexDir;
            }
            if (vertexDir.dir == 2) {
                this.top = vertexDir;
            }
            if (vertexDir.dir == 3) {
                this.bottom = vertexDir;
            }
        }
    }

    private static class PathContent {
        private final Queue<VertexDir> queue = new PriorityQueue<VertexDir>();
        private final Map<OrthoVisGraph.GridVertex, AdjPair> adjPairs = new HashMap<OrthoVisGraph.GridVertex, AdjPair>();

        private PathContent() {
        }

        private void offer(VertexDir vertexDir) {
            Asserts.nullArgument(vertexDir, "vertexDir");
            vertexDir.inQueue = true;
            this.queue.offer(vertexDir);
            AdjPair adjPair = this.adjPairs.computeIfAbsent(vertexDir.vertex, k -> new AdjPair());
            adjPair.set(vertexDir);
        }

        private VertexDir poll() {
            VertexDir v = this.queue.poll();
            if (v == null) {
                return null;
            }
            boolean inQueue = v.inQueue;
            v.inQueue = false;
            return inQueue ? v : null;
        }

        private AdjPair getOrNullCreateAdjPair(OrthoVisGraph.GridVertex vertex) {
            return this.adjPairs.computeIfAbsent(vertex, k -> new AdjPair());
        }

        private boolean isNotEmpty() {
            return !this.isEmpty();
        }

        private boolean isEmpty() {
            return this.queue.isEmpty();
        }

        protected void clear() {
            this.queue.clear();
            this.adjPairs.clear();
        }
    }

    private static class VertexDir
    implements Comparable<VertexDir> {
        private boolean inQueue;
        private int signIdx;
        private final int dir;
        private int costBendNum;
        private int estimateRemainBendNum;
        private double costLen;
        private double estimateRemainLen;
        private VertexDir parent;
        private Double centering;
        private final OrthoVisGraph.GridVertex vertex;
        private final Target target;

        private VertexDir(int dir, VertexDir parent, OrthoVisGraph.GridVertex vertex, Target target) {
            Asserts.nullArgument(vertex, "vertex");
            Asserts.nullArgument(target, "target");
            Asserts.illegalArgument(dir < 0 || dir > 3, "Wrong direction value");
            this.dir = dir;
            this.vertex = vertex;
            this.target = target;
            this.setParent(parent);
        }

        private void setParent(VertexDir p) {
            if (p != null) {
                this.centering = p.centering;
                this.signIdx = p.signIdx;
                this.target.markSignIndex(this);
            }
            this.parent = p;
            this.costBendNum = this.parentBendNum(p);
            this.estimateRemainBendNum = this.target.estimateBendNumToEnd(this);
            this.costLen = this.parentLen(p) + this.lengthToParent(this.parent);
            this.estimateRemainLen = this.target.estimateLenToEnd(this);
        }

        private int parentBendNum(VertexDir p) {
            if (p == null) {
                return 0;
            }
            return p.costBendNum + (this.dir == p.dir ? 0 : 1);
        }

        private double parentLen(VertexDir p) {
            if (p == null) {
                return 0.0;
            }
            return p.costLen;
        }

        private boolean isHor() {
            return this.dir == 0 || this.dir == 1;
        }

        private boolean isOrthogonal(boolean isHor) {
            return this.isOrthogonal(isHor ? 0 : 2);
        }

        private boolean isOrthogonal(int compareDir) {
            if (this.dir == 0 || this.dir == 1) {
                return compareDir == 2 || compareDir == 3;
            }
            if (this.dir == 2 || this.dir == 3) {
                return compareDir == 0 || compareDir == 1;
            }
            return false;
        }

        private double lengthToParent(VertexDir p) {
            if (p == null) {
                return 0.0;
            }
            return FlatPoint.twoPointDistance(p.vertex.getX(), p.vertex.getY(), this.vertex.getX(), this.vertex.getY());
        }

        private int compareCentering(VertexDir dir) {
            if (dir == null || Objects.equals(dir.centering, this.centering) || dir.centering == null || this.centering == null) {
                return 0;
            }
            return Double.compare(this.centering, dir.centering);
        }

        private int compareCost(VertexDir compareParent) {
            if (compareParent == null) {
                return 1;
            }
            if (compareParent == this.parent) {
                return 0;
            }
            int r = Integer.compare(this.costBendNum, this.parentBendNum(compareParent));
            if (r != 0) {
                return r;
            }
            return Double.compare(this.costLen - (double)this.signIdx, this.parentLen(compareParent) + this.lengthToParent(compareParent) - (double)compareParent.signIdx);
        }

        @Override
        public int compareTo(VertexDir o) {
            if (o == null) {
                return 1;
            }
            int r = Integer.compare(this.costBendNum + this.estimateRemainBendNum, o.costBendNum + o.estimateRemainBendNum);
            if (r != 0) {
                return r;
            }
            r = this.compareCentering(o);
            if (r != 0) {
                return r;
            }
            return Double.compare(this.costLen + this.estimateRemainLen, o.costLen + o.estimateRemainLen);
        }
    }

    private static class Target {
        private final Maze.Cell end;
        private List<DotMaze.GuideInfo> lineSigns;
        private double[] signToEndLens;
        private int[][] signToEndBendNum;

        private Target(Maze.Cell end) {
            Asserts.nullArgument(end, "end");
            this.end = end;
        }

        private Target(Maze.Cell end, List<DotMaze.GuideInfo> lineSigns) {
            this(end);
            Asserts.illegalArgument(CollectionUtils.isEmpty(lineSigns), "lineSigns");
            this.lineSigns = lineSigns;
            this.signToEndLens = new double[lineSigns.size()];
            this.signToEndBendNum = new int[lineSigns.size()][];
            this.initSignToEndLens();
            this.initSignToEndBendNum();
        }

        int signSize() {
            return CollectionUtils.isEmpty(this.lineSigns) ? 0 : this.lineSigns.size();
        }

        int estimateBendNumToEnd(VertexDir vertexDir) {
            if (vertexDir == null) {
                return 0;
            }
            int bendNum = Integer.MAX_VALUE;
            bendNum = Math.min(this.estimateBendNumToEnd(vertexDir, 0), bendNum);
            bendNum = Math.min(this.estimateBendNumToEnd(vertexDir, 1), bendNum);
            bendNum = Math.min(this.estimateBendNumToEnd(vertexDir, 2), bendNum);
            bendNum = Math.min(this.estimateBendNumToEnd(vertexDir, 3), bendNum);
            return bendNum;
        }

        double estimateLenToEnd(VertexDir vertexDir) {
            if (vertexDir == null) {
                return 0.0;
            }
            return this.signToEndLens(vertexDir.signIdx) + this.estimateLenToNextSign(vertexDir);
        }

        double estimateLenToNextSign(VertexDir vertexDir) {
            Asserts.nullArgument(vertexDir, "vertexDir");
            this.assertIdx(vertexDir.signIdx);
            return this.lenBetweenTwoSign(vertexDir.vertex, this.getBox(vertexDir.signIdx));
        }

        void markSignIndex(VertexDir vertexDir) {
            if (vertexDir == null || this.lineSigns == null) {
                return;
            }
            if (vertexDir.signIdx < 0 || vertexDir.signIdx >= this.signSize()) {
                return;
            }
            DotMaze.GuideInfo guideInfo = this.lineSigns.get(vertexDir.signIdx);
            if (guideInfo.getGuideVertex() == vertexDir.vertex) {
                vertexDir.signIdx++;
            }
        }

        private void assertIdx(int idx) {
            Asserts.illegalArgument(idx < 0 || idx > this.signSize(), "Wrong Sign index");
        }

        private void initSignToEndLens() {
            if (this.signToEndLens == null) {
                return;
            }
            for (int i = this.signToEndLens.length - 1; i >= 0; --i) {
                this.signToEndLens[i] = this.signToNextLen(i);
                if (i == this.signToEndLens.length - 1) continue;
                int n = i;
                this.signToEndLens[n] = this.signToEndLens[n] + this.signToEndLens[i + 1];
            }
        }

        private void initSignToEndBendNum() {
            if (this.signToEndBendNum == null) {
                return;
            }
            for (int i = this.signToEndBendNum.length - 1; i >= 0; --i) {
                this.signToEndBendNum[i] = new int[4];
                this.signToEndBendNum[i][0] = this.bendNumToNext(i, 0);
                this.signToEndBendNum[i][1] = this.bendNumToNext(i, 1);
                this.signToEndBendNum[i][2] = this.bendNumToNext(i, 2);
                this.signToEndBendNum[i][3] = this.bendNumToNext(i, 3);
                if (i == this.signToEndBendNum.length - 1) continue;
                int[] nArray = this.signToEndBendNum[i];
                nArray[0] = nArray[0] + this.signToEndBendNum[i + 1][this.bendTargetOppositeSide(i, 0)];
                int[] nArray2 = this.signToEndBendNum[i];
                nArray2[1] = nArray2[1] + this.signToEndBendNum[i + 1][this.bendTargetOppositeSide(i, 1)];
                int[] nArray3 = this.signToEndBendNum[i];
                nArray3[2] = nArray3[2] + this.signToEndBendNum[i + 1][this.bendTargetOppositeSide(i, 2)];
                int[] nArray4 = this.signToEndBendNum[i];
                nArray4[3] = nArray4[3] + this.signToEndBendNum[i + 1][this.bendTargetOppositeSide(i, 3)];
            }
        }

        private int estimateBendNumToEnd(VertexDir vertexDir, int dir) {
            Box box = this.getBox(vertexDir.signIdx);
            int bendNum = this.bendNumBetweenTwoSign(vertexDir.vertex, box, dir);
            bendNum += this.signToEndBendNum(vertexDir.signIdx, this.bendTargetOppositeSide(vertexDir.vertex, box, dir));
            if (vertexDir.isOrthogonal(dir)) {
                ++bendNum;
            } else if (OrthogonalRouter.isContrary(dir, vertexDir.dir)) {
                bendNum += 3;
            }
            return bendNum;
        }

        private int bendTargetOppositeSide(int idx, int dir) {
            this.assertIdx(idx);
            if (idx == this.signSize()) {
                return 0;
            }
            Box source = this.getBox(idx);
            Box target = this.getBox(idx + 1);
            return this.bendTargetOppositeSide(source, target, dir);
        }

        private int bendTargetOppositeSide(Box source, Box target, int dir) {
            if (source == target) {
                return dir;
            }
            return this.oppositeDir(TARGET_SIDE_TABLE[this.findInCellRange(source, target)][dir]);
        }

        private int oppositeDir(int dir) {
            switch (dir) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 2;
                }
            }
            return 0;
        }

        private int findInCellRange(Box source, Box target) {
            int row = this.rangeVal(source.getY(), target.getUpBorder(), target.getDownBorder());
            int col = this.rangeVal(source.getX(), target.getLeftBorder(), target.getRightBorder());
            return row * 3 + col;
        }

        private int rangeVal(double target, double min, double max) {
            if (target <= min) {
                return 0;
            }
            if (target >= max) {
                return 2;
            }
            return 1;
        }

        private Box getBox(int idx) {
            if (this.lineSigns == null) {
                return this.end;
            }
            this.assertIdx(idx);
            if (idx == this.signSize()) {
                return this.end;
            }
            return this.lineSigns.get(idx).getGuideVertex();
        }

        private double signToEndLens(int idx) {
            this.assertIdx(idx);
            if (idx == this.signSize()) {
                return 0.0;
            }
            return this.signToEndLens[idx];
        }

        private int signToEndBendNum(int idx, int dir) {
            this.assertIdx(idx);
            if (idx == this.signSize()) {
                return 0;
            }
            return this.signToEndBendNum[idx][dir];
        }

        private int bendNumToNext(int idx, int dir) {
            this.assertIdx(idx);
            if (idx == this.signSize()) {
                return 0;
            }
            Box box = this.getBox(idx);
            Box next = this.getBox(idx + 1);
            return this.bendNumBetweenTwoSign(box, next, dir);
        }

        private int bendNumBetweenTwoSign(Box source, Box target, int sourceDir) {
            return BEND_NUM_TABLE[this.findInCellRange(source, target)][sourceDir];
        }

        private double signToNextLen(int idx) {
            this.assertIdx(idx);
            if (idx == this.signSize()) {
                return 0.0;
            }
            Box box = this.getBox(idx);
            Box next = this.getBox(idx + 1);
            return this.lenBetweenTwoSign(box, next);
        }

        private double lenBetweenTwoSign(Box source, Box target) {
            return Math.abs(source.getX() - target.getX()) + Math.abs(source.getY() - target.getY());
        }
    }

    private static interface TargetConstructor {
        public Target newTarget(Maze.Cell var1);
    }
}

