/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.Objects;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.Port;
import org.graphper.api.ext.ShapePosition;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DefaultShapePosition;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.Rectangle;
import org.graphper.layout.Cell;
import org.graphper.layout.FlipShifterStrategy;
import org.graphper.layout.dot.AbstractDotLineRouter;
import org.graphper.layout.dot.DNode;
import org.graphper.util.Asserts;

public class PortHelper {
    private PortHelper() {
    }

    public static FlatPoint getPortPoint(DNode node, Port port) {
        if (port == null) {
            return new FlatPoint(node.getX(), node.getY());
        }
        return new FlatPoint(node.getX() + port.horOffset(node), node.getY() + port.verOffset(node));
    }

    public static Port getLineEndPointPort(Node node, Line line, DrawGraph drawGraph) {
        return PortHelper.getLineEndPointPort(node, line, drawGraph, true);
    }

    public static Port getLineEndPointPort(Node node, Line line, DrawGraph drawGraph, boolean needMove) {
        if (node == null || line == null || drawGraph == null) {
            return null;
        }
        LineAttrs lineAttrs = drawGraph.lineAttrs(line);
        Asserts.illegalArgument(lineAttrs == null, "can not find lineAttrs");
        if (node == line.tail()) {
            if (needMove) {
                return FlipShifterStrategy.movePort(drawGraph, lineAttrs.getTailPort());
            }
            return lineAttrs.getTailPort();
        }
        if (node == line.head()) {
            if (needMove) {
                return FlipShifterStrategy.movePort(drawGraph, lineAttrs.getHeadPort());
            }
            return lineAttrs.getHeadPort();
        }
        return null;
    }

    public static PortPoint getPortPoint(Line line, DNode node, DrawGraph drawGraph) {
        return PortHelper.getPortPoint(line, node, drawGraph, true);
    }

    public static PortPoint getPortPointWithoutClip(Line line, DNode node, DrawGraph drawGraph) {
        return PortHelper.getPortPoint(line, node, drawGraph, false);
    }

    public static PortPoint getPortPoint(DNode node, String cellId, Port port, DrawGraph drawGraph) {
        return PortHelper.endPoint(true, cellId, port, node.getNode(), drawGraph, node);
    }

    public static PortPoint getPortPoint(Line line, DNode node, DrawGraph drawGraph, boolean portClipNode) {
        Asserts.nullArgument(node, "node");
        Asserts.nullArgument(drawGraph, "drawGraph");
        if (node.isVirtual() || line == null) {
            return new PortPoint(node.getX(), node.getY(), false, null);
        }
        LineDrawProp lineDrawProp = drawGraph.getLineDrawProp(line);
        if (lineDrawProp == null) {
            return new PortPoint(node.getX(), node.getY(), false, null);
        }
        String cellId = PortHelper.getCellId(line, node, lineDrawProp);
        Port port = PortHelper.getLineEndPointPort(node.getNode(), line, drawGraph, false);
        return PortHelper.endPoint(portClipNode, cellId, port, node.getNode(), drawGraph, node);
    }

    public static String getCellId(Line line, DNode node, LineDrawProp lineDrawProp) {
        String cellId = null;
        if (node.getNode() == line.tail()) {
            cellId = lineDrawProp.lineAttrs().getTailCell();
        }
        if (node.getNode() == line.head()) {
            cellId = lineDrawProp.lineAttrs().getHeadCell();
        }
        return cellId;
    }

    public static PortPoint endPoint(boolean portClipNode, String cellId, Port port, Node node, DrawGraph drawGraph, ShapePosition shapePosition) {
        PortPoint portPoint;
        Asserts.nullArgument(node, "node");
        Asserts.nullArgument(shapePosition, "shapePosition");
        NodeDrawProp nodeDrawProp = drawGraph.getNodeDrawProp(node);
        Asserts.nullArgument(nodeDrawProp, "nodeDrawProp");
        Cell cell = null;
        Cell.RootCell rootCell = nodeDrawProp.getCell();
        if (rootCell != null) {
            cell = rootCell.getCellById(cellId);
        }
        if (port == null) {
            if (cell == null) {
                return new PortPoint(shapePosition.getX(), shapePosition.getY(), false, null);
            }
            FlatPoint center = cell.getCenter(shapePosition);
            return new PortPoint(center.getX(), center.getY(), true, null);
        }
        NodeShape nodeShape = nodeDrawProp.nodeShape();
        Rectangle rectangle = PortHelper.getNodeBoxWithRankdir(drawGraph, shapePosition);
        if (cell != null) {
            Rectangle cellRect = cell.getCellBox(shapePosition);
            DefaultShapePosition cellShapePos = new DefaultShapePosition(cellRect.getX(), cellRect.getY(), cell.getHeight(), cell.getWidth(), cell.getShape());
            cellRect = PortHelper.getNodeBoxWithRankdir(shapePosition.getRightBorder(), shapePosition.getDownBorder(), drawGraph, cellShapePos);
            portPoint = new PortPoint(cellRect.getX() + port.horOffset(cellRect), cellRect.getY() + port.verOffset(cellRect), true, port);
            rectangle = cellRect;
            nodeShape = cell.getShape() != null ? cell.getShape() : NodeShapeEnum.RECT;
        } else {
            portPoint = new PortPoint(rectangle.getX() + port.horOffset(rectangle), rectangle.getY() + port.verOffset(rectangle), true, port);
        }
        if (PortHelper.nodeCenter(portPoint, rectangle) || !portClipNode || nodeShape.in(rectangle, portPoint)) {
            FlipShifterStrategy.movePointOpposite(drawGraph.rankdir(), shapePosition, portPoint);
            return portPoint;
        }
        double leftWidth = nodeShape.leftWidth(rectangle.getWidth());
        double topHeight = nodeShape.topHeight(rectangle.getHeight());
        FlatPoint center = new FlatPoint(rectangle.getLeftBorder() + leftWidth, rectangle.getUpBorder() + topHeight);
        FlatPoint p = AbstractDotLineRouter.straightLineClipShape(rectangle, nodeShape, center, portPoint);
        FlipShifterStrategy.movePointOpposite(drawGraph.rankdir(), shapePosition, p);
        return new PortPoint(p.getX(), p.getY(), true, port);
    }

    private static boolean nodeCenter(PortPoint portPoint, Rectangle rectangle) {
        return Objects.equals(portPoint.getX(), rectangle.getX()) && Objects.equals(portPoint.getY(), rectangle.getY());
    }

    public static Rectangle getNodeBoxWithRankdir(DrawGraph drawGraph, ShapePosition shapePosition) {
        return PortHelper.getNodeBoxWithRankdir(shapePosition.getRightBorder(), shapePosition.getDownBorder(), drawGraph, shapePosition);
    }

    public static Rectangle getNodeBoxWithRankdir(double maxX, double maxY, DrawGraph drawGraph, ShapePosition shapePosition) {
        Rectangle rectangle = new Rectangle();
        rectangle.setUpBorder(shapePosition.getUpBorder());
        rectangle.setDownBorder(shapePosition.getDownBorder());
        rectangle.setLeftBorder(shapePosition.getLeftBorder());
        rectangle.setRightBorder(shapePosition.getRightBorder());
        FlipShifterStrategy.moveRectangle(drawGraph.rankdir(), maxX, maxY, rectangle);
        return rectangle;
    }

    public static FlatPoint notFlipEndPoint(String cellId, Port port, NodeDrawProp node, ShapePosition shapePosition) {
        FlatPoint portPoint;
        Asserts.nullArgument(node, "nodeDrawProp");
        Asserts.nullArgument(shapePosition, "shapePosition");
        Cell cell = null;
        Cell.RootCell Cell2 = node.getCell();
        if (Cell2 != null) {
            cell = Cell2.getCellById(cellId);
        }
        if (port == null) {
            if (cell == null) {
                return new FlatPoint(shapePosition.getX(), shapePosition.getY());
            }
            return cell.getCenter(shapePosition);
        }
        if (cell != null) {
            FlatPoint cellCenter = cell.getCenter(shapePosition);
            shapePosition = new DefaultShapePosition(cellCenter.getX(), cellCenter.getY(), cell.getHeight(), cell.getWidth(), NodeShapeEnum.RECT);
        }
        if (Objects.equals((portPoint = new FlatPoint(shapePosition.getX() + port.horOffset(shapePosition), shapePosition.getY() + port.verOffset(shapePosition))).getX(), shapePosition.getX()) && Objects.equals(portPoint.getY(), shapePosition.getY())) {
            return portPoint;
        }
        if (node.nodeShape().in(shapePosition, portPoint)) {
            return portPoint;
        }
        FlatPoint point = new FlatPoint(shapePosition.getX(), shapePosition.getY());
        return AbstractDotLineRouter.straightLineClipShape(shapePosition, point, portPoint);
    }

    public static double portCompareNo(Line line, DNode node, DrawGraph drawGraph) {
        FlatPoint offset;
        Asserts.nullArgument(node, "node");
        Asserts.nullArgument(drawGraph, "drawGraph");
        if (node.isVirtual() || line == null) {
            return 0.0;
        }
        LineDrawProp lineDrawProp = drawGraph.getLineDrawProp(line);
        if (lineDrawProp == null) {
            return 0.0;
        }
        NodeDrawProp nodeDrawProp = drawGraph.getNodeDrawProp(node.getNode());
        Asserts.nullArgument(nodeDrawProp, "nodeDrawProp");
        String cellId = PortHelper.getCellId(line, node, lineDrawProp);
        Port port = PortHelper.getLineEndPointPort(node.getNode(), line, drawGraph, true);
        Cell cell = null;
        Cell.RootCell rootCell = nodeDrawProp.getCell();
        if (rootCell != null) {
            cell = rootCell.getCellById(cellId);
        }
        double compareNo = 0.0;
        if (cell != null && (offset = cell.getOffset()) != null) {
            compareNo += offset.getX();
        }
        if (port != null) {
            compareNo += port.horOffsetRatio();
        }
        return compareNo;
    }

    public static class PortPoint
    extends FlatPoint {
        private static final long serialVersionUID = 1628364834247941307L;
        private final boolean havePort;
        private final Port port;

        public PortPoint(double height, double width, boolean havePort, Port port) {
            super(height, width);
            this.havePort = havePort;
            this.port = port;
        }

        public Port getPort() {
            return this.port;
        }

        public boolean notNodeCenter() {
            return this.havePort;
        }
    }
}

