/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.graphper.api.LineAttrs;
import org.graphper.api.attributes.Port;
import org.graphper.api.ext.ShapePosition;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.layout.FlipShifterStrategy;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.NodeSizeExpander;
import org.graphper.layout.dot.PortHelper;
import org.graphper.util.Asserts;

public class PortNodeSizeExpander
extends NodeSizeExpander {
    public PortNodeSizeExpander(DrawGraph drawGraph, DNode node) {
        Asserts.nullArgument(node, "node");
        Asserts.illegalArgument(node.isVirtual(), "Node is virtual node");
        Asserts.illegalArgument(!node.haveSelfLine(), "Node do not have self lines");
        this.node = node;
        this.init(drawGraph);
    }

    private void init(DrawGraph drawGraph) {
        NodeDrawProp nodeDrawProp = drawGraph.getNodeDrawProp(this.node.getNode());
        Asserts.illegalArgument(nodeDrawProp == null, "Can not find node draw property");
        TreeSet<SelfLine> lines = this.sortSelfLine(drawGraph);
        this.selfLinePoints(drawGraph, nodeDrawProp, lines);
    }

    private void selfLinePoints(DrawGraph drawGraph, NodeDrawProp nodeDrawProp, TreeSet<SelfLine> lines) {
        double interval = PortNodeSizeExpander.minSelfInterval(this.node);
        HashMap axisDistRecord = null;
        HashMap tempAxisDistRecord = null;
        HashMap otherDistRecord = null;
        for (SelfLine selfLine : lines) {
            Port headNearestPort;
            LineDrawProp lineDrawProp = this.lineDrawProp(drawGraph, selfLine);
            if (selfLine.directionPort != null) {
                if (otherDistRecord == null) {
                    otherDistRecord = new HashMap(2);
                }
                double len = this.axisAccumulator(otherDistRecord, selfLine.tailPoint, selfLine.tailPoint, interval, selfLine, this.isHorizontalPort(selfLine.directionPort));
                double x = selfLine.directionPort.horOffset(this.node);
                double y = selfLine.directionPort.verOffset(this.node);
                this.addPoint(lineDrawProp, selfLine.tailPoint);
                if (x == this.node.getX()) {
                    this.addPoint(lineDrawProp, new FlatPoint(selfLine.tailPoint.getX(), y < this.node.getY() ? y - len : y + len));
                } else {
                    this.addPoint(lineDrawProp, new FlatPoint(x < this.node.getX() ? x - len : x + len, selfLine.tailPoint.getY()));
                }
                this.addLabel(selfLine.line, lineDrawProp, 1);
                continue;
            }
            Port tailNearestPort = selfLine.tailNearestPort;
            int n = Math.min(this.portDist(tailNearestPort, headNearestPort = selfLine.headNearestPort, true), this.portDist(tailNearestPort, headNearestPort, false));
            if (n <= 1) {
                if (tempAxisDistRecord == null) {
                    tempAxisDistRecord = new HashMap(2);
                }
                float axisNo = (float)(tailNearestPort.getNo() + headNearestPort.getNo()) / 2.0f;
                boolean isHorizontal = n == 1 || this.isHorizontalPort(tailNearestPort);
                double len = this.axisAccumulator(tempAxisDistRecord, Float.valueOf(axisNo), Float.valueOf(axisNo), interval, selfLine, isHorizontal);
                FlatPoint point = this.getAdjPortPoint(this.node, len, tailNearestPort, headNearestPort);
                this.addPoint(lineDrawProp, selfLine.tailPoint);
                this.addPoint(lineDrawProp, point);
                this.addPoint(lineDrawProp, selfLine.headPoint);
                this.addLabel(selfLine.line, lineDrawProp, 1);
                continue;
            }
            this.addPoint(lineDrawProp, selfLine.tailPoint);
            int labelIdx = 0;
            Port port = tailNearestPort;
            FlatPoint center = null;
            boolean positive = n == Math.abs(tailNearestPort.getNo() - headNearestPort.getNo());
            boolean clockwise = positive == tailNearestPort.getNo() < headNearestPort.getNo();
            Port midPort = this.findMidPort(tailNearestPort, headNearestPort, clockwise);
            while (true) {
                float no;
                Port pre = port;
                port = clockwise ? port.next() : port.pre();
                if (port == headNearestPort) break;
                if (tempAxisDistRecord != null && tempAxisDistRecord.get(Float.valueOf(no = (float)(pre.getNo() + port.getNo()) / 2.0f)) != null) {
                    double len = this.axisAccumulator(tempAxisDistRecord, Float.valueOf(no), null, interval, selfLine, false);
                    FlatPoint point = this.getAdjPortPoint(this.node, len, pre, port);
                    this.addPoint(lineDrawProp, point);
                }
                if (axisDistRecord == null) {
                    axisDistRecord = new HashMap(4);
                }
                double len = this.axisAccumulator(axisDistRecord, port, midPort, interval, selfLine, this.isHorizontalPort(port));
                FlatPoint point = PortHelper.notFlipEndPoint(null, port, nodeDrawProp, this.node);
                if (center == null) {
                    center = new FlatPoint(this.node.getX(), this.node.getY());
                }
                double d = FlatPoint.twoFlatPointDistance(point, center);
                FlatPoint flatPoint = Vectors.add(center, Vectors.multiple(Vectors.sub(point, center), (d + len) / d));
                if (port == midPort) {
                    labelIdx = lineDrawProp.size();
                }
                this.addPoint(lineDrawProp, flatPoint);
            }
            this.addPoint(lineDrawProp, selfLine.headPoint);
            this.addLabel(selfLine.line, lineDrawProp, labelIdx);
        }
    }

    private TreeSet<SelfLine> sortSelfLine(DrawGraph drawGraph) {
        TreeSet<SelfLine> lines = new TreeSet<SelfLine>(this::selfLineComparator);
        for (int i = 0; i < this.node.getSelfLoopCount(); ++i) {
            DLine selfLine = this.node.selfLine(i);
            LineDrawProp lineDrawProp = drawGraph.getLineDrawProp(selfLine.getLine());
            if (lineDrawProp == null) continue;
            LineAttrs lineAttrs = lineDrawProp.lineAttrs();
            Port tailPort = FlipShifterStrategy.movePort(drawGraph, lineAttrs.getTailPort());
            PortHelper.PortPoint tailPoint = PortHelper.getPortPoint(this.node, lineAttrs.getTailCell(), lineAttrs.getTailPort(), drawGraph);
            PortHelper.PortPoint headPoint = PortHelper.getPortPoint(this.node, lineAttrs.getHeadCell(), lineAttrs.getHeadPort(), drawGraph);
            Port tailNearestPort = null;
            Port headNearestPort = null;
            Port directionPort = null;
            if (Objects.equals(tailPoint, headPoint)) {
                boolean inCenterVerAxis = Objects.equals(tailPoint.getX(), this.node.getX());
                boolean inCenterHorAxis = Objects.equals(tailPoint.getY(), this.node.getY());
                directionPort = inCenterHorAxis && inCenterVerAxis ? Port.EAST : (inCenterVerAxis ? (tailPoint.getY() < this.node.getY() ? Port.NORTH : Port.SOUTH) : (inCenterHorAxis ? (tailPoint.getX() < this.node.getX() ? Port.WEST : Port.EAST) : (tailPort.isAxis() ? tailPort : (tailPoint.getX() < this.node.getX() ? Port.WEST : Port.EAST))));
            } else {
                tailNearestPort = this.findNearestPort(tailPoint, this.node, null);
                headNearestPort = this.findNearestPort(headPoint, this.node, tailNearestPort);
            }
            lines.add(new SelfLine(i, selfLine, tailPoint, headPoint, tailNearestPort, headNearestPort, directionPort));
        }
        return lines;
    }

    private FlatPoint getAdjPortPoint(DNode node, double len, Port tailNearestPort, Port headNearestPort) {
        double tx = tailNearestPort.horOffset(node);
        double ty = tailNearestPort.verOffset(node);
        double hx = headNearestPort.horOffset(node);
        double hy = headNearestPort.verOffset(node);
        FlatPoint point = tx == hx ? new FlatPoint(tx < node.getX() ? tx - len : tx + len, (ty + hy) / 2.0) : new FlatPoint((tx + hx) / 2.0, ty < node.getY() ? ty - len : ty + len);
        return point;
    }

    private <T> double axisAccumulator(Map<T, Double> accumulatorMap, T key, T labelKey, double interval, SelfLine selfLine, boolean horizontal) {
        Double length = accumulatorMap.get(key);
        length = length == null ? interval : length + interval;
        double t = length;
        if (selfLine.line.getLabelSize() != null && Objects.equals(labelKey, key)) {
            length = horizontal ? Double.valueOf(length + selfLine.line.getLabelSize().getWidth()) : Double.valueOf(length + selfLine.line.getLabelSize().getHeight());
        }
        accumulatorMap.put(key, length);
        return t;
    }

    private int portDist(Port p1, Port p2, boolean positive) {
        if (positive) {
            return Math.abs(p2.getNo() - p1.getNo());
        }
        Port max = p1.getNo() > p2.getNo() ? p1 : p2;
        Port min = max == p1 ? p2 : p1;
        return Port.maxNo() + 1 - max.getNo() + min.getNo();
    }

    private int selfLineComparator(SelfLine left, SelfLine right) {
        int d2;
        if (left.tailNearestPort == left.headNearestPort) {
            return -1;
        }
        if (right.tailNearestPort == right.headNearestPort) {
            return 1;
        }
        int d1 = Math.min(this.portDist(left.tailNearestPort, left.headNearestPort, true), this.portDist(left.tailNearestPort, left.headNearestPort, false));
        int no = Double.compare(d1, d2 = Math.min(this.portDist(right.tailNearestPort, right.headNearestPort, true), this.portDist(right.tailNearestPort, right.headNearestPort, false)));
        return no != 0 ? no : Integer.compare(left.selfLineNo, right.selfLineNo);
    }

    private Port findNearestPort(FlatPoint point, ShapePosition position, Port exclude) {
        if (point == null) {
            return null;
        }
        Port minNearestPort = null;
        double minDistance = Double.MAX_VALUE;
        for (Port port : Port.values()) {
            if (port == exclude) continue;
            double verOffset = port.verOffset(position);
            double horOffset = port.horOffset(position);
            double d = FlatPoint.twoFlatPointDistance(point, new FlatPoint(horOffset, verOffset));
            if (!(d < minDistance)) continue;
            minDistance = d;
            minNearestPort = port;
        }
        return minNearestPort;
    }

    private Port findMidPort(Port start, Port end, boolean clockwise) {
        int i = 0;
        Port current = start;
        int n = (Math.min(this.portDist(start, end, false), this.portDist(start, end, true)) + 1) / 2;
        while (i++ < n) {
            if (clockwise) {
                current = current.next();
                continue;
            }
            current = current.pre();
        }
        return current;
    }

    private LineDrawProp lineDrawProp(DrawGraph drawGraph, SelfLine line) {
        return drawGraph.getLineDrawProp(line.line.getLine());
    }

    private void addLabel(DLine line, LineDrawProp lineDrawProp, int labelIdx) {
        FlatPoint labelCenter;
        if (!line.haveLabel() || labelIdx < 0 || labelIdx >= lineDrawProp.size()) {
            return;
        }
        FlatPoint labelSize = line.getLabelSize();
        FlatPoint point = (FlatPoint)lineDrawProp.get(labelIdx);
        double halfWidth = labelSize.getWidth() / 2.0;
        double halfHeight = labelSize.getHeight() / 2.0;
        FlatPoint center = new FlatPoint(this.node.getX(), this.node.getY());
        if (point.getX() == this.node.getX()) {
            labelCenter = new FlatPoint(point.getX(), point.getY() < this.node.getY() ? point.getY() - halfHeight : point.getY() + halfHeight);
        } else if (point.getY() == this.node.getY()) {
            labelCenter = new FlatPoint(point.getX() < this.node.getX() ? point.getX() - halfWidth : point.getX() + halfWidth, point.getY());
        } else {
            double d = FlatPoint.twoFlatPointDistance(point, center);
            labelCenter = Vectors.add(center, Vectors.multiple(Vectors.sub(point, center), (d + halfHeight) / d));
        }
        lineDrawProp.setLabelCenter(labelCenter);
        this.refreshVolume(labelCenter.getX() - halfWidth, labelCenter.getY() - halfHeight);
        this.refreshVolume(labelCenter.getX() - halfWidth, labelCenter.getY() + halfHeight);
        this.refreshVolume(labelCenter.getX() + halfWidth, labelCenter.getY() - halfHeight);
        this.refreshVolume(labelCenter.getX() + halfWidth, labelCenter.getY() + halfHeight);
    }

    private boolean isHorizontalPort(Port port) {
        return port == Port.WEST || port == Port.EAST;
    }

    private static class SelfLine {
        private final int selfLineNo;
        private final DLine line;
        private final FlatPoint tailPoint;
        private final FlatPoint headPoint;
        private final Port tailNearestPort;
        private final Port headNearestPort;
        private final Port directionPort;

        public SelfLine(int selfLineNo, DLine line, FlatPoint tailPoint, FlatPoint headPoint, Port tailNearestPort, Port headNearestPort, Port directionPort) {
            this.selfLineNo = selfLineNo;
            this.line = line;
            this.tailPoint = tailPoint;
            this.headPoint = headPoint;
            this.tailNearestPort = tailNearestPort;
            this.headNearestPort = headNearestPort;
            this.directionPort = directionPort;
        }
    }
}

