/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.List;
import java.util.Map;
import org.graphper.api.attributes.Port;
import org.graphper.api.attributes.Rankdir;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.FlipShifterStrategy;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.NodeSizeExpander;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public class PortNodeSizeExpanderV2
extends NodeSizeExpander {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;

    public PortNodeSizeExpanderV2(DrawGraph drawGraph, DNode node) {
        Asserts.nullArgument(node, "node");
        Asserts.illegalArgument(node.isVirtual(), "Node is virtual node");
        Asserts.illegalArgument(!node.haveSelfLine(), "Node do not have self lines");
        this.node = node;
        this.initExpander(drawGraph, this.groupSelfLine(drawGraph, node));
    }

    private void initExpander(DrawGraph drawGraph, Map<NodeSizeExpander.GroupKey, List<NodeSizeExpander.GroupEntry>> selfGroups) {
        for (Map.Entry<NodeSizeExpander.GroupKey, List<NodeSizeExpander.GroupEntry>> entry : selfGroups.entrySet()) {
            double interval;
            List<NodeSizeExpander.GroupEntry> groupEntries = entry.getValue();
            double nextInterval = interval = PortNodeSizeExpanderV2.minSelfInterval(groupEntries.size(), this.node.getNodeSep());
            for (NodeSizeExpander.GroupEntry groupEntry : groupEntries) {
                DLine dLine = groupEntry.line;
                NodeSizeExpander.GroupKey groupKey = groupEntry.groupKey;
                LineDrawProp line = drawGraph.getLineDrawProp(dLine.getLine());
                nextInterval += this.setSamePointLine(groupKey, drawGraph.rankdir(), nextInterval, line, dLine);
                nextInterval += this.setUpDownLine(groupKey, drawGraph.rankdir(), nextInterval, line, dLine);
                nextInterval += this.setLeftRightLine(groupKey, drawGraph.rankdir(), nextInterval, line, dLine);
                nextInterval += interval;
            }
        }
    }

    private double setSamePointLine(NodeSizeExpander.GroupKey groupKey, Rankdir rankdir, double interval, LineDrawProp line, DLine dLine) {
        if (!groupKey.samePoint()) {
            return 0.0;
        }
        Port port = groupKey.tailPort;
        FlatPoint point = groupKey.getTailPoint();
        int direction = this.portDirection(port, rankdir);
        this.addPoint(line, point);
        if (direction == 0) {
            double leftBorder = this.node.getLeftBorder();
            this.addPoint(line, new FlatPoint(leftBorder - interval, point.getY()));
            return this.addLabelByLastPoint(true, false, dLine, line);
        }
        if (direction == 1) {
            double rightBorder = this.node.getRightBorder();
            this.addPoint(line, new FlatPoint(rightBorder + interval, point.getY()));
            return this.addLabelByLastPoint(true, true, dLine, line);
        }
        if (direction == 2) {
            double upBorder = this.node.getUpBorder();
            this.addPoint(line, new FlatPoint(point.getX(), upBorder - interval));
            return this.addLabelByLastPoint(false, false, dLine, line);
        }
        if (direction == 3) {
            double downBorder = this.node.getDownBorder();
            this.addPoint(line, new FlatPoint(point.getX(), downBorder + interval));
        }
        return this.addLabelByLastPoint(false, true, dLine, line);
    }

    private double setUpDownLine(NodeSizeExpander.GroupKey groupKey, Rankdir rankdir, double interval, LineDrawProp line, DLine dLine) {
        if (!groupKey.isOnlySameHor()) {
            return 0.0;
        }
        FlatPoint tailPoint = groupKey.getTailPoint();
        FlatPoint headPoint = groupKey.getHeadPoint();
        this.addPoint(line, tailPoint);
        double x = (tailPoint.getX() + headPoint.getX()) / 2.0;
        int direction = this.sameCellHorDirection(groupKey.tailPort, rankdir);
        if (direction == 2) {
            double upBorder = this.node.getUpBorder();
            this.addPoint(line, new FlatPoint(x, upBorder - interval));
            interval = this.addLabelByLastPoint(false, false, dLine, line);
        }
        if (direction == 3) {
            double downBorder = this.node.getDownBorder();
            this.addPoint(line, new FlatPoint(x, downBorder + interval));
            interval = this.addLabelByLastPoint(false, true, dLine, line);
        }
        this.addPoint(line, headPoint);
        return interval;
    }

    private double setLeftRightLine(NodeSizeExpander.GroupKey groupKey, Rankdir rankdir, double interval, LineDrawProp line, DLine dLine) {
        if (groupKey.samePoint() || groupKey.isOnlySameHor()) {
            return 0.0;
        }
        FlatPoint tailPoint = groupKey.getTailPoint();
        FlatPoint headPoint = groupKey.getHeadPoint();
        this.addPoint(line, tailPoint);
        double y = (tailPoint.getY() + headPoint.getY()) / 2.0;
        int direction = groupKey.isOnlySameVer() ? this.sameCellVerDirection(groupKey.tailPort, rankdir) : (groupKey.sameCell() ? this.sameCellHorDirection(groupKey.tailPort, groupKey.headPort, rankdir) : this.diagonalPointDirection(groupKey));
        if (direction == 0) {
            double leftBorder = this.node.getLeftBorder();
            this.addPoint(line, new FlatPoint(leftBorder - interval, y));
            interval = this.addLabelByLastPoint(true, false, dLine, line);
        }
        if (direction == 1) {
            double rightBorder = this.node.getRightBorder();
            this.addPoint(line, new FlatPoint(rightBorder + interval, y));
            interval = this.addLabelByLastPoint(true, true, dLine, line);
        }
        this.addPoint(line, headPoint);
        return interval;
    }

    private double addLabelByLastPoint(boolean isHor, boolean isAdd, DLine dLine, LineDrawProp line) {
        if (dLine.getLabelSize() == null || CollectionUtils.isEmpty(line)) {
            return 0.0;
        }
        FlatPoint lastPoint = (FlatPoint)line.get(line.size() - 1);
        FlatPoint labelSize = dLine.getLabelSize();
        return this.addLabel(isHor, isAdd, line, lastPoint, labelSize);
    }

    private double addLabel(boolean isHor, boolean isAdd, LineDrawProp line, FlatPoint lastPoint, FlatPoint labelSize) {
        if (isHor) {
            FlatPoint labelCenter = isAdd ? new FlatPoint(lastPoint.getX() + labelSize.getWidth() / 2.0, lastPoint.getY()) : new FlatPoint(lastPoint.getX() - labelSize.getWidth() / 2.0, lastPoint.getY());
            this.addLabel(line, labelSize, labelCenter);
            return labelSize.getWidth();
        }
        FlatPoint labelCenter = isAdd ? new FlatPoint(lastPoint.getX(), lastPoint.getY() + labelSize.getHeight() / 2.0) : new FlatPoint(lastPoint.getX(), lastPoint.getY() - labelSize.getHeight() / 2.0);
        this.addLabel(line, labelSize, labelCenter);
        return labelSize.getHeight();
    }

    private void addLabel(LineDrawProp line, FlatPoint labelSize, FlatPoint labelCenter) {
        line.setLabelCenter(labelCenter);
        this.refreshByLabel(labelSize, labelCenter);
    }

    private void refreshByLabel(FlatPoint labelSize, FlatPoint labelCenter) {
        double halfWidth = labelSize.getWidth() / 2.0;
        double halfHeight = labelSize.getHeight() / 2.0;
        this.refreshVolume(labelCenter.getX() - halfWidth, labelCenter.getY() - halfHeight);
        this.refreshVolume(labelCenter.getX() - halfWidth, labelCenter.getY() + halfHeight);
        this.refreshVolume(labelCenter.getX() + halfWidth, labelCenter.getY() - halfHeight);
        this.refreshVolume(labelCenter.getX() + halfWidth, labelCenter.getY() + halfHeight);
    }

    private int portDirection(Port port, Rankdir rankdir) {
        return this.portDirection(FlipShifterStrategy.movePort(port, rankdir));
    }

    private int sameCellHorDirection(Port port, Rankdir rankdir) {
        return this.sameCellHorDirection(FlipShifterStrategy.movePort(port, rankdir));
    }

    private int sameCellVerDirection(Port port, Rankdir rankdir) {
        return this.sameCellVerDirection(FlipShifterStrategy.movePort(port, rankdir));
    }

    private int sameCellHorDirection(Port tailPort, Port headPort, Rankdir rankdir) {
        if (this.isNW_S(tailPort = FlipShifterStrategy.movePort(tailPort, rankdir), headPort = FlipShifterStrategy.movePort(headPort, rankdir)) || this.isNW_S(headPort, tailPort) || this.isN_SW(tailPort, headPort) || this.isN_SW(headPort, tailPort) || this.isN_W(tailPort, headPort) || this.isN_W(headPort, tailPort) || this.isNE_W(tailPort, headPort) || this.isNE_W(headPort, tailPort) || this.isNE_SW(tailPort, headPort) || this.isNE_SW(headPort, tailPort) || this.isSE_W(tailPort, headPort) || this.isSE_W(headPort, tailPort) || this.isS_W(tailPort, headPort) || this.isS_W(headPort, tailPort) || this.isC_NW(tailPort, headPort) || this.isC_NW(headPort, tailPort) || this.isC_SW(tailPort, headPort) || this.isC_SW(headPort, tailPort)) {
            return 0;
        }
        return 1;
    }

    private boolean isNW_S(Port p1, Port p2) {
        return p1 == Port.NORTH_WEST && p2 == Port.SOUTH;
    }

    private boolean isN_SW(Port p1, Port p2) {
        return p1 == Port.NORTH && p2 == Port.SOUTH_WEST;
    }

    private boolean isN_W(Port p1, Port p2) {
        return p1 == Port.NORTH && p2 == Port.WEST;
    }

    private boolean isNE_W(Port p1, Port p2) {
        return p1 == Port.NORTH_EAST && p2 == Port.WEST;
    }

    private boolean isNE_SW(Port p1, Port p2) {
        return p1 == Port.NORTH_EAST && p2 == Port.SOUTH_WEST;
    }

    private boolean isSE_W(Port p1, Port p2) {
        return p1 == Port.SOUTH_EAST && p2 == Port.WEST;
    }

    private boolean isS_W(Port p1, Port p2) {
        return p1 == Port.SOUTH && p2 == Port.WEST;
    }

    private boolean isC_NW(Port p1, Port p2) {
        return p1 == null && p2 == Port.NORTH_WEST;
    }

    private boolean isC_SW(Port p1, Port p2) {
        return p1 == null && p2 == Port.SOUTH_WEST;
    }

    private int diagonalPointDirection(NodeSizeExpander.GroupKey groupKey) {
        if ((groupKey.tailPoint.getX() + groupKey.headPoint.getX()) / 2.0 < this.node.getX()) {
            return 0;
        }
        return 1;
    }

    private int portDirection(Port port) {
        if (port == Port.NORTH) {
            return 2;
        }
        if (port == Port.SOUTH) {
            return 3;
        }
        if (port == Port.NORTH_WEST || port == Port.WEST || port == Port.SOUTH_WEST) {
            return 0;
        }
        return 1;
    }

    private int sameCellHorDirection(Port port) {
        if (port == Port.SOUTH_WEST || port == Port.SOUTH || port == Port.SOUTH_EAST) {
            return 3;
        }
        return 2;
    }

    private int sameCellVerDirection(Port port) {
        if (port == Port.NORTH_WEST || port == Port.WEST || port == Port.SOUTH_WEST) {
            return 0;
        }
        return 1;
    }
}

