/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.graphper.def.BaseGraph;
import org.graphper.layout.dot.DNode;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

class RankContent
implements Iterable<RankNode> {
    private final double rankSep;
    int minRank = Integer.MAX_VALUE;
    private final boolean positiveRank;
    int maxRank = Integer.MIN_VALUE;
    Map<Integer, RankNode> rankNodeMap;

    RankContent(BaseGraph<DNode> graph, double rankSep, boolean positiveRank, Consumer<DNode[]> sortNodesConsumer) {
        this.rankNodeMap = new HashMap<Integer, RankNode>();
        this.rankSep = rankSep;
        this.positiveRank = positiveRank;
        this.normalize(graph, sortNodesConsumer);
    }

    protected RankContent() {
        this.rankSep = 0.0;
        this.positiveRank = false;
    }

    private void normalize(BaseGraph<DNode> graph, Consumer<DNode[]> sortNodesConsumer) {
        DNode[] nodes = graph.toArray();
        if (nodes == null) {
            return;
        }
        Arrays.sort(nodes, Comparator.comparing(DNode::getRank));
        if (sortNodesConsumer != null) {
            sortNodesConsumer.accept(nodes);
        }
        RankNode current = null;
        Integer currentRankIndex = null;
        int deviation = 0;
        if (this.positiveRank) {
            deviation = 1 - nodes[0].getRank();
        }
        for (DNode node : nodes) {
            int rankIndex = node.getRank() + deviation;
            node.setRank(rankIndex);
            if (current == null || !Objects.equals(currentRankIndex, rankIndex)) {
                if (this.positiveRank && current != null && rankIndex - currentRankIndex > 1) {
                    for (int i = currentRankIndex + 1; i < rankIndex; ++i) {
                        RankNode rankNode = this.get(i);
                        if (rankNode == null) {
                            rankNode = new RankNode(current, null, i);
                            rankNode.rankSep = this.rankSep;
                        }
                        this.put(i, rankNode);
                        current.next = rankNode;
                        current = rankNode;
                    }
                }
                RankNode pre = current;
                currentRankIndex = rankIndex;
                current = new RankNode(pre, null, currentRankIndex);
                current.rankSep = this.rankSep;
                this.put(currentRankIndex, current);
                if (pre != null) {
                    pre.next = current;
                }
            }
            if (rankIndex < this.minRank) {
                this.minRank = rankIndex;
            }
            if (rankIndex > this.maxRank) {
                this.maxRank = rankIndex;
            }
            current.add(node);
        }
    }

    RankNode insertLabelRankNode(int idx) {
        RankNode rankNode = this.rankNodeMap.get(idx);
        if (rankNode == null || rankNode.noNormalNode() || rankNode.pre != null && rankNode.pre.noNormalNode()) {
            return null;
        }
        if (rankNode.pre != null) {
            rankNode.pre.setRankSep(rankNode.pre.getRankSep() / 2.0);
        }
        RankNode r = new RankNode(rankNode.pre, rankNode, 0);
        r.setRankSep(rankNode.pre != null ? rankNode.pre.getRankSep() : rankNode.getRankSep());
        if (rankNode.pre != null) {
            rankNode.pre.next = r;
        }
        rankNode.pre = r;
        return r;
    }

    void rankIndexSync() {
        RankNode adj;
        int rank = this.minRank;
        int minR = this.minRank;
        RankNode current = this.get(minR);
        do {
            if ((adj = current.pre()) == null) continue;
            adj.rankIndex = --rank;
            this.rankNodeMap.put(adj.rankIndex, adj);
            this.minRank = rank;
        } while ((current = adj) != null);
        rank = minR;
        current = this.get(minR);
        do {
            if ((adj = current.next()) == null) continue;
            adj.rankIndex = ++rank;
            this.rankNodeMap.put(adj.rankIndex, adj);
            this.maxRank = Math.max(this.maxRank, rank);
        } while ((current = adj) != null);
    }

    void put(Integer rankIndex, RankNode rankNode) {
        this.rankNodeMap.put(rankIndex, rankNode);
    }

    int size() {
        return this.rankNodeMap.size();
    }

    void remove(Object key) {
        this.rankNodeMap.remove(key);
    }

    RankNode get(Object rankIndex) {
        return this.rankNodeMap.get(rankIndex);
    }

    DNode rankPreNode(DNode node) {
        if (node == null) {
            return null;
        }
        RankNode rankNode = this.get(node.getRankIgnoreModel());
        if (rankNode == null) {
            return null;
        }
        int pi = node.getRankIndex() - 1;
        if (RankNode.isNotRightIndex(pi, rankNode.size())) {
            return null;
        }
        return rankNode.get(pi);
    }

    DNode rankNextNode(DNode node) {
        if (node == null) {
            return null;
        }
        RankNode rankNode = this.get(node.getRankIgnoreModel());
        if (rankNode == null) {
            return null;
        }
        int ni = node.getRankIndex() + 1;
        if (RankNode.isNotRightIndex(ni, rankNode.size())) {
            return null;
        }
        return rankNode.get(ni);
    }

    int minRank() {
        return this.minRank;
    }

    int maxRank() {
        return this.maxRank;
    }

    public String toString() {
        return "RankContent{\nrankNodeMap=" + this.rankNodeMap + ", \nminRank=" + this.minRank + ", \nmaxRank=" + this.maxRank + "\n}";
    }

    @Override
    public Iterator<RankNode> iterator() {
        return this.rankNodeMap.values().iterator();
    }

    static class RankNode
    implements Iterable<DNode> {
        private double startY;
        private double endY;
        private final ArrayList<DNode> nodes;
        private int normalNodeNum;
        private int rankIndex;
        double rankSep;
        RankNode next;
        RankNode pre;
        final boolean labelRank;

        RankNode(RankNode pre, RankNode next, int rankIndex) {
            this(pre, next, rankIndex, false);
        }

        RankNode(RankNode pre, RankNode next, int rankIndex, boolean isLabelRank) {
            this.pre = pre;
            this.next = next;
            this.rankIndex = rankIndex;
            this.nodes = new ArrayList();
            this.labelRank = isLabelRank;
        }

        public boolean havePreRank() {
            return this.pre != null;
        }

        public boolean haveNextRank() {
            return this.next != null;
        }

        public boolean isLabelRank() {
            return this.labelRank;
        }

        DNode get(int idx) {
            if (idx < 0 || idx >= this.size()) {
                return null;
            }
            return this.nodes.get(idx);
        }

        DNode set(int idx, DNode node) {
            return this.nodes.set(idx, node);
        }

        boolean add(DNode node) {
            if (node == null) {
                return false;
            }
            if (!node.isVirtual()) {
                ++this.normalNodeNum;
            }
            return this.nodes.add(node);
        }

        void add(int idx, DNode node) {
            this.nodes.add(idx, node);
        }

        boolean remove(Object obj) {
            if (this.nodes.remove(obj)) {
                if (!((DNode)obj).isVirtual()) {
                    --this.normalNodeNum;
                }
                return true;
            }
            return false;
        }

        int size() {
            return this.nodes.size();
        }

        boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        boolean noNormalNode() {
            return this.normalNodeNum <= 0;
        }

        int normalNodeNum() {
            return this.normalNodeNum;
        }

        DNode first() {
            if (this.size() == 0) {
                return null;
            }
            return this.get(0);
        }

        DNode last() {
            if (this.size() == 0) {
                return null;
            }
            return this.get(this.size() - 1);
        }

        void setRankIndex(int rankIndex) {
            this.rankIndex = rankIndex;
        }

        int rankIndex() {
            return this.rankIndex;
        }

        RankNode pre() {
            return this.pre;
        }

        RankNode next() {
            return this.next;
        }

        double getStartX() {
            if (this.nodes.isEmpty()) {
                throw new IllegalStateException("empty rank");
            }
            DNode first = this.nodes.get(0);
            return (int)(first.getX() - first.leftWidth());
        }

        double getEndX() {
            if (this.nodes.isEmpty()) {
                throw new IllegalStateException("empty rank");
            }
            DNode last = this.nodes.get(this.size() - 1);
            return last.getX() + last.rightWidth();
        }

        double getStartY() {
            return this.startY;
        }

        void setStartY(double startY) {
            this.startY = startY;
        }

        double getEndY() {
            return this.endY;
        }

        double getHeight() {
            return this.endY - this.startY;
        }

        void setRankSep(double rankSep) {
            this.rankSep = rankSep;
        }

        double getRankSep() {
            return this.rankSep;
        }

        void setEndY(double endY) {
            this.endY = endY;
        }

        static boolean isNotRightIndex(int index, int size) {
            return index < 0 || index >= size;
        }

        void sort(Comparator<DNode> comparator) {
            Asserts.nullArgument(comparator, "comparator");
            if (CollectionUtils.isEmpty(this.nodes)) {
                return;
            }
            this.nodes.sort(comparator);
        }

        @Override
        public Iterator<DNode> iterator() {
            return this.nodes.iterator();
        }

        public String toString() {
            return "{hascode=" + this.hashCode() + ",pre=" + (this.pre != null ? Integer.valueOf(this.pre.hashCode()) : null) + ",next=" + (this.next != null ? Integer.valueOf(this.next.hashCode()) : null) + ",rank=" + this.rankIndex + ",size=" + this.nodes.size() + "}";
        }
    }
}

