/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.graphper.api.GraphContainer;
import org.graphper.def.DedirectedEdgeGraph;
import org.graphper.def.EdgeDedigraph;
import org.graphper.draw.DrawGraph;
import org.graphper.layout.dot.BasicCrossRank;
import org.graphper.layout.dot.CrossRank;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.MinCross;
import org.graphper.layout.dot.PortHelper;
import org.graphper.layout.dot.SameRankAdjacentRecord;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

class RootCrossRank
implements CrossRank {
    private static final int MIN_CROSS_SCALE = 256;
    MinCross.ClusterOrder clusterOrder;
    private final DrawGraph drawGraph;
    private final BasicCrossRank root;
    private BasicCrossRank childCrossRank;
    private Map<Integer, Integer> rankStartIndex;
    private final EdgeDedigraph<DNode, DLine> digraphProxy;
    private final Map<Integer, RankCrossCache> rankCrossCacheMap;
    private SameRankAdjacentRecord sameRankAdjacentRecord;

    RootCrossRank(DrawGraph drawGraph) {
        Asserts.nullArgument(drawGraph, "drawGraph");
        this.drawGraph = drawGraph;
        this.root = new BasicCrossRank(drawGraph.getGraphviz());
        this.digraphProxy = new DedirectedEdgeGraph<DNode, DLine>();
        this.rankCrossCacheMap = new HashMap<Integer, RankCrossCache>();
    }

    RootCrossRank(DrawGraph drawGraph, EdgeDedigraph<DNode, DLine> digraphProxy) {
        Asserts.nullArgument(drawGraph, "drawGraph");
        Asserts.nullArgument(digraphProxy, "digraphProxy");
        this.drawGraph = drawGraph;
        this.root = new BasicCrossRank(drawGraph.getGraphviz());
        this.digraphProxy = digraphProxy;
        this.rankCrossCacheMap = new HashMap<Integer, RankCrossCache>();
        for (DNode node : digraphProxy) {
            this.addNode(node, Boolean.FALSE);
        }
    }

    void setBasicCrossRank(BasicCrossRank basicCrossRank) {
        if (basicCrossRank == this.childCrossRank) {
            return;
        }
        this.childCrossRank = basicCrossRank;
        this.setCacheExpired();
    }

    void setCacheExpired() {
        for (int i = this.minRank(); i <= this.maxRank(); ++i) {
            this.setCacheExpired(i);
        }
    }

    void setSameRankAdjacentRecord(SameRankAdjacentRecord sameRankAdjacentRecord) {
        this.sameRankAdjacentRecord = sameRankAdjacentRecord;
    }

    EdgeDedigraph<DNode, DLine> getDigraphProxy() {
        return this.digraphProxy;
    }

    BasicCrossRank getBasicCrossRank() {
        return this.childCrossRank != null ? this.childCrossRank : this.root;
    }

    SameRankAdjacentRecord getSameRankAdjacentRecord() {
        return this.sameRankAdjacentRecord;
    }

    @Override
    public int getRankIndex(DNode node) {
        if (this.childCrossRank == null) {
            return this.root.getRankIndex(node);
        }
        Integer idx = this.childCrossRank.safeGetRankIndex(node);
        if (idx == null) {
            return this.root.getRankIndex(node);
        }
        return this.getChildRankStartIndex(node.getRank()) + idx;
    }

    @Override
    public Integer safeGetRankIndex(DNode node) {
        if (this.childCrossRank == null) {
            return this.root.safeGetRankIndex(node);
        }
        Integer idx = this.childCrossRank.safeGetRankIndex(node);
        if (idx != null) {
            return this.getChildRankStartIndex(node.getRank()) + idx;
        }
        return this.root.safeGetRankIndex(node);
    }

    @Override
    public DNode getNode(int rank, int rankIdx) {
        if (this.childCrossRank == null) {
            return this.root.getNode(rank, rankIdx);
        }
        int rootRankIndex = this.getChildRankStartIndex(rank);
        if (rankIdx < rootRankIndex || rankIdx >= rootRankIndex + this.childCrossRank.rankSize(rank)) {
            return this.root.getNode(rank, rankIdx);
        }
        return this.childCrossRank.getNode(rank, rankIdx - rootRankIndex);
    }

    @Override
    public int rankSize(int rank) {
        return this.root.rankSize(rank);
    }

    @Override
    public int minRank() {
        return this.root.minRank();
    }

    @Override
    public int maxRank() {
        return this.root.maxRank();
    }

    @Override
    public void exchange(DNode v, DNode w) {
        this.crossRank().exchange(v, w);
    }

    @Override
    public void sort(Comparator<DNode> comparator) {
        if (this.childCrossRank != null) {
            this.childCrossRank.sort(comparator);
        } else {
            this.root.sort(comparator);
        }
    }

    @Override
    public void sort(int rank, Comparator<DNode> comparator) {
        if (this.childCrossRank != null) {
            this.childCrossRank.sort(rank, comparator);
        } else {
            this.root.sort(rank, comparator);
        }
    }

    @Override
    public GraphContainer container() {
        return this.root.container;
    }

    @Override
    public void addNode(DNode node) {
        this.addNode(node, Boolean.TRUE);
    }

    void addNode(DNode node, boolean proxyGraphAdd) {
        if (proxyGraphAdd) {
            this.digraphProxy.add(node);
        }
        this.root.addNode(node);
    }

    void addEdge(DLine line) {
        this.digraphProxy.addEdge(line);
    }

    BasicCrossRank expand(ExpandInfoProvider expandInfoProvider) {
        Asserts.nullArgument(expandInfoProvider, "expandInfoProvider");
        Iterable<DNode> expandNodes = expandInfoProvider.expandNodes();
        if (expandNodes == null) {
            return null;
        }
        if (this.rankStartIndex == null) {
            this.rankStartIndex = new HashMap<Integer, Integer>();
        } else {
            this.rankStartIndex.clear();
        }
        BasicCrossRank basicCrossRank = new BasicCrossRank(expandInfoProvider.container());
        for (DNode expandNode : expandNodes) {
            this.digraphProxy.remove(expandNode);
            List<DNode> nodes = this.root.rankNode.get(expandNode.getRank());
            Asserts.illegalArgument(CollectionUtils.isEmpty(nodes), "Illegal expand node, root not contain");
            Iterable<DNode> replaceNodes = expandInfoProvider.replaceNodes(expandNode);
            if (replaceNodes == null) continue;
            int i = 0;
            int rankIndex = this.root.getRankIndex(expandNode);
            this.rankStartIndex.put(expandNode.getRank(), rankIndex);
            for (DNode replaceNode : replaceNodes) {
                if (i == 0) {
                    nodes.set(rankIndex, replaceNode);
                    this.root.nodeRankIndex.remove(expandNode);
                } else {
                    nodes.add(rankIndex + i, replaceNode);
                }
                this.root.nodeRankIndex.put(replaceNode, rankIndex + i);
                basicCrossRank.addNode(replaceNode);
                ++i;
            }
            for (int j = rankIndex + i; j < nodes.size(); ++j) {
                this.root.nodeRankIndex.put(nodes.get(j), j);
            }
        }
        this.setBasicCrossRank(basicCrossRank);
        return basicCrossRank;
    }

    void syncChildOrder() {
        if (this.childCrossRank == null) {
            return;
        }
        for (int i = this.childCrossRank.minRank(); i <= this.childCrossRank.maxRank(); ++i) {
            int rankSize = this.childCrossRank.rankSize(i);
            int rankStartIdx = this.getChildRankStartIndex(i);
            for (int j = 0; j < rankSize; ++j) {
                DNode node = this.childCrossRank.getNode(i, j);
                this.root.exchange(node, this.root.getNode(i, rankStartIdx + j));
            }
        }
    }

    void vmedian(int i) {
        Consumer<DNode> positiveAction = v -> {
            double v1 = this.medianValue((DNode)v, true);
            v.setMedian(v1);
        };
        Consumer<DNode> reverseAction = v -> {
            double v1 = this.medianValue((DNode)v, false);
            v.setMedian(v1);
        };
        IntConsumer rankIndexAction = this::sortRankVertex;
        this.accessRankNode(i, positiveAction, reverseAction, rankIndexAction);
    }

    void adjPostion(Consumer<DNode> adjAction, DNode node, final boolean direction, boolean isProxy) {
        Objects.requireNonNull(adjAction);
        Objects.requireNonNull(node);
        Predicate<DNode> nodeAction = v -> {
            if (!isProxy && v.isVirtual()) {
                class NodeAction
                implements Predicate<DNode> {
                    private DNode adjRealNode;

                    NodeAction() {
                    }

                    @Override
                    public boolean test(DNode vertex) {
                        if (vertex.isVirtual()) {
                            RootCrossRank.this.adjNodeAccess(direction, vertex, this);
                        } else {
                            this.adjRealNode = vertex;
                        }
                        return false;
                    }

                    public DNode getAdjRealNode() {
                        return this.adjRealNode;
                    }
                }
                NodeAction action = new NodeAction();
                this.adjNodeAccess(direction, (DNode)v, action);
                v = action.getAdjRealNode();
            }
            adjAction.accept((DNode)v);
            return true;
        };
        this.adjNodeAccess(direction, node, nodeAction);
    }

    void transpose(boolean reverse) {
        int delta;
        do {
            delta = 0;
            for (int j = this.calcCrossRank().minRank(); j <= this.calcCrossRank().maxRank(); ++j) {
                delta += this.transposeStep(j, reverse);
            }
        } while (delta >= true);
    }

    int currentCrossNum() {
        this.setCacheExpired();
        int num = 0;
        for (int i = this.minRank(); i <= this.maxRank(); ++i) {
            RankCrossCache rankCrossCache = this.getRankCacheIfAbsent(i);
            if (rankCrossCache.effective) {
                num += rankCrossCache.crossNum;
                continue;
            }
            rankCrossCache.crossNum = this.computeCrossNum(i);
            rankCrossCache.effective = true;
            num += rankCrossCache.crossNum;
        }
        return num;
    }

    private double medianValue(DNode v, boolean direction) {
        double right;
        List<Double> positions = this.adjPostion(v, direction);
        if (CollectionUtils.isEmpty(positions)) {
            return -1.0;
        }
        if (positions.size() == 1) {
            return positions.get(0);
        }
        if (positions.size() == 2) {
            return (positions.get(0) + positions.get(1)) / 2.0;
        }
        positions.sort(Double::compareTo);
        int rightIndex = positions.size() / 2;
        if (positions.size() % 2 == 1) {
            return positions.get(rightIndex);
        }
        Double l = positions.get(rightIndex - 1);
        Double r = positions.get(rightIndex);
        double left = l - positions.get(0);
        if (left == (right = positions.get(positions.size() - 1) - r)) {
            return (l + r) / 2.0;
        }
        return (l * right + r * left) / (left + right);
    }

    private List<Double> adjPostion(DNode v, boolean direction) {
        ArrayList<Double> positions = new ArrayList<Double>();
        Consumer<DNode> adjAction = vertex -> positions.add((double)this.getRankIndex((DNode)vertex) * 256.0);
        this.adjPostion(adjAction, v, direction, true);
        return positions;
    }

    private void accessRankNode(int i, Consumer<DNode> positiveAction, Consumer<DNode> reverseAction, IntConsumer rankIndexAction) {
        Objects.requireNonNull(positiveAction);
        Objects.requireNonNull(reverseAction);
        if (i % 2 == 0) {
            for (int j = this.calcCrossRank().minRank(); j <= this.calcCrossRank().maxRank(); ++j) {
                this.rankNodesHandle(positiveAction, rankIndexAction, j);
            }
        } else {
            for (int j = this.calcCrossRank().maxRank(); j >= this.calcCrossRank().minRank(); --j) {
                this.rankNodesHandle(reverseAction, rankIndexAction, j);
            }
        }
    }

    private void rankNodesHandle(Consumer<DNode> positiveAction, IntConsumer rankIndexAction, int rank) {
        if (this.calcCrossRank().rankSize(rank) <= 1) {
            return;
        }
        for (int i = 0; i < this.calcCrossRank().rankSize(rank); ++i) {
            positiveAction.accept(this.calcCrossRank().getNode(rank, i));
        }
        if (rankIndexAction != null) {
            rankIndexAction.accept(rank);
        }
    }

    private int transposeStep(int rank, boolean reverse) {
        int[] leftCrossRecord = new int[3];
        int[] rightCrossRecord = new int[3];
        int rv = 0;
        for (int i = 0; i < this.calcCrossRank().rankSize(rank) - 1; ++i) {
            DNode w;
            DNode v = this.calcCrossRank().getNode(rank, i);
            if (!this.canExchange(v, w = this.calcCrossRank().getNode(rank, i + 1))) continue;
            this.crossing(v, w, leftCrossRecord);
            this.crossing(w, v, rightCrossRecord);
            if (leftCrossRecord[2] == rightCrossRecord[2] && i > 0 && !this.canExchange(this.calcCrossRank().getNode(rank, i - 1), v) || leftCrossRecord[2] <= rightCrossRecord[2] && (leftCrossRecord[2] <= 0 || !reverse || leftCrossRecord[2] != rightCrossRecord[2])) continue;
            rv += leftCrossRecord[2] - rightCrossRecord[2];
            this.exchange(v, w);
            this.setCacheExpired(rank);
        }
        return rv;
    }

    private void setCacheExpired(int rank) {
        RankCrossCache rankCrossCache = this.rankCrossCacheMap.get(rank);
        if (rankCrossCache == null) {
            return;
        }
        rankCrossCache.effective = false;
        rankCrossCache = this.rankCrossCacheMap.get(rank - 1);
        if (rankCrossCache == null) {
            return;
        }
        rankCrossCache.effective = false;
    }

    private boolean canExchange(DNode left, DNode right) {
        if (this.sameRankAdjacentRecord == null && this.clusterOrder == null) {
            return true;
        }
        if (this.sameRankAdjacentRecord != null) {
            boolean haveSameAdj = this.sameRankAdjacentRecord.outContains(left, right);
            if (haveSameAdj) {
                return false;
            }
            Integer leftIdx = this.childCrossRank.safeGetRankIndex(left);
            if (leftIdx == null) {
                return true;
            }
            Set<DNode> inAdjs = this.sameRankAdjacentRecord.inAdjacent(right);
            for (DNode in : inAdjs) {
                Integer idx = this.childCrossRank.safeGetRankIndex(in);
                if (idx == null || idx <= leftIdx) continue;
                return false;
            }
        }
        if (this.clusterOrder == null) {
            return true;
        }
        Integer leftClusterOrder = this.clusterOrder.getNodeOrder(left);
        if (leftClusterOrder == null) {
            return true;
        }
        Integer rightClusterOrder = this.clusterOrder.getNodeOrder(right);
        if (rightClusterOrder == null) {
            return true;
        }
        return leftClusterOrder > rightClusterOrder;
    }

    private void adjNodeAccess(boolean direction, DNode node, Predicate<DNode> nodeActionAndReturnNeedContinue) {
        DLine line;
        DNode vertexInfo;
        Iterable<DLine> dLines = direction ? this.digraphProxy.inAdjacent(node) : this.digraphProxy.outAdjacent(node);
        Iterator<DLine> iterator = dLines.iterator();
        while (iterator.hasNext() && !Objects.equals(nodeActionAndReturnNeedContinue.test(vertexInfo = (line = iterator.next()).other(node)), Boolean.FALSE)) {
        }
    }

    private void sortRankVertex(int rank) {
        int endIndex = this.calcCrossRank().rankSize(rank) - 1;
        block0: for (int i = rank; i <= endIndex; ++i) {
            int left = 0;
            while (left < endIndex) {
                double rm;
                int right;
                DNode leftNode = this.calcCrossRank().getNode(rank, left);
                DNode rightNode = null;
                while (left < endIndex && leftNode.getMedian() < 0.0) {
                    ++left;
                }
                if (left >= endIndex) continue block0;
                boolean canExchange = true;
                for (right = left + 1; right <= endIndex; ++right) {
                    rightNode = this.calcCrossRank().getNode(rank, right);
                    if (!this.canExchange(leftNode, rightNode)) {
                        canExchange = false;
                        break;
                    }
                    if (rightNode.getMedian() >= 0.0) break;
                }
                if (right > endIndex) continue block0;
                double lm = leftNode.getMedian();
                if (lm >= (rm = rightNode.getMedian()) && canExchange) {
                    this.setCacheExpired(rank);
                    this.exchange(leftNode, rightNode);
                }
                left = right;
            }
        }
    }

    private void crossing(DNode left, DNode right, int[] result) {
        int rightSortIndex;
        boolean needExchange;
        int h = left.getRank();
        if (h != right.getRank()) {
            throw new IllegalArgumentException("Inconsistent hierarchy of vertices," + left + "," + right);
        }
        int leftSortIndex = this.calcCrossRank().getRankIndex(left);
        boolean bl = needExchange = leftSortIndex > (rightSortIndex = this.calcCrossRank().getRankIndex(right));
        if (needExchange) {
            this.exchange(left, right);
        }
        if (h != this.minRank()) {
            result[0] = this.inCross(left, right);
        }
        if (h != this.maxRank()) {
            result[1] = this.outCross(left, right);
        }
        result[2] = result[0] + result[1];
        if (needExchange) {
            this.exchange(left, right);
        }
    }

    private RankCrossCache getRankCacheIfAbsent(int rank) {
        return this.rankCrossCacheMap.computeIfAbsent(rank, r -> new RankCrossCache());
    }

    private int computeCrossNum(int rank) {
        int crossNum = 0;
        int rankSize = this.rankSize(rank);
        for (int i = 0; i < rankSize; ++i) {
            DNode current = this.getNode(rank, i);
            for (int j = i + 1; j < rankSize; ++j) {
                DNode next = this.getNode(rank, j);
                Iterable<DLine> curIter = this.digraphProxy.outAdjacent(current);
                Iterable<DLine> nextIter = this.digraphProxy.outAdjacent(next);
                for (DLine curAdjLine : curIter) {
                    for (DLine nextAdjLine : nextIter) {
                        if (!this.isCross(curAdjLine, nextAdjLine)) continue;
                        ++crossNum;
                    }
                }
            }
        }
        return crossNum;
    }

    private int inCross(DNode n, DNode w) {
        int count = 0;
        for (DLine l1 : this.digraphProxy.inAdjacent(n)) {
            for (DLine l2 : this.digraphProxy.inAdjacent(w)) {
                if (!this.isCross(l1, l2)) continue;
                ++count;
            }
        }
        return count;
    }

    private int outCross(DNode n, DNode w) {
        int count = 0;
        for (DLine l1 : this.digraphProxy.outAdjacent(n)) {
            for (DLine l2 : this.digraphProxy.outAdjacent(w)) {
                if (!this.isCross(l1, l2)) continue;
                ++count;
            }
        }
        return count;
    }

    private boolean isCross(DLine line1, DLine line2) {
        boolean line2InSameRank;
        DNode u = (DNode)line1.from();
        DNode x = (DNode)line1.to();
        DNode v = (DNode)line2.from();
        DNode y = (DNode)line2.to();
        if (u == v || u == y || x == v || x == y) {
            if (u == v == (x == y)) {
                return false;
            }
            if (u == v) {
                double up = this.getCompareNo(line1, u);
                double vp = this.getCompareNo(line2, v);
                if (x.getRank() == u.getRank()) {
                    return this.comparePointX(up, vp) < 0 == this.getRankIndex(x) < this.getRankIndex(y);
                }
                return this.locationTag(up, vp) * this.locationTag(y, x) + this.locationTag(vp, up) * this.locationTag(x, y) == 1;
            }
            double xp = this.getCompareNo(line1, x);
            double yp = this.getCompareNo(line2, y);
            if (u.getRank() == x.getRank()) {
                return this.comparePointX(xp, yp) < 0 == this.getRankIndex(u) < this.getRankIndex(v);
            }
            return this.locationTag(u, v) * this.locationTag(yp, xp) + this.locationTag(v, u) * this.locationTag(xp, yp) == 1;
        }
        boolean line1InSameRank = u.getRank() == x.getRank();
        boolean bl = line2InSameRank = v.getRank() == y.getRank();
        if (line1InSameRank || line2InSameRank) {
            return false;
        }
        return this.locationTag(u, v) * this.locationTag(y, x) + this.locationTag(v, u) * this.locationTag(x, y) == 1;
    }

    private int locationTag(DNode v, DNode w) {
        return this.getRankIndex(v) < this.getRankIndex(w) ? 1 : 0;
    }

    private int locationTag(double o1, double o2) {
        return o1 < o2 ? 1 : 0;
    }

    private double getCompareNo(DLine line, DNode node) {
        return PortHelper.portCompareNo(line.getLine(), node, this.drawGraph);
    }

    private int comparePointX(double p1, double p2) {
        return Double.compare(p1, p2);
    }

    private CrossRank crossRank() {
        if (this.childCrossRank != null) {
            return this.childCrossRank;
        }
        return this.root;
    }

    private CrossRank calcCrossRank() {
        if (this.childCrossRank != null) {
            return this.childCrossRank;
        }
        return this;
    }

    private int getChildRankStartIndex(int rank) {
        Integer idx;
        if (this.childCrossRank == null || this.rankStartIndex == null || (idx = this.rankStartIndex.get(rank)) == null) {
            return 0;
        }
        return idx;
    }

    private static class RankCrossCache
    implements Cloneable {
        private int crossNum;
        private boolean effective;

        private RankCrossCache() {
        }

        protected RankCrossCache clone() {
            try {
                return (RankCrossCache)super.clone();
            }
            catch (CloneNotSupportedException e) {
                RankCrossCache crossCache = new RankCrossCache();
                crossCache.crossNum = this.crossNum;
                crossCache.effective = this.effective;
                return crossCache;
            }
        }
    }

    static interface ExpandInfoProvider {
        public Iterable<DNode> expandNodes();

        public Iterable<DNode> replaceNodes(DNode var1);

        public GraphContainer container();
    }
}

