/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.graphper.api.LineAttrs;
import org.graphper.api.attributes.Splines;
import org.graphper.def.Curves;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.dot.AbstractDotLineRouter;
import org.graphper.layout.dot.BoxGuideLineRouter;
import org.graphper.layout.dot.CurveFitBoxRouter;
import org.graphper.layout.dot.RouterBox;
import org.graphper.util.CollectionUtils;

class RoundedRouter
extends CurveFitBoxRouter {
    RoundedRouter() {
    }

    @Override
    public boolean needDeal(Splines splines) {
        return splines == Splines.ROUNDED && super.needDeal(splines);
    }

    @Override
    protected boolean curveLine() {
        return true;
    }

    @Override
    protected void throughPointHandle(BoxGuideLineRouter.ThroughParam throughParam) {
        LineAttrs lineAttrs = this.drawGraph.getLineDrawProp(throughParam.line).lineAttrs();
        List<BoxGuideLineRouter.ThroughPoint> throughPoints = throughParam.throughPoints;
        LineDrawProp lineDrawProp = throughParam.lineDrawProp;
        lineDrawProp.markIsBesselCurve();
        if (CollectionUtils.isEmpty(throughParam.throughPoints)) {
            this.lineDrawPropConnect(lineDrawProp, throughParam.fromPortPoints, true);
            this.lineDrawPropConnect(lineDrawProp, throughParam.toPortPoints, false);
            return;
        }
        if (throughPoints.size() <= 2) {
            BoxGuideLineRouter.ThroughPoint first = throughPoints.get(0);
            BoxGuideLineRouter.ThroughPoint last = throughPoints.get(throughPoints.size() - 1);
            lineDrawProp.add(first);
            lineDrawProp.add(first);
            lineDrawProp.add(last);
            lineDrawProp.add(last);
            this.lineDrawPropConnect(lineDrawProp, throughParam.fromPortPoints, true);
            this.lineDrawPropConnect(lineDrawProp, throughParam.toPortPoints, false);
            return;
        }
        BoxGuideLineRouter.ThroughPoint pre = null;
        BoxGuideLineRouter.ThroughPoint prepre = null;
        double radian = lineAttrs.getRadian() != null ? lineAttrs.getRadian() : 10.0;
        for (int i = 2; i < throughPoints.size(); ++i) {
            BoxGuideLineRouter.ThroughPoint p1 = prepre == null ? throughPoints.get(i - 2) : prepre;
            BoxGuideLineRouter.ThroughPoint p2 = pre == null ? throughPoints.get(i - 1) : pre;
            BoxGuideLineRouter.ThroughPoint p3 = throughPoints.get(i);
            if (prepre == null) {
                prepre = p1;
                lineDrawProp.add(p1);
            }
            if (this.isCorner(p1, p2, p3)) {
                BoxGuideLineRouter.ThroughPoint rt;
                Curves.ThirdOrderBezierCurve corner = null;
                BoxGuideLineRouter.ThroughPoint lt = this.getLeftTangle(lineDrawProp);
                Curves.MultiBezierCurve curves = this.getCorner(lt, p1, p2, p3, rt = i < throughPoints.size() - 1 ? throughPoints.get(i + 1) : null, radian, throughParam.lineRouterBoxes);
                if (curves.size() == 1) {
                    lineDrawProp.add(p1);
                }
                for (Curves.ThirdOrderBezierCurve curve : curves) {
                    if (corner == null && curves.size() == 1) {
                        lineDrawProp.add(curve.getV1());
                        lineDrawProp.add(curve.getV1());
                    }
                    lineDrawProp.add(curve.getV2());
                    lineDrawProp.add(curve.getV3());
                    lineDrawProp.add(curve.getV4());
                    corner = curve;
                }
                if (corner != null) {
                    prepre = new BoxGuideLineRouter.ThroughPoint(corner.getV4());
                    pre = p3;
                }
                if (corner == null || i != throughPoints.size() - 1) continue;
                lineDrawProp.add(corner.getV4());
                lineDrawProp.add(p3);
                lineDrawProp.add(p3);
                continue;
            }
            if (i == throughPoints.size() - 1) {
                lineDrawProp.add(p1);
                lineDrawProp.add(p3);
                lineDrawProp.add(p3);
                continue;
            }
            pre = p3;
        }
        this.lineDrawPropConnect(lineDrawProp, throughParam.fromPortPoints, true);
        this.lineDrawPropConnect(lineDrawProp, throughParam.toPortPoints, false);
    }

    private Curves.MultiBezierCurve getCorner(BoxGuideLineRouter.ThroughPoint lt, BoxGuideLineRouter.ThroughPoint p1, BoxGuideLineRouter.ThroughPoint p2, BoxGuideLineRouter.ThroughPoint p3, BoxGuideLineRouter.ThroughPoint rt, double radian, List<RouterBox> lineRouterBoxes) {
        double d1 = FlatPoint.twoFlatPointDistance(p1, p2);
        double d2 = FlatPoint.twoFlatPointDistance(p2, p3);
        if (d1 < radian || d2 < radian) {
            Curves.MultiBezierCurve curves = Curves.fitCurves(Arrays.asList(p1, p3), lt != null ? Vectors.sub(p2, lt) : null, rt != null ? Vectors.sub(p3, rt) : null, 0.0);
            return this.checkFixBox(lineRouterBoxes, curves);
        }
        FlatPoint dir = Vectors.sub(p2, p1);
        double ratio = (d1 - radian) / d1;
        FlatPoint v1 = Vectors.add(p1, Vectors.multiple(dir, ratio));
        ratio = (d1 - radian / 2.0) / d1;
        FlatPoint v2 = Vectors.add(p1, Vectors.multiple(dir, ratio));
        dir = Vectors.sub(p2, p3);
        ratio = (d2 - radian) / d2;
        FlatPoint v4 = Vectors.add(p3, Vectors.multiple(dir, ratio));
        ratio = (d2 - radian / 2.0) / d2;
        FlatPoint v3 = Vectors.add(p3, Vectors.multiple(dir, ratio));
        Curves.MultiBezierCurve thirdOrderBezierCurves = new Curves.MultiBezierCurve(1);
        thirdOrderBezierCurves.add(new Curves.ThirdOrderBezierCurve(v1, v2, v3, v4));
        return thirdOrderBezierCurves;
    }

    private Curves.MultiBezierCurve checkFixBox(List<RouterBox> lineRouterBoxes, Curves.MultiBezierCurve curves) {
        CurveFitBoxRouter.SplineFitInfo splineFitInfo = this.splineIsFit(curves, lineRouterBoxes, 0, lineRouterBoxes.size() - 1, false);
        if (splineFitInfo.isFit()) {
            return curves;
        }
        int count = 0;
        do {
            this.refineSpline(splineFitInfo);
        } while (!(splineFitInfo = this.splineIsFit(curves, lineRouterBoxes, 0, lineRouterBoxes.size() - 1, true)).isFit() && ++count <= 24);
        return curves;
    }

    private boolean isCorner(BoxGuideLineRouter.ThroughPoint p1, BoxGuideLineRouter.ThroughPoint p2, BoxGuideLineRouter.ThroughPoint p3) {
        double slope2;
        if (p1 == null || p2 == null || p3 == null) {
            return false;
        }
        if (Objects.equals(p1, p2) || Objects.equals(p2, p3) || Objects.equals(p1, p3)) {
            return false;
        }
        if (p1.similarX(p2.getX(), 1.0) && p1.similarX(p3.getX(), 1.0) && p2.similarX(p3.getX(), 1.0)) {
            return false;
        }
        if (p1.similarY(p2.getY(), 1.0) && p1.similarY(p3.getY(), 1.0) && p2.similarY(p3.getY(), 1.0)) {
            return false;
        }
        double slope1 = (p1.getY() - p2.getY()) / (p1.getX() - p2.getX());
        return Math.abs(slope1 - (slope2 = (p3.getY() - p2.getY()) / (p3.getX() - p2.getX()))) > 0.06;
    }

    private BoxGuideLineRouter.ThroughPoint getLeftTangle(LineDrawProp lineDrawProp) {
        if (lineDrawProp.size() <= 3) {
            return null;
        }
        FlatPoint v4 = (FlatPoint)lineDrawProp.get(lineDrawProp.size() - 1);
        FlatPoint v3 = (FlatPoint)lineDrawProp.get(lineDrawProp.size() - 2);
        FlatPoint v2 = (FlatPoint)lineDrawProp.get(lineDrawProp.size() - 3);
        return new BoxGuideLineRouter.ThroughPoint(v3.equals(v4) ? v2 : v3);
    }

    static class RoundedRouterFactory
    extends AbstractDotLineRouter.AbstractDotLineRouterFactory<RoundedRouter> {
        RoundedRouterFactory() {
        }

        @Override
        protected RoundedRouter newInstance() {
            return new RoundedRouter();
        }
    }
}

