/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.io.Serializable;
import org.graphper.api.ext.DefaultBox;
import org.graphper.def.FlatPoint;
import org.graphper.layout.dot.DNode;
import org.graphper.util.Asserts;

public class RouterBox
extends DefaultBox
implements Serializable {
    private static final long serialVersionUID = 578785652705131390L;
    private final DNode node;

    public RouterBox(double leftBorder, double rightBorder, double upBorder, double downBorder) {
        this(leftBorder, rightBorder, upBorder, downBorder, null);
    }

    public RouterBox(double leftBorder, double rightBorder, double upBorder, double downBorder, DNode node) {
        super(leftBorder, rightBorder, upBorder, downBorder);
        this.node = node;
    }

    @Override
    public void setLeftBorder(double leftBorder) {
        Asserts.illegalArgument(leftBorder > this.rightBorder, "Box's right wall must be greater than left wall");
        super.setLeftBorder(leftBorder);
    }

    @Override
    public void setRightBorder(double rightBorder) {
        Asserts.illegalArgument(this.leftBorder > rightBorder, "Box's right wall must be greater than left wall");
        super.setRightBorder(rightBorder);
    }

    @Override
    public void setUpBorder(double upBorder) {
        Asserts.illegalArgument(upBorder > this.downBorder, "Box's down wall must be greater than up wall");
        super.setUpBorder(upBorder);
    }

    @Override
    public void setDownBorder(double downBorder) {
        Asserts.illegalArgument(this.upBorder > downBorder, "Box's down wall must be greater than up wall");
        super.setDownBorder(downBorder);
    }

    boolean inXRange(double x) {
        return RouterBox.inRange(this.leftBorder, this.rightBorder, x);
    }

    boolean inYRange(double y) {
        return RouterBox.inRange(this.upBorder, this.downBorder, y);
    }

    boolean in(FlatPoint point) {
        if (point == null) {
            return false;
        }
        return this.inXRange(point.getX()) && this.inYRange(point.getY());
    }

    double closerVerWall(double x) {
        if (x < this.leftBorder) {
            return this.leftBorder;
        }
        if (x > this.rightBorder) {
            return this.rightBorder;
        }
        if (x - this.leftBorder <= this.rightBorder - x) {
            return this.leftBorder;
        }
        return this.rightBorder;
    }

    double closerHorWall(double y) {
        if (y < this.upBorder) {
            return this.upBorder;
        }
        if (y > this.downBorder) {
            return this.downBorder;
        }
        if (y - this.upBorder <= this.downBorder - y) {
            return this.upBorder;
        }
        return this.downBorder;
    }

    public static boolean inRange(double left, double right, double num) {
        return num <= right && num >= left;
    }

    public void minGuarantee(double minWidth, double minHeight) {
        if (this.getWidth() < minWidth) {
            this.leftBorder = this.rightBorder - minWidth;
        }
        if (this.getHeight() < minHeight) {
            this.upBorder = this.downBorder - minHeight;
        }
    }

    public void reducePublicArea(RouterBox target, boolean isHor) {
        if (isHor) {
            if (this.inXRange(target.getLeftBorder())) {
                this.rightBorder = target.getLeftBorder() - 1.0;
                this.leftBorder = Math.min(this.leftBorder, this.rightBorder);
            }
            if (this.inXRange(target.getRightBorder())) {
                this.leftBorder = target.getRightBorder() + 1.0;
                this.rightBorder = Math.max(this.leftBorder, this.rightBorder);
            }
        } else {
            if (this.inYRange(target.getUpBorder())) {
                this.downBorder = target.getUpBorder() - 1.0;
                this.upBorder = Math.min(this.upBorder, this.downBorder);
            }
            if (this.inYRange(target.getDownBorder())) {
                this.upBorder = target.getDownBorder() + 1.0;
                this.downBorder = Math.max(this.upBorder, this.downBorder);
            }
        }
    }

    DNode getNode() {
        return this.node;
    }
}

