/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.util.CollectionUtils;

class SameRankAdjacentRecord {
    private Map<DNode, SameRankAdjacentInfo> outSameRankAdjacent;
    private Map<DNode, SameRankAdjacentInfo> inSameRankRecord;

    SameRankAdjacentRecord() {
    }

    public Map<DNode, SameRankAdjacentInfo> getOutSameRankAdjacent() {
        return this.outSameRankAdjacent;
    }

    void addOutAdjacent(DNode node, DLine line) {
        if (this.outSameRankAdjacent == null || line.other(node) == null) {
            this.outSameRankAdjacent = new HashMap<DNode, SameRankAdjacentInfo>();
        }
        SameRankAdjacentInfo sameRankAdjacentInfo = this.outSameRankAdjacent.computeIfAbsent(node, n -> new SameRankAdjacentInfo());
        if (!this.outContains(line.other(node), node)) {
            if (sameRankAdjacentInfo.nodes == null) {
                sameRankAdjacentInfo.nodes = new TreeSet<DNode>(Comparator.comparing(DNode::getNode));
            }
            sameRankAdjacentInfo.nodes.add(line.other(node));
            if (sameRankAdjacentInfo.lines == null) {
                sameRankAdjacentInfo.lines = new ArrayList<DLine>();
            }
            sameRankAdjacentInfo.lines.add(line);
            this.addInAdjacent(line.other(node), line);
        } else {
            this.addOutAdjacent(line.other(node), line);
        }
    }

    void addInAdjacent(DNode node, DLine line) {
        if (this.inSameRankRecord == null) {
            this.inSameRankRecord = new HashMap<DNode, SameRankAdjacentInfo>();
        }
        SameRankAdjacentInfo sameRankAdjacentInfo = this.inSameRankRecord.computeIfAbsent(node, n -> new SameRankAdjacentInfo());
        if (sameRankAdjacentInfo.nodes == null) {
            sameRankAdjacentInfo.nodes = new TreeSet<DNode>(Comparator.comparing(DNode::getNode));
        }
        sameRankAdjacentInfo.nodes.add(line.other(node));
        if (sameRankAdjacentInfo.lines == null) {
            sameRankAdjacentInfo.lines = new ArrayList<DLine>();
        }
        sameRankAdjacentInfo.lines.add(line);
    }

    void clearMarkIn() {
        if (this.inSameRankRecord != null) {
            this.inSameRankRecord.clear();
        }
    }

    boolean outContains(DNode node, DNode outNode) {
        if (outNode.isVirtual()) {
            return false;
        }
        if (this.outSameRankAdjacent == null) {
            return false;
        }
        SameRankAdjacentInfo sameRankAdjacentInfo = this.outSameRankAdjacent.get(node);
        if (sameRankAdjacentInfo == null) {
            return false;
        }
        Set<DNode> adjacent = sameRankAdjacentInfo.nodes;
        if (CollectionUtils.isEmpty(adjacent)) {
            return false;
        }
        return adjacent.contains(outNode);
    }

    Set<DNode> outAdjacent(DNode node) {
        if (this.outSameRankAdjacent == null) {
            return Collections.emptySet();
        }
        SameRankAdjacentInfo sameRankAdjacentInfo = this.outSameRankAdjacent.get(node);
        if (sameRankAdjacentInfo == null) {
            return Collections.emptySet();
        }
        Set<DNode> adjacent = sameRankAdjacentInfo.nodes;
        if (CollectionUtils.isEmpty(adjacent)) {
            return Collections.emptySet();
        }
        return adjacent;
    }

    Set<DNode> inAdjacent(DNode node) {
        if (this.outSameRankAdjacent == null) {
            return Collections.emptySet();
        }
        SameRankAdjacentInfo sameRankAdjacentInfo = this.inSameRankRecord.get(node);
        if (sameRankAdjacentInfo == null) {
            return Collections.emptySet();
        }
        Set<DNode> adjacent = sameRankAdjacentInfo.nodes;
        if (CollectionUtils.isEmpty(adjacent)) {
            return Collections.emptySet();
        }
        return adjacent;
    }

    boolean haveSameRank() {
        return this.outSameRankAdjacent != null;
    }

    boolean haveOut(DNode node) {
        return CollectionUtils.isNotEmpty(this.outAdjacent(node));
    }

    boolean haveIn(DNode node) {
        if (this.inSameRankRecord == null) {
            return false;
        }
        return Objects.equals(this.inSameRankRecord.get(node), Boolean.TRUE);
    }

    static class SameRankAdjacentInfo {
        Set<DNode> nodes;
        List<DLine> lines;

        SameRankAdjacentInfo() {
        }
    }
}

