/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.Collections;
import java.util.List;
import org.graphper.api.attributes.Splines;
import org.graphper.def.Curves;
import org.graphper.def.FlatPoint;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.dot.AbstractDotLineRouter;
import org.graphper.layout.dot.BoxGuideLineRouter;
import org.graphper.layout.dot.CurveFitBoxRouter;
import org.graphper.layout.dot.RouterBox;
import org.graphper.util.CollectionUtils;

class SplineRouter
extends CurveFitBoxRouter {
    private SplineRouter() {
    }

    @Override
    public boolean needDeal(Splines splines) {
        return splines == Splines.SPLINE && super.needDeal(splines);
    }

    @Override
    protected boolean curveLine() {
        return true;
    }

    @Override
    protected void throughPointHandle(BoxGuideLineRouter.ThroughParam throughParam) {
        throughParam.lineDrawProp.clear();
        int pointStart = 0;
        FlatPoint rightVector = null;
        boolean isVerticalMode = false;
        List<BoxGuideLineRouter.ThroughPoint> throughPoints = throughParam.throughPoints;
        LineDrawProp lineDrawProp = throughParam.lineDrawProp;
        List<RouterBox> lineRouterBoxes = throughParam.lineRouterBoxes;
        for (int i = 0; i < throughPoints.size() - 1; ++i) {
            BoxGuideLineRouter.ThroughPoint start;
            FlatPoint leftVector;
            BoxGuideLineRouter.ThroughPoint next;
            BoxGuideLineRouter.ThroughPoint point = throughPoints.get(i);
            if (this.needVerticalOptimization(point, next = throughPoints.get(i + 1))) {
                if (isVerticalMode) continue;
                leftVector = rightVector == null ? null : rightVector.reserve();
                rightVector = new FlatPoint(0.0, -1.0);
                isVerticalMode = true;
                if (i == 0) continue;
                start = throughPoints.get(pointStart);
                this.addAllLineProp(lineDrawProp, this.computeSpline(throughPoints, lineRouterBoxes, leftVector, rightVector, pointStart, i, pointStart == 0 ? start.getBoxIndex() : start.getBoxIndex() + 1, point.getBoxIndex(), throughParam.isHorizontal));
                pointStart = i;
                continue;
            }
            if (!isVerticalMode) continue;
            start = throughPoints.get(pointStart);
            leftVector = rightVector.reserve();
            rightVector = new FlatPoint(0.0, -1.0);
            this.addAllLineProp(lineDrawProp, this.computeSpline(throughPoints, lineRouterBoxes, leftVector, rightVector, pointStart, i, pointStart == 0 ? start.getBoxIndex() : start.getBoxIndex() + 1, point.getBoxIndex(), throughParam.isHorizontal));
            pointStart = i;
            isVerticalMode = false;
        }
        BoxGuideLineRouter.ThroughPoint start = throughPoints.get(pointStart);
        this.addAllLineProp(lineDrawProp, this.computeSpline(throughPoints, lineRouterBoxes, rightVector == null ? null : rightVector.reserve(), null, pointStart, throughPoints.size() - 1, pointStart == 0 ? start.getBoxIndex() : start.getBoxIndex() + 1, lineRouterBoxes.size() - 1, throughParam.isHorizontal));
        throughPoints.clear();
        this.lineDrawPropConnect(lineDrawProp, throughParam.fromPortPoints, true);
        this.lineDrawPropConnect(lineDrawProp, throughParam.toPortPoints, false);
        lineDrawProp.markIsBesselCurve();
    }

    private void addAllLineProp(LineDrawProp lineDrawProp, List<FlatPoint> flatPoints) {
        int k;
        int n = k = CollectionUtils.isEmpty(lineDrawProp) ? 0 : 1;
        while (k < flatPoints.size()) {
            lineDrawProp.add(flatPoints.get(k));
            ++k;
        }
    }

    private boolean needVerticalOptimization(FlatPoint p1, FlatPoint p2) {
        return Math.abs(p1.getX() - p2.getX()) < 5.0 && p2.getY() - p1.getY() > this.drawGraph.getGraphviz().graphAttrs().getRankSep();
    }

    private List<FlatPoint> computeSpline(List<BoxGuideLineRouter.ThroughPoint> points, List<RouterBox> lineRouterBoxes, FlatPoint leftVector, FlatPoint rightVector, int pointStart, int pointEnd, int boxStart, int boxEnd, boolean isHorizontal) {
        if (CollectionUtils.isEmpty(points) || points.size() < 2) {
            return Collections.emptyList();
        }
        Curves.MultiBezierCurve curves = Curves.fitCurves(points.subList(pointStart, pointEnd + 1), leftVector, rightVector, 0.0);
        if (isHorizontal) {
            return this.multiBezierCurveToPoints(curves);
        }
        if (pointEnd - pointStart + 1 <= 2) {
            CurveFitBoxRouter.SplineFitInfo splineFitInfo;
            int count = 0;
            while (count++ < 24 && !(splineFitInfo = this.splineIsFit(curves, lineRouterBoxes, boxStart, boxEnd, false)).isFit()) {
                this.straightenSpline(splineFitInfo.curve);
            }
            return this.multiBezierCurveToPoints(curves);
        }
        CurveFitBoxRouter.SplineFitInfo splineFitInfo = this.splineIsFit(curves, lineRouterBoxes, boxStart, boxEnd, true);
        if (splineFitInfo.isFit()) {
            return this.multiBezierCurveToPoints(curves);
        }
        int count = 0;
        do {
            this.refineSpline(splineFitInfo);
        } while (!(splineFitInfo = this.splineIsFit(curves, lineRouterBoxes, boxStart, boxEnd, true)).isFit() && ++count <= 24);
        if (splineFitInfo.isFit()) {
            return this.multiBezierCurveToPoints(curves);
        }
        CurveFitBoxRouter.SplitInfo split = this.splineSplit(curves, lineRouterBoxes, points, pointStart, pointEnd, boxStart, boxEnd);
        if (split == null) {
            return this.multiBezierCurveToPoints(curves);
        }
        List<FlatPoint> leftSplines = this.computeSpline(points, lineRouterBoxes, leftVector, split.splitVector, pointStart, split.pointsSplitIndex, boxStart, split.boxSplitIndex, false);
        List<FlatPoint> rightSplines = this.computeSpline(points, lineRouterBoxes, split.splitVector.reserve(), rightVector, split.pointsSplitIndex, pointEnd, split.boxSplitIndex + 1, boxEnd, false);
        rightSplines.remove(0);
        leftSplines.addAll(rightSplines);
        return leftSplines;
    }

    public static class SplineRouterFactory
    extends AbstractDotLineRouter.AbstractDotLineRouterFactory<SplineRouter> {
        @Override
        protected SplineRouter newInstance() {
            return new SplineRouter();
        }
    }
}

