/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.graphper.api.GraphContainer;
import org.graphper.api.Node;
import org.graphper.api.Subgraph;
import org.graphper.api.attributes.Rank;
import org.graphper.def.Graph;
import org.graphper.def.UndirectedGraph;
import org.graphper.def.VertexIndex;
import org.graphper.draw.DrawGraph;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.layout.dot.SubgrahOppositRankException;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

class SubgraphMerge {
    private final DotAttachment dotAttachment;
    private final GraphContainer container;
    private final List<SubNode> subNodes;
    private Map<DNode, MergeNode> mergeNodeMap;
    private boolean haveBorderNode;
    private static final SubgraphMerge EMPTY_SUBGRAPH_MERGE = new SubgraphMerge(null, null, null);

    private SubgraphMerge(GraphContainer container, List<SubNode> subNodes, DotAttachment dotAttachment) {
        this.container = container;
        this.subNodes = subNodes;
        this.dotAttachment = dotAttachment;
        this.subConnect();
    }

    static SubgraphMerge newSubgraphMerge(GraphContainer container, DotAttachment dotAttachment, Consumer<GraphContainer> containerConsumer) {
        Asserts.nullArgument(container, "container");
        Asserts.nullArgument(dotAttachment, "dotAttachment");
        ArrayList<SubNode> subNodes = new ArrayList<SubNode>(container.subgraphs().size());
        SubgraphMerge.addSubNode(container, subNodes, dotAttachment, containerConsumer);
        if (CollectionUtils.isEmpty(subNodes)) {
            return EMPTY_SUBGRAPH_MERGE;
        }
        return new SubgraphMerge(container, subNodes, dotAttachment);
    }

    boolean haveBorderNode() {
        return this.haveBorderNode;
    }

    MergeNode getMergeNode(DNode node) {
        if (this.mergeNodeMap == null) {
            return null;
        }
        return this.mergeNodeMap.get(node);
    }

    Iterable<DNode> nodes() {
        if (this.mergeNodeMap == null) {
            return Collections.emptyList();
        }
        return this.mergeNodeMap.keySet();
    }

    boolean isEmpty() {
        return this.mergeNodeMap == null;
    }

    private static void addSubNode(GraphContainer container, List<SubNode> subNodes, DotAttachment dotAttachment, Consumer<GraphContainer> containerConsumer) {
        if (containerConsumer != null) {
            containerConsumer.accept(container);
        }
        for (Subgraph subgraph : container.subgraphs()) {
            if (subgraph.isTransparent()) {
                SubgraphMerge.addSubNode(subgraph, subNodes, dotAttachment, containerConsumer);
                continue;
            }
            SubNode subNode = new SubNode(subgraph);
            subNodes.add(subNode);
            DrawGraph drawGraph = dotAttachment.getDrawGraph();
            for (Node node : subgraph.nodes()) {
                DNode dNode = dotAttachment.get(node);
                if (dNode.getContainer() != container) continue;
                subNode.addNodeId(drawGraph.nodeNo(node));
            }
        }
    }

    private void subConnect() {
        if (CollectionUtils.isEmpty(this.subNodes)) {
            return;
        }
        UndirectedGraph<SubNode> connectGraph = new UndirectedGraph<SubNode>(this.subNodes.size());
        for (int i = 0; i < this.subNodes.size(); ++i) {
            SubNode s1 = this.subNodes.get(i);
            for (int j = i + 1; j < this.subNodes.size(); ++j) {
                SubNode s2 = this.subNodes.get(j);
                if (!s1.haveCommonNode(s2)) continue;
                connectGraph.addEdge(s1, s2);
            }
        }
        HashSet<SubNode> mark = new HashSet<SubNode>(this.subNodes.size());
        for (SubNode subNode : this.subNodes) {
            if (mark.contains(subNode)) continue;
            this.dfs(this.newSubNodeKey(subNode, this.dotAttachment), subNode, mark, connectGraph);
        }
        for (SubNode subNode : this.subNodes) {
            for (Node node : subNode.subgraph.nodes()) {
                DNode dn = this.dotAttachment.get(node);
                if (dn.getContainer() != this.container) continue;
                if (this.mergeNodeMap == null) {
                    this.mergeNodeMap = new HashMap<DNode, MergeNode>();
                }
                MergeNode mergeNode = subNode.subKey.key;
                this.mergeNodeMap.put(dn, subNode.subKey.key);
                if (!mergeNode.isBorder()) continue;
                this.haveBorderNode = true;
            }
        }
    }

    private void dfs(SubKey subKey, SubNode subNode, Set<SubNode> mark, Graph.VertexGraph<SubNode> connectGraph) {
        mark.add(subNode);
        subKey.key.rank = this.compareRankKey(subKey.key.rank, subNode.subgraph.getRank());
        subNode.subKey = subKey;
        for (SubNode node : connectGraph.adjacent(subNode)) {
            if (mark.contains(node)) continue;
            this.dfs(subKey, node, mark, connectGraph);
        }
    }

    private SubKey newSubNodeKey(SubNode s1, DotAttachment dotAttachment) {
        Node node = this.findFirst(s1.subgraph.nodes());
        MergeNode mergeNode = new MergeNode(dotAttachment.get(node), s1.subgraph.getRank());
        return new SubKey(mergeNode);
    }

    private Node findFirst(Iterable<Node> nodes) {
        Iterator<Node> iterator = nodes.iterator();
        if (iterator.hasNext()) {
            Node node = iterator.next();
            return node;
        }
        return null;
    }

    private Rank compareRankKey(Rank r1, Rank r2) {
        if (r1 == r2) {
            return r1;
        }
        if (r1 == Rank.SAME) {
            return r2;
        }
        if (r2 == Rank.SAME) {
            return r1;
        }
        if (r1 == Rank.MIN || r1 == Rank.SOURCE) {
            if (r2 == Rank.MAX || r2 == Rank.SINK) {
                throw new SubgrahOppositRankException();
            }
            return Rank.SOURCE;
        }
        if (r2 == Rank.MIN || r2 == Rank.SOURCE) {
            throw new SubgrahOppositRankException();
        }
        return Rank.SINK;
    }

    static class MergeNode {
        private final DNode node;
        private Rank rank;

        MergeNode(DNode node, Rank rank) {
            this.node = node;
            this.rank = rank;
        }

        DNode getNode() {
            return this.node;
        }

        Rank getRank() {
            return this.rank;
        }

        boolean shouldNoInDegree() {
            return this.rank == Rank.MIN || this.rank == Rank.SOURCE;
        }

        boolean shouldNoOutDegree() {
            return this.rank == Rank.MAX || this.rank == Rank.SINK;
        }

        boolean isBorder() {
            return this.rank == Rank.MIN || this.rank == Rank.SOURCE || this.rank == Rank.MAX || this.rank == Rank.SINK;
        }
    }

    private static class SubKey {
        private final MergeNode key;

        public SubKey(MergeNode key) {
            this.key = key;
        }
    }

    private static class SubNode
    extends VertexIndex {
        private static final long serialVersionUID = 6756911716157476290L;
        private SubKey subKey;
        private long[] bitNodeIds;
        private final Subgraph subgraph;

        private SubNode(Subgraph subgraph) {
            Asserts.nullArgument(subgraph, "subgraph");
            this.subgraph = subgraph;
            this.bitNodeIds = new long[(subgraph.nodeNum() - 1) / 64 + 1];
        }

        private void addNodeId(int nodeId) {
            int segment = (nodeId - 1) / 64;
            if (segment > this.bitNodeIds.length - 1) {
                this.bitNodeIds = Arrays.copyOf(this.bitNodeIds, segment + 1);
            }
            int n = this.bitNodeIds.length - segment - 1;
            this.bitNodeIds[n] = this.bitNodeIds[n] | 1L << nodeId - 64 * segment - 1;
        }

        boolean haveCommonNode(SubNode subNode) {
            if (subNode.bitNodeIds == null || this.bitNodeIds == null) {
                return false;
            }
            int i = this.bitNodeIds.length - 1;
            for (int j = subNode.bitNodeIds.length - 1; i >= 0 && j >= 0; --i, --j) {
                if ((this.bitNodeIds[i] & subNode.bitNodeIds[j]) <= 0L) continue;
                return true;
            }
            return false;
        }
    }
}

