/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graphper.util.Asserts;

public class ClassUtils {
    private ClassUtils() {
    }

    public static Object newObject(Class<?> clazz) throws Exception {
        return ClassUtils.newObject(clazz, null, null);
    }

    public static Object newObjectOne(Class<?> clazz, Class<?> parameterType, Object param) throws Exception {
        return ClassUtils.newObject(clazz, new Class[]{parameterType}, param);
    }

    public static Object newObject(Class<?> clazz, Object ... params) throws Exception {
        if (params == null || params.length == 0) {
            return ClassUtils.newObject(clazz);
        }
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Asserts.illegalArgument(params[i] == null, "Constructor can not have null parameter");
            parameterTypes[i] = ClassUtils.getClass(params[i]);
        }
        return ClassUtils.newObject(clazz, parameterTypes, params);
    }

    public static Object newObject(Class<?> clazz, Class<?>[] parameterTypes, Object ... params) throws Exception {
        Asserts.nullArgument(clazz, "clazz");
        Constructor<?> constructor = clazz.getConstructor(parameterTypes);
        return constructor.newInstance(params);
    }

    public static Object invoke(Object obj, String methodName) throws Exception {
        return ClassUtils.invoke(obj, methodName, null, null);
    }

    public static Object invoke(Object obj, String methodName, Object ... params) throws Exception {
        if (params == null || params.length == 0) {
            return ClassUtils.invoke(obj, methodName);
        }
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Asserts.illegalArgument(params[i] == null, "Method can not have null parameter");
            parameterTypes[i] = ClassUtils.getClass(params[i]);
        }
        return ClassUtils.invoke(obj, methodName, parameterTypes, params);
    }

    public static Object invokeOne(Object obj, String methodName, Class<?> parameterType, Object param) throws Exception {
        return ClassUtils.invoke(obj, methodName, new Class[]{parameterType}, param);
    }

    public static Object invoke(Object obj, String methodName, Class<?>[] parameterTypes, Object ... params) throws Exception {
        Asserts.nullArgument(obj, "obj");
        Method method = obj.getClass().getMethod(methodName, parameterTypes);
        return method.invoke(obj, params);
    }

    public static Object getField(Object obj, String fieldName) throws Exception {
        Asserts.nullArgument(obj, "obj");
        Class<?> clazz = obj.getClass();
        Field field = clazz.getField(fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(obj);
    }

    public static Object invokeStatic(Class<?> clazz, String methodName) throws Exception {
        return ClassUtils.invokeStatic(clazz, methodName, null, null);
    }

    public static Object invokeStatic(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object ... params) throws Exception {
        Asserts.nullArgument(clazz, "class");
        Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method.invoke(null, params);
    }

    public static Object getStaticField(Class<?> clazz, String fieldName) throws Exception {
        Asserts.nullArgument(clazz, "class");
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(null);
    }

    public static Map<String, Object> propValMap(Object obj) throws IllegalAccessException {
        if (obj == null) {
            return Collections.emptyMap();
        }
        Class<?> cls = obj.getClass();
        Field[] fields = cls.getDeclaredFields();
        if (fields.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>(fields.length);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String name = field.getName();
            field.setAccessible(true);
            Object propVal = field.get(obj);
            if (propVal == null) continue;
            field.setAccessible(false);
            map.put(name, propVal);
        }
        return map;
    }

    public static void modifyField(Object obj, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Asserts.nullArgument(obj, "Null object");
        Asserts.nullArgument(fieldName, "Null field name");
        Class<?> clazz = obj.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        if (Modifier.isStatic(field.getModifiers())) {
            return;
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        field.set(obj, value);
        field.setAccessible(accessible);
    }

    private static Class<?> getClass(Object obj) {
        Class<?> clazz = obj.getClass();
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        return clazz;
    }
}

