/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.util;

import java.util.ServiceLoader;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.def.FlatPoint;
import org.graphper.layout.FontSelector;
import org.graphper.layout.MeasureText;

public class FontUtils {
    public static final String DEFAULT_FONT;
    private static final MeasureText MEASURE_TEXT;

    private FontUtils() {
    }

    private static MeasureText selectMeasureText() {
        ServiceLoader<MeasureText> measureTextServiceLoader = ServiceLoader.load(MeasureText.class);
        MeasureText measureText = null;
        for (MeasureText ms : measureTextServiceLoader) {
            if (!ms.envSupport() || measureText != null && measureText.order() <= ms.order()) continue;
            measureText = ms;
        }
        if (measureText == null) {
            throw new RuntimeException("Could not find any available MeasureText");
        }
        return measureText;
    }

    private static String selectDefaultFont() {
        ServiceLoader<FontSelector> fontSelectorServiceLoader = ServiceLoader.load(FontSelector.class);
        FontSelector fontSelector = null;
        for (FontSelector fs : fontSelectorServiceLoader) {
            if (!fs.envSupport() || fontSelector != null && fontSelector.order() <= fs.order()) continue;
            fontSelector = fs;
        }
        String defaultFont = fontSelector != null ? fontSelector.defaultFont() : null;
        return StringUtils.isEmpty(defaultFont) ? "Times New Roman" : defaultFont;
    }

    public static FlatPoint measure(String label, String fontName, double fontSize, double widthIncr) {
        FlatPoint size = MEASURE_TEXT.measure(label, fontName, fontSize);
        if (size == null) {
            throw new RuntimeException("Occurred unexpected error, MeasureText can not work and return null label size");
        }
        size.setWidth(size.getWidth() + widthIncr);
        return size;
    }

    static {
        MEASURE_TEXT = FontUtils.selectMeasureText();
        DEFAULT_FONT = FontUtils.selectDefaultFont();
    }
}

