/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.util;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graphper.api.Cluster;
import org.graphper.api.GraphContainer;
import org.graphper.api.Subgraph;
import org.graphper.def.CycleDependencyException;
import org.graphper.util.Asserts;

public class GraphvizUtils {
    private GraphvizUtils() {
    }

    public static void dfs(int maxDepth, boolean preConsumer, GraphContainer container, Consumer<Subgraph> subgraphConsumer, Consumer<Cluster> clusterConsumer, Predicate<GraphContainer> continueDfsPredicate) {
        GraphvizUtils.dfs(maxDepth, preConsumer, null, null, container, subgraphConsumer, clusterConsumer, continueDfsPredicate);
    }

    public static void dfs(int maxDepth, boolean preConsumer, Set<GraphContainer> path, Set<GraphContainer> accessStack, GraphContainer container, Consumer<Subgraph> subgraphConsumer, Consumer<Cluster> clusterConsumer, Predicate<GraphContainer> continueDfsPredicate) {
        Asserts.nullArgument(container, "container");
        GraphvizUtils.dfs(preConsumer, 1, maxDepth, path, accessStack, container, (c, f) -> subgraphConsumer.accept((Subgraph)c), (c, f) -> clusterConsumer.accept((Cluster)c), continueDfsPredicate);
    }

    public static void dfs(int maxDepth, boolean preConsumer, Set<GraphContainer> path, Set<GraphContainer> accessStack, GraphContainer container, BiConsumer<Subgraph, GraphContainer> subgraphConsumer, BiConsumer<Cluster, GraphContainer> clusterConsumer, Predicate<GraphContainer> continueDfsPredicate) {
        Asserts.nullArgument(container, "container");
        GraphvizUtils.dfs(preConsumer, 1, maxDepth, path, accessStack, container, subgraphConsumer, clusterConsumer, continueDfsPredicate);
    }

    private static void dfs(boolean preConsumer, int depth, int maxDepth, Set<GraphContainer> path, Set<GraphContainer> accessStack, GraphContainer container, BiConsumer<Subgraph, GraphContainer> subgraphConsumer, BiConsumer<Cluster, GraphContainer> clusterConsumer, Predicate<GraphContainer> continueDfsPredicate) {
        Asserts.illegalArgument(depth > maxDepth, "The depth of the subgraph exceeds the maximum depth " + maxDepth);
        if (accessStack != null) {
            if (accessStack.contains(container)) {
                throw new CycleDependencyException("Find that the subgraphs or clusters have circular dependencies!");
            }
            accessStack.add(container);
        }
        if (path != null) {
            if (path.contains(container)) {
                return;
            }
            path.add(container);
        }
        for (Subgraph subgraph : container.subgraphs()) {
            GraphvizUtils.consumerContainer(preConsumer, depth, maxDepth, path, accessStack, subgraphConsumer, clusterConsumer, continueDfsPredicate, subgraph, container);
        }
        for (Cluster cluster : container.clusters()) {
            GraphvizUtils.consumerContainer(preConsumer, depth, maxDepth, path, accessStack, subgraphConsumer, clusterConsumer, continueDfsPredicate, cluster, container);
        }
        if (accessStack != null) {
            accessStack.remove(container);
        }
    }

    private static void consumerContainer(boolean preConsumer, int depth, int maxDepth, Set<GraphContainer> path, Set<GraphContainer> accessStack, BiConsumer<Subgraph, GraphContainer> subgraphConsumer, BiConsumer<Cluster, GraphContainer> clusterConsumer, Predicate<GraphContainer> continueDfsPredicate, GraphContainer container, GraphContainer father) {
        if (preConsumer) {
            GraphvizUtils.consumerContainer(father, container, subgraphConsumer, clusterConsumer);
        }
        if (continueDfsPredicate == null || Objects.equals(Boolean.TRUE, continueDfsPredicate.test(container))) {
            GraphvizUtils.dfs(preConsumer, depth + 1, maxDepth, path, accessStack, container, subgraphConsumer, clusterConsumer, continueDfsPredicate);
        }
        if (!preConsumer) {
            GraphvizUtils.consumerContainer(father, container, subgraphConsumer, clusterConsumer);
        }
    }

    private static void consumerContainer(GraphContainer father, GraphContainer container, BiConsumer<Subgraph, GraphContainer> subgraphConsumer, BiConsumer<Cluster, GraphContainer> clusterConsumer) {
        if (container.isSubgraph() && subgraphConsumer != null) {
            subgraphConsumer.accept((Subgraph)container, father);
        } else if (container.isCluster() && clusterConsumer != null) {
            clusterConsumer.accept((Cluster)container, father);
        }
    }
}

