/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graphstream.graph.BreadthFirstIterator;
import org.graphstream.graph.DepthFirstIterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.stream.SourceBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
extends AbstractElement
implements Node {
    protected AbstractGraph graph;

    protected AbstractNode(AbstractGraph graph, String id) {
        super(id);
        this.graph = graph;
    }

    @Override
    protected void attributeChanged(String sourceId, long timeId, String attribute, AbstractElement.AttributeChangeEvent event, Object oldValue, Object newValue) {
        this.graph.listeners.sendAttributeChangedEvent(sourceId, timeId, this.id, SourceBase.ElementType.NODE, attribute, event, oldValue, newValue);
    }

    @Override
    protected String myGraphId() {
        return this.graph.getId();
    }

    @Override
    protected long newEvent() {
        return this.graph.newEvent();
    }

    @Override
    protected boolean nullAttributesAreErrors() {
        return this.graph.nullAttributesAreErrors();
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public abstract int getDegree();

    @Override
    public abstract int getInDegree();

    @Override
    public abstract int getOutDegree();

    @Override
    public boolean hasEdgeToward(Node node) {
        return this.getEdgeToward(node) != null;
    }

    @Override
    public boolean hasEdgeToward(int index) {
        return this.getEdgeToward(index) != null;
    }

    @Override
    public boolean hasEdgeToward(String id) {
        return this.getEdgeToward(id) != null;
    }

    @Override
    public boolean hasEdgeFrom(Node node) {
        return this.getEdgeFrom(node) != null;
    }

    @Override
    public boolean hasEdgeFrom(int index) {
        return this.getEdgeFrom(index) != null;
    }

    @Override
    public boolean hasEdgeFrom(String id) {
        return this.getEdgeFrom(id) != null;
    }

    @Override
    public boolean hasEdgeBetween(Node node) {
        return this.getEdgeBetween(node) != null;
    }

    @Override
    public boolean hasEdgeBetween(int index) {
        return this.getEdgeBetween(index) != null;
    }

    @Override
    public boolean hasEdgeBetween(String id) {
        return this.getEdgeBetween(id) != null;
    }

    @Override
    public abstract <T extends Edge> T getEdgeToward(Node var1);

    @Override
    public <T extends Edge> T getEdgeToward(int index) {
        return this.getEdgeToward((Node)this.graph.getNode(index));
    }

    @Override
    public <T extends Edge> T getEdgeToward(String id) {
        return this.getEdgeToward((Node)this.graph.getNode(id));
    }

    @Override
    public abstract <T extends Edge> T getEdgeFrom(Node var1);

    @Override
    public <T extends Edge> T getEdgeFrom(int index) {
        return this.getEdgeFrom((Node)this.graph.getNode(index));
    }

    @Override
    public <T extends Edge> T getEdgeFrom(String id) {
        return this.getEdgeFrom((Node)this.graph.getNode(id));
    }

    @Override
    public abstract <T extends Edge> T getEdgeBetween(Node var1);

    @Override
    public <T extends Edge> T getEdgeBetween(int index) {
        return this.getEdgeBetween((Node)this.graph.getNode(index));
    }

    @Override
    public <T extends Edge> T getEdgeBetween(String id) {
        return this.getEdgeBetween((Node)this.graph.getNode(id));
    }

    @Override
    public abstract <T extends Edge> Iterator<T> getEdgeIterator();

    @Override
    public abstract <T extends Edge> Iterator<T> getEnteringEdgeIterator();

    @Override
    public abstract <T extends Edge> Iterator<T> getLeavingEdgeIterator();

    @Override
    public <T extends Edge> Iterable<T> getEachEdge() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractNode.this.getEdgeIterator();
            }
        };
    }

    @Override
    public <T extends Edge> Iterable<T> getEachEnteringEdge() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractNode.this.getEnteringEdgeIterator();
            }
        };
    }

    @Override
    public <T extends Edge> Iterable<T> getEachLeavingEdge() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractNode.this.getLeavingEdgeIterator();
            }
        };
    }

    @Override
    public <T extends Edge> Collection<T> getEdgeSet() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractNode.this.getEdgeIterator();
            }

            @Override
            public int size() {
                return AbstractNode.this.getDegree();
            }
        };
    }

    @Override
    public <T extends Edge> Collection<T> getEnteringEdgeSet() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractNode.this.getEnteringEdgeIterator();
            }

            @Override
            public int size() {
                return AbstractNode.this.getInDegree();
            }
        };
    }

    @Override
    public <T extends Edge> Collection<T> getLeavingEdgeSet() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractNode.this.getLeavingEdgeIterator();
            }

            @Override
            public int size() {
                return AbstractNode.this.getOutDegree();
            }
        };
    }

    @Override
    public Iterator<Edge> iterator() {
        return this.getEdgeIterator();
    }

    @Override
    public abstract <T extends Edge> T getEdge(int var1);

    @Override
    public abstract <T extends Edge> T getEnteringEdge(int var1);

    @Override
    public abstract <T extends Edge> T getLeavingEdge(int var1);

    @Override
    public <T extends Node> Iterator<T> getNeighborNodeIterator() {
        return new Iterator<T>(){
            Iterator<Edge> edgeIt;
            HashSet<T> visited;
            T next;
            {
                this.edgeIt = AbstractNode.this.getEdgeIterator();
                this.visited = new HashSet(AbstractNode.this.getDegree());
                this.gotoNext();
            }

            private void gotoNext() {
                while (this.edgeIt.hasNext()) {
                    this.next = this.edgeIt.next().getOpposite(AbstractNode.this);
                    if (this.visited.contains(this.next)) continue;
                    this.visited.add(this.next);
                    return;
                }
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object current = this.next;
                this.gotoNext();
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This iterator does not support remove");
            }
        };
    }

    @Override
    public <T extends Node> Iterator<T> getBreadthFirstIterator() {
        return new BreadthFirstIterator(this);
    }

    @Override
    public <T extends Node> Iterator<T> getBreadthFirstIterator(boolean directed) {
        return new BreadthFirstIterator(this, directed);
    }

    @Override
    public <T extends Node> Iterator<T> getDepthFirstIterator() {
        return new DepthFirstIterator(this);
    }

    @Override
    public <T extends Node> Iterator<T> getDepthFirstIterator(boolean directed) {
        return new DepthFirstIterator(this, directed);
    }

    protected abstract boolean addEdgeCallback(AbstractEdge var1);

    protected abstract void removeEdgeCallback(AbstractEdge var1);

    protected abstract void clearCallback();

    public boolean isEnteringEdge(Edge e) {
        return e.getTargetNode() == this || !e.isDirected() && e.getSourceNode() == this;
    }

    public boolean isLeavingEdge(Edge e) {
        return e.getSourceNode() == this || !e.isDirected() && e.getTargetNode() == this;
    }

    public boolean isIncidentEdge(Edge e) {
        return e.getSourceNode() == this || e.getTargetNode() == this;
    }
}

