/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.graphstream.graph.Edge;
import org.graphstream.graph.EdgeFactory;
import org.graphstream.graph.EdgeRejectedException;
import org.graphstream.graph.Element;
import org.graphstream.graph.ElementNotFoundException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.IdAlreadyInUseException;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.GraphParseException;
import org.graphstream.stream.GraphReplay;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSource;
import org.graphstream.ui.swingViewer.Viewer;

public class Graphs {
    public static Graph unmutableGraph(Graph g) {
        return null;
    }

    public static Graph synchronizedGraph(Graph g) {
        return new SynchronizedGraph(g);
    }

    public static Graph merge(Graph ... graphs) {
        Graph result;
        if (graphs == null) {
            return new DefaultGraph("void-merge");
        }
        String id = "merge";
        for (Graph g : graphs) {
            id = id + "-" + g.getId();
        }
        try {
            Class<?> cls = graphs[0].getClass();
            result = (Graph)cls.getConstructor(String.class).newInstance(id);
        }
        catch (Exception e) {
            System.err.printf("*** WARNING *** can not create a graph of %s\n", graphs[0].getClass().getName());
            result = new MultiGraph(id);
        }
        Graphs.mergeIn(result, graphs);
        return result;
    }

    public static void mergeIn(Graph result, Graph ... graphs) {
        boolean strict = result.isStrict();
        GraphReplay replay = new GraphReplay(String.format("replay-%x", System.nanoTime()));
        replay.addSink(result);
        result.setStrict(false);
        if (graphs != null) {
            for (Graph g : graphs) {
                replay.replay(g);
            }
        }
        replay.removeSink(result);
        result.setStrict(strict);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedEdge
    extends SynchronizedElement<Edge>
    implements Edge {
        final SynchronizedGraph sg;

        SynchronizedEdge(SynchronizedGraph sg, Edge e) {
            super(e);
            this.sg = sg;
        }

        @Override
        public <T extends Node> T getNode0() {
            this.sg.elementLock.lock();
            Object n = this.sg.getNode(((Edge)this.wrappedElement).getNode0().getIndex());
            this.sg.elementLock.unlock();
            return n;
        }

        @Override
        public <T extends Node> T getNode1() {
            this.sg.elementLock.lock();
            Object n = this.sg.getNode(((Edge)this.wrappedElement).getNode1().getIndex());
            this.sg.elementLock.unlock();
            return n;
        }

        @Override
        public <T extends Node> T getOpposite(Node node) {
            if (node instanceof SynchronizedNode) {
                node = (Node)((SynchronizedNode)node).wrappedElement;
            }
            this.sg.elementLock.lock();
            Object n = this.sg.getNode(((Edge)this.wrappedElement).getOpposite(node).getIndex());
            this.sg.elementLock.unlock();
            return n;
        }

        @Override
        public <T extends Node> T getSourceNode() {
            this.sg.elementLock.lock();
            Object n = this.sg.getNode(((Edge)this.wrappedElement).getSourceNode().getIndex());
            this.sg.elementLock.unlock();
            return n;
        }

        @Override
        public <T extends Node> T getTargetNode() {
            this.sg.elementLock.lock();
            Object n = this.sg.getNode(((Edge)this.wrappedElement).getTargetNode().getIndex());
            this.sg.elementLock.unlock();
            return n;
        }

        @Override
        public boolean isDirected() {
            return ((Edge)this.wrappedElement).isDirected();
        }

        @Override
        public boolean isLoop() {
            return ((Edge)this.wrappedElement).isLoop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedNode
    extends SynchronizedElement<Node>
    implements Node {
        private final SynchronizedGraph sg;
        private final ReentrantLock elementLock;

        SynchronizedNode(SynchronizedGraph sg, Node n) {
            super(n);
            this.sg = sg;
            this.elementLock = new ReentrantLock();
        }

        public Iterator<Node> getBreadthFirstIterator() {
            return this.getBreadthFirstIterator(false);
        }

        public Iterator<Node> getBreadthFirstIterator(boolean directed) {
            LinkedList l = new LinkedList();
            this.elementLock.lock();
            this.sg.elementLock.lock();
            Iterator it = ((Node)this.wrappedElement).getBreadthFirstIterator(directed);
            while (it.hasNext()) {
                l.add(this.sg.getNode(((Node)it.next()).getIndex()));
            }
            this.sg.elementLock.unlock();
            this.elementLock.unlock();
            return l.iterator();
        }

        @Override
        public int getDegree() {
            this.elementLock.lock();
            int d = ((Node)this.wrappedElement).getDegree();
            this.elementLock.unlock();
            return d;
        }

        public Iterator<Node> getDepthFirstIterator() {
            return this.getDepthFirstIterator(false);
        }

        public Iterator<Node> getDepthFirstIterator(boolean directed) {
            LinkedList l = new LinkedList();
            this.elementLock.lock();
            this.sg.elementLock.lock();
            Iterator it = ((Node)this.wrappedElement).getDepthFirstIterator();
            while (it.hasNext()) {
                l.add(this.sg.getNode(((Node)it.next()).getIndex()));
            }
            this.sg.elementLock.unlock();
            this.elementLock.unlock();
            return l.iterator();
        }

        public Iterable<Edge> getEachEdge() {
            return this.getEdgeSet();
        }

        public Iterable<Edge> getEachEnteringEdge() {
            return this.getEnteringEdgeSet();
        }

        public Iterable<Edge> getEachLeavingEdge() {
            return this.getLeavingEdgeSet();
        }

        @Override
        public <T extends Edge> T getEdge(int i) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdge(i).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEnteringEdge(int i) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEnteringEdge(i).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getLeavingEdge(int i) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getLeavingEdge(i).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEdgeBetween(String id) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeBetween(id).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEdgeBetween(Node n) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeBetween(n).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEdgeBetween(int index) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeBetween(index).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEdgeFrom(String id) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeFrom(id).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEdgeFrom(Node n) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeFrom(n).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEdgeFrom(int index) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeFrom(index).getIndex());
            this.elementLock.unlock();
            return e;
        }

        public Iterator<Edge> getEdgeIterator() {
            return this.getEdgeSet().iterator();
        }

        public Collection<Edge> getEdgeSet() {
            this.elementLock.lock();
            ArrayList<Edge> l = new ArrayList<Edge>(((Node)this.wrappedElement).getDegree());
            Iterator it = ((Node)this.wrappedElement).getEachEdge().iterator();
            while (it.hasNext()) {
                l.add((Edge)this.sg.getEdge(((Edge)it.next()).getIndex()));
            }
            this.elementLock.unlock();
            return l;
        }

        @Override
        public <T extends Edge> T getEdgeToward(String id) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeToward(id).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEdgeToward(Node n) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeToward(n).getIndex());
            this.elementLock.unlock();
            return e;
        }

        @Override
        public <T extends Edge> T getEdgeToward(int index) {
            this.elementLock.lock();
            Object e = this.sg.getEdge(((Node)this.wrappedElement).getEdgeToward(index).getIndex());
            this.elementLock.unlock();
            return e;
        }

        public Iterator<Edge> getEnteringEdgeIterator() {
            return this.getEnteringEdgeSet().iterator();
        }

        public Collection<Edge> getEnteringEdgeSet() {
            this.elementLock.lock();
            this.sg.elementLock.lock();
            ArrayList<Edge> l = new ArrayList<Edge>(((Node)this.wrappedElement).getInDegree());
            Iterator it = ((Node)this.wrappedElement).getEachEnteringEdge().iterator();
            while (it.hasNext()) {
                l.add((Edge)this.sg.getEdge(((Edge)it.next()).getIndex()));
            }
            this.sg.elementLock.unlock();
            this.elementLock.unlock();
            return l;
        }

        @Override
        public Graph getGraph() {
            return this.sg;
        }

        @Override
        public int getInDegree() {
            this.elementLock.lock();
            int d = ((Node)this.wrappedElement).getInDegree();
            this.elementLock.unlock();
            return d;
        }

        public Iterator<Edge> getLeavingEdgeIterator() {
            return this.getLeavingEdgeSet().iterator();
        }

        public Collection<Edge> getLeavingEdgeSet() {
            this.elementLock.lock();
            this.sg.elementLock.lock();
            ArrayList<Edge> l = new ArrayList<Edge>(((Node)this.wrappedElement).getOutDegree());
            Iterator it = ((Node)this.wrappedElement).getEachLeavingEdge().iterator();
            while (it.hasNext()) {
                l.add((Edge)this.sg.getEdge(((Edge)it.next()).getIndex()));
            }
            this.sg.elementLock.unlock();
            this.elementLock.unlock();
            return l;
        }

        public Iterator<Node> getNeighborNodeIterator() {
            this.elementLock.lock();
            this.sg.elementLock.lock();
            ArrayList l = new ArrayList(((Node)this.wrappedElement).getDegree());
            Iterator it = ((Node)this.wrappedElement).getNeighborNodeIterator();
            while (it.hasNext()) {
                l.add(this.sg.getNode(((Node)it.next()).getIndex()));
            }
            this.sg.elementLock.unlock();
            this.elementLock.unlock();
            return l.iterator();
        }

        @Override
        public int getOutDegree() {
            this.elementLock.lock();
            int d = ((Node)this.wrappedElement).getOutDegree();
            this.elementLock.unlock();
            return d;
        }

        @Override
        public boolean hasEdgeBetween(String id) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeBetween(id);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public boolean hasEdgeBetween(Node node) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeBetween(node);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public boolean hasEdgeBetween(int index) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeBetween(index);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public boolean hasEdgeFrom(String id) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeFrom(id);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public boolean hasEdgeFrom(Node node) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeFrom(node);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public boolean hasEdgeFrom(int index) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeFrom(index);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public boolean hasEdgeToward(String id) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeToward(id);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public boolean hasEdgeToward(Node node) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeToward(node);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public boolean hasEdgeToward(int index) {
            this.elementLock.lock();
            boolean b = ((Node)this.wrappedElement).hasEdgeToward(index);
            this.elementLock.unlock();
            return b;
        }

        @Override
        public Iterator<Edge> iterator() {
            return this.getEdgeSet().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedGraph
    extends SynchronizedElement<Graph>
    implements Graph {
        final ReentrantLock elementLock = new ReentrantLock();
        final HashMap<String, Node> synchronizedNodes = new HashMap();
        final HashMap<String, Edge> synchronizedEdges = new HashMap();

        SynchronizedGraph(Graph g) {
            super(g);
            for (Node n : g.getEachNode()) {
                this.synchronizedNodes.put(n.getId(), new SynchronizedNode(this, n));
            }
            for (Edge e : g.getEachEdge()) {
                this.synchronizedEdges.put(e.getId(), new SynchronizedEdge(this, e));
            }
        }

        @Override
        public <T extends Edge> T addEdge(String id, String node1, String node2) throws IdAlreadyInUseException, ElementNotFoundException, EdgeRejectedException {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).addEdge(id, node1, node2);
            SynchronizedEdge se = new SynchronizedEdge(this, (Edge)e);
            this.synchronizedEdges.put(id, se);
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T addEdge(String id, String from, String to, boolean directed) throws IdAlreadyInUseException, ElementNotFoundException {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).addEdge(id, from, to, directed);
            SynchronizedEdge se = new SynchronizedEdge(this, (Edge)e);
            this.synchronizedEdges.put(id, se);
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T addEdge(String id, int index1, int index2) {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).addEdge(id, index1, index2);
            SynchronizedEdge se = new SynchronizedEdge(this, (Edge)e);
            this.synchronizedEdges.put(id, se);
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T addEdge(String id, int fromIndex, int toIndex, boolean directed) {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).addEdge(id, fromIndex, toIndex, directed);
            SynchronizedEdge se = new SynchronizedEdge(this, (Edge)e);
            this.synchronizedEdges.put(id, se);
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T addEdge(String id, Node node1, Node node2) {
            Node unsyncNode1 = (Node)((SynchronizedElement)((Object)node1)).wrappedElement;
            Node unsyncNode2 = (Node)((SynchronizedElement)((Object)node2)).wrappedElement;
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).addEdge(id, unsyncNode1, unsyncNode2);
            SynchronizedEdge se = new SynchronizedEdge(this, (Edge)e);
            this.synchronizedEdges.put(id, se);
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T addEdge(String id, Node from, Node to, boolean directed) {
            Node unsyncFrom = (Node)((SynchronizedElement)((Object)from)).wrappedElement;
            Node unsyncTo = (Node)((SynchronizedElement)((Object)to)).wrappedElement;
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).addEdge(id, unsyncFrom, unsyncTo, directed);
            SynchronizedEdge se = new SynchronizedEdge(this, (Edge)e);
            this.synchronizedEdges.put(id, se);
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Node> T addNode(String id) throws IdAlreadyInUseException {
            this.elementLock.lock();
            Object n = ((Graph)this.wrappedElement).addNode(id);
            SynchronizedNode sn = new SynchronizedNode(this, (Node)n);
            this.synchronizedNodes.put(id, sn);
            this.elementLock.unlock();
            return (T)sn;
        }

        @Override
        public Iterable<AttributeSink> attributeSinks() {
            LinkedList<AttributeSink> sinks = new LinkedList<AttributeSink>();
            this.elementLock.lock();
            for (AttributeSink as : ((Graph)this.wrappedElement).attributeSinks()) {
                sinks.add(as);
            }
            this.elementLock.unlock();
            return sinks;
        }

        @Override
        public void clear() {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).clear();
            this.elementLock.unlock();
        }

        @Override
        public Viewer display() {
            return ((Graph)this.wrappedElement).display();
        }

        @Override
        public Viewer display(boolean autoLayout) {
            return ((Graph)this.wrappedElement).display(autoLayout);
        }

        @Override
        public EdgeFactory<? extends Edge> edgeFactory() {
            return ((Graph)this.wrappedElement).edgeFactory();
        }

        @Override
        public Iterable<ElementSink> elementSinks() {
            LinkedList<ElementSink> sinks = new LinkedList<ElementSink>();
            this.elementLock.lock();
            for (ElementSink es : ((Graph)this.wrappedElement).elementSinks()) {
                sinks.add(es);
            }
            this.elementLock.unlock();
            return sinks;
        }

        public Iterable<Edge> getEachEdge() {
            this.elementLock.lock();
            LinkedList<Edge> edges = new LinkedList<Edge>(this.synchronizedEdges.values());
            this.elementLock.unlock();
            return edges;
        }

        public Iterable<Node> getEachNode() {
            this.elementLock.lock();
            LinkedList<Node> nodes = new LinkedList<Node>(this.synchronizedNodes.values());
            this.elementLock.unlock();
            return nodes;
        }

        @Override
        public <T extends Edge> T getEdge(String id) {
            this.elementLock.lock();
            Edge e = this.synchronizedEdges.get(id);
            this.elementLock.unlock();
            return (T)e;
        }

        @Override
        public <T extends Edge> T getEdge(int index) throws IndexOutOfBoundsException {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).getEdge(index);
            this.elementLock.unlock();
            return e == null ? null : (T)this.getEdge(e.getId());
        }

        @Override
        public int getEdgeCount() {
            this.elementLock.lock();
            int c = this.synchronizedEdges.size();
            this.elementLock.unlock();
            return c;
        }

        public Iterator<Edge> getEdgeIterator() {
            return this.getEdgeSet().iterator();
        }

        public Collection<Edge> getEdgeSet() {
            this.elementLock.lock();
            LinkedList<Edge> l = new LinkedList<Edge>(this.synchronizedEdges.values());
            this.elementLock.unlock();
            return l;
        }

        @Override
        public <T extends Node> T getNode(String id) {
            this.elementLock.lock();
            Node n = this.synchronizedNodes.get(id);
            this.elementLock.unlock();
            return (T)n;
        }

        @Override
        public <T extends Node> T getNode(int index) throws IndexOutOfBoundsException {
            this.elementLock.lock();
            Object n = ((Graph)this.wrappedElement).getNode(index);
            this.elementLock.unlock();
            return n == null ? null : (T)this.getNode(n.getId());
        }

        @Override
        public int getNodeCount() {
            this.elementLock.lock();
            int c = this.synchronizedNodes.size();
            this.elementLock.unlock();
            return c;
        }

        public Iterator<Node> getNodeIterator() {
            return this.getNodeSet().iterator();
        }

        public Collection<Node> getNodeSet() {
            this.elementLock.lock();
            LinkedList<Node> l = new LinkedList<Node>(this.synchronizedNodes.values());
            this.elementLock.unlock();
            return l;
        }

        @Override
        public double getStep() {
            this.elementLock.lock();
            double s = ((Graph)this.wrappedElement).getStep();
            this.elementLock.unlock();
            return s;
        }

        @Override
        public boolean isAutoCreationEnabled() {
            return ((Graph)this.wrappedElement).isAutoCreationEnabled();
        }

        @Override
        public boolean isStrict() {
            return ((Graph)this.wrappedElement).isStrict();
        }

        @Override
        public NodeFactory<? extends Node> nodeFactory() {
            return ((Graph)this.wrappedElement).nodeFactory();
        }

        @Override
        public boolean nullAttributesAreErrors() {
            return ((Graph)this.wrappedElement).nullAttributesAreErrors();
        }

        @Override
        public void read(String filename) throws IOException, GraphParseException, ElementNotFoundException {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).read(filename);
            this.elementLock.unlock();
        }

        @Override
        public void read(FileSource input, String filename) throws IOException, GraphParseException {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).read(input, filename);
            this.elementLock.unlock();
        }

        @Override
        public <T extends Edge> T removeEdge(String from, String to) throws ElementNotFoundException {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).removeEdge(from, to);
            Edge se = this.synchronizedEdges.remove(e.getId());
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T removeEdge(String id) throws ElementNotFoundException {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).removeEdge(id);
            Edge se = this.synchronizedEdges.remove(e.getId());
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T removeEdge(int index) {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).removeEdge(index);
            Edge se = this.synchronizedEdges.remove(e.getId());
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T removeEdge(int fromIndex, int toIndex) {
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).removeEdge(fromIndex, toIndex);
            Edge se = this.synchronizedEdges.remove(e.getId());
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T removeEdge(Node node1, Node node2) {
            if (node1 instanceof SynchronizedNode) {
                node1 = (Node)((SynchronizedNode)node1).wrappedElement;
            }
            if (node2 instanceof SynchronizedNode) {
                node2 = (Node)((SynchronizedNode)node1).wrappedElement;
            }
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).removeEdge(node1, node2);
            Edge se = this.synchronizedEdges.remove(e.getId());
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Edge> T removeEdge(Edge edge) {
            if (edge instanceof SynchronizedEdge) {
                edge = (Edge)((SynchronizedEdge)edge).wrappedElement;
            }
            this.elementLock.lock();
            Object e = ((Graph)this.wrappedElement).removeEdge(edge);
            Edge se = this.synchronizedEdges.remove(e.getId());
            this.elementLock.unlock();
            return (T)se;
        }

        @Override
        public <T extends Node> T removeNode(String id) throws ElementNotFoundException {
            this.elementLock.lock();
            Object n = ((Graph)this.wrappedElement).removeNode(id);
            Node sn = this.synchronizedNodes.remove(n.getId());
            this.elementLock.unlock();
            return (T)sn;
        }

        @Override
        public <T extends Node> T removeNode(int index) {
            this.elementLock.lock();
            Object n = ((Graph)this.wrappedElement).removeNode(index);
            Node sn = this.synchronizedNodes.remove(n.getId());
            this.elementLock.unlock();
            return (T)sn;
        }

        @Override
        public <T extends Node> T removeNode(Node node) {
            if (node instanceof SynchronizedNode) {
                node = (Node)((SynchronizedNode)node).wrappedElement;
            }
            this.elementLock.lock();
            Object n = ((Graph)this.wrappedElement).removeNode(node);
            Node sn = this.synchronizedNodes.remove(n.getId());
            this.elementLock.unlock();
            return (T)sn;
        }

        @Override
        public void setAutoCreate(boolean on) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).setAutoCreate(on);
            this.elementLock.unlock();
        }

        @Override
        public void setEdgeFactory(EdgeFactory<? extends Edge> ef) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).setEdgeFactory(ef);
            this.elementLock.unlock();
        }

        @Override
        public void setNodeFactory(NodeFactory<? extends Node> nf) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).setNodeFactory(nf);
            this.elementLock.unlock();
        }

        @Override
        public void setNullAttributesAreErrors(boolean on) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).setNullAttributesAreErrors(on);
            this.elementLock.unlock();
        }

        @Override
        public void setStrict(boolean on) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).setStrict(on);
            this.elementLock.unlock();
        }

        @Override
        public void stepBegins(double time) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).stepBegins(time);
            this.elementLock.unlock();
        }

        @Override
        public void write(String filename) throws IOException {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).write(filename);
            this.elementLock.unlock();
        }

        @Override
        public void write(FileSink output, String filename) throws IOException {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).write(output, filename);
            this.elementLock.unlock();
        }

        @Override
        public void addAttributeSink(AttributeSink sink) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).addAttributeSink(sink);
            this.elementLock.unlock();
        }

        @Override
        public void addElementSink(ElementSink sink) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).addElementSink(sink);
            this.elementLock.unlock();
        }

        @Override
        public void addSink(Sink sink) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).addSink(sink);
            this.elementLock.unlock();
        }

        @Override
        public void clearAttributeSinks() {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).clearAttributeSinks();
            this.elementLock.unlock();
        }

        @Override
        public void clearElementSinks() {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).clearElementSinks();
            this.elementLock.unlock();
        }

        @Override
        public void clearSinks() {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).clearSinks();
            this.elementLock.unlock();
        }

        @Override
        public void removeAttributeSink(AttributeSink sink) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).removeAttributeSink(sink);
            this.elementLock.unlock();
        }

        @Override
        public void removeElementSink(ElementSink sink) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).removeElementSink(sink);
            this.elementLock.unlock();
        }

        @Override
        public void removeSink(Sink sink) {
            this.elementLock.lock();
            ((Graph)this.wrappedElement).removeSink(sink);
            this.elementLock.unlock();
        }

        @Override
        public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
            ((Graph)this.wrappedElement).edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
        }

        @Override
        public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
            ((Graph)this.wrappedElement).edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
        }

        @Override
        public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
            ((Graph)this.wrappedElement).edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
        }

        @Override
        public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
            ((Graph)this.wrappedElement).graphAttributeAdded(sourceId, timeId, attribute, value);
        }

        @Override
        public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
            ((Graph)this.wrappedElement).graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
        }

        @Override
        public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
            ((Graph)this.wrappedElement).graphAttributeRemoved(sourceId, timeId, attribute);
        }

        @Override
        public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
            ((Graph)this.wrappedElement).nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
        }

        @Override
        public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
            ((Graph)this.wrappedElement).nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
        }

        @Override
        public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
            ((Graph)this.wrappedElement).nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
        }

        @Override
        public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
            ((Graph)this.wrappedElement).edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
        }

        @Override
        public void edgeRemoved(String sourceId, long timeId, String edgeId) {
            ((Graph)this.wrappedElement).edgeRemoved(sourceId, timeId, edgeId);
        }

        @Override
        public void graphCleared(String sourceId, long timeId) {
            ((Graph)this.wrappedElement).graphCleared(sourceId, timeId);
        }

        @Override
        public void nodeAdded(String sourceId, long timeId, String nodeId) {
            ((Graph)this.wrappedElement).nodeAdded(sourceId, timeId, nodeId);
        }

        @Override
        public void nodeRemoved(String sourceId, long timeId, String nodeId) {
            ((Graph)this.wrappedElement).nodeRemoved(sourceId, timeId, nodeId);
        }

        @Override
        public void stepBegins(String sourceId, long timeId, double step) {
            ((Graph)this.wrappedElement).stepBegins(sourceId, timeId, step);
        }

        @Override
        public Iterator<Node> iterator() {
            return this.getEachNode().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedElement<U extends Element>
    implements Element {
        private final ReentrantLock attributeLock;
        protected final U wrappedElement;

        SynchronizedElement(U e) {
            this.wrappedElement = e;
            this.attributeLock = new ReentrantLock();
        }

        @Override
        public void addAttribute(String attribute, Object ... values) {
            this.attributeLock.lock();
            this.wrappedElement.addAttribute(attribute, values);
            this.attributeLock.unlock();
        }

        @Override
        public void addAttributes(Map<String, Object> attributes) {
            this.attributeLock.lock();
            this.wrappedElement.addAttributes(attributes);
            this.attributeLock.unlock();
        }

        @Override
        public void changeAttribute(String attribute, Object ... values) {
            this.attributeLock.lock();
            this.wrappedElement.changeAttribute(attribute, values);
            this.attributeLock.unlock();
        }

        @Override
        public void clearAttributes() {
            this.attributeLock.lock();
            this.wrappedElement.clearAttributes();
            this.attributeLock.unlock();
        }

        @Override
        public Object[] getArray(String key) {
            this.attributeLock.lock();
            Object[] o = this.wrappedElement.getArray(key);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public <T> T getAttribute(String key) {
            this.attributeLock.lock();
            Object o = this.wrappedElement.getAttribute(key);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public <T> T getAttribute(String key, Class<T> clazz) {
            this.attributeLock.lock();
            T o = this.wrappedElement.getAttribute(key, clazz);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public int getAttributeCount() {
            this.attributeLock.lock();
            int c = this.wrappedElement.getAttributeCount();
            this.attributeLock.unlock();
            return c;
        }

        @Override
        public Iterator<String> getAttributeKeyIterator() {
            return this.getAttributeKeySet().iterator();
        }

        @Override
        public Iterable<String> getAttributeKeySet() {
            this.attributeLock.lock();
            ArrayList<String> o = new ArrayList<String>(this.wrappedElement.getAttributeCount());
            Iterator<String> it = this.wrappedElement.getAttributeKeyIterator();
            while (it.hasNext()) {
                o.add(it.next());
            }
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public <T> T getFirstAttributeOf(String ... keys) {
            this.attributeLock.lock();
            Object o = this.wrappedElement.getFirstAttributeOf(keys);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public <T> T getFirstAttributeOf(Class<T> clazz, String ... keys) {
            this.attributeLock.lock();
            T o = this.wrappedElement.getFirstAttributeOf(clazz, keys);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public HashMap<?, ?> getHash(String key) {
            this.attributeLock.lock();
            HashMap<?, ?> o = this.wrappedElement.getHash(key);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public String getId() {
            return this.wrappedElement.getId();
        }

        @Override
        public int getIndex() {
            return this.wrappedElement.getIndex();
        }

        @Override
        public CharSequence getLabel(String key) {
            this.attributeLock.lock();
            CharSequence o = this.wrappedElement.getLabel(key);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public double getNumber(String key) {
            this.attributeLock.lock();
            double o = this.wrappedElement.getNumber(key);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public ArrayList<? extends Number> getVector(String key) {
            this.attributeLock.lock();
            ArrayList<? extends Number> o = this.wrappedElement.getVector(key);
            this.attributeLock.unlock();
            return o;
        }

        @Override
        public boolean hasArray(String key) {
            this.attributeLock.lock();
            boolean b = this.wrappedElement.hasArray(key);
            this.attributeLock.unlock();
            return b;
        }

        @Override
        public boolean hasAttribute(String key) {
            this.attributeLock.lock();
            boolean b = this.wrappedElement.hasAttribute(key);
            this.attributeLock.unlock();
            return b;
        }

        @Override
        public boolean hasAttribute(String key, Class<?> clazz) {
            this.attributeLock.lock();
            boolean b = this.wrappedElement.hasAttribute(key, clazz);
            this.attributeLock.unlock();
            return b;
        }

        @Override
        public boolean hasHash(String key) {
            this.attributeLock.lock();
            boolean b = this.wrappedElement.hasHash(key);
            this.attributeLock.unlock();
            return b;
        }

        @Override
        public boolean hasLabel(String key) {
            this.attributeLock.lock();
            boolean b = this.wrappedElement.hasLabel(key);
            this.attributeLock.unlock();
            return b;
        }

        @Override
        public boolean hasNumber(String key) {
            this.attributeLock.lock();
            boolean b = this.wrappedElement.hasNumber(key);
            this.attributeLock.unlock();
            return b;
        }

        @Override
        public boolean hasVector(String key) {
            this.attributeLock.lock();
            boolean b = this.wrappedElement.hasVector(key);
            this.attributeLock.unlock();
            return b;
        }

        @Override
        public void removeAttribute(String attribute) {
            this.attributeLock.lock();
            this.wrappedElement.removeAttribute(attribute);
            this.attributeLock.unlock();
        }

        @Override
        public void setAttribute(String attribute, Object ... values) {
            this.attributeLock.lock();
            this.wrappedElement.setAttribute(attribute, values);
            this.attributeLock.unlock();
        }
    }
}

