/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.util.HashMap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.stream.file.FileSinkBase;

public class FileSinkGraphML
extends FileSinkBase {
    protected void outputEndOfFile() throws IOException {
        this.print("</graphml>\n", new Object[0]);
    }

    protected void outputHeader() throws IOException {
        this.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n", new Object[0]);
        this.print("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n", new Object[0]);
        this.print("\t xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n", new Object[0]);
        this.print("\t xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n", new Object[0]);
        this.print("\t   http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n", new Object[0]);
    }

    private void print(String format, Object ... args) throws IOException {
        this.output.write(String.format(format, args));
    }

    protected void exportGraph(Graph g) {
        try {
            String type;
            String id;
            Object value;
            int attribute = 0;
            HashMap<String, String> nodeAttributes = new HashMap<String, String>();
            HashMap<String, String> edgeAttributes = new HashMap<String, String>();
            for (Element n : g.getEachNode()) {
                for (String k : n.getAttributeKeySet()) {
                    if (nodeAttributes.containsKey(k) || (value = n.getAttribute(k)) == null) continue;
                    id = String.format("attr%04X", attribute++);
                    type = value instanceof Boolean ? "boolean" : (value instanceof Long ? "long" : (value instanceof Integer ? "int" : (value instanceof Double ? "double" : (value instanceof Float ? "float" : "string"))));
                    nodeAttributes.put(k, id);
                    this.print("\t<key id=\"%s\" for=\"node\" attr.name=\"%s\" attr.type=\"%s\"/>\n", id, k, type);
                }
            }
            for (Element n : g.getEachEdge()) {
                for (String k : n.getAttributeKeySet()) {
                    if (edgeAttributes.containsKey(k) || (value = n.getAttribute(k)) == null) continue;
                    id = String.format("attr%04X", attribute++);
                    type = value instanceof Boolean ? "boolean" : (value instanceof Long ? "long" : (value instanceof Integer ? "int" : (value instanceof Double ? "double" : (value instanceof Float ? "float" : "string"))));
                    edgeAttributes.put(k, id);
                    this.print("\t<key id=\"%s\" for=\"edge\" attr.name=\"%s\" attr.type=\"%s\"/>\n", id, k, type);
                }
            }
            this.print("\t<graph id=\"%s\" edgedefault=\"undirected\">\n", g.getId());
            for (Element n : g.getEachNode()) {
                this.print("\t\t<node id=\"%s\">\n", n.getId());
                for (String k : n.getAttributeKeySet()) {
                    this.print("\t\t\t<data key=\"%s\">%s</data>\n", nodeAttributes.get(k), n.getAttribute(k).toString());
                }
                this.print("\t\t</node>\n", new Object[0]);
            }
            for (Edge e : g.getEachEdge()) {
                this.print("\t\t<edge id=\"%s\" source=\"%s\" target=\"%s\" directed=\"%s\">\n", e.getId(), e.getSourceNode().getId(), e.getTargetNode().getId(), e.isDirected());
                for (String k : e.getAttributeKeySet()) {
                    this.print("\t\t\t<data key=\"%s\">%s</data>\n", edgeAttributes.get(k), e.getAttribute(k).toString());
                }
                this.print("\t\t</edge>\n", new Object[0]);
            }
            this.print("\t</graph>\n", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        throw new UnsupportedOperationException();
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        throw new UnsupportedOperationException();
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        throw new UnsupportedOperationException();
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        throw new UnsupportedOperationException();
    }

    public void graphCleared(String sourceId, long timeId) {
        throw new UnsupportedOperationException();
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        throw new UnsupportedOperationException();
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        throw new UnsupportedOperationException();
    }

    public void stepBegins(String sourceId, long timeId, double step) {
        throw new UnsupportedOperationException();
    }
}

