/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;
import org.graphstream.stream.GraphReplay;
import org.graphstream.stream.file.FileSinkBase;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;

public class FileSinkTikZ
extends FileSinkBase {
    public static final String XYZ_ATTR = "xyz";
    public static final String WIDTH_ATTR = "ui.tikz.width";
    public static final String HEIGHT_ATTR = "ui.tikz.height";
    protected PrintWriter out;
    protected HashMap<String, String> colors = new HashMap();
    protected HashMap<String, String> classes = new HashMap();
    protected HashMap<String, String> classNames = new HashMap();
    protected int classIndex = 0;
    protected int colorIndex = 0;
    protected double width = 10.0;
    protected double height = 10.0;
    protected boolean layout = false;
    protected GraphicGraph buffer = new GraphicGraph("tikz-buffer");
    protected String css = null;

    protected static String formatId(String id) {
        return "node" + id.replaceAll("\\W", "_");
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setCSS(String css) {
        this.css = css;
    }

    public void setLayout(boolean layout) {
        this.layout = layout;
    }

    protected double getNodeX(Node n) {
        if (n.hasAttribute(XYZ_ATTR)) {
            return ((Number)n.getArray(XYZ_ATTR)[0]).doubleValue();
        }
        if (n.hasAttribute("x")) {
            return n.getNumber("x");
        }
        return Double.NaN;
    }

    protected double getNodeY(Node n) {
        if (n.hasAttribute(XYZ_ATTR)) {
            return ((Number)n.getArray(XYZ_ATTR)[1]).doubleValue();
        }
        if (n.hasAttribute("y")) {
            return n.getNumber("y");
        }
        return Double.NaN;
    }

    protected String checkColor(Color c) {
        String rgb = String.format(Locale.ROOT, "%.3f,%.3f,%.3f", Float.valueOf((float)c.getRed() / 255.0f), Float.valueOf((float)c.getGreen() / 255.0f), Float.valueOf((float)c.getBlue() / 255.0f));
        if (this.colors.containsKey(rgb)) {
            return this.colors.get(rgb);
        }
        String key = String.format("tikzC%02d", this.colorIndex++);
        this.colors.put(rgb, key);
        return key;
    }

    protected String getTikzStyle(StyleGroup group) {
        StringBuilder buffer = new StringBuilder();
        LinkedList<String> style = new LinkedList<String>();
        block0 : switch (group.getType()) {
            case NODE: {
                String fill = this.checkColor(group.getFillColor(0));
                style.add("fill=" + fill);
                if (group.getFillColor(0).getAlpha() < 255) {
                    style.add(String.format(Locale.ROOT, "fill opacity=%.2f", Float.valueOf((float)group.getFillColor(0).getAlpha() / 255.0f)));
                }
                switch (group.getStrokeMode()) {
                    case DOTS: 
                    case DASHES: 
                    case PLAIN: {
                        String stroke = this.checkColor(group.getStrokeColor(0));
                        style.add("draw=" + stroke);
                        style.add("line width=" + String.format("%.1fpt", group.getStrokeWidth().value));
                        if (group.getStrokeColor(0).getAlpha() >= 255) break;
                        style.add(String.format(Locale.ROOT, "draw opacity=%.2f", Float.valueOf((float)group.getStrokeColor(0).getAlpha() / 255.0f)));
                    }
                }
                switch (group.getShape()) {
                    case CIRCLE: {
                        style.add("circle");
                        break;
                    }
                    case ROUNDED_BOX: {
                        style.add("rounded corners=2pt");
                    }
                    case BOX: {
                        style.add("rectangle");
                        break;
                    }
                    case TRIANGLE: {
                        style.add("isosceles triangle");
                        break;
                    }
                    case DIAMOND: {
                        style.add("diamond");
                        break;
                    }
                    default: {
                        System.err.printf("unhandled shape : %s%n", new Object[]{group.getShape()});
                    }
                }
                String text = this.checkColor(group.getTextColor(0));
                style.add("text=" + text);
                switch (group.getSize().units) {
                    case GU: {
                        style.add("minimum size=" + String.format(Locale.ROOT, "%.1fcm", group.getSize().values.get(0)));
                        break;
                    }
                    default: {
                        System.err.printf("[warning] units %s are not compatible with TikZ.%n", new Object[]{group.getSize().units});
                    }
                }
                style.add("inner sep=0pt");
                break;
            }
            case EDGE: {
                String fill = this.checkColor(group.getFillColor(0));
                style.add("draw=" + fill);
                if (group.getFillColor(0).getAlpha() < 255) {
                    style.add(String.format(Locale.ROOT, "draw opacity=%.2f", Float.valueOf((float)group.getFillColor(0).getAlpha() / 255.0f)));
                }
                switch (group.getSize().units) {
                    case GU: {
                        style.add("line width=" + String.format(Locale.ROOT, "%.1fpt", group.getSize().values.get(0)));
                        break block0;
                    }
                }
                System.err.printf("[warning] units %s are not compatible with TikZ.%n", new Object[]{group.getSize().units});
            }
        }
        for (int i = 0; i < style.size(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append((String)style.get(i));
        }
        return buffer.toString();
    }

    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.colors.clear();
        this.classes.clear();
        this.classNames.clear();
        this.buffer.clear();
    }

    protected void outputEndOfFile() throws IOException {
        double y;
        SpringBox sbox = null;
        if (this.layout) {
            sbox = new SpringBox();
            GraphReplay replay = new GraphReplay("replay");
            replay.addSink(sbox);
            sbox.addAttributeSink(this.buffer);
            replay.replay(this.buffer);
            do {
                sbox.compute();
            } while (sbox.getStabilization() < 0.9);
            this.buffer.removeSink(sbox);
            sbox.removeAttributeSink(this.buffer);
            sbox = null;
        }
        if (this.css != null) {
            this.buffer.addAttribute("ui.stylesheet", this.css);
        }
        StyleGroupSet sgs = this.buffer.getStyleGroups();
        for (StyleGroup styleGroup : sgs.groups()) {
            String key = String.format("class%02d", this.classIndex++);
            this.classNames.put(styleGroup.getId(), key);
            this.classes.put(key, this.getTikzStyle(styleGroup));
        }
        String nodeStyle = "circle,draw=black,fill=black";
        String string = "draw=black";
        Locale l = Locale.ROOT;
        PointsWrapper points = new PointsWrapper();
        this.out.printf("%%%n%% Do not forget \\usepackage{tikz} in header.%n%%%n", new Object[0]);
        this.out.printf("\\begin{tikzpicture}[%n", new Object[0]);
        for (String string2 : this.classes.keySet()) {
            this.out.printf(l, "\t%s/.style={%s},%n", string2, this.classes.get(string2));
        }
        this.out.printf(l, "\ttikzgsnode/.style={%s},%n", nodeStyle);
        this.out.printf(l, "\ttikzgsedge/.style={%s}%n", string);
        this.out.printf("]%n", new Object[0]);
        for (String string3 : this.colors.keySet()) {
            this.out.printf(l, "\t\\definecolor{%s}{rgb}{%s}%n", this.colors.get(string3), string3);
        }
        double ymin = Double.MAX_VALUE;
        double xmin = Double.MAX_VALUE;
        double ymax = Double.MIN_VALUE;
        double xmax = Double.MIN_VALUE;
        for (Node node : this.buffer.getEachNode()) {
            double x = this.getNodeX(node);
            y = this.getNodeY(node);
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                xmin = Math.min(xmin, x);
                xmax = Math.max(xmax, x);
                ymin = Math.min(ymin, y);
                ymax = Math.max(ymax, y);
                continue;
            }
            System.err.printf("[warning] missing node (x,y).%n", new Object[0]);
        }
        for (Edge edge : this.buffer.getEachEdge()) {
            points.setElement(edge);
            if (!points.check()) continue;
            for (int i = 0; i < points.getPointsCount(); ++i) {
                double x = points.getX(i);
                double y2 = points.getY(i);
                xmin = Math.min(xmin, x);
                xmax = Math.max(xmax, x);
                ymin = Math.min(ymin, y2);
                ymax = Math.max(ymax, y2);
            }
        }
        for (Node node : this.buffer.getEachNode()) {
            String label;
            String uiClass = "tikzgsnode";
            double x = this.getNodeX(node);
            y = this.getNodeY(node);
            if (Double.isNaN(x) || Double.isNaN(y)) {
                x = Math.random() * this.width;
                y = Math.random() * this.height;
            } else {
                x = this.width * (x - xmin) / (xmax - xmin);
                y = this.height * (y - ymin) / (ymax - ymin);
            }
            String string4 = label = node.hasAttribute("label") ? (String)node.getLabel("label") : "";
            if (node instanceof GraphicNode) {
                uiClass = this.classNames.get(((GraphicNode)node).style.getId());
            }
            this.out.printf(l, "\t\\node[%s] (%s) at (%f,%f) {%s};%n", uiClass, FileSinkTikZ.formatId(node.getId()), x, y, label);
        }
        for (Edge edge : this.buffer.getEachEdge()) {
            String uiClass = "tikzgsedge";
            if (edge instanceof GraphicEdge) {
                uiClass = this.classNames.get(((GraphicEdge)edge).style.getId());
            }
            String uiPoints = "";
            points.setElement(edge);
            if (points.check()) {
                for (int i = 0; i < points.getPointsCount(); ++i) {
                    double x = points.getX(i);
                    double y3 = points.getY(i);
                    x = this.width * (x - xmin) / (xmax - xmin);
                    y3 = this.height * (y3 - ymin) / (ymax - ymin);
                    uiPoints = String.format(l, "%s-- (%.3f,%.3f) ", uiPoints, x, y3);
                }
            }
            this.out.printf(l, "\t\\draw[%s] (%s) %s%s (%s);%n", uiClass, FileSinkTikZ.formatId(edge.getSourceNode().getId()), uiPoints, edge.isDirected() ? "->" : "--", FileSinkTikZ.formatId(edge.getTargetNode().getId()));
        }
        this.out.printf("\\end{tikzpicture}%n", new Object[0]);
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.buffer.graphAttributeAdded(sourceId, timeId, attribute, value);
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.buffer.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.buffer.graphAttributeRemoved(sourceId, timeId, attribute);
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.buffer.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.buffer.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.buffer.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.buffer.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.buffer.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.buffer.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.buffer.nodeAdded(sourceId, timeId, nodeId);
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.buffer.nodeRemoved(sourceId, timeId, nodeId);
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.buffer.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.buffer.edgeRemoved(sourceId, timeId, edgeId);
    }

    public void graphCleared(String sourceId, long timeId) {
        this.buffer.graphCleared(sourceId, timeId);
    }

    public void stepBegins(String sourceId, long timeId, double step) {
        this.buffer.stepBegins(sourceId, timeId, step);
    }

    protected class PointsWrapper {
        Object[] points;

        PointsWrapper() {
        }

        public void setElement(Element e) {
            this.points = e.hasArray("ui.points") ? e.getArray("ui.points") : null;
        }

        public boolean check() {
            if (this.points == null) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i] instanceof Point3 || this.points[i].getClass().isArray()) continue;
                return false;
            }
            return true;
        }

        public int getPointsCount() {
            return this.points == null ? 0 : this.points.length;
        }

        public double getX(int i) {
            if (this.points == null || i >= this.points.length) {
                return Double.NaN;
            }
            Object p = this.points[i];
            if (p instanceof Point3) {
                return ((Point3)p).x;
            }
            Object x = Array.get(p, 0);
            if (x instanceof Number) {
                return ((Number)x).doubleValue();
            }
            return Array.getDouble(p, 0);
        }

        public double getY(int i) {
            if (i >= this.points.length) {
                return Double.NaN;
            }
            Object p = this.points[i];
            if (p instanceof Point3) {
                return ((Point3)p).y;
            }
            Object y = Array.get(p, 0);
            if (y instanceof Number) {
                return ((Number)y).doubleValue();
            }
            return Array.getDouble(p, 1);
        }
    }
}

