/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.net;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedList;
import org.graphstream.stream.SourceBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPSource
extends SourceBase {
    protected final HttpServer server;

    public HTTPSource(String graphId, int port) throws IOException {
        super(String.format("http://%s", graphId));
        this.server = HttpServer.create(new InetSocketAddress(port), 4);
        this.server.createContext(String.format("/%s/edit", graphId), new EditHandler());
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop(0);
    }

    protected static void error(HttpExchange ex, String message) throws IOException {
        byte[] data = message.getBytes();
        ex.sendResponseHeaders(400, data.length);
        ex.getResponseBody().write(data);
        ex.getResponseBody().close();
    }

    protected static HashMap<String, Object> GET(HttpExchange ex) {
        String[] args;
        HashMap<String, Object> get = new HashMap<String, Object>();
        for (String arg : args = ex.getRequestURI().getRawQuery().split("[&]")) {
            String[] kv = arg.split("[=]");
            String k = null;
            String v = null;
            try {
                if (kv.length > 0) {
                    k = URLDecoder.decode(kv[0], System.getProperty("file.encoding"));
                }
                if (kv.length > 1) {
                    v = URLDecoder.decode(kv[1], System.getProperty("file.encoding"));
                }
                if (get.containsKey(k)) {
                    Object o = get.get(k);
                    if (o instanceof LinkedList) {
                        ((LinkedList)o).add(v);
                        continue;
                    }
                    LinkedList<Object> l = new LinkedList<Object>();
                    l.add(o);
                    l.add(v);
                    get.put(k, l);
                    continue;
                }
                get.put(k, v);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return get;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        AN,
        CN,
        DN,
        AE,
        CE,
        DE,
        CG,
        ST,
        CLEAR;

    }

    private class EditHandler
    implements HttpHandler {
        private EditHandler() {
        }

        public void handle(HttpExchange ex) throws IOException {
            Action a;
            HashMap<String, Object> get = HTTPSource.GET(ex);
            try {
                a = Action.valueOf(get.get("q").toString().toUpperCase());
            }
            catch (Exception e) {
                HTTPSource.error(ex, "invalid action");
                return;
            }
            switch (a) {
                case AN: {
                    HTTPSource.this.sendNodeAdded(HTTPSource.this.sourceId, get.get("id").toString());
                    break;
                }
                case CN: {
                    break;
                }
                case DN: {
                    HTTPSource.this.sendNodeRemoved(HTTPSource.this.sourceId, get.get("id").toString());
                    break;
                }
                case AE: {
                    HTTPSource.this.sendEdgeAdded(HTTPSource.this.sourceId, get.get("id").toString(), get.get("from").toString(), get.get("to").toString(), get.containsKey("directed"));
                    break;
                }
                case CE: {
                    break;
                }
                case DE: {
                    HTTPSource.this.sendEdgeRemoved(HTTPSource.this.sourceId, get.get("id").toString());
                    break;
                }
                case CG: {
                    break;
                }
                case ST: {
                    HTTPSource.this.sendStepBegins(HTTPSource.this.sourceId, Double.valueOf(get.get("step").toString()));
                }
            }
            ex.sendResponseHeaders(200, 0L);
            ex.getResponseBody().close();
        }
    }
}

