/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.graphstream.stream.netstream.NetStreamConstants;
import org.graphstream.stream.netstream.packing.NetStreamUnpacker;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.miv.mbox.net.PositionableByteArrayInputStream;

public class NetStreamReceiver
extends Thread {
    private String hostname;
    private int port;
    protected ServerSocketChannel server;
    protected Selector selector;
    protected SelectionKey key;
    protected boolean loop = true;
    protected boolean debug = true;
    protected String lastError = null;
    protected ThreadProxyPipe currentStream;
    protected HashMap<String, ThreadProxyPipe> streams = new HashMap();
    protected HashMap<SelectionKey, IncomingBuffer> incoming = new HashMap();
    private NetStreamUnpacker unpacker;
    protected static final String LIGHT_YELLOW = "\u001b[33;1m";
    protected static final String RESET = "\u001b[0m";

    public NetStreamReceiver(String hostname, int port) throws IOException, UnknownHostException {
        this(hostname, port, false);
    }

    public NetStreamReceiver(int port) throws IOException, UnknownHostException {
        this("localhost", port, false);
    }

    public NetStreamReceiver(String hostname, int port, boolean debug) throws IOException, UnknownHostException {
        this.hostname = hostname;
        this.port = port;
        this.unpacker = new DefaultUnpacker();
        this.setDebugOn(debug);
        this.init();
        this.start();
    }

    public synchronized boolean isRunning() {
        return this.loop;
    }

    public synchronized ThreadProxyPipe getStream(String name) {
        ThreadProxyPipe s = this.streams.get(name);
        if (s == null) {
            s = new ThreadProxyPipe();
            this.streams.put(name, s);
        }
        return s;
    }

    public synchronized ThreadProxyPipe getDefaultStream() {
        ThreadProxyPipe s = this.streams.get("default");
        if (s == null) {
            s = new ThreadProxyPipe();
            this.streams.put("default", s);
        }
        return s;
    }

    protected void init() throws IOException, UnknownHostException {
        this.selector = Selector.open();
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        InetAddress ia = InetAddress.getByName(this.hostname);
        InetSocketAddress isa = new InetSocketAddress(ia, this.port);
        this.server.socket().bind(isa);
        if (this.debug) {
            this.debug("bound to socket %s:%d", this.server.socket().getInetAddress(), this.server.socket().getLocalPort());
        }
        this.key = this.server.register(this.selector, 16);
    }

    public void setDebugOn(boolean on) {
        this.debug = on;
    }

    public synchronized void register(String name, ThreadProxyPipe stream) throws Exception {
        if (this.streams.containsKey(name)) {
            throw new Exception("name " + name + " already registered");
        }
        this.streams.put(name, stream);
        if (this.debug) {
            this.debug("registered pipe %s", name);
        }
    }

    public synchronized void quit() {
        this.loop = false;
        this.key.selector().wakeup();
        if (this.debug) {
            this.debug("stopped", new Object[0]);
        }
    }

    public synchronized boolean hasActiveConnections() {
        return !this.incoming.isEmpty();
    }

    public void setUnpacker(NetStreamUnpacker unpaker) {
        this.unpacker = unpaker;
    }

    public void removeUnpacker() {
        this.unpacker = new DefaultUnpacker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean l;
        NetStreamReceiver netStreamReceiver = this;
        synchronized (netStreamReceiver) {
            l = this.loop;
        }
        while (l) {
            this.poll();
            netStreamReceiver = this;
            synchronized (netStreamReceiver) {
                l = this.loop;
            }
        }
        try {
            this.server.close();
        }
        catch (IOException e) {
            this.error("cannot close the server socket: " + e.getMessage(), e);
        }
        if (this.debug) {
            this.debug("receiver //" + this.hostname + ":" + this.port + " finished", new Object[0]);
        }
    }

    public void poll() {
        try {
            if (this.key.selector().select() > 0) {
                Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = readyKeys.iterator();
                while (i.hasNext()) {
                    SelectionKey akey = i.next();
                    i.remove();
                    if (akey.isAcceptable()) {
                        ServerSocketChannel ssocket = (ServerSocketChannel)akey.channel();
                        SocketChannel socket = ssocket.accept();
                        if (this.debug) {
                            this.debug("accepting socket %s:%d", socket.socket().getInetAddress(), socket.socket().getPort());
                        }
                        socket.configureBlocking(false);
                        socket.finishConnect();
                        socket.register(this.selector, 1);
                        continue;
                    }
                    if (akey.isReadable()) {
                        this.readDataChunk(akey);
                        continue;
                    }
                    if (!akey.isWritable()) continue;
                    throw new RuntimeException("should not happen");
                }
            }
        }
        catch (IOException e) {
            this.error(e, "I/O error in receiver //%s:%d thread: aborting: %s", this.hostname, this.port, e.getMessage());
            this.loop = false;
        }
        catch (Throwable e) {
            this.error(e, "Unknown error: %s", e.getMessage());
            this.loop = false;
        }
    }

    protected void readDataChunk(SelectionKey key) throws IOException {
        IncomingBuffer buf = this.incoming.get(key);
        if (buf == null) {
            buf = new IncomingBuffer();
            this.incoming.put(key, buf);
            SocketChannel socket = (SocketChannel)key.channel();
            if (this.debug) {
                this.debug("creating buffer for new connection from %s:%d", socket.socket().getInetAddress(), socket.socket().getPort());
            }
        }
        try {
            buf.readDataChunk(key);
        }
        catch (IOException e) {
            this.incoming.remove(key);
            e.printStackTrace();
            this.error(e, "receiver //%s:%d cannot read object socket channel (I/O error): %s", this.hostname, this.port, e.getMessage());
            this.loop = false;
        }
        if (!buf.active) {
            this.incoming.remove(key);
            if (this.debug) {
                this.debug("removing buffer %s from incoming for geting inactive. %d left", key.toString(), this.incoming.size());
            }
        }
    }

    protected void error(String message, Object ... data) {
        this.error(null, message, data);
    }

    protected void error(Throwable e, String message, Object ... data) {
        System.err.print("[");
        System.err.printf(message, data);
        System.err.printf("]%n", new Object[0]);
        if (e != null) {
            e.printStackTrace();
        }
    }

    protected void debug(String message, Object ... data) {
        System.err.printf("[//%s:%d | ", this.hostname, this.port);
        System.err.printf(message, data);
        System.err.printf("]%n", new Object[0]);
    }

    protected void serve_EVENT_DEL_EDGE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received DEL_EDGE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String edgeId = this.readString(in);
        String attrId = this.readString(in);
        this.currentStream.edgeAttributeRemoved(sourceId, timeId, edgeId, attrId);
    }

    protected void serve_EVENT_CHG_EDGE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received CHG_EDGE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String edgeId = this.readString(in);
        String attrId = this.readString(in);
        int oldValueType = this.readType(in);
        Object oldValue = this.readValue(in, oldValueType);
        int newValueType = this.readType(in);
        Object newValue = this.readValue(in, newValueType);
        this.currentStream.edgeAttributeChanged(sourceId, timeId, edgeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_EDGE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received ADD_EDGE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String edgeId = this.readString(in);
        String attrId = this.readString(in);
        Object value = this.readValue(in, this.readType(in));
        this.currentStream.edgeAttributeAdded(sourceId, timeId, edgeId, attrId, value);
    }

    protected void serve_EVENT_DEL_NODE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received DEL_NODE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String nodeId = this.readString(in);
        String attrId = this.readString(in);
        this.currentStream.nodeAttributeRemoved(sourceId, timeId, nodeId, attrId);
    }

    protected void serve_EVENT_CHG_NODE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_CHG_NODE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String nodeId = this.readString(in);
        String attrId = this.readString(in);
        int oldValueType = this.readType(in);
        Object oldValue = this.readValue(in, oldValueType);
        int newValueType = this.readType(in);
        Object newValue = this.readValue(in, newValueType);
        this.currentStream.nodeAttributeChanged(sourceId, timeId, nodeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_NODE_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_ADD_NODE_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String nodeId = this.readString(in);
        String attrId = this.readString(in);
        Object value = this.readValue(in, this.readType(in));
        this.currentStream.nodeAttributeAdded(sourceId, timeId, nodeId, attrId, value);
    }

    protected void serve_EVENT_DEL_GRAPH_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_DEL_GRAPH_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String attrId = this.readString(in);
        this.currentStream.graphAttributeRemoved(sourceId, timeId, attrId);
    }

    protected void serve_EVENT_CHG_GRAPH_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_CHG_GRAPH_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String attrId = this.readString(in);
        int oldValueType = this.readType(in);
        Object oldValue = this.readValue(in, oldValueType);
        int newValueType = this.readType(in);
        Object newValue = this.readValue(in, newValueType);
        this.currentStream.graphAttributeChanged(sourceId, timeId, attrId, oldValue, newValue);
    }

    protected void serve_EVENT_ADD_GRAPH_ATTR(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_ADD_GRAPH_ATTR command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String attrId = this.readString(in);
        Object value = this.readValue(in, this.readType(in));
        if (this.debug) {
            this.debug("NetStreamServer | EVENT_ADD_GRAPH_ATTR | %s=%s", attrId, value.toString());
        }
        this.currentStream.graphAttributeAdded(sourceId, timeId, attrId, value);
    }

    protected void serve_EVENT_CLEARED(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_CLEARED command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        this.currentStream.graphCleared(sourceId, timeId);
    }

    protected void serve_EVENT_STEP(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_STEP command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        double time = this.readDouble(in);
        this.currentStream.stepBegins(sourceId, timeId, time);
    }

    protected void serve_EVENT_DEL_EDGE(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_DEL_EDGE command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String edgeId = this.readString(in);
        this.currentStream.edgeRemoved(sourceId, timeId, edgeId);
    }

    protected void serve_EVENT_ADD_EDGE(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received ADD_EDGE command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String edgeId = this.readString(in);
        String from = this.readString(in);
        String to = this.readString(in);
        boolean directed = this.readBoolean(in);
        this.currentStream.edgeAdded(sourceId, timeId, edgeId, from, to, directed);
    }

    protected void serve_DEL_NODE(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received DEL_NODE command.", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String nodeId = this.readString(in);
        this.currentStream.nodeRemoved(sourceId, timeId, nodeId);
    }

    protected void serve_EVENT_ADD_NODE(InputStream in) {
        if (this.debug) {
            this.debug("NetStreamServer: Received EVENT_ADD_NODE command", new Object[0]);
        }
        String sourceId = this.readString(in);
        long timeId = this.readLong(in);
        String nodeId = this.readString(in);
        this.currentStream.nodeAdded(sourceId, timeId, nodeId);
    }

    protected int readType(InputStream in) {
        try {
            int data = 0;
            data = in.read();
            if (data == -1) {
                this.debug("readType : could not read type", new Object[0]);
                return 0;
            }
            return data;
        }
        catch (IOException e) {
            this.debug("readType: could not read type", new Object[0]);
            e.printStackTrace();
            return 0;
        }
    }

    protected Object readValue(InputStream in, int valueType) {
        if (NetStreamConstants.TYPE_BOOLEAN == valueType) {
            return this.readBoolean(in);
        }
        if (NetStreamConstants.TYPE_BOOLEAN_ARRAY == valueType) {
            return this.readBooleanArray(in);
        }
        if (NetStreamConstants.TYPE_BYTE == valueType) {
            return this.readByte(in);
        }
        if (NetStreamConstants.TYPE_BYTE_ARRAY == valueType) {
            return this.readByteArray(in);
        }
        if (NetStreamConstants.TYPE_SHORT == valueType) {
            return this.readShort(in);
        }
        if (NetStreamConstants.TYPE_SHORT_ARRAY == valueType) {
            return this.readShortArray(in);
        }
        if (NetStreamConstants.TYPE_INT == valueType) {
            return this.readInt(in);
        }
        if (NetStreamConstants.TYPE_INT_ARRAY == valueType) {
            return this.readIntArray(in);
        }
        if (NetStreamConstants.TYPE_LONG == valueType) {
            return this.readLong(in);
        }
        if (NetStreamConstants.TYPE_LONG_ARRAY == valueType) {
            return this.readLongArray(in);
        }
        if (NetStreamConstants.TYPE_FLOAT == valueType) {
            return this.readFloat(in);
        }
        if (NetStreamConstants.TYPE_FLOAT_ARRAY == valueType) {
            return this.readFloatArray(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE == valueType) {
            return this.readDouble(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE_ARRAY == valueType) {
            return this.readDoubleArray(in);
        }
        if (NetStreamConstants.TYPE_STRING == valueType) {
            return this.readString(in);
        }
        if (NetStreamConstants.TYPE_ARRAY == valueType) {
            return this.readArray(in);
        }
        return null;
    }

    protected Object[] readArray(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readArray: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            Object[] array = new Object[len];
            for (int i = 0; i < len; ++i) {
                array[i] = this.readValue(in, this.readType(in));
            }
            return array;
        }
        catch (IOException e) {
            this.debug("readArray: could not read", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected String readString(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readString: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            data = new byte[len];
            if (in.read(data, 0, len) != len) {
                return null;
            }
            return new String(data, Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            this.debug("readString: could not read string", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Boolean readBoolean(InputStream in) {
        int data = 0;
        try {
            data = in.read();
        }
        catch (IOException e) {
            this.debug("readByte: could not read", new Object[0]);
            e.printStackTrace();
        }
        return data != 0;
    }

    protected Byte readByte(InputStream in) {
        byte data = 0;
        try {
            data = (byte)in.read();
        }
        catch (IOException e) {
            this.debug("readByte: could not read", new Object[0]);
            e.printStackTrace();
        }
        return data;
    }

    protected Short readShort(InputStream in) {
        byte[] data = new byte[2];
        try {
            if (in.read(data, 0, 2) != 2) {
                this.debug("readShort: could not read", new Object[0]);
                return (short)0;
            }
        }
        catch (IOException e) {
            this.debug("readShort: could not read", new Object[0]);
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.put(data);
        bb.flip();
        return bb.getShort();
    }

    protected Integer readInt(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readInt: could not read", new Object[0]);
                return 0;
            }
        }
        catch (IOException e) {
            this.debug("readInt: could not read", new Object[0]);
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(data);
        bb.flip();
        return bb.getInt();
    }

    protected Long readLong(InputStream in) {
        byte[] data = new byte[8];
        try {
            if (in.read(data, 0, 8) != 8) {
                this.debug("readLong: could not read", new Object[0]);
                return 0L;
            }
        }
        catch (IOException e) {
            this.debug("readLong: could not read", new Object[0]);
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(data);
        bb.flip();
        return bb.getLong();
    }

    protected Float readFloat(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readFloat: could not read", new Object[0]);
                return Float.valueOf(0.0f);
            }
        }
        catch (IOException e) {
            this.debug("readFloat: could not read", new Object[0]);
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(data);
        bb.flip();
        return Float.valueOf(bb.getFloat());
    }

    protected Double readDouble(InputStream in) {
        byte[] data = new byte[8];
        try {
            if (in.read(data, 0, 8) != 8) {
                this.debug("readDouble: could not read", new Object[0]);
                return 0.0;
            }
        }
        catch (IOException e) {
            this.debug("readDouble: could not read", new Object[0]);
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(data);
        bb.flip();
        return bb.getDouble();
    }

    protected Integer[] readIntArray(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readIntArray: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            data = new byte[len * 4];
            if (in.read(data, 0, len * 4) != len * 4) {
                this.debug("readIntArray: could not read array", new Object[0]);
                return null;
            }
            bb = ByteBuffer.allocate(4 * len);
            bb.put(data);
            bb.flip();
            Integer[] res = new Integer[len];
            for (int i = 0; i < len; ++i) {
                res[i] = bb.getInt();
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readIntArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Boolean[] readBooleanArray(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readBooleanArray: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            data = new byte[len];
            if (in.read(data, 0, len) != len) {
                this.debug("readBooleanArray: could not read array", new Object[0]);
                return null;
            }
            bb = ByteBuffer.allocate(len);
            bb.put(data);
            bb.flip();
            Boolean[] res = new Boolean[len];
            for (int i = 0; i < len; ++i) {
                byte b = bb.get();
                res[i] = b != 0;
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readBooleanArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Byte[] readByteArray(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readByteArray: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            data = new byte[len];
            if (in.read(data, 0, len) != len) {
                this.debug("readByteArray: could not read array", new Object[0]);
                return null;
            }
            bb = ByteBuffer.allocate(len);
            bb.put(data);
            bb.flip();
            Byte[] res = new Byte[len];
            for (int i = 0; i < len; ++i) {
                res[i] = bb.get();
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readBooleanArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Double[] readDoubleArray(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readDoubleArray: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            data = new byte[len * 8];
            if (in.read(data, 0, len * 8) != len * 8) {
                this.debug("readDoubleArray: could not read array", new Object[0]);
                return null;
            }
            bb = ByteBuffer.allocate(8 * len);
            bb.put(data);
            bb.flip();
            Double[] res = new Double[len];
            for (int i = 0; i < len; ++i) {
                res[i] = bb.getDouble();
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readDoubleArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Float[] readFloatArray(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readFloatArray: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            data = new byte[len * 4];
            if (in.read(data, 0, len * 4) != len * 4) {
                this.debug("readFloatArray: could not read array", new Object[0]);
                return null;
            }
            bb = ByteBuffer.allocate(4 * len);
            bb.put(data);
            bb.flip();
            Float[] res = new Float[len];
            for (int i = 0; i < len; ++i) {
                res[i] = Float.valueOf(bb.getFloat());
            }
            return res;
        }
        catch (IOException e) {
            this.debug("readFloatArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Long[] readLongArray(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readLongArray: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            data = new byte[len * 8];
            if (in.read(data, 0, len * 8) != len * 8) {
                this.debug("readLongArray: could not read array", new Object[0]);
                return null;
            }
            bb = ByteBuffer.allocate(8 * len);
            bb.put(data);
            bb.flip();
            Long[] res = new Long[len];
            for (int i = 0; i < len; ++i) {
                res[i] = bb.getLong();
                this.debug(res[i] + ",", new Object[0]);
            }
            this.debug("%n", new Object[0]);
            return res;
        }
        catch (IOException e) {
            this.debug("readLongArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected Short[] readShortArray(InputStream in) {
        byte[] data = new byte[4];
        try {
            if (in.read(data, 0, 4) != 4) {
                this.debug("readShortArray: could not read length of array (int)", new Object[0]);
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.put(data);
            bb.flip();
            int len = bb.getInt();
            data = new byte[len * 2];
            if (in.read(data, 0, len * 2) != len * 2) {
                this.debug("readShortArray: could not read array", new Object[0]);
                return null;
            }
            bb = ByteBuffer.allocate(2 * len);
            bb.put(data);
            bb.flip();
            Short[] res = new Short[len];
            for (int i = 0; i < len; ++i) {
                res[i] = bb.getShort();
                this.debug(res[i] + ",", new Object[0]);
            }
            this.debug("%n", new Object[0]);
            return res;
        }
        catch (IOException e) {
            this.debug("readShortArray: could not read array", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    protected class IncomingBuffer {
        protected static final int BUFFER_INITIAL_SIZE = 8192;
        protected ByteBuffer buf = ByteBuffer.allocate(8192);
        protected int end = -1;
        protected int beg = 0;
        protected int pos = 0;
        PositionableByteArrayInputStream in;
        PositionableByteArrayInputStream bin;
        protected boolean active = true;

        public void readDataChunk(SelectionKey key) throws IOException {
            int limit = 0;
            int nbytes = 0;
            SocketChannel socket = (SocketChannel)key.channel();
            int sizeOfInt = NetStreamReceiver.this.unpacker.sizeOfInt();
            nbytes = this.bufferize(this.pos, socket);
            limit = this.pos + nbytes;
            if (nbytes <= 0) {
                return;
            }
            if (NetStreamReceiver.this.debug) {
                NetStreamReceiver.this.debug("<chunk (%d bytes) from " + socket.socket().getInetAddress() + ":" + socket.socket().getPort() + ">", nbytes);
                int at = this.buf.position();
                for (int i = 0; i < nbytes; ++i) {
                    System.err.printf("%d ", this.buf.get(at + i));
                }
                System.err.println();
                this.buf.position(at);
            }
            if (this.end < 0) {
                if (limit - this.beg >= sizeOfInt) {
                    this.buf.position(0);
                    int size = NetStreamReceiver.this.unpacker.unpackMessageSize(this.buf);
                    this.end = size + sizeOfInt;
                    this.beg = sizeOfInt;
                    if (NetStreamReceiver.this.debug) {
                        NetStreamReceiver.this.debug("start to bufferize a %d byte long messsage", size);
                    }
                } else {
                    this.pos = limit;
                }
            }
            if (this.end > 0) {
                while (this.end < limit) {
                    this.decodeMessage(limit);
                    this.buf.position(this.end);
                    if (this.end + sizeOfInt <= limit) {
                        this.beg = this.end + sizeOfInt;
                        this.end = this.end + NetStreamReceiver.this.unpacker.unpackMessageSize(this.buf) + sizeOfInt;
                        continue;
                    }
                    assert (this.beg >= sizeOfInt);
                    this.beg = this.end;
                    int p = sizeOfInt - (this.end + sizeOfInt - limit);
                    this.compactBuffer();
                    this.pos = p;
                    this.beg = 0;
                    this.end = -1;
                    break;
                }
                if (this.end == limit) {
                    this.decodeMessage(limit);
                    this.buf.clear();
                    this.pos = 0;
                    this.beg = 0;
                    this.end = -1;
                } else if (this.end > limit) {
                    this.pos = limit;
                    if (this.end > this.buf.capacity()) {
                        this.compactBuffer();
                    }
                }
            }
        }

        protected int bufferize(int at, SocketChannel socket) throws IOException {
            int nbytes = 0;
            try {
                this.buf.position(at);
                nbytes = socket.read(this.buf);
                if (nbytes < 0) {
                    this.active = false;
                    if (this.in != null) {
                        this.in.close();
                    }
                    socket.close();
                    if (NetStreamReceiver.this.debug) {
                        NetStreamReceiver.this.debug("socket from %s:%d closed", socket.socket().getInetAddress(), socket.socket().getPort());
                    }
                    return nbytes;
                }
                if (nbytes == 0) {
                    throw new RuntimeException("should not happen: buffer to small, 0 bytes read: compact does not function? messages is larger than " + this.buf.capacity() + "?");
                }
                this.buf.position(at);
                return nbytes;
            }
            catch (IOException e) {
                if (NetStreamReceiver.this.debug) {
                    NetStreamReceiver.this.debug("socket from %s:%d I/O error: %s", socket.socket().getInetAddress(), socket.socket().getPort(), e.getMessage());
                }
                this.active = false;
                if (this.in != null) {
                    this.in.close();
                }
                socket.close();
                throw e;
            }
        }

        protected void decodeMessage(int limit) throws IOException {
            ByteBuffer unpackedBuffer = NetStreamReceiver.this.unpacker.unpackMessage(this.buf, this.beg, this.end);
            this.in = unpackedBuffer == this.buf ? new PositionableByteArrayInputStream(this.buf.array(), this.beg, this.end - this.beg) : new PositionableByteArrayInputStream(unpackedBuffer.array(), 0, unpackedBuffer.capacity());
            int cmd = 0;
            String stream = NetStreamReceiver.this.readString((InputStream)this.in);
            if (NetStreamReceiver.this.debug) {
                NetStreamReceiver.this.debug("Stream \"%s\" is addressed in this message.", stream);
            }
            NetStreamReceiver.this.currentStream = NetStreamReceiver.this.getStream(stream);
            cmd = this.in.read();
            if (cmd != -1) {
                if (cmd == NetStreamConstants.EVENT_ADD_NODE) {
                    NetStreamReceiver.this.serve_EVENT_ADD_NODE((InputStream)this.in);
                } else if ((cmd & 0xFF) == (NetStreamConstants.EVENT_DEL_NODE & 0xFF)) {
                    NetStreamReceiver.this.serve_DEL_NODE((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_ADD_EDGE) {
                    NetStreamReceiver.this.serve_EVENT_ADD_EDGE((InputStream)this.in);
                } else if (NetStreamConstants.EVENT_DEL_EDGE == cmd) {
                    NetStreamReceiver.this.serve_EVENT_DEL_EDGE((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_STEP) {
                    NetStreamReceiver.this.serve_EVENT_STEP((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_CLEARED) {
                    NetStreamReceiver.this.serve_EVENT_CLEARED((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_ADD_GRAPH_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_ADD_GRAPH_ATTR((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_CHG_GRAPH_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_CHG_GRAPH_ATTR((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_DEL_GRAPH_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_DEL_GRAPH_ATTR((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_ADD_NODE_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_ADD_NODE_ATTR((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_CHG_NODE_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_CHG_NODE_ATTR((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_DEL_NODE_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_DEL_NODE_ATTR((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_ADD_EDGE_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_ADD_EDGE_ATTR((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_CHG_EDGE_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_CHG_EDGE_ATTR((InputStream)this.in);
                } else if (cmd == NetStreamConstants.EVENT_DEL_EDGE_ATTR) {
                    NetStreamReceiver.this.serve_EVENT_DEL_EDGE_ATTR((InputStream)this.in);
                } else {
                    if (cmd == NetStreamConstants.EVENT_END) {
                        NetStreamReceiver.this.debug("NetStreamReceiver : Client properly ended the connection.", new Object[0]);
                        return;
                    }
                    NetStreamReceiver.this.debug("NetStreamReceiver: Don't know this command: " + cmd, new Object[0]);
                    return;
                }
                cmd = this.in.read();
            }
        }

        protected int compactBuffer() {
            if (this.beg > NetStreamReceiver.this.unpacker.sizeOfInt()) {
                int off = this.beg;
                this.buf.position(this.beg);
                this.buf.limit(this.buf.capacity());
                this.buf.compact();
                this.pos -= this.beg;
                this.end -= this.beg;
                this.beg = 0;
                return off;
            }
            return 0;
        }

        protected void enlargeBuffer() {
            ByteBuffer tmp = ByteBuffer.allocate(this.buf.capacity() * 2);
            this.buf.position(0);
            this.buf.limit(this.buf.capacity());
            tmp.put(this.buf);
            tmp.position(this.pos);
            this.buf = tmp;
            if (this.bin != null) {
                this.bin.changeBuffer(this.buf.array());
            }
        }
    }

    class DefaultUnpacker
    extends NetStreamUnpacker {
        DefaultUnpacker() {
        }

        public ByteBuffer unpackMessage(ByteBuffer buffer, int startIndex, int endIndex) {
            return buffer;
        }

        public int unpackMessageSize(ByteBuffer buffer) {
            return buffer.getInt();
        }

        public int sizeOfInt() {
            return 4;
        }
    }
}

