/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.graphstream.stream.Sink;
import org.graphstream.stream.netstream.NetStreamConstants;
import org.graphstream.stream.netstream.packing.NetStreamPacker;

public class NetStreamSender
implements Sink {
    protected String stream;
    byte[] streamIdArray;
    protected String host;
    protected int port;
    protected Socket socket;
    protected BufferedOutputStream out;
    protected String sourceId = "";
    protected byte[] sourceIdBuff;
    protected NetStreamPacker packer = new DefaultPacker();

    public NetStreamSender(String host, int port) throws UnknownHostException, IOException {
        this("default", host, port);
    }

    public NetStreamSender(int port) throws UnknownHostException, IOException {
        this("default", "localhost", port);
    }

    public NetStreamSender(String stream, String host, int port) throws UnknownHostException, IOException {
        this.stream = stream;
        this.host = host;
        this.port = port;
        this.streamIdArray = stream.getBytes(Charset.forName("UTF-8"));
        this.connect();
    }

    public void setPacker(NetStreamPacker paker) {
        this.packer = paker;
    }

    public void removePacker() {
        this.packer = new DefaultPacker();
    }

    protected void connect() throws UnknownHostException, IOException {
        this.socket = new Socket(this.host, this.port);
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
    }

    protected int getType(Object value) {
        int valueType = 0;
        Class<?> valueClass = value.getClass();
        boolean isArray = valueClass.isArray();
        if (isArray) {
            valueClass = ((Object[])value)[0].getClass();
        }
        if (valueClass.equals(Boolean.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_BOOLEAN_ARRAY : NetStreamConstants.TYPE_BOOLEAN;
        } else if (valueClass.equals(Byte.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_BYTE_ARRAY : NetStreamConstants.TYPE_BYTE;
        } else if (valueClass.equals(Short.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_SHORT_ARRAY : NetStreamConstants.TYPE_SHORT;
        } else if (valueClass.equals(Integer.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_INT_ARRAY : NetStreamConstants.TYPE_INT;
        } else if (valueClass.equals(Long.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_LONG_ARRAY : NetStreamConstants.TYPE_LONG;
        } else if (valueClass.equals(Float.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_FLOAT_ARRAY : NetStreamConstants.TYPE_FLOAT;
        } else if (valueClass.equals(Double.class)) {
            valueType = isArray ? NetStreamConstants.TYPE_DOUBLE_ARRAY : NetStreamConstants.TYPE_DOUBLE;
        } else if (valueClass.equals(String.class)) {
            valueType = isArray ? (int)NetStreamConstants.TYPE_ARRAY : NetStreamConstants.TYPE_STRING;
        }
        return valueType;
    }

    protected ByteBuffer encodeValue(Object in, int valueType) {
        if (NetStreamConstants.TYPE_BOOLEAN == valueType) {
            return this.encodeBoolean(in);
        }
        if (NetStreamConstants.TYPE_BOOLEAN_ARRAY == valueType) {
            return this.encodeBooleanArray(in);
        }
        if (NetStreamConstants.TYPE_BYTE == valueType) {
            return this.encodeByte(in);
        }
        if (NetStreamConstants.TYPE_BYTE_ARRAY == valueType) {
            return this.encodeByteArray(in);
        }
        if (NetStreamConstants.TYPE_SHORT == valueType) {
            return this.encodeShort(in);
        }
        if (NetStreamConstants.TYPE_SHORT_ARRAY == valueType) {
            return this.encodeShortArray(in);
        }
        if (NetStreamConstants.TYPE_INT == valueType) {
            return this.encodeInt(in);
        }
        if (NetStreamConstants.TYPE_INT_ARRAY == valueType) {
            return this.encodeIntArray(in);
        }
        if (NetStreamConstants.TYPE_LONG == valueType) {
            return this.encodeLong(in);
        }
        if (NetStreamConstants.TYPE_LONG_ARRAY == valueType) {
            return this.encodeLongArray(in);
        }
        if (NetStreamConstants.TYPE_FLOAT == valueType) {
            return this.encodeFloat(in);
        }
        if (NetStreamConstants.TYPE_FLOAT_ARRAY == valueType) {
            return this.encodeFloatArray(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE == valueType) {
            return this.encodeDouble(in);
        }
        if (NetStreamConstants.TYPE_DOUBLE_ARRAY == valueType) {
            return this.encodeDoubleArray(in);
        }
        if (NetStreamConstants.TYPE_STRING == valueType) {
            return this.encodeString(in);
        }
        if (NetStreamConstants.TYPE_ARRAY == valueType) {
            return this.encodeArray(in);
        }
        return null;
    }

    protected ByteBuffer encodeArray(Object in) {
        return null;
    }

    protected ByteBuffer encodeString(Object in) {
        String s = (String)in;
        byte[] data = s.getBytes(Charset.forName("UTF-8"));
        return ByteBuffer.allocate(4 + data.length).putInt(data.length).put(data);
    }

    protected ByteBuffer encodeDoubleArray(Object in) {
        Object[] data = (Object[])in;
        ByteBuffer b = ByteBuffer.allocate(4 + data.length * 8);
        b.putInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            b.putDouble((Double)data[i]);
        }
        return b;
    }

    protected ByteBuffer encodeDouble(Object in) {
        return ByteBuffer.allocate(8).putDouble((Double)in);
    }

    protected ByteBuffer encodeFloatArray(Object in) {
        Object[] data = (Object[])in;
        ByteBuffer b = ByteBuffer.allocate(4 + data.length * 4).putInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            b.putFloat(((Float)data[i]).floatValue());
        }
        return b;
    }

    protected ByteBuffer encodeFloat(Object in) {
        return ByteBuffer.allocate(4).putFloat(((Float)in).floatValue());
    }

    protected ByteBuffer encodeLongArray(Object in) {
        Object[] data = (Object[])in;
        ByteBuffer b = ByteBuffer.allocate(4 + data.length * 8);
        b.putInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            b.putLong((Long)data[i]);
        }
        return b;
    }

    protected ByteBuffer encodeLong(Object in) {
        return ByteBuffer.allocate(8).putLong((Long)in);
    }

    protected ByteBuffer encodeIntArray(Object in) {
        Object[] data = (Object[])in;
        ByteBuffer b = ByteBuffer.allocate(4 + data.length * 4);
        b.putInt(data.length);
        for (Object aData : data) {
            b.putInt((Integer)aData);
        }
        return b;
    }

    protected ByteBuffer encodeInt(Object in) {
        return ByteBuffer.allocate(4).putInt((Integer)in);
    }

    protected ByteBuffer encodeShortArray(Object in) {
        Object[] data = (Object[])in;
        ByteBuffer b = ByteBuffer.allocate(4 + data.length * 2);
        b.putInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            b.putShort((Short)data[i]);
        }
        return b;
    }

    protected ByteBuffer encodeShort(Object in) {
        return ByteBuffer.allocate(2).putShort((Short)in);
    }

    protected ByteBuffer encodeByteArray(Object in) {
        Object[] data = (Object[])in;
        ByteBuffer b = ByteBuffer.allocate(4 + data.length);
        b.putInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            b.put((Byte)data[i]);
        }
        return b;
    }

    protected ByteBuffer encodeByte(Object in) {
        return ByteBuffer.allocate(1).put((Byte)in);
    }

    protected ByteBuffer encodeBooleanArray(Object in) {
        Object[] data = (Object[])in;
        ByteBuffer b = ByteBuffer.allocate(4 + data.length);
        b.putInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            b.put((byte)((Boolean)data[i] != false ? 1 : 0));
        }
        return b;
    }

    protected ByteBuffer encodeBoolean(Object in) {
        return ByteBuffer.allocate(1).put((byte)((Boolean)in != false ? 1 : 0));
    }

    private void doSend(ByteBuffer buff) {
        if (this.socket.isClosed()) {
            System.err.println("NetStreamSender : can't send. The socket is closed.");
        } else {
            ByteBuffer buffer = this.packer.packMessage(buff);
            ByteBuffer sizeBuffer = this.packer.packMessageSize(buffer.capacity());
            buff.rewind();
            try {
                this.out.write(sizeBuffer.array(), 0, sizeBuffer.capacity());
                this.out.write(buffer.array(), 0, buffer.capacity());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        int valueType = this.getType(value);
        ByteBuffer bValue = this.encodeValue(value, valueType);
        bValue.flip();
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + 4 + attrArray.length + 1 + bValue.capacity());
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_ADD_GRAPH_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(attrArray.length).put(attrArray).put((byte)valueType).put(bValue);
        this.doSend(buff);
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        int oldValueType = this.getType(oldValue);
        int newValueType = this.getType(newValue);
        ByteBuffer bOldValue = this.encodeValue(oldValue, oldValueType);
        bOldValue.flip();
        ByteBuffer bNewValue = this.encodeValue(newValue, newValueType);
        bNewValue.flip();
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + 4 + attrArray.length + 1 + bOldValue.capacity() + 1 + bNewValue.capacity());
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_CHG_GRAPH_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(attrArray.length).put(attrArray).put((byte)oldValueType).put(bOldValue).put((byte)newValueType).put(bNewValue);
        this.doSend(buff);
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + 4 + attrArray.length);
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_DEL_GRAPH_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(attrArray.length).put(attrArray);
        this.doSend(buff);
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] nodeIdArray = nodeId.getBytes(Charset.forName("UTF-8"));
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        int valueType = this.getType(value);
        ByteBuffer bValue = this.encodeValue(value, valueType);
        bValue.flip();
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + (4 + nodeIdArray.length) + (4 + attrArray.length) + 1 + bValue.capacity());
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_ADD_NODE_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(nodeIdArray.length).put(nodeIdArray).putInt(attrArray.length).put(attrArray).put((byte)valueType).put(bValue);
        this.doSend(buff);
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        byte[] nodeIdArray = nodeId.getBytes(Charset.forName("UTF-8"));
        int oldValueType = this.getType(oldValue);
        int newValueType = this.getType(newValue);
        ByteBuffer bOldValue = this.encodeValue(oldValue, oldValueType);
        bOldValue.flip();
        ByteBuffer bNewValue = this.encodeValue(newValue, newValueType);
        bNewValue.flip();
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + (4 + nodeIdArray.length) + (4 + attrArray.length) + 1 + bOldValue.capacity() + 1 + bNewValue.capacity());
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_CHG_NODE_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(nodeIdArray.length).put(nodeIdArray).putInt(attrArray.length).put(attrArray).put((byte)oldValueType).put(bOldValue).put((byte)newValueType).put(bNewValue);
        this.doSend(buff);
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] nodeIdArray = nodeId.getBytes(Charset.forName("UTF-8"));
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + (4 + nodeIdArray.length) + (4 + attrArray.length));
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_DEL_NODE_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(nodeIdArray.length).put(nodeIdArray).putInt(attrArray.length).put(attrArray);
        this.doSend(buff);
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] edgeIdArray = edgeId.getBytes(Charset.forName("UTF-8"));
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        int valueType = this.getType(value);
        ByteBuffer bValue = this.encodeValue(value, valueType);
        bValue.flip();
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + (4 + edgeIdArray.length) + (4 + attrArray.length) + 1 + bValue.capacity());
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_ADD_EDGE_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(edgeIdArray.length).put(edgeIdArray).putInt(attrArray.length).put(attrArray).put((byte)valueType).put(bValue);
        this.doSend(buff);
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] edgeIdArray = edgeId.getBytes(Charset.forName("UTF-8"));
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        int oldValueType = this.getType(oldValue);
        int newValueType = this.getType(newValue);
        ByteBuffer bOldValue = this.encodeValue(oldValue, oldValueType);
        bOldValue.flip();
        ByteBuffer bNewValue = this.encodeValue(newValue, newValueType);
        bNewValue.flip();
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + (4 + edgeIdArray.length) + (4 + attrArray.length) + 1 + bOldValue.capacity() + 1 + bNewValue.capacity());
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_CHG_EDGE_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(edgeIdArray.length).put(edgeIdArray).putInt(attrArray.length).put(attrArray).put((byte)oldValueType).put(bOldValue).put((byte)newValueType).put(bNewValue);
        this.doSend(buff);
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] edgeIdArray = edgeId.getBytes(Charset.forName("UTF-8"));
        byte[] attrArray = attribute.getBytes(Charset.forName("UTF-8"));
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + (4 + edgeIdArray.length) + (4 + attrArray.length));
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_DEL_EDGE_ATTR).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(edgeIdArray.length).put(edgeIdArray).putInt(attrArray.length).put(attrArray);
        this.doSend(buff);
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] nodeIdArray = nodeId.getBytes(Charset.forName("UTF-8"));
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + 4 + nodeIdArray.length);
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_ADD_NODE).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(nodeIdArray.length).put(nodeIdArray);
        this.doSend(buff);
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] nodeIdArray = nodeId.getBytes(Charset.forName("UTF-8"));
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + 4 + nodeIdArray.length);
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_DEL_NODE).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(nodeIdArray.length).put(nodeIdArray);
        this.doSend(buff);
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] edgeIdArray = edgeId.getBytes(Charset.forName("UTF-8"));
        byte[] fromNodeIdArray = fromNodeId.getBytes(Charset.forName("UTF-8"));
        byte[] toNodeIdArray = toNodeId.getBytes(Charset.forName("UTF-8"));
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + 4 + edgeIdArray.length + 4 + fromNodeIdArray.length + 4 + toNodeIdArray.length + 1);
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_ADD_EDGE).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(edgeIdArray.length).put(edgeIdArray).putInt(fromNodeIdArray.length).put(fromNodeIdArray).putInt(toNodeIdArray.length).put(toNodeIdArray).put((byte)(directed ? 1 : 0));
        this.doSend(buff);
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        byte[] edgeIdArray = edgeId.getBytes(Charset.forName("UTF-8"));
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + 4 + edgeIdArray.length);
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_DEL_EDGE).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putInt(edgeIdArray.length).put(edgeIdArray);
        this.doSend(buff);
    }

    public void graphCleared(String sourceId, long timeId) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8);
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_CLEARED).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId);
        this.doSend(buff);
    }

    public void stepBegins(String sourceId, long timeId, double step) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = sourceId.getBytes(Charset.forName("UTF-8"));
        }
        ByteBuffer buff = ByteBuffer.allocate(4 + this.streamIdArray.length + 1 + 4 + this.sourceIdBuff.length + 8 + 8);
        buff.putInt(this.streamIdArray.length).put(this.streamIdArray).put((byte)NetStreamConstants.EVENT_STEP).putInt(this.sourceIdBuff.length).put(this.sourceIdBuff).putLong(timeId).putDouble(step);
        this.doSend(buff);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    class DefaultPacker
    extends NetStreamPacker {
        ByteBuffer sizeBuffer = ByteBuffer.allocate(4);

        DefaultPacker() {
        }

        public ByteBuffer packMessage(ByteBuffer buffer, int startIndex, int endIndex) {
            return buffer;
        }

        public ByteBuffer packMessageSize(int capacity) {
            this.sizeBuffer.rewind();
            this.sizeBuffer.putInt(capacity);
            return this.sizeBuffer;
        }
    }
}

