/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.stylesheet;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graphstream.ui.graphicGraph.stylesheet.Value;

public class StyleConstants {
    protected static HashMap<String, Color> colorMap;
    protected static Pattern sharpColor1;
    protected static Pattern sharpColor2;
    protected static Pattern cssColor;
    protected static Pattern cssColorA;
    protected static Pattern awtColor;
    protected static Pattern hexaColor;
    protected static Pattern numberUnit;
    protected static Pattern number;

    public static Color convertColor(Object anyValue) {
        if (anyValue == null) {
            return null;
        }
        if (anyValue instanceof Color) {
            return (Color)anyValue;
        }
        if (anyValue instanceof String) {
            Matcher m;
            Color c = null;
            String value = (String)anyValue;
            if (value.startsWith("#")) {
                Matcher m2 = sharpColor1.matcher(value);
                if (m2.matches()) {
                    if (value.length() == 7) {
                        try {
                            c = Color.decode(value);
                            return c;
                        }
                        catch (NumberFormatException e) {
                            c = null;
                        }
                    } else if (value.length() == 9) {
                        int r = Integer.parseInt(m2.group(1), 16);
                        int g = Integer.parseInt(m2.group(2), 16);
                        int b = Integer.parseInt(m2.group(3), 16);
                        int a = Integer.parseInt(m2.group(4), 16);
                        return new Color(r, g, b, a);
                    }
                }
                if ((m2 = sharpColor2.matcher(value)).matches() && value.length() >= 4) {
                    int r = Integer.parseInt(m2.group(1), 16) * 16;
                    int g = Integer.parseInt(m2.group(2), 16) * 16;
                    int b = Integer.parseInt(m2.group(3), 16) * 16;
                    int a = 255;
                    if (value.length() == 5) {
                        a = Integer.parseInt(m2.group(4), 16) * 16;
                    }
                    return new Color(r, g, b, a);
                }
            } else if (value.startsWith("rgb")) {
                Matcher m3 = cssColorA.matcher(value);
                if (m3.matches()) {
                    int r = Integer.parseInt(m3.group(1));
                    int g = Integer.parseInt(m3.group(2));
                    int b = Integer.parseInt(m3.group(3));
                    int a = Integer.parseInt(m3.group(4));
                    return new Color(r, g, b, a);
                }
                m3 = cssColor.matcher(value);
                if (m3.matches()) {
                    int r = Integer.parseInt(m3.group(1));
                    int g = Integer.parseInt(m3.group(2));
                    int b = Integer.parseInt(m3.group(3));
                    return new Color(r, g, b);
                }
            } else if (value.startsWith("0x") || value.startsWith("0X")) {
                Matcher m4 = hexaColor.matcher(value);
                if (m4.matches()) {
                    if (value.length() == 8) {
                        try {
                            return Color.decode(value);
                        }
                        catch (NumberFormatException e) {
                            c = null;
                        }
                    } else if (value.length() == 10) {
                        String r = m4.group(1);
                        String g = m4.group(2);
                        String b = m4.group(3);
                        String a = m4.group(4);
                        return new Color(Integer.parseInt(r, 16), Integer.parseInt(g, 16), Integer.parseInt(b, 16), Integer.parseInt(a, 16));
                    }
                }
            } else if (value.startsWith("java.awt.Color[") && (m = awtColor.matcher(value)).matches()) {
                int r = Integer.parseInt(m.group(1));
                int g = Integer.parseInt(m.group(2));
                int b = Integer.parseInt(m.group(3));
                return new Color(r, g, b);
            }
            return colorMap.get(value.toLowerCase());
        }
        return null;
    }

    public static String convertLabel(Object value) {
        String label = null;
        if (value != null && (label = value instanceof CharSequence ? ((Object)((CharSequence)value)).toString() : value.toString()).length() > 128) {
            label = String.format("%s...", label.substring(0, 128));
        }
        return label;
    }

    public static float convertWidth(Object value) {
        if (value instanceof CharSequence) {
            try {
                float val = Float.parseFloat(((Object)((CharSequence)value)).toString());
                return val;
            }
            catch (NumberFormatException e) {
                return -1.0f;
            }
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return -1.0f;
    }

    public static Value convertValue(Object value) {
        if (value instanceof CharSequence) {
            CharSequence string = (CharSequence)value;
            if (string.length() < 0) {
                throw new RuntimeException("empty size string ...");
            }
            Matcher m = numberUnit.matcher(string);
            if (m.matches()) {
                return new Value(StyleConstants.convertUnit(m.group(2)), Float.parseFloat(m.group(1)));
            }
            m = number.matcher(string);
            if (m.matches()) {
                return new Value(Units.PX, Float.parseFloat(m.group(1)));
            }
            throw new RuntimeException(String.format("string is not convertible to a value (%s)", string));
        }
        if (value instanceof Number) {
            return new Value(Units.PX, ((Number)value).floatValue());
        }
        if (value == null) {
            throw new RuntimeException("cannot convert null value");
        }
        throw new RuntimeException(String.format("value is of class %s%n", value.getClass().getName()));
    }

    protected static Units convertUnit(String unit) {
        if (unit.equals("gu")) {
            return Units.GU;
        }
        if (unit.equals("px")) {
            return Units.PX;
        }
        if (unit.equals("%")) {
            return Units.PERCENTS;
        }
        return Units.PX;
    }

    static {
        number = Pattern.compile("\\s*(\\p{Digit}+([.]\\p{Digit})?)\\s*");
        numberUnit = Pattern.compile("\\s*(\\p{Digit}+(?:[.]\\p{Digit}+)?)\\s*(gu|px|%)\\s*");
        sharpColor1 = Pattern.compile("#(\\p{XDigit}\\p{XDigit})(\\p{XDigit}\\p{XDigit})(\\p{XDigit}\\p{XDigit})((\\p{XDigit}\\p{XDigit})?)");
        sharpColor2 = Pattern.compile("#(\\p{XDigit})(\\p{XDigit})(\\p{XDigit})((\\p{XDigit})?)");
        hexaColor = Pattern.compile("0[xX](\\p{XDigit}\\p{XDigit})(\\p{XDigit}\\p{XDigit})(\\p{XDigit}\\p{XDigit})((\\p{XDigit}\\p{XDigit})?)");
        cssColor = Pattern.compile("rgb\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)");
        cssColorA = Pattern.compile("rgba\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)");
        awtColor = Pattern.compile("java.awt.Color\\[r=([0-9]+),g=([0-9]+),b=([0-9]+)\\]");
        colorMap = new HashMap();
        URL url = StyleConstants.class.getResource("rgb.properties");
        if (url == null) {
            throw new RuntimeException("corrupted graphstream.jar ? the org/miv/graphstream/ui/graphicGraph/rgb.properties file is not found");
        }
        Properties p = new Properties();
        try {
            p.load(url.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Object o : p.keySet()) {
            String key = (String)o;
            String val = p.getProperty(key);
            Color col = Color.decode(val);
            colorMap.put(key.toLowerCase(), col);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JComponents {
        BUTTON,
        TEXT_FIELD,
        PANEL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArrowShape {
        NONE,
        ARROW,
        CIRCLE,
        DIAMOND,
        IMAGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpriteOrientation {
        NONE,
        FROM,
        NODE0,
        TO,
        NODE1,
        PROJECTION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Shape {
        CIRCLE(ShapeKind.ELLIPSOID),
        BOX(ShapeKind.RECTANGULAR),
        ROUNDED_BOX(ShapeKind.RECTANGULAR),
        DIAMOND(ShapeKind.RECTANGULAR),
        POLYGON(ShapeKind.RECTANGULAR),
        TRIANGLE(ShapeKind.RECTANGULAR),
        CROSS(ShapeKind.RECTANGULAR),
        FREEPLANE(ShapeKind.RECTANGULAR),
        TEXT_BOX(ShapeKind.RECTANGULAR),
        TEXT_ROUNDED_BOX(ShapeKind.RECTANGULAR),
        TEXT_PARAGRAPH(ShapeKind.RECTANGULAR),
        TEXT_CIRCLE(ShapeKind.ELLIPSOID),
        TEXT_DIAMOND(ShapeKind.RECTANGULAR),
        JCOMPONENT(ShapeKind.RECTANGULAR),
        PIE_CHART(ShapeKind.ELLIPSOID),
        FLOW(ShapeKind.LINEAR),
        ARROW(ShapeKind.RECTANGULAR),
        IMAGES(ShapeKind.RECTANGULAR),
        LINE(ShapeKind.LINEAR),
        ANGLE(ShapeKind.LINEAR),
        CUBIC_CURVE(ShapeKind.CURVE),
        POLYLINE(ShapeKind.LINEAR),
        POLYLINE_SCALED(ShapeKind.LINEAR),
        SQUARELINE(ShapeKind.LINEAR),
        LSQUARELINE(ShapeKind.LINEAR),
        HSQUARELINE(ShapeKind.LINEAR),
        VSQUARELINE(ShapeKind.LINEAR),
        BLOB(ShapeKind.CURVE);

        public ShapeKind kind;

        private Shape(ShapeKind kind) {
            this.kind = kind;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShapeKind {
        ELLIPSOID,
        RECTANGULAR,
        LINEAR,
        CURVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextBackgroundMode {
        NONE,
        PLAIN,
        ROUNDEDBOX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextAlignment {
        CENTER,
        LEFT,
        RIGHT,
        AT_LEFT,
        AT_RIGHT,
        UNDER,
        ABOVE,
        JUSTIFY,
        ALONG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizeMode {
        NORMAL,
        FIT,
        DYN_SIZE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IconMode {
        NONE,
        AT_LEFT,
        AT_RIGHT,
        UNDER,
        ABOVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextStyle {
        NORMAL,
        ITALIC,
        BOLD,
        BOLD_ITALIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextVisibilityMode {
        NORMAL,
        HIDDEN,
        AT_ZOOM,
        UNDER_ZOOM,
        OVER_ZOOM,
        ZOOM_RANGE,
        ZOOMS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextMode {
        NORMAL,
        TRUNCATED,
        HIDDEN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VisibilityMode {
        NORMAL,
        HIDDEN,
        AT_ZOOM,
        UNDER_ZOOM,
        OVER_ZOOM,
        ZOOM_RANGE,
        ZOOMS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShadowMode {
        NONE,
        PLAIN,
        GRADIENT_RADIAL,
        GRADIENT_HORIZONTAL,
        GRADIENT_VERTICAL,
        GRADIENT_DIAGONAL1,
        GRADIENT_DIAGONAL2;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StrokeMode {
        NONE,
        PLAIN,
        DASHES,
        DOTS,
        DOUBLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FillMode {
        NONE,
        PLAIN,
        DYN_PLAIN,
        GRADIENT_RADIAL,
        GRADIENT_HORIZONTAL,
        GRADIENT_VERTICAL,
        GRADIENT_DIAGONAL1,
        GRADIENT_DIAGONAL2,
        IMAGE_TILED,
        IMAGE_SCALED,
        IMAGE_SCALED_RATIO_MAX,
        IMAGE_SCALED_RATIO_MIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Units {
        PX,
        GU,
        PERCENTS;

    }
}

