/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout.springbox.implementations;

import java.util.Random;
import org.graphstream.ui.layout.springbox.BarnesHutLayout;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.graphstream.ui.layout.springbox.implementations.SpringBoxNodeParticle;
import org.miv.pherd.geom.Point3;

public class SpringBox
extends BarnesHutLayout {
    protected double k = 1.0;
    protected double K1 = 0.06f;
    protected double K2 = 0.024f;

    public SpringBox() {
        this(false);
    }

    public SpringBox(boolean is3D) {
        this(is3D, new Random(System.currentTimeMillis()));
    }

    public SpringBox(boolean is3D, Random randomNumberGenerator) {
        super(is3D, randomNumberGenerator);
        this.setQuality(0.1);
    }

    public String getLayoutAlgorithmName() {
        return "SpringBox";
    }

    public void setQuality(double qualityLevel) {
        super.setQuality(qualityLevel);
        this.viewZone = this.quality >= 1.0 ? -1.0 : (this.quality <= 0.0 ? this.k : this.k + this.k * 10.0 * this.quality);
    }

    protected void chooseNodePosition(NodeParticle n0, NodeParticle n1) {
        if (n0.frozen || n1.frozen) {
            return;
        }
        double delta = this.random.nextDouble();
        if (n0.getEdges().size() == 1 && n1.getEdges().size() > 1) {
            Point3 pos = n1.getPosition();
            n0.moveTo(pos.x + delta, pos.y + delta, pos.z + delta);
        } else if (n1.getEdges().size() == 1 && n0.getEdges().size() > 1) {
            Point3 pos = n0.getPosition();
            n1.moveTo(pos.x + delta, pos.y + delta, pos.z + delta);
        }
    }

    public NodeParticle newNodeParticle(String id) {
        return new SpringBoxNodeParticle(this, id);
    }
}

