/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BinaryExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LogicalExpression;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqualityExpression
extends BinaryExpression
implements LogicalExpression {
    private static final Logger log = LoggerFactory.getLogger(EqualityExpression.class);
    private final boolean checkEquality;

    public EqualityExpression(Token start, Expression left, Expression right, boolean checkEquality) {
        super(start, left, right);
        this.checkEquality = checkEquality;
    }

    @Override
    public Object evaluateUnsafe(EvaluationContext context) {
        return this.evaluateBool(context);
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public boolean evaluateBool(EvaluationContext context) {
        Object left = this.left.evaluateUnsafe(context);
        Object right = this.right.evaluateUnsafe(context);
        if (left == null) {
            log.warn("left expression evaluated to null, returning false: {}", (Object)this.left);
            return false;
        }
        boolean equals = left instanceof DateTime && right instanceof DateTime ? ((DateTime)left).isEqual((ReadableInstant)((DateTime)right)) : left.equals(right);
        if (log.isTraceEnabled()) {
            this.traceEquality(left, right, equals, this.checkEquality);
        }
        if (this.checkEquality) {
            return equals;
        }
        return !equals;
    }

    private void traceEquality(Object left, Object right, boolean equals, boolean checkEquality) {
        log.trace(checkEquality ? "[{}] {} == {} : {} == {}" : "[{}] {} != {} : {} != {}", new Object[]{checkEquality == equals, this.left, this.right, left, right});
    }

    public boolean isCheckEquality() {
        return this.checkEquality;
    }

    public String toString() {
        return this.left.toString() + (this.checkEquality ? " == " : " != ") + this.right.toString();
    }
}

