/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import org.antlr.v4.runtime.Token;
import org.apache.commons.beanutils.PropertyUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldAccessExpression
extends BaseExpression {
    private static final Logger log = LoggerFactory.getLogger(FieldAccessExpression.class);
    private final Expression object;
    private final Expression field;

    public FieldAccessExpression(Token start, Expression object, Expression field) {
        super(start);
        this.object = object;
        this.field = field;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Object evaluateUnsafe(EvaluationContext context) {
        Object bean = this.object.evaluateUnsafe(context);
        Object fieldValue = this.field.evaluateUnsafe(context);
        if (bean == null || fieldValue == null) {
            return null;
        }
        String fieldName = fieldValue.toString();
        try {
            Object property = PropertyUtils.getProperty((Object)bean, (String)fieldName);
            if (property == null) {
                property = PropertyUtils.getSimpleProperty((Object)bean, (String)fieldName);
            }
            log.debug("[field access] property {} of bean {}: {}", new Object[]{fieldName, bean.getClass().getTypeName(), property});
            return property;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.debug("Unable to read property {} from {}", (Object)fieldName, bean);
            return null;
        }
    }

    @Override
    public Class getType() {
        return Object.class;
    }

    public String toString() {
        return this.object.toString() + "." + this.field.toString();
    }

    public Expression object() {
        return this.object;
    }

    public Expression field() {
        return this.field;
    }

    @Override
    public Iterable<Expression> children() {
        return ImmutableList.of((Object)this.object, (Object)this.field);
    }
}

