/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;

public class MapLiteralExpression
extends BaseExpression {
    private final HashMap<String, Expression> map;

    public MapLiteralExpression(Token start, HashMap<String, Expression> map) {
        super(start);
        this.map = map;
    }

    @Override
    public boolean isConstant() {
        return this.map.values().stream().allMatch(Expression::isConstant);
    }

    @Override
    public Map evaluateUnsafe(EvaluationContext context) {
        return Seq.seq(this.map).map(entry -> entry.map2(value -> value.evaluateUnsafe(context))).toMap(Tuple2::v1, Tuple2::v2);
    }

    @Override
    public Class getType() {
        return Map.class;
    }

    public String toString() {
        return "{" + Joiner.on((String)", ").withKeyValueSeparator(":").join(this.map) + "}";
    }

    public Iterable<Map.Entry<String, Expression>> entries() {
        return ImmutableSet.copyOf(this.map.entrySet());
    }

    @Override
    public Iterable<Expression> children() {
        return ImmutableList.copyOf(this.map.values());
    }
}

