/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.NumericExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.UnaryExpression;

public class SignedExpression
extends UnaryExpression
implements NumericExpression {
    private final boolean isPlus;

    public SignedExpression(Token start, Expression right, boolean isPlus) {
        super(start, right);
        this.isPlus = isPlus;
    }

    @Override
    public boolean isIntegral() {
        return this.getType().equals(Long.class);
    }

    @Override
    public long evaluateLong(EvaluationContext context) {
        return (Long)MoreObjects.firstNonNull((Object)this.evaluateUnsafe(context), (Object)0);
    }

    @Override
    public double evaluateDouble(EvaluationContext context) {
        return (Double)MoreObjects.firstNonNull((Object)this.evaluateUnsafe(context), (Object)0.0);
    }

    @Override
    @Nullable
    public Object evaluateUnsafe(EvaluationContext context) {
        Object value = this.right.evaluateUnsafe(context);
        if (value instanceof Long) {
            long number = (Long)value;
            return this.isPlus ? number : -number;
        }
        if (value instanceof Double) {
            double number = (Double)value;
            return this.isPlus ? number : -number;
        }
        throw new IllegalArgumentException("Value of '" + this.right.toString() + "' is not a number: " + value);
    }

    public String toString() {
        return (this.isPlus ? " + " : " - ") + this.right.toString();
    }

    public boolean isPlus() {
        return this.isPlus;
    }
}

