/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class IsNull
extends AbstractFunction<Boolean> {
    public static final String NAME = "is_null";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.type("value", Object.class).description("The value to check").build();

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        try {
            Object value = this.valueParam.required(args, context);
            return value == null;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam)).description("Checks whether a value is 'null'").build();
    }
}

