/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.conversion;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class LongConversion
extends AbstractFunction<Long> {
    public static final String NAME = "to_long";
    private static final String VALUE = "value";
    private static final String DEFAULT = "default";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("Value to convert").build();
    private final ParameterDescriptor<Long, Long> defaultParam = ParameterDescriptor.integer("default").optional().description("Used when 'value' is null, defaults to 0").build();

    @Override
    public Long evaluate(FunctionArgs args, EvaluationContext context) {
        Object evaluated = this.valueParam.required(args, context);
        Long defaultValue = this.defaultParam.optional(args, context).orElse(0L);
        return (Long)MoreObjects.firstNonNull((Object)Longs.tryParse((String)String.valueOf(evaluated)), (Object)defaultValue);
    }

    @Override
    public FunctionDescriptor<Long> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Long.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.defaultParam)).description("Converts a value to a long value using its string representation").build();
    }
}

