/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.TypeLiteral;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class SelectJsonPath
extends AbstractFunction<Map<String, Object>> {
    public static final String NAME = "select_jsonpath";
    private final Configuration configuration;
    private final ParameterDescriptor<JsonNode, JsonNode> jsonParam;
    private final ParameterDescriptor<Map<String, String>, Map<String, JsonPath>> pathsParam;

    @Inject
    public SelectJsonPath(ObjectMapper objectMapper) {
        this.configuration = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider(objectMapper)).build();
        this.jsonParam = ParameterDescriptor.type("json", JsonNode.class).description("A parsed JSON tree").build();
        this.pathsParam = ParameterDescriptor.type("paths", new TypeLiteral<Map<String, String>>(){}.getRawType(), new TypeLiteral<Map<String, JsonPath>>(){}.getRawType()).transform(inputMap -> inputMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonPath.compile((String)((String)e.getValue()), (Predicate[])new Predicate[0])))).description("A map of names to a JsonPath expression, see http://jsonpath.com").build();
    }

    @Override
    public Map<String, Object> evaluate(FunctionArgs args, EvaluationContext context) {
        JsonNode json = this.jsonParam.required(args, context);
        Map<String, JsonPath> paths = this.pathsParam.required(args, context);
        if (json == null || paths == null) {
            return null;
        }
        return paths.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.unwrapJsonNode(((JsonPath)e.getValue()).read((Object)json, this.configuration))));
    }

    private Object unwrapJsonNode(Object value) {
        if (!(value instanceof JsonNode)) {
            return value;
        }
        JsonNode read = (JsonNode)value;
        switch (read.getNodeType()) {
            case ARRAY: {
                return ImmutableList.copyOf((Iterator)read.elements());
            }
            case BINARY: {
                try {
                    return read.binaryValue();
                }
                catch (IOException e) {
                    return null;
                }
            }
            case BOOLEAN: {
                return read.booleanValue();
            }
            case MISSING: 
            case NULL: {
                return null;
            }
            case NUMBER: {
                return read.numberValue();
            }
            case OBJECT: {
                return read;
            }
            case POJO: {
                return read;
            }
            case STRING: {
                return read.textValue();
            }
        }
        return read;
    }

    @Override
    public FunctionDescriptor<Map<String, Object>> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(new TypeLiteral<Map<String, Object>>(){}.getRawType()).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.jsonParam, this.pathsParam)).description("Selects a map of fields containing the result of their JsonPath expressions").build();
    }
}

