/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.plugin.Message;

public class CloneMessage
extends AbstractFunction<Message> {
    public static final String NAME = "clone_message";
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();

    @Override
    public Message evaluate(FunctionArgs args, EvaluationContext context) {
        Message currentMessage = this.messageParam.optional(args, context).orElse(context.currentMessage());
        Message clonedMessage = new Message(currentMessage.getMessage(), currentMessage.getSource(), currentMessage.getTimestamp());
        clonedMessage.addFields(currentMessage.getFields());
        clonedMessage.addStreams((Iterable)currentMessage.getStreams());
        context.addCreatedMessage(clonedMessage);
        return clonedMessage;
    }

    @Override
    public FunctionDescriptor<Message> descriptor() {
        return FunctionDescriptor.builder().name(NAME).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.messageParam)).returnType(Message.class).description("Clones a message").build();
    }
}

